// python wrapper for vtkDataLabelRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkDataLabelRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkDataLabelRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkDataLabelRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataRepresentation_ClassNew
extern "C" { PyObject *PyvtkPVDataRepresentation_ClassNew(); }
#define DECLARED_PyvtkPVDataRepresentation_ClassNew
#endif

static PyObject *
PyvtkDataLabelRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkDataLabelRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkDataLabelRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkDataLabelRepresentation *tempr = vtkDataLabelRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkDataLabelRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkDataLabelRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkDataLabelRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkDataLabelRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_GetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetVisibility() :
      op->vtkDataLabelRepresentation::GetVisibility());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetMaximumNumberOfLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaximumNumberOfLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaximumNumberOfLabels(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetMaximumNumberOfLabels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_GetMaximumNumberOfLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximumNumberOfLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaximumNumberOfLabels() :
      op->vtkDataLabelRepresentation::GetMaximumNumberOfLabels());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelVisibility(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointFieldDataArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointFieldDataArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointFieldDataArrayName(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointFieldDataArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelMode(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelOpacity(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelOpacity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelFontFamily(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  size_t size0 = ap.GetStringSize(0);
  vtkPythonArgs::Array<char> store0(2*size0 + 1);
  char *temp0 = store0.Data();
  char *save0 = temp0 + size0 + 1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetPointLabelFontFile(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelFontFile(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelBold(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelItalic(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelShadow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelShadow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelShadow(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelShadow(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelJustification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelJustification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelJustification(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelJustification(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelFontSize(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPointLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPointLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPointLabelFormat(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPointLabelFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelVisibility(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellFieldDataArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellFieldDataArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellFieldDataArrayName(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellFieldDataArrayName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelMode(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelOpacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelOpacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelOpacity(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelOpacity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelFontFamily(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  size_t size0 = ap.GetStringSize(0);
  vtkPythonArgs::Array<char> store0(2*size0 + 1);
  char *temp0 = store0.Data();
  char *save0 = temp0 + size0 + 1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetCellLabelFontFile(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelFontFile(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelBold(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelItalic(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelShadow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelShadow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelShadow(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelShadow(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelJustification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelJustification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelJustification(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelJustification(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelFontSize(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetCellLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCellLabelFormat(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetCellLabelFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetOrientation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetOrientation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetOrigin(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrigin");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrigin(temp0, temp1, temp2);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetOrigin(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetPosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetScale(temp0, temp1, temp2);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetScale(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_SetUserTransform(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUserTransform");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  const size_t size0 = 16;
  double temp0[16];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetUserTransform(temp0);
    }
    else
    {
      op->vtkDataLabelRepresentation::SetUserTransform(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkDataLabelRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkDataLabelRepresentation *op = static_cast<vtkDataLabelRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkDataLabelRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkDataLabelRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkDataLabelRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkDataLabelRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkDataLabelRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkDataLabelRepresentation\nC++: static vtkDataLabelRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkDataLabelRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkDataLabelRepresentation\nC++: vtkDataLabelRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkDataLabelRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkDataLabelRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetVisibility", PyvtkDataLabelRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, val:bool) -> None\nC++: void SetVisibility(bool val) override;\n\nGet/Set the visibility for this representation. When the\nvisibility of representation of false, all view passes are\nignored.\n"},
  {"GetVisibility", PyvtkDataLabelRepresentation_GetVisibility, METH_VARARGS,
   "GetVisibility(self) -> bool\nC++: bool GetVisibility() override;\n\n"},
  {"SetMaximumNumberOfLabels", PyvtkDataLabelRepresentation_SetMaximumNumberOfLabels, METH_VARARGS,
   "SetMaximumNumberOfLabels(self, numLabels:int) -> None\nC++: void SetMaximumNumberOfLabels(int numLabels)\n\nGet/Set the maximum number of points/cells that will be labeled. \nToo many labels is difficult to read so this may help with large\ndatasets.  Default: 100.\n"},
  {"GetMaximumNumberOfLabels", PyvtkDataLabelRepresentation_GetMaximumNumberOfLabels, METH_VARARGS,
   "GetMaximumNumberOfLabels(self) -> int\nC++: int GetMaximumNumberOfLabels()\n\n"},
  {"SetPointLabelVisibility", PyvtkDataLabelRepresentation_SetPointLabelVisibility, METH_VARARGS,
   "SetPointLabelVisibility(self, __a:int) -> None\nC++: void SetPointLabelVisibility(int)\n\n"},
  {"SetPointFieldDataArrayName", PyvtkDataLabelRepresentation_SetPointFieldDataArrayName, METH_VARARGS,
   "SetPointFieldDataArrayName(self, __a:str) -> None\nC++: void SetPointFieldDataArrayName(const char *)\n\n"},
  {"SetPointLabelMode", PyvtkDataLabelRepresentation_SetPointLabelMode, METH_VARARGS,
   "SetPointLabelMode(self, __a:int) -> None\nC++: void SetPointLabelMode(int)\n\n"},
  {"SetPointLabelColor", PyvtkDataLabelRepresentation_SetPointLabelColor, METH_VARARGS,
   "SetPointLabelColor(self, r:float, g:float, b:float) -> None\nC++: void SetPointLabelColor(double r, double g, double b)\n\n"},
  {"SetPointLabelOpacity", PyvtkDataLabelRepresentation_SetPointLabelOpacity, METH_VARARGS,
   "SetPointLabelOpacity(self, __a:float) -> None\nC++: void SetPointLabelOpacity(double)\n\n"},
  {"SetPointLabelFontFamily", PyvtkDataLabelRepresentation_SetPointLabelFontFamily, METH_VARARGS,
   "SetPointLabelFontFamily(self, __a:int) -> None\nC++: void SetPointLabelFontFamily(int)\n\n"},
  {"SetPointLabelFontFile", PyvtkDataLabelRepresentation_SetPointLabelFontFile, METH_VARARGS,
   "SetPointLabelFontFile(self, __a:str) -> None\nC++: void SetPointLabelFontFile(char *)\n\n"},
  {"SetPointLabelBold", PyvtkDataLabelRepresentation_SetPointLabelBold, METH_VARARGS,
   "SetPointLabelBold(self, __a:int) -> None\nC++: void SetPointLabelBold(int)\n\n"},
  {"SetPointLabelItalic", PyvtkDataLabelRepresentation_SetPointLabelItalic, METH_VARARGS,
   "SetPointLabelItalic(self, __a:int) -> None\nC++: void SetPointLabelItalic(int)\n\n"},
  {"SetPointLabelShadow", PyvtkDataLabelRepresentation_SetPointLabelShadow, METH_VARARGS,
   "SetPointLabelShadow(self, __a:int) -> None\nC++: void SetPointLabelShadow(int)\n\n"},
  {"SetPointLabelJustification", PyvtkDataLabelRepresentation_SetPointLabelJustification, METH_VARARGS,
   "SetPointLabelJustification(self, __a:int) -> None\nC++: void SetPointLabelJustification(int)\n\n"},
  {"SetPointLabelFontSize", PyvtkDataLabelRepresentation_SetPointLabelFontSize, METH_VARARGS,
   "SetPointLabelFontSize(self, __a:int) -> None\nC++: void SetPointLabelFontSize(int)\n\n"},
  {"SetPointLabelFormat", PyvtkDataLabelRepresentation_SetPointLabelFormat, METH_VARARGS,
   "SetPointLabelFormat(self, __a:str) -> None\nC++: void SetPointLabelFormat(const char *)\n\n"},
  {"SetCellLabelVisibility", PyvtkDataLabelRepresentation_SetCellLabelVisibility, METH_VARARGS,
   "SetCellLabelVisibility(self, __a:int) -> None\nC++: void SetCellLabelVisibility(int)\n\n"},
  {"SetCellFieldDataArrayName", PyvtkDataLabelRepresentation_SetCellFieldDataArrayName, METH_VARARGS,
   "SetCellFieldDataArrayName(self, __a:str) -> None\nC++: void SetCellFieldDataArrayName(const char *)\n\n"},
  {"SetCellLabelMode", PyvtkDataLabelRepresentation_SetCellLabelMode, METH_VARARGS,
   "SetCellLabelMode(self, __a:int) -> None\nC++: void SetCellLabelMode(int)\n\n"},
  {"SetCellLabelColor", PyvtkDataLabelRepresentation_SetCellLabelColor, METH_VARARGS,
   "SetCellLabelColor(self, r:float, g:float, b:float) -> None\nC++: void SetCellLabelColor(double r, double g, double b)\n\n"},
  {"SetCellLabelOpacity", PyvtkDataLabelRepresentation_SetCellLabelOpacity, METH_VARARGS,
   "SetCellLabelOpacity(self, __a:float) -> None\nC++: void SetCellLabelOpacity(double)\n\n"},
  {"SetCellLabelFontFamily", PyvtkDataLabelRepresentation_SetCellLabelFontFamily, METH_VARARGS,
   "SetCellLabelFontFamily(self, __a:int) -> None\nC++: void SetCellLabelFontFamily(int)\n\n"},
  {"SetCellLabelFontFile", PyvtkDataLabelRepresentation_SetCellLabelFontFile, METH_VARARGS,
   "SetCellLabelFontFile(self, __a:str) -> None\nC++: void SetCellLabelFontFile(char *)\n\n"},
  {"SetCellLabelBold", PyvtkDataLabelRepresentation_SetCellLabelBold, METH_VARARGS,
   "SetCellLabelBold(self, __a:int) -> None\nC++: void SetCellLabelBold(int)\n\n"},
  {"SetCellLabelItalic", PyvtkDataLabelRepresentation_SetCellLabelItalic, METH_VARARGS,
   "SetCellLabelItalic(self, __a:int) -> None\nC++: void SetCellLabelItalic(int)\n\n"},
  {"SetCellLabelShadow", PyvtkDataLabelRepresentation_SetCellLabelShadow, METH_VARARGS,
   "SetCellLabelShadow(self, __a:int) -> None\nC++: void SetCellLabelShadow(int)\n\n"},
  {"SetCellLabelJustification", PyvtkDataLabelRepresentation_SetCellLabelJustification, METH_VARARGS,
   "SetCellLabelJustification(self, __a:int) -> None\nC++: void SetCellLabelJustification(int)\n\n"},
  {"SetCellLabelFontSize", PyvtkDataLabelRepresentation_SetCellLabelFontSize, METH_VARARGS,
   "SetCellLabelFontSize(self, __a:int) -> None\nC++: void SetCellLabelFontSize(int)\n\n"},
  {"SetCellLabelFormat", PyvtkDataLabelRepresentation_SetCellLabelFormat, METH_VARARGS,
   "SetCellLabelFormat(self, __a:str) -> None\nC++: void SetCellLabelFormat(const char *)\n\n"},
  {"SetOrientation", PyvtkDataLabelRepresentation_SetOrientation, METH_VARARGS,
   "SetOrientation(self, __a:float, __b:float, __c:float) -> None\nC++: void SetOrientation(double, double, double)\n\nUsed to build the internal transform.\n"},
  {"SetOrigin", PyvtkDataLabelRepresentation_SetOrigin, METH_VARARGS,
   "SetOrigin(self, __a:float, __b:float, __c:float) -> None\nC++: void SetOrigin(double, double, double)\n\n"},
  {"SetPosition", PyvtkDataLabelRepresentation_SetPosition, METH_VARARGS,
   "SetPosition(self, __a:float, __b:float, __c:float) -> None\nC++: void SetPosition(double, double, double)\n\n"},
  {"SetScale", PyvtkDataLabelRepresentation_SetScale, METH_VARARGS,
   "SetScale(self, __a:float, __b:float, __c:float) -> None\nC++: void SetScale(double, double, double)\n\n"},
  {"SetUserTransform", PyvtkDataLabelRepresentation_SetUserTransform, METH_VARARGS,
   "SetUserTransform(self, __a:(float, float, float, float, float,\n    float, float, float, float, float, float, float, float, float,\n     float, float)) -> None\nC++: void SetUserTransform(const double[16])\n\n"},
  {"ProcessViewRequest", PyvtkDataLabelRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkDataLabelRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("visibility"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkDataLabelRepresentation_GetVisibility(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetVisibility/SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximum_number_of_labels"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkDataLabelRepresentation_GetMaximumNumberOfLabels(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetMaximumNumberOfLabels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetMaximumNumberOfLabels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaximumNumberOfLabels/SetMaximumNumberOfLabels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_field_data_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointFieldDataArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointFieldDataArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointFieldDataArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_opacity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelOpacity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelOpacity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelOpacity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_shadow"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelShadow(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelShadow(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelShadow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_justification"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelJustification(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelJustification(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelJustification\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("point_label_format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPointLabelFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPointLabelFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_field_data_array_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellFieldDataArrayName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellFieldDataArrayName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellFieldDataArrayName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_opacity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelOpacity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelOpacity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelOpacity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_shadow"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelShadow(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelShadow(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelShadow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_justification"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelJustification(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelJustification(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelJustification\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cell_label_format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetCellLabelFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCellLabelFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetOrientation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetOrientation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrientation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("origin"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetOrigin(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetOrigin(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOrigin\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("position"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("user_transform"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkDataLabelRepresentation_SetUserTransform(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkDataLabelRepresentation_SetUserTransform(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUserTransform\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkDataLabelRepresentation_Doc =
  "vtkDataLabelRepresentation - representation for showing cell and\npoint labels.\n\n"
  "Superclass: vtkPVDataRepresentation\n\n"
  "vtkDataLabelRepresentation is a representation for showing cell\n"
  "and/or point labels. This representation relies on all the data being\n"
  "cloned on all nodes hence beware of using this representation for\n"
  "large datasets.@par Caveat: Note that vtkDataLabelRepresentation adds\n"
  "the label props to the non-composited renderer.@par Thanks: The\n"
  "addition of a transformation matrix was supported by CEA/DIF\n"
  "Commissariat a l'Energie Atomique, Centre DAM Ile-De-France, Arpajon,\n"
  "France.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkDataLabelRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkDataLabelRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkDataLabelRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkDataLabelRepresentation_StaticNew()
{
  return vtkDataLabelRepresentation::New();
}

PyObject *PyvtkDataLabelRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkDataLabelRepresentation_Type, PyvtkDataLabelRepresentation_Methods,
    "vtkDataLabelRepresentation",
 &PyvtkDataLabelRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkDataLabelRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkDataLabelRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkDataLabelRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkDataLabelRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

