/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NICINFO_H_RPCGEN
#define _NICINFO_H_RPCGEN

#include <vmxrpc.h>


#ifdef __cplusplus
extern "C" {
#endif


enum NicInfoVersion {
	NIC_INFO_V1 = 1,
	NIC_INFO_V2 = 2,
	NIC_INFO_V3 = 3,
};
typedef enum NicInfoVersion NicInfoVersion;
#define NICINFO_MAX_IP_LEN 64
#define NICINFO_MAX_IPS 2048
#define NICINFO_MAX_NICS 16
#define NICINFO_MAC_LEN 18

enum NicInfoAddrType {
	NICINFO_ADDR_IPV4 = 0,
	NICINFO_ADDR_IPV6 = 1,
};
typedef enum NicInfoAddrType NicInfoAddrType;

struct VmIpAddress {
	NicInfoAddrType addressFamily;
	Bool dhcpEnabled;
	char ipAddress[NICINFO_MAX_IP_LEN];
	char subnetMask[NICINFO_MAX_IP_LEN];
};
typedef struct VmIpAddress VmIpAddress;

struct GuestNic {
	char macAddress[NICINFO_MAC_LEN];
	struct {
		u_int ips_len;
		struct VmIpAddress *ips_val;
	} ips;
};
typedef struct GuestNic GuestNic;

struct GuestNicList {
	struct {
		u_int nics_len;
		struct GuestNic *nics_val;
	} nics;
};
typedef struct GuestNicList GuestNicList;
#define INET_ADDRESS_MAX_LEN 255

typedef struct {
	u_int InetAddress_len;
	char *InetAddress_val;
} InetAddress;

enum InetAddressType {
	IAT_UNKNOWN = 0,
	IAT_IPV4 = 1,
	IAT_IPV6 = 2,
	IAT_IPV4Z = 3,
	IAT_IPV6Z = 4,
	IAT_DNS = 16,
};
typedef enum InetAddressType InetAddressType;

typedef u_int InetAddressPrefixLength;

enum IpAddressOrigin {
	IAO_OTHER = 1,
	IAO_MANUAL = 2,
	IAO_DHCP = 4,
	IAO_LINKLAYER = 5,
	IAO_RANDOM = 6,
};
typedef enum IpAddressOrigin IpAddressOrigin;

enum IpAddressStatus {
	IAS_PREFERRED = 1,
	IAS_DEPRECATED = 2,
	IAS_INVALID = 3,
	IAS_INACCESSIBLE = 4,
	IAS_UNKNOWN = 5,
	IAS_TENTATIVE = 6,
	IAS_DUPLICATE = 7,
	IAS_OPTIMISTIC = 8,
};
typedef enum IpAddressStatus IpAddressStatus;

struct TypedIpAddress {
	InetAddressType ipAddressAddrType;
	InetAddress ipAddressAddr;
};
typedef struct TypedIpAddress TypedIpAddress;

struct IpAddressEntry {
	TypedIpAddress ipAddressAddr;
	InetAddressPrefixLength ipAddressPrefixLength;
	IpAddressOrigin *ipAddressOrigin;
	IpAddressStatus *ipAddressStatus;
};
typedef struct IpAddressEntry IpAddressEntry;
#define DNSINFO_MAX_ADDRLEN 255

typedef char *DnsHostname;
#define DNSINFO_MAX_SUFFIXES 10
#define DNSINFO_MAX_SERVERS 16

struct DnsConfigInfo {
	DnsHostname *hostName;
	DnsHostname *domainName;
	struct {
		u_int serverList_len;
		TypedIpAddress *serverList_val;
	} serverList;
	struct {
		u_int searchSuffixes_len;
		DnsHostname *searchSuffixes_val;
	} searchSuffixes;
};
typedef struct DnsConfigInfo DnsConfigInfo;

struct WinsConfigInfo {
	TypedIpAddress primary;
	TypedIpAddress secondary;
};
typedef struct WinsConfigInfo WinsConfigInfo;
#define NICINFO_MAX_ROUTES 100

enum InetCidrRouteType {
	ICRT_OTHER = 1,
	ICRT_REJECT = 2,
	ICRT_LOCAL = 3,
	ICRT_REMOTE = 4,
};
typedef enum InetCidrRouteType InetCidrRouteType;

struct InetCidrRouteEntry {
	TypedIpAddress inetCidrRouteDest;
	InetAddressPrefixLength inetCidrRoutePfxLen;
	TypedIpAddress *inetCidrRouteNextHop;
	uint32 inetCidrRouteIfIndex;
	InetCidrRouteType inetCidrRouteType;
	uint32 inetCidrRouteMetric;
};
typedef struct InetCidrRouteEntry InetCidrRouteEntry;
#define DHCP_MAX_CONFIG_SIZE 16384

struct DhcpConfigInfo {
	bool_t enabled;
	char *dhcpSettings;
};
typedef struct DhcpConfigInfo DhcpConfigInfo;

struct GuestNicV3 {
	char *macAddress;
	struct {
		u_int ips_len;
		IpAddressEntry *ips_val;
	} ips;
	DnsConfigInfo *dnsConfigInfo;
	WinsConfigInfo *winsConfigInfo;
	DhcpConfigInfo *dhcpConfigInfov4;
	DhcpConfigInfo *dhcpConfigInfov6;
};
typedef struct GuestNicV3 GuestNicV3;

struct NicInfoV3 {
	struct {
		u_int nics_len;
		GuestNicV3 *nics_val;
	} nics;
	struct {
		u_int routes_len;
		InetCidrRouteEntry *routes_val;
	} routes;
	DnsConfigInfo *dnsConfigInfo;
	WinsConfigInfo *winsConfigInfo;
	DhcpConfigInfo *dhcpConfigInfov4;
	DhcpConfigInfo *dhcpConfigInfov6;
};
typedef struct NicInfoV3 NicInfoV3;

struct GuestNicProto {
	NicInfoVersion ver;
	union {
		struct GuestNicList *nicsV2;
		struct NicInfoV3 *nicInfoV3;
	} GuestNicProto_u;
};
typedef struct GuestNicProto GuestNicProto;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_NicInfoVersion (XDR *, NicInfoVersion*);
extern  bool_t xdr_NicInfoAddrType (XDR *, NicInfoAddrType*);
extern  bool_t xdr_VmIpAddress (XDR *, VmIpAddress*);
extern  bool_t xdr_GuestNic (XDR *, GuestNic*);
extern  bool_t xdr_GuestNicList (XDR *, GuestNicList*);
extern  bool_t xdr_InetAddress (XDR *, InetAddress*);
extern  bool_t xdr_InetAddressType (XDR *, InetAddressType*);
extern  bool_t xdr_InetAddressPrefixLength (XDR *, InetAddressPrefixLength*);
extern  bool_t xdr_IpAddressOrigin (XDR *, IpAddressOrigin*);
extern  bool_t xdr_IpAddressStatus (XDR *, IpAddressStatus*);
extern  bool_t xdr_TypedIpAddress (XDR *, TypedIpAddress*);
extern  bool_t xdr_IpAddressEntry (XDR *, IpAddressEntry*);
extern  bool_t xdr_DnsHostname (XDR *, DnsHostname*);
extern  bool_t xdr_DnsConfigInfo (XDR *, DnsConfigInfo*);
extern  bool_t xdr_WinsConfigInfo (XDR *, WinsConfigInfo*);
extern  bool_t xdr_InetCidrRouteType (XDR *, InetCidrRouteType*);
extern  bool_t xdr_InetCidrRouteEntry (XDR *, InetCidrRouteEntry*);
extern  bool_t xdr_DhcpConfigInfo (XDR *, DhcpConfigInfo*);
extern  bool_t xdr_GuestNicV3 (XDR *, GuestNicV3*);
extern  bool_t xdr_NicInfoV3 (XDR *, NicInfoV3*);
extern  bool_t xdr_GuestNicProto (XDR *, GuestNicProto*);

#else /* K&R C */
extern bool_t xdr_NicInfoVersion ();
extern bool_t xdr_NicInfoAddrType ();
extern bool_t xdr_VmIpAddress ();
extern bool_t xdr_GuestNic ();
extern bool_t xdr_GuestNicList ();
extern bool_t xdr_InetAddress ();
extern bool_t xdr_InetAddressType ();
extern bool_t xdr_InetAddressPrefixLength ();
extern bool_t xdr_IpAddressOrigin ();
extern bool_t xdr_IpAddressStatus ();
extern bool_t xdr_TypedIpAddress ();
extern bool_t xdr_IpAddressEntry ();
extern bool_t xdr_DnsHostname ();
extern bool_t xdr_DnsConfigInfo ();
extern bool_t xdr_WinsConfigInfo ();
extern bool_t xdr_InetCidrRouteType ();
extern bool_t xdr_InetCidrRouteEntry ();
extern bool_t xdr_DhcpConfigInfo ();
extern bool_t xdr_GuestNicV3 ();
extern bool_t xdr_NicInfoV3 ();
extern bool_t xdr_GuestNicProto ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NICINFO_H_RPCGEN */
