#include "libnewsboat-ffi/src/cliargsparser.rs.h"
#include "libnewsboat-ffi/src/filepath.rs.h"
#include <array>
#include <cstddef>
#include <cstdint>
#include <new>
#include <string>
#include <type_traits>
#include <utility>

#ifdef __GNUC__
#pragma GCC diagnostic ignored "-Wmissing-declarations"
#ifdef __clang__
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#endif // __clang__
#endif // __GNUC__

namespace rust {
inline namespace cxxbridge1 {
// #include "rust/cxx.h"

struct unsafe_bitcopy_t;

#ifndef CXXBRIDGE1_RUST_STRING
#define CXXBRIDGE1_RUST_STRING
class String final {
public:
  String() noexcept;
  String(const String &) noexcept;
  String(String &&) noexcept;
  ~String() noexcept;

  String(const std::string &);
  String(const char *);
  String(const char *, std::size_t);
  String(const char16_t *);
  String(const char16_t *, std::size_t);
#ifdef __cpp_char8_t
  String(const char8_t *s);
  String(const char8_t *s, std::size_t len);
#endif

  static String lossy(const std::string &) noexcept;
  static String lossy(const char *) noexcept;
  static String lossy(const char *, std::size_t) noexcept;
  static String lossy(const char16_t *) noexcept;
  static String lossy(const char16_t *, std::size_t) noexcept;

  String &operator=(const String &) & noexcept;
  String &operator=(String &&) & noexcept;

  explicit operator std::string() const;

  const char *data() const noexcept;
  std::size_t size() const noexcept;
  std::size_t length() const noexcept;
  bool empty() const noexcept;

  const char *c_str() noexcept;

  std::size_t capacity() const noexcept;
  void reserve(size_t new_cap) noexcept;

  using iterator = char *;
  iterator begin() noexcept;
  iterator end() noexcept;

  using const_iterator = const char *;
  const_iterator begin() const noexcept;
  const_iterator end() const noexcept;
  const_iterator cbegin() const noexcept;
  const_iterator cend() const noexcept;

  bool operator==(const String &) const noexcept;
  bool operator!=(const String &) const noexcept;
  bool operator<(const String &) const noexcept;
  bool operator<=(const String &) const noexcept;
  bool operator>(const String &) const noexcept;
  bool operator>=(const String &) const noexcept;

  void swap(String &) noexcept;

  String(unsafe_bitcopy_t, const String &) noexcept;

private:
  struct lossy_t;
  String(lossy_t, const char *, std::size_t) noexcept;
  String(lossy_t, const char16_t *, std::size_t) noexcept;
  friend void swap(String &lhs, String &rhs) noexcept { lhs.swap(rhs); }

  std::array<std::uintptr_t, 3> repr;
};
#endif // CXXBRIDGE1_RUST_STRING

#ifndef CXXBRIDGE1_RUST_BOX
#define CXXBRIDGE1_RUST_BOX
template <typename T>
class Box final {
public:
  using element_type = T;
  using const_pointer =
      typename std::add_pointer<typename std::add_const<T>::type>::type;
  using pointer = typename std::add_pointer<T>::type;

  Box() = delete;
  Box(Box &&) noexcept;
  ~Box() noexcept;

  explicit Box(const T &);
  explicit Box(T &&);

  Box &operator=(Box &&) & noexcept;

  const T *operator->() const noexcept;
  const T &operator*() const noexcept;
  T *operator->() noexcept;
  T &operator*() noexcept;

  template <typename... Fields>
  static Box in_place(Fields &&...);

  void swap(Box &) noexcept;

  static Box from_raw(T *) noexcept;

  T *into_raw() noexcept;

  /* Deprecated */ using value_type = element_type;

private:
  class uninit;
  class allocation;
  Box(uninit) noexcept;
  void drop() noexcept;

  friend void swap(Box &lhs, Box &rhs) noexcept { lhs.swap(rhs); }

  T *ptr;
};

template <typename T>
class Box<T>::uninit {};

template <typename T>
class Box<T>::allocation {
  static T *alloc() noexcept;
  static void dealloc(T *) noexcept;

public:
  allocation() noexcept : ptr(alloc()) {}
  ~allocation() noexcept {
    if (this->ptr) {
      dealloc(this->ptr);
    }
  }
  T *ptr;
};

template <typename T>
Box<T>::Box(Box &&other) noexcept : ptr(other.ptr) {
  other.ptr = nullptr;
}

template <typename T>
Box<T>::Box(const T &val) {
  allocation alloc;
  ::new (alloc.ptr) T(val);
  this->ptr = alloc.ptr;
  alloc.ptr = nullptr;
}

template <typename T>
Box<T>::Box(T &&val) {
  allocation alloc;
  ::new (alloc.ptr) T(std::move(val));
  this->ptr = alloc.ptr;
  alloc.ptr = nullptr;
}

template <typename T>
Box<T>::~Box() noexcept {
  if (this->ptr) {
    this->drop();
  }
}

template <typename T>
Box<T> &Box<T>::operator=(Box &&other) & noexcept {
  if (this->ptr) {
    this->drop();
  }
  this->ptr = other.ptr;
  other.ptr = nullptr;
  return *this;
}

template <typename T>
const T *Box<T>::operator->() const noexcept {
  return this->ptr;
}

template <typename T>
const T &Box<T>::operator*() const noexcept {
  return *this->ptr;
}

template <typename T>
T *Box<T>::operator->() noexcept {
  return this->ptr;
}

template <typename T>
T &Box<T>::operator*() noexcept {
  return *this->ptr;
}

template <typename T>
template <typename... Fields>
Box<T> Box<T>::in_place(Fields &&...fields) {
  allocation alloc;
  auto ptr = alloc.ptr;
  ::new (ptr) T{std::forward<Fields>(fields)...};
  alloc.ptr = nullptr;
  return from_raw(ptr);
}

template <typename T>
void Box<T>::swap(Box &rhs) noexcept {
  using std::swap;
  swap(this->ptr, rhs.ptr);
}

template <typename T>
Box<T> Box<T>::from_raw(T *raw) noexcept {
  Box box = uninit{};
  box.ptr = raw;
  return box;
}

template <typename T>
T *Box<T>::into_raw() noexcept {
  T *raw = this->ptr;
  this->ptr = nullptr;
  return raw;
}

template <typename T>
Box<T>::Box(uninit) noexcept {}
#endif // CXXBRIDGE1_RUST_BOX

#ifndef CXXBRIDGE1_RUST_OPAQUE
#define CXXBRIDGE1_RUST_OPAQUE
class Opaque {
public:
  Opaque() = delete;
  Opaque(const Opaque &) = delete;
  ~Opaque() = delete;
};
#endif // CXXBRIDGE1_RUST_OPAQUE

#ifndef CXXBRIDGE1_IS_COMPLETE
#define CXXBRIDGE1_IS_COMPLETE
namespace detail {
namespace {
template <typename T, typename = std::size_t>
struct is_complete : std::false_type {};
template <typename T>
struct is_complete<T, decltype(sizeof(T))> : std::true_type {};
} // namespace
} // namespace detail
#endif // CXXBRIDGE1_IS_COMPLETE

#ifndef CXXBRIDGE1_LAYOUT
#define CXXBRIDGE1_LAYOUT
class layout {
  template <typename T>
  friend std::size_t size_of();
  template <typename T>
  friend std::size_t align_of();
  template <typename T>
  static typename std::enable_if<std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_size_of() {
    return T::layout::size();
  }
  template <typename T>
  static typename std::enable_if<!std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_size_of() {
    return sizeof(T);
  }
  template <typename T>
  static
      typename std::enable_if<detail::is_complete<T>::value, std::size_t>::type
      size_of() {
    return do_size_of<T>();
  }
  template <typename T>
  static typename std::enable_if<std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_align_of() {
    return T::layout::align();
  }
  template <typename T>
  static typename std::enable_if<!std::is_base_of<Opaque, T>::value,
                                 std::size_t>::type
  do_align_of() {
    return alignof(T);
  }
  template <typename T>
  static
      typename std::enable_if<detail::is_complete<T>::value, std::size_t>::type
      align_of() {
    return do_align_of<T>();
  }
};

template <typename T>
std::size_t size_of() {
  return layout::size_of<T>();
}

template <typename T>
std::size_t align_of() {
  return layout::align_of<T>();
}
#endif // CXXBRIDGE1_LAYOUT

namespace detail {
template <typename T, typename = void *>
struct operator_new {
  void *operator()(::std::size_t sz) { return ::operator new(sz); }
};

template <typename T>
struct operator_new<T, decltype(T::operator new(sizeof(T)))> {
  void *operator()(::std::size_t sz) { return T::operator new(sz); }
};
} // namespace detail

template <typename T>
union MaybeUninit {
  T value;
  void *operator new(::std::size_t sz) { return detail::operator_new<T>{}(sz); }
  MaybeUninit() {}
  ~MaybeUninit() {}
};
} // namespace cxxbridge1
} // namespace rust

namespace newsboat {
  namespace configpaths {
    namespace bridged {
      struct ConfigPaths;
    }
  }
}

namespace newsboat {
namespace configpaths {
namespace bridged {
#ifndef CXXBRIDGE1_STRUCT_newsboat$configpaths$bridged$ConfigPaths
#define CXXBRIDGE1_STRUCT_newsboat$configpaths$bridged$ConfigPaths
struct ConfigPaths final : public ::rust::Opaque {
  ~ConfigPaths() = delete;

private:
  friend ::rust::layout;
  struct layout {
    static ::std::size_t size() noexcept;
    static ::std::size_t align() noexcept;
  };
};
#endif // CXXBRIDGE1_STRUCT_newsboat$configpaths$bridged$ConfigPaths

extern "C" {
::std::size_t newsboat$configpaths$bridged$cxxbridge1$ConfigPaths$operator$sizeof() noexcept;
::std::size_t newsboat$configpaths$bridged$cxxbridge1$ConfigPaths$operator$alignof() noexcept;

::newsboat::configpaths::bridged::ConfigPaths *newsboat$configpaths$bridged$cxxbridge1$create() noexcept;

bool newsboat$configpaths$bridged$cxxbridge1$create_dirs(::newsboat::configpaths::bridged::ConfigPaths const &configpaths) noexcept;

bool newsboat$configpaths$bridged$cxxbridge1$initialized(::newsboat::configpaths::bridged::ConfigPaths const &configpaths) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$error_message(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::rust::String *return$) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$process_args(::newsboat::configpaths::bridged::ConfigPaths &configpaths, ::newsboat::cliargsparser::bridged::CliArgsParser const &args) noexcept;

bool newsboat$configpaths$bridged$cxxbridge1$try_migrate_from_newsbeuter(::newsboat::configpaths::bridged::ConfigPaths &configpaths) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$url_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$cache_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$set_cache_file(::newsboat::configpaths::bridged::ConfigPaths &configpaths, ::newsboat::filepath::bridged::PathBuf const &path) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$config_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$lock_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$queue_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$search_history_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept;

void newsboat$configpaths$bridged$cxxbridge1$cmdline_history_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept;
} // extern "C"

::std::size_t ConfigPaths::layout::size() noexcept {
  return newsboat$configpaths$bridged$cxxbridge1$ConfigPaths$operator$sizeof();
}

::std::size_t ConfigPaths::layout::align() noexcept {
  return newsboat$configpaths$bridged$cxxbridge1$ConfigPaths$operator$alignof();
}

::rust::Box<::newsboat::configpaths::bridged::ConfigPaths> create() noexcept {
  return ::rust::Box<::newsboat::configpaths::bridged::ConfigPaths>::from_raw(newsboat$configpaths$bridged$cxxbridge1$create());
}

bool create_dirs(::newsboat::configpaths::bridged::ConfigPaths const &configpaths) noexcept {
  return newsboat$configpaths$bridged$cxxbridge1$create_dirs(configpaths);
}

bool initialized(::newsboat::configpaths::bridged::ConfigPaths const &configpaths) noexcept {
  return newsboat$configpaths$bridged$cxxbridge1$initialized(configpaths);
}

::rust::String error_message(::newsboat::configpaths::bridged::ConfigPaths const &configpaths) noexcept {
  ::rust::MaybeUninit<::rust::String> return$;
  newsboat$configpaths$bridged$cxxbridge1$error_message(configpaths, &return$.value);
  return ::std::move(return$.value);
}

void process_args(::newsboat::configpaths::bridged::ConfigPaths &configpaths, ::newsboat::cliargsparser::bridged::CliArgsParser const &args) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$process_args(configpaths, args);
}

bool try_migrate_from_newsbeuter(::newsboat::configpaths::bridged::ConfigPaths &configpaths) noexcept {
  return newsboat$configpaths$bridged$cxxbridge1$try_migrate_from_newsbeuter(configpaths);
}

void url_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$url_file(configpaths, path);
}

void cache_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$cache_file(configpaths, path);
}

void set_cache_file(::newsboat::configpaths::bridged::ConfigPaths &configpaths, ::newsboat::filepath::bridged::PathBuf const &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$set_cache_file(configpaths, path);
}

void config_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$config_file(configpaths, path);
}

void lock_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$lock_file(configpaths, path);
}

void queue_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$queue_file(configpaths, path);
}

void search_history_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$search_history_file(configpaths, path);
}

void cmdline_history_file(::newsboat::configpaths::bridged::ConfigPaths const &configpaths, ::newsboat::filepath::bridged::PathBuf &path) noexcept {
  newsboat$configpaths$bridged$cxxbridge1$cmdline_history_file(configpaths, path);
}
} // namespace bridged
} // namespace configpaths
} // namespace newsboat

extern "C" {
::newsboat::configpaths::bridged::ConfigPaths *cxxbridge1$box$newsboat$configpaths$bridged$ConfigPaths$alloc() noexcept;
void cxxbridge1$box$newsboat$configpaths$bridged$ConfigPaths$dealloc(::newsboat::configpaths::bridged::ConfigPaths *) noexcept;
void cxxbridge1$box$newsboat$configpaths$bridged$ConfigPaths$drop(::rust::Box<::newsboat::configpaths::bridged::ConfigPaths> *ptr) noexcept;
} // extern "C"

namespace rust {
inline namespace cxxbridge1 {
template <>
::newsboat::configpaths::bridged::ConfigPaths *Box<::newsboat::configpaths::bridged::ConfigPaths>::allocation::alloc() noexcept {
  return cxxbridge1$box$newsboat$configpaths$bridged$ConfigPaths$alloc();
}
template <>
void Box<::newsboat::configpaths::bridged::ConfigPaths>::allocation::dealloc(::newsboat::configpaths::bridged::ConfigPaths *ptr) noexcept {
  cxxbridge1$box$newsboat$configpaths$bridged$ConfigPaths$dealloc(ptr);
}
template <>
void Box<::newsboat::configpaths::bridged::ConfigPaths>::drop() noexcept {
  cxxbridge1$box$newsboat$configpaths$bridged$ConfigPaths$drop(this);
}
} // namespace cxxbridge1
} // namespace rust
