// Copyright 2025 Chainguard, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package linters

import (
	"context"
	"fmt"
	"io/fs"
	"strings"

	"chainguard.dev/melange/pkg/config"
)

func ManInfoLinter(ctx context.Context, _ *config.Configuration, pkgname string, fsys fs.FS) error {
	if strings.HasSuffix(pkgname, "-doc") {
		return nil
	}
	return AllPaths(ctx, pkgname, fsys,
		func(path string) bool { return ManRegex.MatchString(path) || InfoRegex.MatchString(path) },
		func(pkgname string, paths []string) string {
			fileWord := "file"
			if len(paths) > 1 {
				fileWord = "files"
			}
			return fmt.Sprintf("%s contains %d man/info %s but is not a documentation package", pkgname, len(paths), fileWord)
		},
	)
}
