/* settings.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from settings.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2011,2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define UG_SETTINGS_KEY_BACKGROUND "background"
#define UG_SETTINGS_KEY_BACKGROUND_COLOR "background-color"
#define UG_SETTINGS_KEY_BACKGROUND_STRETCH "stretch-background-across-monitors"
#define UG_SETTINGS_KEY_DRAW_USER_BACKGROUNDS "draw-user-backgrounds"
#define UG_SETTINGS_KEY_DRAW_GRID "draw-grid"
#define UG_SETTINGS_KEY_SHOW_HOSTNAME "show-hostname"
#define UG_SETTINGS_KEY_SHOW_POWER "show-power"
#define UG_SETTINGS_KEY_SHOW_A11Y "show-a11y"
#define UG_SETTINGS_KEY_SHOW_CLOCK "show-clock"
#define UG_SETTINGS_KEY_SHOW_KEYBOARD "show-keyboard"
#define UG_SETTINGS_KEY_SHOW_QUIT "show-quit"
#define UG_SETTINGS_KEY_LOGO "logo"
#define UG_SETTINGS_KEY_OTHER_MONITORS_LOGO "other-monitors-logo"
#define UG_SETTINGS_KEY_THEME_NAME "theme-name"
#define UG_SETTINGS_KEY_ICON_THEME_NAME "icon-theme-name"
#define UG_SETTINGS_KEY_CURSOR_THEME_NAME "cursor-theme-name"
#define UG_SETTINGS_KEY_CURSOR_THEME_SIZE "cursor-theme-size"
#define UG_SETTINGS_KEY_FONT_NAME "font-name"
#define UG_SETTINGS_KEY_XFT_ANTIALIAS "xft-antialias"
#define UG_SETTINGS_KEY_XFT_DPI "xft-dpi"
#define UG_SETTINGS_KEY_XFT_HINTSTYLE "xft-hintstyle"
#define UG_SETTINGS_KEY_XFT_RGBA "xft-rgba"
#define UG_SETTINGS_KEY_ONSCREEN_KEYBOARD "onscreen-keyboard"
#define UG_SETTINGS_KEY_HIGH_CONTRAST "high-contrast"
#define UG_SETTINGS_KEY_SCREEN_READER "screen-reader"
#define UG_SETTINGS_KEY_PLAY_READY_SOUND "play-ready-sound"
#define UG_SETTINGS_KEY_HIDDEN_USERS "hidden-users"
#define UG_SETTINGS_KEY_GROUP_FILTER "group-filter"
#define UG_SETTINGS_KEY_ENABLE_HIDPI "enable-hidpi"
#define UG_SETTINGS_KEY_ACTIVATE_NUMLOCK "activate-numlock"
#define UG_SETTINGS_KEY_ONLY_ON_MONITOR "only-on-monitor"
#define UG_SETTINGS_KEY_CLOCK_FORMAT "clock-format"
#define UG_SETTINGS_KEY_ONSCREEN_KEYBOARD_LAYOUT "onscreen-keyboard-layout"
#define UG_SETTINGS_KEY_CONTENT_ALIGN "content-align"
#define UG_SETTINGS_SCHEMA "x.dm.slick-greeter"
#define UG_SETTINGS_GROUP_NAME "Greeter"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UG_SETTINGS (ug_settings_get_type ())
#define UG_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UG_SETTINGS, UGSettings))
#define UG_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UG_SETTINGS, UGSettingsClass))
#define IS_UG_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UG_SETTINGS))
#define IS_UG_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UG_SETTINGS))
#define UG_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UG_SETTINGS, UGSettingsClass))

typedef struct _UGSettings UGSettings;
typedef struct _UGSettingsClass UGSettingsClass;
typedef struct _UGSettingsPrivate UGSettingsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecUGSettings ParamSpecUGSettings;

struct _UGSettings {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UGSettingsPrivate * priv;
};

struct _UGSettingsClass {
	GTypeClass parent_class;
	void (*finalize) (UGSettings *self);
};

struct _ParamSpecUGSettings {
	GParamSpec parent_instance;
};

static gpointer ug_settings_parent_class = NULL;

VALA_EXTERN gpointer ug_settings_ref (gpointer instance);
VALA_EXTERN void ug_settings_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_ug_settings (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_ug_settings (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_ug_settings (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_ug_settings (const GValue* value);
VALA_EXTERN GType ug_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UGSettings, ug_settings_unref)
VALA_EXTERN gboolean ug_settings_get_boolean (const gchar* key);
VALA_EXTERN gboolean ug_settings_safe_get_boolean (const gchar* key,
                                       gboolean _default_);
VALA_EXTERN gint ug_settings_get_integer (const gchar* key);
VALA_EXTERN gdouble ug_settings_get_double (const gchar* key);
VALA_EXTERN gchar* ug_settings_get_string (const gchar* key);
VALA_EXTERN gboolean ug_settings_set_boolean (const gchar* key,
                                  gboolean value);
VALA_EXTERN gchar** ug_settings_get_strv (const gchar* key,
                              gint* result_length1);
VALA_EXTERN gboolean ug_settings_set_strv (const gchar* key,
                               gchar** value,
                               gint value_length1);
VALA_EXTERN void ug_settings_apply_conf_settings (void);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN UGSettings* ug_settings_new (void);
VALA_EXTERN UGSettings* ug_settings_construct (GType object_type);
static void ug_settings_finalize (UGSettings * obj);
static GType ug_settings_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gboolean
ug_settings_get_boolean (const gchar* key)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gboolean result;
#line 58 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 60 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 60 "../src/settings.vala"
	gsettings = _tmp0_;
#line 61 "../src/settings.vala"
	result = g_settings_get_boolean (gsettings, key);
#line 61 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 61 "../src/settings.vala"
	return result;
#line 184 "settings.c"
}

gboolean
ug_settings_safe_get_boolean (const gchar* key,
                              gboolean _default_)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gchar** keys = NULL;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint keys_length1;
	gint _keys_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gboolean result;
#line 65 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 67 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 67 "../src/settings.vala"
	gsettings = _tmp0_;
#line 68 "../src/settings.vala"
	_tmp1_ = gsettings;
#line 68 "../src/settings.vala"
	_tmp3_ = _tmp2_ = g_settings_list_keys (_tmp1_);
#line 68 "../src/settings.vala"
	keys = _tmp3_;
#line 68 "../src/settings.vala"
	keys_length1 = _vala_array_length (_tmp2_);
#line 68 "../src/settings.vala"
	_keys_size_ = keys_length1;
#line 69 "../src/settings.vala"
	_tmp4_ = keys;
#line 69 "../src/settings.vala"
	_tmp4__length1 = keys_length1;
#line 222 "settings.c"
	{
		gchar** k_collection = NULL;
		gint k_collection_length1 = 0;
		gint _k_collection_size_ = 0;
		gint k_it = 0;
#line 69 "../src/settings.vala"
		k_collection = _tmp4_;
#line 69 "../src/settings.vala"
		k_collection_length1 = _tmp4__length1;
#line 69 "../src/settings.vala"
		for (k_it = 0; k_it < k_collection_length1; k_it = k_it + 1) {
#line 234 "settings.c"
			gchar* _tmp5_;
			gchar* k = NULL;
#line 69 "../src/settings.vala"
			_tmp5_ = g_strdup (k_collection[k_it]);
#line 69 "../src/settings.vala"
			k = _tmp5_;
#line 241 "settings.c"
			{
				const gchar* _tmp6_;
#line 70 "../src/settings.vala"
				_tmp6_ = k;
#line 70 "../src/settings.vala"
				if (g_strcmp0 (_tmp6_, key) == 0) {
#line 248 "settings.c"
					GSettings* _tmp7_;
#line 71 "../src/settings.vala"
					_tmp7_ = gsettings;
#line 71 "../src/settings.vala"
					result = g_settings_get_boolean (_tmp7_, key);
#line 71 "../src/settings.vala"
					_g_free0 (k);
#line 71 "../src/settings.vala"
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 71 "../src/settings.vala"
					_g_object_unref0 (gsettings);
#line 71 "../src/settings.vala"
					return result;
#line 262 "settings.c"
				}
#line 69 "../src/settings.vala"
				_g_free0 (k);
#line 266 "settings.c"
			}
		}
	}
#line 74 "../src/settings.vala"
	result = _default_;
#line 74 "../src/settings.vala"
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 74 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 74 "../src/settings.vala"
	return result;
#line 278 "settings.c"
}

gint
ug_settings_get_integer (const gchar* key)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gint result;
#line 77 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 79 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 79 "../src/settings.vala"
	gsettings = _tmp0_;
#line 80 "../src/settings.vala"
	result = g_settings_get_int (gsettings, key);
#line 80 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 80 "../src/settings.vala"
	return result;
#line 299 "settings.c"
}

gdouble
ug_settings_get_double (const gchar* key)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gdouble result;
#line 83 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, 0.0);
#line 85 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 85 "../src/settings.vala"
	gsettings = _tmp0_;
#line 86 "../src/settings.vala"
	result = g_settings_get_double (gsettings, key);
#line 86 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 86 "../src/settings.vala"
	return result;
#line 320 "settings.c"
}

gchar*
ug_settings_get_string (const gchar* key)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 89 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 91 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 91 "../src/settings.vala"
	gsettings = _tmp0_;
#line 92 "../src/settings.vala"
	_tmp1_ = g_settings_get_string (gsettings, key);
#line 92 "../src/settings.vala"
	result = _tmp1_;
#line 92 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 92 "../src/settings.vala"
	return result;
#line 344 "settings.c"
}

gboolean
ug_settings_set_boolean (const gchar* key,
                         gboolean value)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gboolean result;
#line 95 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 97 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 97 "../src/settings.vala"
	gsettings = _tmp0_;
#line 98 "../src/settings.vala"
	result = g_settings_set_boolean (gsettings, key, value);
#line 98 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 98 "../src/settings.vala"
	return result;
#line 366 "settings.c"
}

gchar**
ug_settings_get_strv (const gchar* key,
                      gint* result_length1)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** result;
#line 101 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 103 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 103 "../src/settings.vala"
	gsettings = _tmp0_;
#line 104 "../src/settings.vala"
	_tmp2_ = _tmp1_ = g_settings_get_strv (gsettings, key);
#line 104 "../src/settings.vala"
	_tmp3_ = _tmp2_;
#line 104 "../src/settings.vala"
	_tmp3__length1 = _vala_array_length (_tmp1_);
#line 104 "../src/settings.vala"
	if (result_length1) {
#line 104 "../src/settings.vala"
		*result_length1 = _tmp3__length1;
#line 396 "settings.c"
	}
#line 104 "../src/settings.vala"
	result = _tmp3_;
#line 104 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 104 "../src/settings.vala"
	return result;
#line 404 "settings.c"
}

gboolean
ug_settings_set_strv (const gchar* key,
                      gchar** value,
                      gint value_length1)
{
	GSettings* gsettings = NULL;
	GSettings* _tmp0_;
	gboolean result;
#line 107 "../src/settings.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 109 "../src/settings.vala"
	_tmp0_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 109 "../src/settings.vala"
	gsettings = _tmp0_;
#line 110 "../src/settings.vala"
	result = g_settings_set_strv (gsettings, key, value);
#line 110 "../src/settings.vala"
	_g_object_unref0 (gsettings);
#line 110 "../src/settings.vala"
	return result;
#line 427 "settings.c"
}

static void
_g_free0_ (gpointer var)
{
#line 166 "../src/settings.vala"
	var = (g_free (var), NULL);
#line 435 "settings.c"
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
#line 166 "../src/settings.vala"
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
#line 443 "settings.c"
}

void
ug_settings_apply_conf_settings (void)
{
	GError* _inner_error0_ = NULL;
	{
		gchar* path = NULL;
		gchar* _tmp0_;
		GSettings* gsettings = NULL;
		GSettings* _tmp1_;
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		GList* string_keys = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GList* bool_keys = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GList* int_keys = NULL;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GList* strv_keys = NULL;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GList* _tmp37_;
		GList* _tmp58_;
		GList* _tmp76_;
		GList* _tmp94_;
#line 116 "../src/settings.vala"
		_tmp0_ = g_strdup ("/etc/lightdm/slick-greeter.conf");
#line 116 "../src/settings.vala"
		path = _tmp0_;
#line 117 "../src/settings.vala"
		_tmp1_ = g_settings_new (UG_SETTINGS_SCHEMA);
#line 117 "../src/settings.vala"
		gsettings = _tmp1_;
#line 118 "../src/settings.vala"
		_tmp2_ = g_key_file_new ();
#line 118 "../src/settings.vala"
		keyfile = _tmp2_;
#line 120 "../src/settings.vala"
		_tmp3_ = path;
#line 120 "../src/settings.vala"
		if (g_file_test (_tmp3_, G_FILE_TEST_EXISTS)) {
#line 513 "settings.c"
			GKeyFile* _tmp4_;
			const gchar* _tmp5_;
#line 122 "../src/settings.vala"
			_tmp4_ = keyfile;
#line 122 "../src/settings.vala"
			_tmp5_ = path;
#line 122 "../src/settings.vala"
			g_key_file_load_from_file (_tmp4_, _tmp5_, G_KEY_FILE_NONE, &_inner_error0_);
#line 122 "../src/settings.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 122 "../src/settings.vala"
				_g_key_file_unref0 (keyfile);
#line 122 "../src/settings.vala"
				_g_object_unref0 (gsettings);
#line 122 "../src/settings.vala"
				_g_free0 (path);
#line 530 "settings.c"
				goto __catch0_g_error;
			}
		}
#line 125 "../src/settings.vala"
		string_keys = NULL;
#line 126 "../src/settings.vala"
		_tmp6_ = g_strdup (UG_SETTINGS_KEY_BACKGROUND);
#line 126 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp6_);
#line 127 "../src/settings.vala"
		_tmp7_ = g_strdup (UG_SETTINGS_KEY_BACKGROUND_COLOR);
#line 127 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp7_);
#line 128 "../src/settings.vala"
		_tmp8_ = g_strdup (UG_SETTINGS_KEY_LOGO);
#line 128 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp8_);
#line 129 "../src/settings.vala"
		_tmp9_ = g_strdup (UG_SETTINGS_KEY_OTHER_MONITORS_LOGO);
#line 129 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp9_);
#line 130 "../src/settings.vala"
		_tmp10_ = g_strdup (UG_SETTINGS_KEY_THEME_NAME);
#line 130 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp10_);
#line 131 "../src/settings.vala"
		_tmp11_ = g_strdup (UG_SETTINGS_KEY_ICON_THEME_NAME);
#line 131 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp11_);
#line 132 "../src/settings.vala"
		_tmp12_ = g_strdup (UG_SETTINGS_KEY_CURSOR_THEME_NAME);
#line 132 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp12_);
#line 133 "../src/settings.vala"
		_tmp13_ = g_strdup (UG_SETTINGS_KEY_FONT_NAME);
#line 133 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp13_);
#line 134 "../src/settings.vala"
		_tmp14_ = g_strdup (UG_SETTINGS_KEY_PLAY_READY_SOUND);
#line 134 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp14_);
#line 135 "../src/settings.vala"
		_tmp15_ = g_strdup (UG_SETTINGS_KEY_XFT_HINTSTYLE);
#line 135 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp15_);
#line 136 "../src/settings.vala"
		_tmp16_ = g_strdup (UG_SETTINGS_KEY_XFT_RGBA);
#line 136 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp16_);
#line 137 "../src/settings.vala"
		_tmp17_ = g_strdup (UG_SETTINGS_KEY_ENABLE_HIDPI);
#line 137 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp17_);
#line 138 "../src/settings.vala"
		_tmp18_ = g_strdup (UG_SETTINGS_KEY_ONLY_ON_MONITOR);
#line 138 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp18_);
#line 139 "../src/settings.vala"
		_tmp19_ = g_strdup (UG_SETTINGS_KEY_CLOCK_FORMAT);
#line 139 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp19_);
#line 140 "../src/settings.vala"
		_tmp20_ = g_strdup (UG_SETTINGS_KEY_ONSCREEN_KEYBOARD_LAYOUT);
#line 140 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp20_);
#line 141 "../src/settings.vala"
		_tmp21_ = g_strdup (UG_SETTINGS_KEY_CONTENT_ALIGN);
#line 141 "../src/settings.vala"
		string_keys = g_list_append (string_keys, _tmp21_);
#line 143 "../src/settings.vala"
		bool_keys = NULL;
#line 144 "../src/settings.vala"
		_tmp22_ = g_strdup (UG_SETTINGS_KEY_DRAW_USER_BACKGROUNDS);
#line 144 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp22_);
#line 145 "../src/settings.vala"
		_tmp23_ = g_strdup (UG_SETTINGS_KEY_BACKGROUND_STRETCH);
#line 145 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp23_);
#line 146 "../src/settings.vala"
		_tmp24_ = g_strdup (UG_SETTINGS_KEY_DRAW_GRID);
#line 146 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp24_);
#line 147 "../src/settings.vala"
		_tmp25_ = g_strdup (UG_SETTINGS_KEY_SHOW_HOSTNAME);
#line 147 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp25_);
#line 148 "../src/settings.vala"
		_tmp26_ = g_strdup (UG_SETTINGS_KEY_SHOW_POWER);
#line 148 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp26_);
#line 149 "../src/settings.vala"
		_tmp27_ = g_strdup (UG_SETTINGS_KEY_SHOW_A11Y);
#line 149 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp27_);
#line 150 "../src/settings.vala"
		_tmp28_ = g_strdup (UG_SETTINGS_KEY_SHOW_CLOCK);
#line 150 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp28_);
#line 151 "../src/settings.vala"
		_tmp29_ = g_strdup (UG_SETTINGS_KEY_SHOW_KEYBOARD);
#line 151 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp29_);
#line 152 "../src/settings.vala"
		_tmp30_ = g_strdup (UG_SETTINGS_KEY_SHOW_QUIT);
#line 152 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp30_);
#line 153 "../src/settings.vala"
		_tmp31_ = g_strdup (UG_SETTINGS_KEY_XFT_ANTIALIAS);
#line 153 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp31_);
#line 154 "../src/settings.vala"
		_tmp32_ = g_strdup (UG_SETTINGS_KEY_ACTIVATE_NUMLOCK);
#line 154 "../src/settings.vala"
		bool_keys = g_list_append (bool_keys, _tmp32_);
#line 156 "../src/settings.vala"
		int_keys = NULL;
#line 157 "../src/settings.vala"
		_tmp33_ = g_strdup (UG_SETTINGS_KEY_XFT_DPI);
#line 157 "../src/settings.vala"
		int_keys = g_list_append (int_keys, _tmp33_);
#line 158 "../src/settings.vala"
		_tmp34_ = g_strdup (UG_SETTINGS_KEY_CURSOR_THEME_SIZE);
#line 158 "../src/settings.vala"
		int_keys = g_list_append (int_keys, _tmp34_);
#line 160 "../src/settings.vala"
		strv_keys = NULL;
#line 161 "../src/settings.vala"
		_tmp35_ = g_strdup (UG_SETTINGS_KEY_HIDDEN_USERS);
#line 161 "../src/settings.vala"
		strv_keys = g_list_append (strv_keys, _tmp35_);
#line 162 "../src/settings.vala"
		_tmp36_ = g_strdup (UG_SETTINGS_KEY_GROUP_FILTER);
#line 162 "../src/settings.vala"
		strv_keys = g_list_append (strv_keys, _tmp36_);
#line 164 "../src/settings.vala"
		_tmp37_ = string_keys;
#line 668 "settings.c"
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
#line 164 "../src/settings.vala"
			key_collection = _tmp37_;
#line 164 "../src/settings.vala"
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 676 "settings.c"
				gchar* _tmp38_;
				gchar* key = NULL;
#line 164 "../src/settings.vala"
				_tmp38_ = g_strdup ((const gchar*) key_it->data);
#line 164 "../src/settings.vala"
				key = _tmp38_;
#line 683 "settings.c"
				{
					gboolean _tmp39_ = FALSE;
					GKeyFile* _tmp40_;
#line 166 "../src/settings.vala"
					_tmp40_ = keyfile;
#line 166 "../src/settings.vala"
					if (g_key_file_has_group (_tmp40_, UG_SETTINGS_GROUP_NAME)) {
#line 691 "settings.c"
						gboolean _tmp41_ = FALSE;
						GKeyFile* _tmp42_;
						const gchar* _tmp43_;
#line 166 "../src/settings.vala"
						_tmp42_ = keyfile;
#line 166 "../src/settings.vala"
						_tmp43_ = key;
#line 166 "../src/settings.vala"
						_tmp41_ = g_key_file_has_key (_tmp42_, UG_SETTINGS_GROUP_NAME, _tmp43_, &_inner_error0_);
#line 166 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 166 "../src/settings.vala"
							_g_free0 (key);
#line 166 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 166 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 166 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 166 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 166 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 166 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 166 "../src/settings.vala"
							_g_free0 (path);
#line 719 "settings.c"
							goto __catch0_g_error;
						}
#line 166 "../src/settings.vala"
						_tmp39_ = _tmp41_;
#line 724 "settings.c"
					} else {
#line 166 "../src/settings.vala"
						_tmp39_ = FALSE;
#line 728 "settings.c"
					}
#line 166 "../src/settings.vala"
					if (_tmp39_) {
#line 732 "settings.c"
						{
							gchar* value = NULL;
							GKeyFile* _tmp44_;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							GSettings* _tmp49_;
							const gchar* _tmp50_;
							const gchar* _tmp51_;
#line 168 "../src/settings.vala"
							_tmp44_ = keyfile;
#line 168 "../src/settings.vala"
							_tmp45_ = key;
#line 168 "../src/settings.vala"
							_tmp46_ = g_key_file_get_string (_tmp44_, UG_SETTINGS_GROUP_NAME, _tmp45_, &_inner_error0_);
#line 168 "../src/settings.vala"
							value = _tmp46_;
#line 168 "../src/settings.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 753 "settings.c"
								goto __catch1_g_error;
							}
#line 169 "../src/settings.vala"
							_tmp47_ = key;
#line 169 "../src/settings.vala"
							_tmp48_ = value;
#line 169 "../src/settings.vala"
							g_debug ("settings.vala:169: Overriding dconf setting for %s with %s", _tmp47_, _tmp48_);
#line 170 "../src/settings.vala"
							_tmp49_ = gsettings;
#line 170 "../src/settings.vala"
							_tmp50_ = key;
#line 170 "../src/settings.vala"
							_tmp51_ = value;
#line 170 "../src/settings.vala"
							g_settings_set_string (_tmp49_, _tmp50_, _tmp51_);
#line 167 "../src/settings.vala"
							_g_free0 (value);
#line 772 "settings.c"
						}
						goto __finally1;
						__catch1_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp52_;
							GError* _tmp53_;
							const gchar* _tmp54_;
#line 167 "../src/settings.vala"
							e = _inner_error0_;
#line 167 "../src/settings.vala"
							_inner_error0_ = NULL;
#line 173 "../src/settings.vala"
							_tmp52_ = key;
#line 173 "../src/settings.vala"
							_tmp53_ = e;
#line 173 "../src/settings.vala"
							_tmp54_ = _tmp53_->message;
#line 173 "../src/settings.vala"
							g_warning ("settings.vala:173: Failed to apply %s from configuration file: %s", _tmp52_, _tmp54_);
#line 167 "../src/settings.vala"
							_g_error_free0 (e);
#line 795 "settings.c"
						}
						__finally1:
#line 167 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 167 "../src/settings.vala"
							_g_free0 (key);
#line 167 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 167 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 167 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 167 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 167 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 167 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 167 "../src/settings.vala"
							_g_free0 (path);
#line 816 "settings.c"
							goto __catch0_g_error;
						}
					} else {
						GSettings* _tmp55_;
						const gchar* _tmp56_;
						const gchar* _tmp57_;
#line 177 "../src/settings.vala"
						_tmp55_ = gsettings;
#line 177 "../src/settings.vala"
						_tmp56_ = key;
#line 177 "../src/settings.vala"
						g_settings_reset (_tmp55_, _tmp56_);
#line 178 "../src/settings.vala"
						_tmp57_ = key;
#line 178 "../src/settings.vala"
						g_debug ("settings.vala:178: Resetting dconf setting for %s to default", _tmp57_);
#line 833 "settings.c"
					}
#line 164 "../src/settings.vala"
					_g_free0 (key);
#line 837 "settings.c"
				}
			}
		}
#line 182 "../src/settings.vala"
		_tmp58_ = bool_keys;
#line 843 "settings.c"
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
#line 182 "../src/settings.vala"
			key_collection = _tmp58_;
#line 182 "../src/settings.vala"
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 851 "settings.c"
				gchar* _tmp59_;
				gchar* key = NULL;
#line 182 "../src/settings.vala"
				_tmp59_ = g_strdup ((const gchar*) key_it->data);
#line 182 "../src/settings.vala"
				key = _tmp59_;
#line 858 "settings.c"
				{
					gboolean _tmp60_ = FALSE;
					GKeyFile* _tmp61_;
#line 184 "../src/settings.vala"
					_tmp61_ = keyfile;
#line 184 "../src/settings.vala"
					if (g_key_file_has_group (_tmp61_, UG_SETTINGS_GROUP_NAME)) {
#line 866 "settings.c"
						gboolean _tmp62_ = FALSE;
						GKeyFile* _tmp63_;
						const gchar* _tmp64_;
#line 184 "../src/settings.vala"
						_tmp63_ = keyfile;
#line 184 "../src/settings.vala"
						_tmp64_ = key;
#line 184 "../src/settings.vala"
						_tmp62_ = g_key_file_has_key (_tmp63_, UG_SETTINGS_GROUP_NAME, _tmp64_, &_inner_error0_);
#line 184 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "../src/settings.vala"
							_g_free0 (key);
#line 184 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 184 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 184 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 184 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 184 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 184 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 184 "../src/settings.vala"
							_g_free0 (path);
#line 894 "settings.c"
							goto __catch0_g_error;
						}
#line 184 "../src/settings.vala"
						_tmp60_ = _tmp62_;
#line 899 "settings.c"
					} else {
#line 184 "../src/settings.vala"
						_tmp60_ = FALSE;
#line 903 "settings.c"
					}
#line 184 "../src/settings.vala"
					if (_tmp60_) {
#line 907 "settings.c"
						{
							gboolean value = FALSE;
							GKeyFile* _tmp65_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							GSettings* _tmp68_;
							const gchar* _tmp69_;
#line 186 "../src/settings.vala"
							_tmp65_ = keyfile;
#line 186 "../src/settings.vala"
							_tmp66_ = key;
#line 186 "../src/settings.vala"
							value = g_key_file_get_boolean (_tmp65_, UG_SETTINGS_GROUP_NAME, _tmp66_, &_inner_error0_);
#line 186 "../src/settings.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 923 "settings.c"
								goto __catch2_g_error;
							}
#line 187 "../src/settings.vala"
							_tmp67_ = key;
#line 187 "../src/settings.vala"
							g_debug ("settings.vala:187: Overriding dconf setting for %s", _tmp67_);
#line 188 "../src/settings.vala"
							_tmp68_ = gsettings;
#line 188 "../src/settings.vala"
							_tmp69_ = key;
#line 188 "../src/settings.vala"
							g_settings_set_boolean (_tmp68_, _tmp69_, value);
#line 936 "settings.c"
						}
						goto __finally2;
						__catch2_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp70_;
							GError* _tmp71_;
							const gchar* _tmp72_;
#line 185 "../src/settings.vala"
							e = _inner_error0_;
#line 185 "../src/settings.vala"
							_inner_error0_ = NULL;
#line 191 "../src/settings.vala"
							_tmp70_ = key;
#line 191 "../src/settings.vala"
							_tmp71_ = e;
#line 191 "../src/settings.vala"
							_tmp72_ = _tmp71_->message;
#line 191 "../src/settings.vala"
							g_warning ("settings.vala:191: Failed to apply %s from configuration file: %s", _tmp70_, _tmp72_);
#line 185 "../src/settings.vala"
							_g_error_free0 (e);
#line 959 "settings.c"
						}
						__finally2:
#line 185 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "../src/settings.vala"
							_g_free0 (key);
#line 185 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 185 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 185 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 185 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 185 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 185 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 185 "../src/settings.vala"
							_g_free0 (path);
#line 980 "settings.c"
							goto __catch0_g_error;
						}
					} else {
						GSettings* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
#line 195 "../src/settings.vala"
						_tmp73_ = gsettings;
#line 195 "../src/settings.vala"
						_tmp74_ = key;
#line 195 "../src/settings.vala"
						g_settings_reset (_tmp73_, _tmp74_);
#line 196 "../src/settings.vala"
						_tmp75_ = key;
#line 196 "../src/settings.vala"
						g_debug ("settings.vala:196: Resetting dconf setting for %s to default", _tmp75_);
#line 997 "settings.c"
					}
#line 182 "../src/settings.vala"
					_g_free0 (key);
#line 1001 "settings.c"
				}
			}
		}
#line 200 "../src/settings.vala"
		_tmp76_ = int_keys;
#line 1007 "settings.c"
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
#line 200 "../src/settings.vala"
			key_collection = _tmp76_;
#line 200 "../src/settings.vala"
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 1015 "settings.c"
				gchar* _tmp77_;
				gchar* key = NULL;
#line 200 "../src/settings.vala"
				_tmp77_ = g_strdup ((const gchar*) key_it->data);
#line 200 "../src/settings.vala"
				key = _tmp77_;
#line 1022 "settings.c"
				{
					gboolean _tmp78_ = FALSE;
					GKeyFile* _tmp79_;
#line 202 "../src/settings.vala"
					_tmp79_ = keyfile;
#line 202 "../src/settings.vala"
					if (g_key_file_has_group (_tmp79_, UG_SETTINGS_GROUP_NAME)) {
#line 1030 "settings.c"
						gboolean _tmp80_ = FALSE;
						GKeyFile* _tmp81_;
						const gchar* _tmp82_;
#line 202 "../src/settings.vala"
						_tmp81_ = keyfile;
#line 202 "../src/settings.vala"
						_tmp82_ = key;
#line 202 "../src/settings.vala"
						_tmp80_ = g_key_file_has_key (_tmp81_, UG_SETTINGS_GROUP_NAME, _tmp82_, &_inner_error0_);
#line 202 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 202 "../src/settings.vala"
							_g_free0 (key);
#line 202 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 202 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 202 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 202 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 202 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 202 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 202 "../src/settings.vala"
							_g_free0 (path);
#line 1058 "settings.c"
							goto __catch0_g_error;
						}
#line 202 "../src/settings.vala"
						_tmp78_ = _tmp80_;
#line 1063 "settings.c"
					} else {
#line 202 "../src/settings.vala"
						_tmp78_ = FALSE;
#line 1067 "settings.c"
					}
#line 202 "../src/settings.vala"
					if (_tmp78_) {
#line 1071 "settings.c"
						{
							gint value = 0;
							GKeyFile* _tmp83_;
							const gchar* _tmp84_;
							const gchar* _tmp85_;
							GSettings* _tmp86_;
							const gchar* _tmp87_;
#line 204 "../src/settings.vala"
							_tmp83_ = keyfile;
#line 204 "../src/settings.vala"
							_tmp84_ = key;
#line 204 "../src/settings.vala"
							value = g_key_file_get_integer (_tmp83_, UG_SETTINGS_GROUP_NAME, _tmp84_, &_inner_error0_);
#line 204 "../src/settings.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1087 "settings.c"
								goto __catch3_g_error;
							}
#line 205 "../src/settings.vala"
							_tmp85_ = key;
#line 205 "../src/settings.vala"
							g_debug ("settings.vala:205: Overriding dconf setting for %s with %d", _tmp85_, value);
#line 206 "../src/settings.vala"
							_tmp86_ = gsettings;
#line 206 "../src/settings.vala"
							_tmp87_ = key;
#line 206 "../src/settings.vala"
							g_settings_set_int (_tmp86_, _tmp87_, value);
#line 1100 "settings.c"
						}
						goto __finally3;
						__catch3_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp88_;
							GError* _tmp89_;
							const gchar* _tmp90_;
#line 203 "../src/settings.vala"
							e = _inner_error0_;
#line 203 "../src/settings.vala"
							_inner_error0_ = NULL;
#line 209 "../src/settings.vala"
							_tmp88_ = key;
#line 209 "../src/settings.vala"
							_tmp89_ = e;
#line 209 "../src/settings.vala"
							_tmp90_ = _tmp89_->message;
#line 209 "../src/settings.vala"
							g_warning ("settings.vala:209: Failed to apply %s from configuration file: %s", _tmp88_, _tmp90_);
#line 203 "../src/settings.vala"
							_g_error_free0 (e);
#line 1123 "settings.c"
						}
						__finally3:
#line 203 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 203 "../src/settings.vala"
							_g_free0 (key);
#line 203 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 203 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 203 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 203 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 203 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 203 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 203 "../src/settings.vala"
							_g_free0 (path);
#line 1144 "settings.c"
							goto __catch0_g_error;
						}
					} else {
						GSettings* _tmp91_;
						const gchar* _tmp92_;
						const gchar* _tmp93_;
#line 213 "../src/settings.vala"
						_tmp91_ = gsettings;
#line 213 "../src/settings.vala"
						_tmp92_ = key;
#line 213 "../src/settings.vala"
						g_settings_reset (_tmp91_, _tmp92_);
#line 214 "../src/settings.vala"
						_tmp93_ = key;
#line 214 "../src/settings.vala"
						g_debug ("settings.vala:214: Resetting dconf setting for %s to default", _tmp93_);
#line 1161 "settings.c"
					}
#line 200 "../src/settings.vala"
					_g_free0 (key);
#line 1165 "settings.c"
				}
			}
		}
#line 218 "../src/settings.vala"
		_tmp94_ = strv_keys;
#line 1171 "settings.c"
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
#line 218 "../src/settings.vala"
			key_collection = _tmp94_;
#line 218 "../src/settings.vala"
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 1179 "settings.c"
				gchar* _tmp95_;
				gchar* key = NULL;
#line 218 "../src/settings.vala"
				_tmp95_ = g_strdup ((const gchar*) key_it->data);
#line 218 "../src/settings.vala"
				key = _tmp95_;
#line 1186 "settings.c"
				{
					gboolean _tmp96_ = FALSE;
					GKeyFile* _tmp97_;
#line 220 "../src/settings.vala"
					_tmp97_ = keyfile;
#line 220 "../src/settings.vala"
					if (g_key_file_has_group (_tmp97_, UG_SETTINGS_GROUP_NAME)) {
#line 1194 "settings.c"
						gboolean _tmp98_ = FALSE;
						GKeyFile* _tmp99_;
						const gchar* _tmp100_;
#line 220 "../src/settings.vala"
						_tmp99_ = keyfile;
#line 220 "../src/settings.vala"
						_tmp100_ = key;
#line 220 "../src/settings.vala"
						_tmp98_ = g_key_file_has_key (_tmp99_, UG_SETTINGS_GROUP_NAME, _tmp100_, &_inner_error0_);
#line 220 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 220 "../src/settings.vala"
							_g_free0 (key);
#line 220 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 220 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 220 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 220 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 220 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 220 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 220 "../src/settings.vala"
							_g_free0 (path);
#line 1222 "settings.c"
							goto __catch0_g_error;
						}
#line 220 "../src/settings.vala"
						_tmp96_ = _tmp98_;
#line 1227 "settings.c"
					} else {
#line 220 "../src/settings.vala"
						_tmp96_ = FALSE;
#line 1231 "settings.c"
					}
#line 220 "../src/settings.vala"
					if (_tmp96_) {
#line 1235 "settings.c"
						{
							gchar** value = NULL;
							GKeyFile* _tmp101_;
							const gchar* _tmp102_;
							gsize _tmp103_ = 0;
							gchar** _tmp104_;
							gint value_length1;
							gint _value_size_;
							const gchar* _tmp105_;
							GSettings* _tmp106_;
							const gchar* _tmp107_;
							gchar** _tmp108_;
							gint _tmp108__length1;
#line 222 "../src/settings.vala"
							_tmp101_ = keyfile;
#line 222 "../src/settings.vala"
							_tmp102_ = key;
#line 222 "../src/settings.vala"
							_tmp104_ = g_key_file_get_string_list (_tmp101_, UG_SETTINGS_GROUP_NAME, _tmp102_, &_tmp103_, &_inner_error0_);
#line 222 "../src/settings.vala"
							value = _tmp104_;
#line 222 "../src/settings.vala"
							value_length1 = _tmp103_;
#line 222 "../src/settings.vala"
							_value_size_ = value_length1;
#line 222 "../src/settings.vala"
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1263 "settings.c"
								goto __catch4_g_error;
							}
#line 223 "../src/settings.vala"
							_tmp105_ = key;
#line 223 "../src/settings.vala"
							g_debug ("settings.vala:223: Overriding dconf setting for %s", _tmp105_);
#line 224 "../src/settings.vala"
							_tmp106_ = gsettings;
#line 224 "../src/settings.vala"
							_tmp107_ = key;
#line 224 "../src/settings.vala"
							_tmp108_ = value;
#line 224 "../src/settings.vala"
							_tmp108__length1 = value_length1;
#line 224 "../src/settings.vala"
							g_settings_set_strv (_tmp106_, _tmp107_, _tmp108_);
#line 221 "../src/settings.vala"
							value = (_vala_array_free (value, value_length1, (GDestroyNotify) g_free), NULL);
#line 1282 "settings.c"
						}
						goto __finally4;
						__catch4_g_error:
						{
							GError* e = NULL;
							const gchar* _tmp109_;
							GError* _tmp110_;
							const gchar* _tmp111_;
#line 221 "../src/settings.vala"
							e = _inner_error0_;
#line 221 "../src/settings.vala"
							_inner_error0_ = NULL;
#line 227 "../src/settings.vala"
							_tmp109_ = key;
#line 227 "../src/settings.vala"
							_tmp110_ = e;
#line 227 "../src/settings.vala"
							_tmp111_ = _tmp110_->message;
#line 227 "../src/settings.vala"
							g_warning ("settings.vala:227: Failed to apply %s from configuration file: %s", _tmp109_, _tmp111_);
#line 221 "../src/settings.vala"
							_g_error_free0 (e);
#line 1305 "settings.c"
						}
						__finally4:
#line 221 "../src/settings.vala"
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 221 "../src/settings.vala"
							_g_free0 (key);
#line 221 "../src/settings.vala"
							(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 221 "../src/settings.vala"
							(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 221 "../src/settings.vala"
							(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 221 "../src/settings.vala"
							(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 221 "../src/settings.vala"
							_g_key_file_unref0 (keyfile);
#line 221 "../src/settings.vala"
							_g_object_unref0 (gsettings);
#line 221 "../src/settings.vala"
							_g_free0 (path);
#line 1326 "settings.c"
							goto __catch0_g_error;
						}
					} else {
						GSettings* _tmp112_;
						const gchar* _tmp113_;
						const gchar* _tmp114_;
#line 231 "../src/settings.vala"
						_tmp112_ = gsettings;
#line 231 "../src/settings.vala"
						_tmp113_ = key;
#line 231 "../src/settings.vala"
						g_settings_reset (_tmp112_, _tmp113_);
#line 232 "../src/settings.vala"
						_tmp114_ = key;
#line 232 "../src/settings.vala"
						g_debug ("settings.vala:232: Resetting dconf setting for %s to default", _tmp114_);
#line 1343 "settings.c"
					}
#line 218 "../src/settings.vala"
					_g_free0 (key);
#line 1347 "settings.c"
				}
			}
		}
#line 115 "../src/settings.vala"
		(strv_keys == NULL) ? NULL : (strv_keys = (_g_list_free__g_free0_ (strv_keys), NULL));
#line 115 "../src/settings.vala"
		(int_keys == NULL) ? NULL : (int_keys = (_g_list_free__g_free0_ (int_keys), NULL));
#line 115 "../src/settings.vala"
		(bool_keys == NULL) ? NULL : (bool_keys = (_g_list_free__g_free0_ (bool_keys), NULL));
#line 115 "../src/settings.vala"
		(string_keys == NULL) ? NULL : (string_keys = (_g_list_free__g_free0_ (string_keys), NULL));
#line 115 "../src/settings.vala"
		_g_key_file_unref0 (keyfile);
#line 115 "../src/settings.vala"
		_g_object_unref0 (gsettings);
#line 115 "../src/settings.vala"
		_g_free0 (path);
#line 1365 "settings.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp115_;
		const gchar* _tmp116_;
#line 115 "../src/settings.vala"
		e = _inner_error0_;
#line 115 "../src/settings.vala"
		_inner_error0_ = NULL;
#line 237 "../src/settings.vala"
		_tmp115_ = e;
#line 237 "../src/settings.vala"
		_tmp116_ = _tmp115_->message;
#line 237 "../src/settings.vala"
		g_warning ("settings.vala:237: Error in apply_conf_settings (): %s", _tmp116_);
#line 115 "../src/settings.vala"
		_g_error_free0 (e);
#line 1385 "settings.c"
	}
	__finally0:
#line 115 "../src/settings.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 115 "../src/settings.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 115 "../src/settings.vala"
		g_clear_error (&_inner_error0_);
#line 115 "../src/settings.vala"
		return;
#line 1396 "settings.c"
	}
}

UGSettings*
ug_settings_construct (GType object_type)
{
	UGSettings* self = NULL;
#line 21 "../src/settings.vala"
	self = (UGSettings*) g_type_create_instance (object_type);
#line 21 "../src/settings.vala"
	return self;
#line 1408 "settings.c"
}

UGSettings*
ug_settings_new (void)
{
#line 21 "../src/settings.vala"
	return ug_settings_construct (TYPE_UG_SETTINGS);
#line 1416 "settings.c"
}

static void
value_ug_settings_init (GValue* value)
{
#line 21 "../src/settings.vala"
	value->data[0].v_pointer = NULL;
#line 1424 "settings.c"
}

static void
value_ug_settings_free_value (GValue* value)
{
#line 21 "../src/settings.vala"
	if (value->data[0].v_pointer) {
#line 21 "../src/settings.vala"
		ug_settings_unref (value->data[0].v_pointer);
#line 1434 "settings.c"
	}
}

static void
value_ug_settings_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
#line 21 "../src/settings.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "../src/settings.vala"
		dest_value->data[0].v_pointer = ug_settings_ref (src_value->data[0].v_pointer);
#line 1446 "settings.c"
	} else {
#line 21 "../src/settings.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1450 "settings.c"
	}
}

static gpointer
value_ug_settings_peek_pointer (const GValue* value)
{
#line 21 "../src/settings.vala"
	return value->data[0].v_pointer;
#line 1459 "settings.c"
}

static gchar*
value_ug_settings_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
#line 21 "../src/settings.vala"
	if (collect_values[0].v_pointer) {
#line 1470 "settings.c"
		UGSettings * object;
		object = collect_values[0].v_pointer;
#line 21 "../src/settings.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "../src/settings.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1477 "settings.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "../src/settings.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1481 "settings.c"
		}
#line 21 "../src/settings.vala"
		value->data[0].v_pointer = ug_settings_ref (object);
#line 1485 "settings.c"
	} else {
#line 21 "../src/settings.vala"
		value->data[0].v_pointer = NULL;
#line 1489 "settings.c"
	}
#line 21 "../src/settings.vala"
	return NULL;
#line 1493 "settings.c"
}

static gchar*
value_ug_settings_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	UGSettings ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "../src/settings.vala"
	if (!object_p) {
#line 21 "../src/settings.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1508 "settings.c"
	}
#line 21 "../src/settings.vala"
	if (!value->data[0].v_pointer) {
#line 21 "../src/settings.vala"
		*object_p = NULL;
#line 1514 "settings.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "../src/settings.vala"
		*object_p = value->data[0].v_pointer;
#line 1518 "settings.c"
	} else {
#line 21 "../src/settings.vala"
		*object_p = ug_settings_ref (value->data[0].v_pointer);
#line 1522 "settings.c"
	}
#line 21 "../src/settings.vala"
	return NULL;
#line 1526 "settings.c"
}

GParamSpec*
param_spec_ug_settings (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecUGSettings* spec;
#line 21 "../src/settings.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UG_SETTINGS), NULL);
#line 21 "../src/settings.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "../src/settings.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "../src/settings.vala"
	return G_PARAM_SPEC (spec);
#line 1545 "settings.c"
}

gpointer
value_get_ug_settings (const GValue* value)
{
#line 21 "../src/settings.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UG_SETTINGS), NULL);
#line 21 "../src/settings.vala"
	return value->data[0].v_pointer;
#line 1555 "settings.c"
}

void
value_set_ug_settings (GValue* value,
                       gpointer v_object)
{
	UGSettings * old;
#line 21 "../src/settings.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UG_SETTINGS));
#line 21 "../src/settings.vala"
	old = value->data[0].v_pointer;
#line 21 "../src/settings.vala"
	if (v_object) {
#line 21 "../src/settings.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UG_SETTINGS));
#line 21 "../src/settings.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "../src/settings.vala"
		value->data[0].v_pointer = v_object;
#line 21 "../src/settings.vala"
		ug_settings_ref (value->data[0].v_pointer);
#line 1577 "settings.c"
	} else {
#line 21 "../src/settings.vala"
		value->data[0].v_pointer = NULL;
#line 1581 "settings.c"
	}
#line 21 "../src/settings.vala"
	if (old) {
#line 21 "../src/settings.vala"
		ug_settings_unref (old);
#line 1587 "settings.c"
	}
}

void
value_take_ug_settings (GValue* value,
                        gpointer v_object)
{
	UGSettings * old;
#line 21 "../src/settings.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UG_SETTINGS));
#line 21 "../src/settings.vala"
	old = value->data[0].v_pointer;
#line 21 "../src/settings.vala"
	if (v_object) {
#line 21 "../src/settings.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UG_SETTINGS));
#line 21 "../src/settings.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "../src/settings.vala"
		value->data[0].v_pointer = v_object;
#line 1608 "settings.c"
	} else {
#line 21 "../src/settings.vala"
		value->data[0].v_pointer = NULL;
#line 1612 "settings.c"
	}
#line 21 "../src/settings.vala"
	if (old) {
#line 21 "../src/settings.vala"
		ug_settings_unref (old);
#line 1618 "settings.c"
	}
}

static void
ug_settings_class_init (UGSettingsClass * klass,
                        gpointer klass_data)
{
#line 21 "../src/settings.vala"
	ug_settings_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/settings.vala"
	((UGSettingsClass *) klass)->finalize = ug_settings_finalize;
#line 1630 "settings.c"
}

static void
ug_settings_instance_init (UGSettings * self,
                           gpointer klass)
{
#line 21 "../src/settings.vala"
	self->ref_count = 1;
#line 1639 "settings.c"
}

static void
ug_settings_finalize (UGSettings * obj)
{
	UGSettings * self;
#line 21 "../src/settings.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UG_SETTINGS, UGSettings);
#line 21 "../src/settings.vala"
	g_signal_handlers_destroy (self);
#line 1650 "settings.c"
}

static GType
ug_settings_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_ug_settings_init, value_ug_settings_free_value, value_ug_settings_copy_value, value_ug_settings_peek_pointer, "p", value_ug_settings_collect_value, "p", value_ug_settings_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UGSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ug_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UGSettings), 0, (GInstanceInitFunc) ug_settings_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ug_settings_type_id;
	ug_settings_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UGSettings", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ug_settings_type_id;
}

GType
ug_settings_get_type (void)
{
	static volatile gsize ug_settings_type_id__once = 0;
	if (g_once_init_enter (&ug_settings_type_id__once)) {
		GType ug_settings_type_id;
		ug_settings_type_id = ug_settings_get_type_once ();
		g_once_init_leave (&ug_settings_type_id__once, ug_settings_type_id);
	}
	return ug_settings_type_id__once;
}

gpointer
ug_settings_ref (gpointer instance)
{
	UGSettings * self;
	self = instance;
#line 21 "../src/settings.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "../src/settings.vala"
	return instance;
#line 1685 "settings.c"
}

void
ug_settings_unref (gpointer instance)
{
	UGSettings * self;
	self = instance;
#line 21 "../src/settings.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "../src/settings.vala"
		UG_SETTINGS_GET_CLASS (self)->finalize (self);
#line 21 "../src/settings.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1699 "settings.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

