#ifndef SBK_KXMLGUIBUILDERWRAPPER_H
#define SBK_KXMLGUIBUILDERWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kxmlguibuilder.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class KXMLGUIBuilderWrapper : public KXMLGUIBuilder
{
public:
    KXMLGUIBuilderWrapper(::QWidget * widget);
    KXMLGUIBuilderWrapper(const KXMLGUIBuilderWrapper &) = delete;
    KXMLGUIBuilderWrapper& operator=(const KXMLGUIBuilderWrapper &) = delete;
    KXMLGUIBuilderWrapper(KXMLGUIBuilderWrapper &&) = delete;
    KXMLGUIBuilderWrapper& operator=(KXMLGUIBuilderWrapper &&) = delete;
    ~KXMLGUIBuilderWrapper() override;

    ::QStringList containerTags() const override;
    static ::QStringList sbk_o_containerTags(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QStringList customTags() const override;
    void finalizeGUI(::KXMLGUIClient * client) override;
    static void sbk_o_finalizeGUI(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KXMLGUIClient * client);
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 3> m_PyMethodCache = {nullptr, nullptr, nullptr};
};

#endif // SBK_KXMLGUIBUILDERWRAPPER_H
