/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_EXTERNAL_BRIGHTNESS_V1_SERVER_PROTOCOL_H
#define KDE_EXTERNAL_BRIGHTNESS_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_external_brightness_v1 The kde_external_brightness_v1 protocol
 * @section page_ifaces_kde_external_brightness_v1 Interfaces
 * - @subpage page_iface_kde_external_brightness_v1 - external brightness control
 * - @subpage page_iface_kde_external_brightness_device_v1 - brightness control device
 * @section page_copyright_kde_external_brightness_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 Xaver Hugl <xaver.hugl@gmail.com>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_external_brightness_device_v1;
struct kde_external_brightness_v1;

#ifndef KDE_EXTERNAL_BRIGHTNESS_V1_INTERFACE
#define KDE_EXTERNAL_BRIGHTNESS_V1_INTERFACE
/**
 * @page page_iface_kde_external_brightness_v1 kde_external_brightness_v1
 * @section page_iface_kde_external_brightness_v1_desc Description
 *
 * Some brightness control mechanisms are somewhat unstable, or require root
 * privileges, so putting them inside of the compositor is not desired.
 * This protocol is for outsourcing the actual brightness-setting to a
 * process outside of the compositor.
 * @section page_iface_kde_external_brightness_v1_api API
 * See @ref iface_kde_external_brightness_v1.
 */
/**
 * @defgroup iface_kde_external_brightness_v1 The kde_external_brightness_v1 interface
 *
 * Some brightness control mechanisms are somewhat unstable, or require root
 * privileges, so putting them inside of the compositor is not desired.
 * This protocol is for outsourcing the actual brightness-setting to a
 * process outside of the compositor.
 */
extern const struct wl_interface kde_external_brightness_v1_interface;
#endif
#ifndef KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_INTERFACE
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_INTERFACE
/**
 * @page page_iface_kde_external_brightness_device_v1 kde_external_brightness_device_v1
 * @section page_iface_kde_external_brightness_device_v1_desc Description
 *
 * After creating this object, the client should issue all relevant setup requests
 * (set_internal, set_edid, set_max_brightness, optionally set_observed_brightness)
 * and finish the sequence with commit.
 * Afterwards, for each change in values, the client must call commit again.
 * @section page_iface_kde_external_brightness_device_v1_api API
 * See @ref iface_kde_external_brightness_device_v1.
 */
/**
 * @defgroup iface_kde_external_brightness_device_v1 The kde_external_brightness_device_v1 interface
 *
 * After creating this object, the client should issue all relevant setup requests
 * (set_internal, set_edid, set_max_brightness, optionally set_observed_brightness)
 * and finish the sequence with commit.
 * Afterwards, for each change in values, the client must call commit again.
 */
extern const struct wl_interface kde_external_brightness_device_v1_interface;
#endif

/**
 * @ingroup iface_kde_external_brightness_v1
 * @struct kde_external_brightness_v1_interface
 */
struct kde_external_brightness_v1_interface {
	/**
	 * Destroy the object.
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * registers a brightness device with the compositor
	 *
	 * 
	 */
	void (*create_brightness_control)(struct wl_client *client,
					  struct wl_resource *resource,
					  uint32_t id);
};


/**
 * @ingroup iface_kde_external_brightness_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_V1_CREATE_BRIGHTNESS_CONTROL_SINCE_VERSION 1

/**
 * @ingroup iface_kde_external_brightness_device_v1
 * @struct kde_external_brightness_device_v1_interface
 */
struct kde_external_brightness_device_v1_interface {
	/**
	 * destroy the object and unregister the brightness control device
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * sets whether or not the brightness device belongs to an internal display
	 *
	 * 
	 * @param internal 1 if it's an internal panel, 0 if not
	 */
	void (*set_internal)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t internal);
	/**
	 * set the EDID data for identification of the display
	 *
	 * 
	 * @param string base-64 encoded string of the first 128 bytes of the EDID
	 */
	void (*set_edid)(struct wl_client *client,
			 struct wl_resource *resource,
			 const char *string);
	/**
	 * notifies the compositor of the maximum brightness that can be set on this device
	 *
	 * 
	 * @param value the maximum value that can be set
	 */
	void (*set_max_brightness)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t value);
	/**
	 * notifies the compositor that all relevant identifiers and values have been sent
	 *
	 * 
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * notifies the compositor of the brightness that was read from this device
	 *
	 * The client can set this to notify the compositor of the
	 * device's initial brightness. It can also set this again after
	 * the initial commit to notify the compositor that the brightness
	 * level has changed due to external factors. The compositor is
	 * free to use or ignore this value as it sees fit.
	 * @param value the observed value that was read
	 * @since 2
	 */
	void (*set_observed_brightness)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t value);
	/**
	 * notifies the compositor that DDC/CI is used to control brightness etc.
	 *
	 * The compositor can use this information to ignore this object
	 * if its commands expose monitor issues. The compositor may also
	 * reduce the amount of brightness requests given potentially slow
	 * response times and concerns about monitor EEPROM
	 * longevity/wear-out.
	 * @param value 1 if it uses DDC/CI, 0 if not (assumed by default)
	 * @since 3
	 */
	void (*set_uses_ddc_ci)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t value);
};

#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_REQUESTED_BRIGHTNESS 0

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_REQUESTED_BRIGHTNESS_SINCE_VERSION 1

/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_INTERNAL_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_EDID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_MAX_BRIGHTNESS_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_OBSERVED_BRIGHTNESS_SINCE_VERSION 2
/**
 * @ingroup iface_kde_external_brightness_device_v1
 */
#define KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_SET_USES_DDC_CI_SINCE_VERSION 3

/**
 * @ingroup iface_kde_external_brightness_device_v1
 * Sends an requested_brightness event to the client owning the resource.
 * @param resource_ The client's resource
 * @param value the value to set the device to
 */
static inline void
kde_external_brightness_device_v1_send_requested_brightness(struct wl_resource *resource_, uint32_t value)
{
	wl_resource_post_event(resource_, KDE_EXTERNAL_BRIGHTNESS_DEVICE_V1_REQUESTED_BRIGHTNESS, value);
}

#ifdef  __cplusplus
}
#endif

#endif
