
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kmimetypechooser_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qevent.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMimeTypeChooser_Type = nullptr;
static PyTypeObject *Sbk_KMimeTypeChooser_TypeF(void)
{
    return _Sbk_KMimeTypeChooser_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KMimeTypeChooserWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KMimeTypeChooserWrapper::KMimeTypeChooserWrapper(const ::QString & text, const ::QStringList & selectedMimeTypes, const ::QString & defaultGroup, const ::QStringList & groupsToShow, int visuals, ::QWidget * parent) : KMimeTypeChooser(text, selectedMimeTypes, defaultGroup, groupsToShow, visuals, parent)
{
}

void KMimeTypeChooserWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMimeTypeChooser", funcName, gil, pyOverride, signal);
}

void KMimeTypeChooserWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

int KMimeTypeChooserWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KMimeTypeChooser", funcName, gil, pyOverride);
}

void KMimeTypeChooserWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KMimeTypeChooser", funcName, gil, pyOverride, signal);
}

void KMimeTypeChooserWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KMimeTypeChooser", funcName, gil, pyOverride, watched, event);
}

void KMimeTypeChooserWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KMimeTypeChooser", funcName, gil, pyOverride, next);
}

void KMimeTypeChooserWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KMimeTypeChooser", funcName, gil, pyOverride);
}

int KMimeTypeChooserWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KMimeTypeChooser", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KMimeTypeChooser", funcName, gil, pyOverride, painter);
}

void KMimeTypeChooserWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

::QVariant KMimeTypeChooserWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KMimeTypeChooser", funcName, gil, pyOverride, arg__1);
}

void KMimeTypeChooserWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

int KMimeTypeChooserWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KMimeTypeChooser", funcName, gil, pyOverride, arg__1);
}

::QSize KMimeTypeChooserWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMimeTypeChooser", funcName, gil, pyOverride);
}

void KMimeTypeChooserWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

bool KMimeTypeChooserWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KMimeTypeChooser", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KMimeTypeChooserWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KMimeTypeChooser", funcName, gil, pyOverride);
}

void KMimeTypeChooserWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

::QPaintDevice * KMimeTypeChooserWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KMimeTypeChooser", funcName, gil, pyOverride, offset);
}

void KMimeTypeChooserWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KMimeTypeChooser", funcName, gil, pyOverride, visible);
}

::QPainter * KMimeTypeChooserWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KMimeTypeChooser", funcName, gil, pyOverride);
}

void KMimeTypeChooserWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

::QSize KMimeTypeChooserWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KMimeTypeChooser", funcName, gil, pyOverride);
}

void KMimeTypeChooserWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

void KMimeTypeChooserWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KMimeTypeChooser_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KMimeTypeChooser", funcName, gil, pyOverride, event);
}

const QMetaObject *KMimeTypeChooserWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KMimeTypeChooser::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KMimeTypeChooserWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KMimeTypeChooser::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KMimeTypeChooserWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KMimeTypeChooserWrapper *>(this));
    }
    return KMimeTypeChooser::qt_metacast(_clname);
}

KMimeTypeChooserWrapper::~KMimeTypeChooserWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KMimeTypeChooser_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMimeTypeChooser_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMimeTypeChooser >()))
        return -1;

    KMimeTypeChooserWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[6];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOOOOO:KMimeTypeChooser", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMimeTypeChooser::KMimeTypeChooser(const QString&=,const QStringList&=,const QString&=,const QStringList&=,int=,QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[5])))) {
                            overloadId = 0; // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[6] = {{"text", 0}, {"selectedMimeTypes", 1}, {"defaultGroup", 2}, {"groupsToShow", 3}, {"visuals", 4}, {"parent", 5}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 6, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[5]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]);
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1 = QStringList();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QStringList cppArg3 = QStringList();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = KMimeTypeChooser::Visuals::Comments | KMimeTypeChooser::Visuals::Patterns | KMimeTypeChooser::Visuals::EditButton;
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);
        if (!Shiboken::Object::isValid(pyArgs[5]))
            return -1;
        ::QWidget *cppArg5 = nullptr;
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KMimeTypeChooser(QString,QStringList,QString,QStringList,int,QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KMimeTypeChooserWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KMimeTypeChooserWrapper(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KMimeTypeChooser >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KMimeTypeChooserFunc_mimeTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMimeTypeChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // mimeTypes()const
        QStringList cppResult = const_cast<const ::KMimeTypeChooser *>(cppSelf)->mimeTypes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMimeTypeChooserFunc_patterns(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMimeTypeChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // patterns()const
        QStringList cppResult = const_cast<const ::KMimeTypeChooser *>(cppSelf)->patterns();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KMimeTypeChooser_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KMimeTypeChooser_EnumFlagInfo[] = {
    "Visuals:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMimeTypeChooser_methods[] = {
    {"mimeTypes", reinterpret_cast<PyCFunction>(Sbk_KMimeTypeChooserFunc_mimeTypes), METH_NOARGS, nullptr},
    {"patterns", reinterpret_cast<PyCFunction>(Sbk_KMimeTypeChooserFunc_patterns), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KMimeTypeChooser_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KMimeTypeChooser *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KMimeTypeChooserWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KMimeTypeChooser_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMimeTypeChooser_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KMimeTypeChooserSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KMimeTypeChooser *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMimeTypeChooser_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KMimeTypeChooser_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMimeTypeChooser_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMimeTypeChooser_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMimeTypeChooser_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMimeTypeChooser_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMimeTypeChooser_spec = {
    "1:KWidgetsAddons.KMimeTypeChooser",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMimeTypeChooser_slots
};

} //extern "C"

static void *Sbk_KMimeTypeChooser_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KMimeTypeChooser *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KMimeTypeChooser *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KMimeTypeChooser *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KMimeTypeChooser_Visuals(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KMimeTypeChooser::Visuals>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KMimeTypeChooser::Visuals *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KMimeTypeChooser_Visuals_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_Visuals_IDX])))
        return Enum_PythonToCpp_KMimeTypeChooser_Visuals;
    return {};
}

static PyObject *KMimeTypeChooser_Visuals_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KMimeTypeChooser::Visuals>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KMimeTypeChooser::Visuals *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMimeTypeChooser_PythonToCpp_KMimeTypeChooser_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMimeTypeChooser_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMimeTypeChooser_PythonToCpp_KMimeTypeChooser_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMimeTypeChooser_TypeF()))
        return KMimeTypeChooser_PythonToCpp_KMimeTypeChooser_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMimeTypeChooser_PTR_CppToPython_KMimeTypeChooser(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KMimeTypeChooser *>(const_cast<void *>(cppIn)), Sbk_KMimeTypeChooser_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMimeTypeChooser_SignatureStrings[] = {
    "KWidgetsAddons.KMimeTypeChooser(self,text:QString=QString(),selectedMimeTypes:QStringList=QStringList(),defaultGroup:QString=QString(),groupsToShow:QStringList=QStringList(),visuals:int=KMimeTypeChooser.Visuals.Comments | KMimeTypeChooser.Visuals.Patterns | KMimeTypeChooser.Visuals.EditButton,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "KWidgetsAddons.KMimeTypeChooser.mimeTypes(self)->QStringList",
    "KWidgetsAddons.KMimeTypeChooser.patterns(self)->QStringList",
    nullptr}; // Sentinel
#else
static constexpr size_t KMimeTypeChooser_SignatureByteSize = 203;
static constexpr uint8_t KMimeTypeChooser_SignatureBytes[203] = {
    0x78, 0xda, 0x85, 0x50, 0x4d, 0x0b, 0x82, 0x40, 0x10, 0xbd, 0xf7, 0x2b, 0x3c, 0x26, 0xd8, 0x1e,
    0x3b, 0x08, 0x06, 0x15, 0xd1, 0xc1, 0x02, 0x45, 0xa9, 0xb3, 0xb4, 0x93, 0x2e, 0xac, 0xbb, 0xcb,
    0xce, 0x6c, 0x25, 0xf4, 0xe3, 0xb3, 0x54, 0x88, 0x28, 0x3b, 0xcd, 0x30, 0xef, 0x83, 0x37, 0x2f,
    0x3e, 0x0a, 0x5e, 0x02, 0xe1, 0x92, 0x73, 0xad, 0x90, 0xc5, 0x7b, 0x51, 0x43, 0xde, 0x18, 0x58,
    0x57, 0x5a, 0x23, 0xd8, 0x29, 0x82, 0x3c, 0x07, 0x04, 0x37, 0x0a, 0xd3, 0x8c, 0xac, 0x50, 0x65,
    0xd4, 0xcf, 0xa9, 0x1f, 0xb4, 0x18, 0x9c, 0x08, 0xf8, 0xa0, 0xc1, 0x81, 0xb3, 0x13, 0x48, 0xd1,
    0xdb, 0xde, 0x72, 0x39, 0x9c, 0x0b, 0x27, 0x69, 0x6b, 0xb5, 0x33, 0x5f, 0xac, 0xca, 0xe7, 0x1d,
    0x73, 0x9d, 0x55, 0xfa, 0x3a, 0xe2, 0x72, 0x11, 0xe8, 0x0a, 0x89, 0xa1, 0x50, 0x14, 0x7d, 0x46,
    0x65, 0x87, 0x0e, 0x64, 0x6b, 0x5d, 0xd7, 0xa0, 0x08, 0xbd, 0xbb, 0xf7, 0x93, 0x93, 0x14, 0x44,
    0x60, 0xd5, 0x28, 0x67, 0xc3, 0x05, 0xad, 0x1c, 0x91, 0x56, 0x81, 0x29, 0x6c, 0xeb, 0x18, 0x26,
    0x4d, 0x26, 0x38, 0xcc, 0x59, 0x4a, 0x7d, 0x6b, 0x2c, 0xed, 0x96, 0x48, 0x39, 0x29, 0x0d, 0x59,
    0x7f, 0x12, 0x8f, 0xf7, 0xc9, 0xea, 0xa1, 0xab, 0x57, 0xb3, 0xfe, 0x6c, 0xf1, 0xf6, 0xe0, 0x5f,
    0xb1, 0xe9, 0x53, 0x7f, 0xd3, 0x3e, 0x00, 0xb5, 0x5c, 0xab, 0x42
};
#endif

PyTypeObject *init_KMimeTypeChooser(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX].type;

    Shiboken::AutoDecRef Sbk_KMimeTypeChooser_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_KMimeTypeChooser_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMimeTypeChooser",
        "KMimeTypeChooser*",
        &Sbk_KMimeTypeChooser_spec,
        &Shiboken::callCppDestructor< KMimeTypeChooser >,
        Sbk_KMimeTypeChooser_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_KMimeTypeChooser_Type; // references _Sbk_KMimeTypeChooser_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMimeTypeChooser_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMimeTypeChooser_SignatureBytes, KMimeTypeChooser_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMimeTypeChooser_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMimeTypeChooser_PythonToCpp_KMimeTypeChooser_PTR,
        is_KMimeTypeChooser_PythonToCpp_KMimeTypeChooser_PTR_Convertible,
        KMimeTypeChooser_PTR_CppToPython_KMimeTypeChooser);

    Shiboken::Conversions::registerConverterName(converter, "KMimeTypeChooser");
    Shiboken::Conversions::registerConverterName(converter, "KMimeTypeChooser*");
    Shiboken::Conversions::registerConverterName(converter, "KMimeTypeChooser&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMimeTypeChooser).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KMimeTypeChooserWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KMimeTypeChooser_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KMimeTypeChooser_TypeF(), &Sbk_KMimeTypeChooserSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KMimeTypeChooser_TypeF(), &Sbk_KMimeTypeChooser_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KMimeTypeChooser_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Visuals'.
    const char *Visuals_Initializer[] = {
        "Comments",
        "Patterns",
        "EditButton",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Visuals_InitializerValues[] = {
        uint8_t(KMimeTypeChooser::Visuals::Comments),  //  0x01  1
        uint8_t(KMimeTypeChooser::Visuals::Patterns),  //  0x02  2
        uint8_t(KMimeTypeChooser::Visuals::EditButton) //  0x04  4
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KMimeTypeChooser_TypeF(),
        "1:KWidgetsAddons.KMimeTypeChooser.Visuals",
        Visuals_Initializer, Visuals_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KMimeTypeChooser_Visuals_IDX].type = EType;
    // Register converter for enum 'KMimeTypeChooser::Visuals'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KMimeTypeChooser_Visuals_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KMimeTypeChooser_Visuals,
            is_Enum_PythonToCpp_KMimeTypeChooser_Visuals_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KMimeTypeChooser::Visuals");
        Shiboken::Conversions::registerConverterAlias(converter, "Visuals");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Visuals' enum.

    qRegisterMetaType< ::KMimeTypeChooser::Visuals >("KMimeTypeChooser::Visuals");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KMimeTypeChooser::staticMetaObject, sizeof(KMimeTypeChooserWrapper));

    return pyType;
}
