
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kmemoryinfo_wrapper.h"

// Argument includes
#include <kmemoryinfo.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMemoryInfo_Type = nullptr;
static PyTypeObject *Sbk_KMemoryInfo_TypeF(void)
{
    return _Sbk_KMemoryInfo_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KMemoryInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KMemoryInfo >()))
        return -1;

    ::KMemoryInfo *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KMemoryInfo", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KMemoryInfo::KMemoryInfo()
    // 1: KMemoryInfo::KMemoryInfo(KMemoryInfo)
    if (numArgs == 0) {
        overloadId = 0; // KMemoryInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KMemoryInfo(KMemoryInfo)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KMemoryInfo()
        {

            // KMemoryInfo()
            cptr = new ::KMemoryInfo();
            break;
        }
        case 1: // KMemoryInfo(const KMemoryInfo &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KMemoryInfo cppArg0_local;
            ::KMemoryInfo *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KMemoryInfo(KMemoryInfo)
                cptr = new ::KMemoryInfo(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KMemoryInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KMemoryInfoFunc_availablePhysical(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // availablePhysical()const
        quint64 cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->availablePhysical();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfoFunc_buffers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // buffers()const
        quint64 cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->buffers();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfoFunc_cached(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // cached()const
        quint64 cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->cached();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfoFunc_freePhysical(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // freePhysical()const
        quint64 cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->freePhysical();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfoFunc_freeSwapFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // freeSwapFile()const
        quint64 cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->freeSwapFile();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfoFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfoFunc_totalPhysical(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // totalPhysical()const
        quint64 cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->totalPhysical();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfoFunc_totalSwapFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // totalSwapFile()const
        quint64 cppResult = const_cast<const ::KMemoryInfo *>(cppSelf)->totalSwapFile();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMemoryInfo__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KMemoryInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMemoryInfo_methods[] = {
    {"availablePhysical", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_availablePhysical), METH_NOARGS, nullptr},
    {"buffers", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_buffers), METH_NOARGS, nullptr},
    {"cached", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_cached), METH_NOARGS, nullptr},
    {"freePhysical", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_freePhysical), METH_NOARGS, nullptr},
    {"freeSwapFile", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_freeSwapFile), METH_NOARGS, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_isNull), METH_NOARGS, nullptr},
    {"totalPhysical", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_totalPhysical), METH_NOARGS, nullptr},
    {"totalSwapFile", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfoFunc_totalSwapFile), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KMemoryInfo__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_KMemoryInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), (pyArg)))) {
                // operator!=(const KMemoryInfo &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KMemoryInfo cppArg0_local;
                ::KMemoryInfo *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf != (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), (pyArg)))) {
                // operator==(const KMemoryInfo &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KMemoryInfo cppArg0_local;
                ::KMemoryInfo *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

} // extern "C"

static int Sbk_KMemoryInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMemoryInfo_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMemoryInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMemoryInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMemoryInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_KMemoryInfo_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMemoryInfo_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMemoryInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMemoryInfo_spec = {
    "1:KCoreAddons.KMemoryInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMemoryInfo_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KMemoryInfo_PythonToCpp_KMemoryInfo_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KMemoryInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KMemoryInfo_PythonToCpp_KMemoryInfo_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KMemoryInfo_TypeF()))
        return KMemoryInfo_PythonToCpp_KMemoryInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KMemoryInfo_PTR_CppToPython_KMemoryInfo(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KMemoryInfo_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KMemoryInfo_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KMemoryInfo_COPY_CppToPython_KMemoryInfo(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KMemoryInfo *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KMemoryInfo_TypeF(), new ::KMemoryInfo(*source), true, true);
}

// Python to C++ copy conversion.
static void KMemoryInfo_PythonToCpp_KMemoryInfo_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KMemoryInfo *>(cppOut) = *reinterpret_cast< ::KMemoryInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KMemoryInfo_PythonToCpp_KMemoryInfo_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KMemoryInfo_TypeF()))
        return KMemoryInfo_PythonToCpp_KMemoryInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KMemoryInfo_SignatureStrings[] = {
    "1:KCoreAddons.KMemoryInfo(self)",
    "0:KCoreAddons.KMemoryInfo(self,other:KCoreAddons.KMemoryInfo)",
    "KCoreAddons.KMemoryInfo.availablePhysical(self)->quint64",
    "KCoreAddons.KMemoryInfo.buffers(self)->quint64",
    "KCoreAddons.KMemoryInfo.cached(self)->quint64",
    "KCoreAddons.KMemoryInfo.freePhysical(self)->quint64",
    "KCoreAddons.KMemoryInfo.freeSwapFile(self)->quint64",
    "KCoreAddons.KMemoryInfo.isNull(self)->bool",
    "KCoreAddons.KMemoryInfo.totalPhysical(self)->quint64",
    "KCoreAddons.KMemoryInfo.totalSwapFile(self)->quint64",
    "KCoreAddons.KMemoryInfo.__copy__(self)->typing._Self",
    "KCoreAddons.KMemoryInfo.__ne__(self,other:KCoreAddons.KMemoryInfo)->bool",
    "KCoreAddons.KMemoryInfo.__eq__(self,other:KCoreAddons.KMemoryInfo)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KMemoryInfo_SignatureByteSize = 180;
static constexpr uint8_t KMemoryInfo_SignatureBytes[180] = {
    0x78, 0xda, 0x95, 0x92, 0xcf, 0x0a, 0xc2, 0x30, 0x0c, 0x87, 0xef, 0x7b, 0x12, 0x07, 0x3a, 0x14,
    0xc4, 0x83, 0x07, 0x41, 0x04, 0x41, 0x86, 0x22, 0xec, 0x01, 0x4a, 0xd7, 0xa5, 0xae, 0x10, 0x9b,
    0xad, 0xed, 0x94, 0xbe, 0xbd, 0xff, 0xbd, 0x75, 0x5b, 0x8f, 0x21, 0xdf, 0x97, 0xfc, 0x02, 0x59,
    0xac, 0xf3, 0x1d, 0x19, 0xd8, 0x56, 0x15, 0x69, 0x9b, 0xe5, 0x47, 0xb8, 0x92, 0xf1, 0x07, 0x2d,
    0x69, 0x62, 0x01, 0x65, 0x9a, 0xcc, 0x7b, 0xfb, 0x53, 0x72, 0x35, 0x98, 0x10, 0x92, 0x26, 0x81,
    0x46, 0xc6, 0x6f, 0x5c, 0x21, 0x2f, 0x11, 0xce, 0xb5, 0xb7, 0x4a, 0x70, 0xfc, 0x6c, 0x9b, 0x6d,
    0xda, 0x4e, 0x69, 0xb7, 0x5a, 0x06, 0xc5, 0xb2, 0x93, 0x12, 0x8c, 0x1d, 0x8b, 0x0b, 0x2e, 0x6a,
    0xa8, 0xc6, 0xd2, 0xd2, 0x40, 0x74, 0xa0, 0x97, 0x53, 0xdc, 0x79, 0xb3, 0x57, 0x08, 0x63, 0x1d,
    0x65, 0x4f, 0x1d, 0xfe, 0x37, 0x94, 0x44, 0x18, 0x44, 0x1d, 0x39, 0x8e, 0xb1, 0x99, 0xde, 0x52,
    0x6c, 0x28, 0xc6, 0x04, 0x35, 0x9e, 0xb1, 0x1f, 0xef, 0x7c, 0xa3, 0xf4, 0x25, 0x63, 0xc5, 0xb3,
    0xec, 0x91, 0x34, 0x7c, 0x95, 0x81, 0x57, 0x18, 0xb8, 0x93, 0x31, 0x68, 0xa3, 0x06, 0x3d, 0x00,
    0xa4, 0x62, 0xfa, 0x93
};
#endif

PyTypeObject *init_KMemoryInfo(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX].type;

    Shiboken::AutoDecRef Sbk_KMemoryInfo_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KMemoryInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMemoryInfo",
        "KMemoryInfo",
        &Sbk_KMemoryInfo_spec,
        &Shiboken::callCppDestructor< ::KMemoryInfo >,
        Sbk_KMemoryInfo_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_KMemoryInfo_TypeF(); // references _Sbk_KMemoryInfo_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KMemoryInfo_SignatureStrings);
#else
    InitSignatureBytes(pyType, KMemoryInfo_SignatureBytes, KMemoryInfo_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMemoryInfo_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KMemoryInfo_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KMemoryInfo_PythonToCpp_KMemoryInfo_PTR,
        is_KMemoryInfo_PythonToCpp_KMemoryInfo_PTR_Convertible,
        KMemoryInfo_PTR_CppToPython_KMemoryInfo,
        KMemoryInfo_COPY_CppToPython_KMemoryInfo);

    Shiboken::Conversions::registerConverterName(converter, "KMemoryInfo");
    Shiboken::Conversions::registerConverterName(converter, "KMemoryInfo*");
    Shiboken::Conversions::registerConverterName(converter, "KMemoryInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KMemoryInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KMemoryInfo_PythonToCpp_KMemoryInfo_COPY,
        is_KMemoryInfo_PythonToCpp_KMemoryInfo_COPY_Convertible);

    qRegisterMetaType< ::KMemoryInfo >("KMemoryInfo");

    return pyType;
}
