{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoAttrSize@ structure is used to represent attributes which
-- set font size.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.AttrSize
    ( 

-- * Exported types
    AttrSize(..)                            ,
    newZeroAttrSize                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAttrSizeMethod                   ,
#endif

-- ** new #method:new#

    attrSizeNew                             ,


-- ** newAbsolute #method:newAbsolute#

    attrSizeNewAbsolute                     ,




 -- * Properties


-- ** absolute #attr:absolute#
-- | whether the font size is in device units or points.
--   This field is only present for compatibility with Pango-1.8.0
--   ('GI.Pango.Enums.AttrTypeAbsoluteSize' was added in 1.8.1); and always will
--   be 'P.False' for 'GI.Pango.Enums.AttrTypeSize' and 'P.True' for 'GI.Pango.Enums.AttrTypeAbsoluteSize'.

#if defined(ENABLE_OVERLOADING)
    attrSize_absolute                       ,
#endif
    getAttrSizeAbsolute                     ,
    setAttrSizeAbsolute                     ,


-- ** attr #attr:attr#
-- | the common portion of the attribute

#if defined(ENABLE_OVERLOADING)
    attrSize_attr                           ,
#endif
    getAttrSizeAttr                         ,


-- ** size #attr:size#
-- | size of font, in units of 1\/'GI.Pango.Constants.SCALE' of a point (for
--   'GI.Pango.Enums.AttrTypeSize') or of a device unit (for 'GI.Pango.Enums.AttrTypeAbsoluteSize')

#if defined(ENABLE_OVERLOADING)
    attrSize_size                           ,
#endif
    getAttrSizeSize                         ,
    setAttrSizeSize                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute

#endif

-- | Memory-managed wrapper type.
newtype AttrSize = AttrSize (SP.ManagedPtr AttrSize)
    deriving (Eq)

instance SP.ManagedPtrNewtype AttrSize where
    toManagedPtr (AttrSize p) = p

instance BoxedPtr AttrSize where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr AttrSize)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AttrSize where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'AttrSize' struct initialized to zero.
newZeroAttrSize :: MonadIO m => m AttrSize
newZeroAttrSize = liftIO $ boxedPtrCalloc >>= wrapPtr AttrSize

instance tag ~ 'AttrSet => Constructible AttrSize tag where
    new _ attrs = do
        o <- newZeroAttrSize
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@attr@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrSize #attr
-- @
getAttrSizeAttr :: MonadIO m => AttrSize -> m Pango.Attribute.Attribute
getAttrSizeAttr s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr Pango.Attribute.Attribute)
    val' <- (newBoxed Pango.Attribute.Attribute) val
    return val'

#if defined(ENABLE_OVERLOADING)
data AttrSizeAttrFieldInfo
instance AttrInfo AttrSizeAttrFieldInfo where
    type AttrBaseTypeConstraint AttrSizeAttrFieldInfo = (~) AttrSize
    type AttrAllowedOps AttrSizeAttrFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint AttrSizeAttrFieldInfo = (~) (Ptr Pango.Attribute.Attribute)
    type AttrTransferTypeConstraint AttrSizeAttrFieldInfo = (~)(Ptr Pango.Attribute.Attribute)
    type AttrTransferType AttrSizeAttrFieldInfo = (Ptr Pango.Attribute.Attribute)
    type AttrGetType AttrSizeAttrFieldInfo = Pango.Attribute.Attribute
    type AttrLabel AttrSizeAttrFieldInfo = "attr"
    type AttrOrigin AttrSizeAttrFieldInfo = AttrSize
    attrGet = getAttrSizeAttr
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrSize.attr"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrSize.html#g:attr:attr"
        })

attrSize_attr :: AttrLabelProxy "attr"
attrSize_attr = AttrLabelProxy

#endif


-- | Get the value of the “@size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrSize #size
-- @
getAttrSizeSize :: MonadIO m => AttrSize -> m Int32
getAttrSizeSize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int32
    return val

-- | Set the value of the “@size@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrSize [ #size 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrSizeSize :: MonadIO m => AttrSize -> Int32 -> m ()
setAttrSizeSize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data AttrSizeSizeFieldInfo
instance AttrInfo AttrSizeSizeFieldInfo where
    type AttrBaseTypeConstraint AttrSizeSizeFieldInfo = (~) AttrSize
    type AttrAllowedOps AttrSizeSizeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AttrSizeSizeFieldInfo = (~) Int32
    type AttrTransferTypeConstraint AttrSizeSizeFieldInfo = (~)Int32
    type AttrTransferType AttrSizeSizeFieldInfo = Int32
    type AttrGetType AttrSizeSizeFieldInfo = Int32
    type AttrLabel AttrSizeSizeFieldInfo = "size"
    type AttrOrigin AttrSizeSizeFieldInfo = AttrSize
    attrGet = getAttrSizeSize
    attrSet = setAttrSizeSize
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrSize.size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrSize.html#g:attr:size"
        })

attrSize_size :: AttrLabelProxy "size"
attrSize_size = AttrLabelProxy

#endif


-- | Get the value of the “@absolute@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' attrSize #absolute
-- @
getAttrSizeAbsolute :: MonadIO m => AttrSize -> m Word32
getAttrSizeAbsolute s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@absolute@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' attrSize [ #absolute 'Data.GI.Base.Attributes.:=' value ]
-- @
setAttrSizeAbsolute :: MonadIO m => AttrSize -> Word32 -> m ()
setAttrSizeAbsolute s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data AttrSizeAbsoluteFieldInfo
instance AttrInfo AttrSizeAbsoluteFieldInfo where
    type AttrBaseTypeConstraint AttrSizeAbsoluteFieldInfo = (~) AttrSize
    type AttrAllowedOps AttrSizeAbsoluteFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AttrSizeAbsoluteFieldInfo = (~) Word32
    type AttrTransferTypeConstraint AttrSizeAbsoluteFieldInfo = (~)Word32
    type AttrTransferType AttrSizeAbsoluteFieldInfo = Word32
    type AttrGetType AttrSizeAbsoluteFieldInfo = Word32
    type AttrLabel AttrSizeAbsoluteFieldInfo = "absolute"
    type AttrOrigin AttrSizeAbsoluteFieldInfo = AttrSize
    attrGet = getAttrSizeAbsolute
    attrSet = setAttrSizeAbsolute
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.AttrSize.absolute"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-AttrSize.html#g:attr:absolute"
        })

attrSize_absolute :: AttrLabelProxy "absolute"
attrSize_absolute = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AttrSize
type instance O.AttributeList AttrSize = AttrSizeAttributeList
type AttrSizeAttributeList = ('[ '("attr", AttrSizeAttrFieldInfo), '("size", AttrSizeSizeFieldInfo), '("absolute", AttrSizeAbsoluteFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method AttrSize::new
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the font size, in %PANGO_SCALE-ths of a point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_size_new" pango_attr_size_new :: 
    Int32 ->                                -- size : TBasicType TInt
    IO (Ptr Pango.Attribute.Attribute)

-- | Create a new font-size attribute in fractional points.
attrSizeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@size@/: the font size, in 'GI.Pango.Constants.SCALE'-ths of a point
    -> m Pango.Attribute.Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'
attrSizeNew size = liftIO $ do
    result <- pango_attr_size_new size
    checkUnexpectedReturnNULL "attrSizeNew" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AttrSize::new_absolute
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "size"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the font size, in %PANGO_SCALE-ths of a device unit"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Attribute" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_attr_size_new_absolute" pango_attr_size_new_absolute :: 
    Int32 ->                                -- size : TBasicType TInt
    IO (Ptr Pango.Attribute.Attribute)

-- | Create a new font-size attribute in device units.
-- 
-- /Since: 1.8/
attrSizeNewAbsolute ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Int32
    -- ^ /@size@/: the font size, in 'GI.Pango.Constants.SCALE'-ths of a device unit
    -> m Pango.Attribute.Attribute
    -- ^ __Returns:__ the newly allocated
    --   @PangoAttribute@, which should be freed with
    --   'GI.Pango.Structs.Attribute.attributeDestroy'
attrSizeNewAbsolute size = liftIO $ do
    result <- pango_attr_size_new_absolute size
    checkUnexpectedReturnNULL "attrSizeNewAbsolute" result
    result' <- (wrapBoxed Pango.Attribute.Attribute) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAttrSizeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAttrSizeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAttrSizeMethod t AttrSize, O.OverloadedMethod info AttrSize p) => OL.IsLabel t (AttrSize -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAttrSizeMethod t AttrSize, O.OverloadedMethod info AttrSize p, R.HasField t AttrSize p) => R.HasField t AttrSize p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAttrSizeMethod t AttrSize, O.OverloadedMethodInfo info AttrSize) => OL.IsLabel t (O.MethodProxy info AttrSize) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


