/**************************************************************************/
/*  license.gen.h                                                         */
/**************************************************************************/
/*                         This file is part of:                          */
/*                             GODOT ENGINE                               */
/*                        https://godotengine.org                         */
/**************************************************************************/
/* Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md). */
/* Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.                  */
/*                                                                        */
/* Permission is hereby granted, free of charge, to any person obtaining  */
/* a copy of this software and associated documentation files (the        */
/* "Software"), to deal in the Software without restriction, including    */
/* without limitation the rights to use, copy, modify, merge, publish,    */
/* distribute, sublicense, and/or sell copies of the Software, and to     */
/* permit persons to whom the Software is furnished to do so, subject to  */
/* the following conditions:                                              */
/*                                                                        */
/* The above copyright notice and this permission notice shall be         */
/* included in all copies or substantial portions of the Software.        */
/*                                                                        */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        */
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     */
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. */
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY   */
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,   */
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE      */
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                 */
/**************************************************************************/

/* THIS FILE IS GENERATED. EDITS WILL BE LOST. */

#pragma once

inline constexpr const char *GODOT_LICENSE_TEXT = {
R"<!>(Copyright (c) 2014-present Godot Engine contributors (see AUTHORS.md).
Copyright (c) 2007-2014 Juan Linietsky, Ariel Manzur.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
)<!>"
};

struct ComponentCopyrightPart {
	const char *license;
	const char *const *files;
	const char *const *copyright_statements;
	int file_count;
	int copyright_count;
};

struct ComponentCopyright {
	const char *name;
	const ComponentCopyrightPart *parts;
	int part_count;
};

inline constexpr const char *COPYRIGHT_INFO_DATA[] = {
	"*",
	"2014-present, Godot Engine contributors",
	"2007-2014, Juan Linietsky, Ariel Manzur",
	"icon.png",
	"icon.svg",
	"logo.png",
	"logo.svg",
	"2017, Andrea Calabró",
	"core/math/convex_hull.cpp",
	"core/math/convex_hull.h",
	"2011, Ole Kniemeyer, MAXON, www.maxon.net",
	"2014-present, Godot Engine contributors",
	"2007-2014, Juan Linietsky, Ariel Manzur",
	"modules/godot_physics_3d/gjk_epa.cpp",
	"modules/godot_physics_3d/joints/godot_generic_6dof_joint_3d.cpp",
	"modules/godot_physics_3d/joints/godot_generic_6dof_joint_3d.h",
	"modules/godot_physics_3d/joints/godot_hinge_joint_3d.cpp",
	"modules/godot_physics_3d/joints/godot_hinge_joint_3d_sw.h",
	"modules/godot_physics_3d/joints/godot_jacobian_entry_3d_sw.h",
	"modules/godot_physics_3d/joints/godot_pin_joint_3d.cpp",
	"modules/godot_physics_3d/joints/godot_pin_joint_3d.h",
	"modules/godot_physics_3d/joints/godot_slider_joint_3d.cpp",
	"modules/godot_physics_3d/joints/godot_slider_joint_3d.h",
	"modules/godot_physics_3d/godot_soft_body_3d.cpp",
	"modules/godot_physics_3d/godot_soft_body_3d.h",
	"modules/godot_physics_3d/godot_shape_3d.cpp",
	"modules/godot_physics_3d/godot_shape_3d.h",
	"2003-2008, Erwin Coumans",
	"2014-present, Godot Engine contributors",
	"2007-2014, Juan Linietsky, Ariel Manzur",
	"modules/godot_physics_3d/joints/godot_cone_twist_joint_3d.cpp",
	"modules/godot_physics_3d/joints/godot_cone_twist_joint_3d.h",
	"2007, Starbreeze Studios",
	"2014-present, Godot Engine contributors",
	"2007-2014, Juan Linietsky, Ariel Manzur",
	"modules/betsy/alpha_stitch.glsl",
	"modules/betsy/bc1.glsl",
	"modules/betsy/bc4.glsl",
	"modules/betsy/bc6h.glsl",
	"modules/betsy/CrossPlatformSettings_piece_all.glsl",
	"2020-2022, Matias N. Goldberg",
	"modules/godot_physics_2d/godot_joints_2d.cpp",
	"2007, Scott Lembcke",
	"modules/godot_physics_3d/godot_collision_solver_3d_sat.cpp",
	"2001-2003, Russell L. Smith, Alen Ladavac, Nguyen Binh",
	"modules/jolt_physics/spaces/jolt_temp_allocator.cpp",
	"2021, Jorrit Rouwe",
	"2014-present, Godot Engine contributors",
	"2007-2014, Juan Linietsky, Ariel Manzur",
	"thirdparty/jolt_physics/*",
	"2021, Jorrit Rouwe",
	"modules/lightmapper_rd/lm_compute.glsl",
	"2020, Manuel Prandini",
	"2014-present, Godot Engine contributors",
	"2007-2014, Juan Linietsky, Ariel Manzur",
	"platform/android/java/editor/src/main/java/com/android/*",
	"platform/android/java/lib/aidl/com/android/*",
	"platform/android/java/lib/res/layout/status_bar_ongoing_event_progress_bar.xml",
	"platform/android/java/lib/src/com/google/android/*",
	"platform/android/java/lib/src/org/godotengine/godot/input/InputManagerCompat.java",
	"platform/android/java/lib/src/org/godotengine/godot/input/InputManagerV16.java",
	"2008-2016, The Android Open Source Project",
	"2002, Google, Inc.",
	"platform/android/java/lib/src/org/godotengine/godot/utils/ProcessPhoenix.java",
	"2015, Jake Wharton",
	"scene/animation/easing_equations.h",
	"2001, Robert Penner",
	"2014-present, Godot Engine contributors",
	"2007-2014, Juan Linietsky, Ariel Manzur",
	"./servers/rendering/renderer_rd/shaders/effects/tonemap.glsl",
	"2014-2015, NVIDIA CORPORATION",
	"2017 Simon Rodriguez",
	"./servers/rendering/renderer_rd/shaders/ss_effects_downsample.glsl",
	"./servers/rendering/renderer_rd/shaders/ssao_blur.glsl",
	"./servers/rendering/renderer_rd/shaders/ssao_importance_map.glsl",
	"./servers/rendering/renderer_rd/shaders/ssao_interleave.glsl",
	"./servers/rendering/renderer_rd/shaders/ssao.glsl",
	"./servers/rendering/renderer_rd/shaders/ssil_blur.glsl",
	"./servers/rendering/renderer_rd/shaders/ssil_importance_map.glsl",
	"./servers/rendering/renderer_rd/shaders/ssil_interleave.glsl",
	"./servers/rendering/renderer_rd/shaders/ssil.glsl",
	"2016, Intel Corporation",
	"servers/rendering/renderer_rd/shaders/effects/taa_resolve.glsl",
	"2016, Panos Karabelas",
	"servers/rendering/renderer_rd/shaders/smaa_blending.glsl",
	"servers/rendering/renderer_rd/shaders/smaa_weight_calculation.glsl",
	"servers/rendering/renderer_rd/shaders/smaa_edge_detection.glsl",
	"thirdparty/smaa/*",
	"2013, Jorge Jimenez",
	"2013, Jose I. Echevarria",
	"2013, Belen Masia",
	"2013, Fernando Navarro",
	"2013, Diego Gutierrez",
	"thirdparty/accesskit/*",
	"2023, The AccessKit Authors.",
	"thirdparty/amd-fsr/*",
	"2021, Advanced Micro Devices, Inc.",
	"thirdparty/amd-fsr2/*",
	"2022-2023, Advanced Micro Devices, Inc.",
	"thirdparty/angle/*",
	"2018, The ANGLE Project Authors.",
	"thirdparty/astcenc/*",
	"2011-2025, Arm Limited",
	"thirdparty/basis_universal/*",
	"2019-2024, Binomial LLC.",
	"thirdparty/brotli/*",
	"2009, 2010, 2013-2016 by the Brotli Authors.",
	"thirdparty/certs/ca-certificates.crt",
	"Mozilla Contributors",
	"thirdparty/clipper2/*",
	"2010-2025, Angus Johnson",
	"thirdparty/cvtt/*",
	"2018, Eric Lasota",
	"2018, Microsoft Corp.",
	"thirdparty/d3d12ma/*",
	"2019-2022 Advanced Micro Devices, Inc.",
	"thirdparty/directx_headers/*",
	"Microsoft Corporation",
	"thirdparty/doctest/*",
	"2016-2023, Viktor Kirilov",
	"thirdparty/embree/*",
	"2009-2021 Intel Corporation",
	"thirdparty/enet/*",
	"2002-2024, Lee Salzman",
	"thirdparty/etcpak/*",
	"2013-2022, Bartosz Taudul",
	"thirdparty/fonts/DroidSans*.woff2",
	"2008, The Android Open Source Project",
	"thirdparty/fonts/JetBrainsMono_Regular.woff2",
	"2020, JetBrains s.r.o.",
	"thirdparty/fonts/NotoSans*.woff2",
	"2012, Google Inc.",
	"thirdparty/fonts/Vazirmatn*.woff2",
	"2015, The Vazirmatn Project Authors.",
	"thirdparty/freetype/*",
	"1996-2023, David Turner, Robert Wilhelm, and Werner Lemberg.",
	"thirdparty/glad/*",
	"2013-2022, David Herberth",
	"2013-2020, The Khronos Group Inc.",
	"thirdparty/glslang/*",
	"2015-2020, Google, Inc.",
	"2014-2020, The Khronos Group Inc",
	"2002, NVIDIA Corporation.",
	"thirdparty/graphite/*",
	"2010, SIL International",
	"thirdparty/grisu2/*",
	"2009, Florian Loitsch",
	"2018-2023, The simdjson authors",
	"thirdparty/harfbuzz/*",
	"2010-2022, Google, Inc.",
	"2015-2020, Ebrahim Byagowi",
	"2019,2020, Facebook, Inc.",
	"2012, 2015, Mozilla Foundation",
	"2011, Codethink Limited",
	"2008, 2010, Nokia Corporation and/or its subsidiary(-ies)",
	"2009, Keith Stribley",
	"2011, Martin Hosken and SIL International",
	"2007, Chris Wilson",
	"2005-2006, 2020-2023, Behdad Esfahbod",
	"2004, 2007-2010, 2013, 2021-2023, Red Hat, Inc.",
	"1998-2005, David Turner and Werner Lemberg",
	"2016, Igalia, S.L.",
	"2022, Matthias Clasen",
	"2018, 2021, Khaled Hosny",
	"2018-2020, Adobe, Inc.",
	"2013-2015, Alexei Podtelezhnikov",
	"thirdparty/icu4c/*",
	"2016-2024, Unicode, Inc.",
	"thirdparty/libbacktrace/*",
	"2012-2021, Free Software Foundation, Inc.",
	"thirdparty/libjpeg-turbo/*",
	"2009-2024, D. R. Commander",
	"2015, Viktor Szathmáry.",
	"1991-2020, Thomas G. Lane, Guido Vollbeding",
	"thirdparty/libktx/*",
	"2013-2020, Mark Callow",
	"2010-2020 The Khronos Group, Inc.",
	"thirdparty/libogg/*",
	"2002, Xiph.org Foundation",
	"thirdparty/libvorbis/*",
	"2002-2015, Xiph.org Foundation",
	"thirdparty/libpng/*",
	"1995-2025, The PNG Reference Library Authors.",
	"2018-2025, Cosmin Truta.",
	"2000-2002, 2004, 2006-2018 Glenn Randers-Pehrson.",
	"1996-1997, Andreas Dilger.",
	"1995-1996, Guy Eric Schalnat, Group 42, Inc.",
	"thirdparty/libtheora/*",
	"2002-2009, Xiph.org Foundation",
	"thirdparty/libwebp/*",
	"2010, Google Inc.",
	"thirdparty/manifold/*",
	"2020-2025, The Manifold Authors",
	"thirdparty/mbedtls/*",
	"The Mbed TLS Contributors",
	"thirdparty/meshoptimizer/*",
	"2016-2024, Arseny Kapoulkine",
	"thirdparty/mingw-std-threads/*",
	"2016, Mega Limited",
	"thirdparty/minimp3/*",
	"lieff",
	"thirdparty/miniupnpc/*",
	"2005-2025, Thomas Bernard",
	"thirdparty/minizip/*",
	"1998-2010, Gilles Vollant",
	"2007-2008, Even Rouault",
	"2009-2010, Mathias Svensson",
	"thirdparty/misc/bcdec.h",
	"2022, Sergii Kudlai",
	"thirdparty/misc/cubemap_coeffs.h",
	"2016, Activision Publishing, Inc.",
	"thirdparty/misc/fastlz.c",
	"thirdparty/misc/fastlz.h",
	"2005-2020, Ariya Hidayat",
	"thirdparty/misc/FastNoiseLite.h",
	"2023, Jordan Peck and contributors",
	"thirdparty/misc/ifaddrs-android.cc",
	"thirdparty/misc/ifaddrs-android.h",
	"2012-2013, Google Inc.",
	"thirdparty/misc/mikktspace.c",
	"thirdparty/misc/mikktspace.h",
	"2011, Morten S. Mikkelsen",
	"thirdparty/misc/nvapi_minimal.h",
	"2019-2022, NVIDIA Corporation",
	"thirdparty/misc/ok_color.h",
	"thirdparty/misc/ok_color_shader.h",
	"2021, Björn Ottosson",
	"thirdparty/misc/pcg.cpp",
	"thirdparty/misc/pcg.h",
	"2014, M.E. O'Neill",
	"thirdparty/misc/polypartition.cpp",
	"thirdparty/misc/polypartition.h",
	"2011-2021, Ivan Fratric and contributors",
	"thirdparty/misc/qoa.h",
	"2023, Dominic Szablewski",
	"thirdparty/misc/r128.c",
	"thirdparty/misc/r128.h",
	"Alan Hickman",
	"thirdparty/misc/smaz.c",
	"thirdparty/misc/smaz.h",
	"2006-2009, Salvatore Sanfilippo",
	"thirdparty/misc/smolv.cpp",
	"thirdparty/misc/smolv.h",
	"2016-2024, Aras Pranckevicius",
	"thirdparty/misc/stb_rect_pack.h",
	"Sean Barrett",
	"thirdparty/misc/yuv2rgb.h",
	"2008-2011, Robin Watts",
	"thirdparty/msdfgen/*",
	"2014-2025, Viktor Chlumsky",
	"thirdparty/openxr/*",
	"2020-2025, The Khronos Group Inc.",
	"thirdparty/pcre2/*",
	"1997-2024, University of Cambridge",
	"2009-2024, Zoltan Herczeg",
	"thirdparty/recastnavigation/*",
	"2009, Mikko Mononen",
	"thirdparty/rvo2/*",
	"2016, University of North Carolina at Chapel Hill",
	"thirdparty/sdl/*",
	"1997-2025, Sam Lantinga",
	"thirdparty/sdl/hidapi/*",
	"2010, Alan Ott, Signal 11 Software",
	"thirdparty/spirv-cross/*",
	"2015-2021, Arm Limited",
	"thirdparty/spirv-reflect/*",
	"2017-2022, Google Inc.",
	"thirdparty/swappy-frame-pacing/*",
	"2019, The Android Open Source Project",
	"thirdparty/thorvg/*",
	"2020-2024, The ThorVG Project",
	"thirdparty/tinyexr/*",
	"2014-2021, Syoyo Fujita",
	"2002, Industrial Light & Magic, a division of Lucas Digital Ltd. LLC",
	"thirdparty/ufbx/*",
	"2020, Samuli Raivio",
	"thirdparty/vhacd/*",
	"2011, Khaled Mamou",
	"2003-2009, Erwin Coumans",
	"thirdparty/volk/*",
	"2018-2024, Arseny Kapoulkine",
	"thirdparty/vulkan/*",
	"2014-2024, The Khronos Group Inc.",
	"2014-2024, Valve Corporation",
	"2014-2024, LunarG, Inc.",
	"thirdparty/vulkan/vk_mem_alloc.h",
	"2017-2024, Advanced Micro Devices, Inc.",
	"thirdparty/wayland/*",
	"2008-2012, Kristian Høgsberg",
	"2010-2012, Intel Corporation",
	"2011, Benjamin Franzke",
	"2012, Collabora, Ltd.",
	"thirdparty/wayland-protocols/*",
	"2008-2013, Kristian Høgsberg",
	"2010-2013, Intel Corporation",
	"2013, Rafael Antognolli",
	"2013, Jasper St. Pierre",
	"2014, Jonas Ådahl",
	"2014, Jason Ekstrand",
	"2014-2015, Collabora, Ltd.",
	"2015, Red Hat Inc.",
	"thirdparty/wslay/*",
	"2011, 2012, 2015, Tatsuhiro Tsujikawa",
	"thirdparty/xatlas/*",
	"2018-2020, Jonathan Young",
	"2013, Thekla, Inc",
	"2006, NVIDIA Corporation, Ignacio Castano",
	"thirdparty/zlib/*",
	"1995-2024, Jean-loup Gailly and Mark Adler",
	"thirdparty/zstd/*",
	"Meta Platforms, Inc. and affiliates.",
};

inline constexpr ComponentCopyrightPart COPYRIGHT_PROJECT_PARTS[] = {
	{ "Expat", &COPYRIGHT_INFO_DATA[0], &COPYRIGHT_INFO_DATA[1], 1, 2 },
	{ "CC-BY-4.0", &COPYRIGHT_INFO_DATA[3], &COPYRIGHT_INFO_DATA[7], 4, 1 },
	{ "Expat and Zlib", &COPYRIGHT_INFO_DATA[8], &COPYRIGHT_INFO_DATA[10], 2, 3 },
	{ "Expat and Zlib", &COPYRIGHT_INFO_DATA[13], &COPYRIGHT_INFO_DATA[27], 14, 3 },
	{ "Expat and Zlib", &COPYRIGHT_INFO_DATA[30], &COPYRIGHT_INFO_DATA[32], 2, 3 },
	{ "Expat", &COPYRIGHT_INFO_DATA[35], &COPYRIGHT_INFO_DATA[40], 5, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[41], &COPYRIGHT_INFO_DATA[42], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[43], &COPYRIGHT_INFO_DATA[44], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[45], &COPYRIGHT_INFO_DATA[46], 1, 3 },
	{ "Expat", &COPYRIGHT_INFO_DATA[49], &COPYRIGHT_INFO_DATA[50], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[51], &COPYRIGHT_INFO_DATA[52], 1, 3 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[55], &COPYRIGHT_INFO_DATA[61], 6, 2 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[63], &COPYRIGHT_INFO_DATA[64], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[65], &COPYRIGHT_INFO_DATA[66], 1, 3 },
	{ "BSD-3-clause and Expat", &COPYRIGHT_INFO_DATA[69], &COPYRIGHT_INFO_DATA[70], 1, 2 },
	{ "Expat", &COPYRIGHT_INFO_DATA[72], &COPYRIGHT_INFO_DATA[81], 9, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[82], &COPYRIGHT_INFO_DATA[83], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[84], &COPYRIGHT_INFO_DATA[88], 4, 5 },
	{ "Expat", &COPYRIGHT_INFO_DATA[93], &COPYRIGHT_INFO_DATA[94], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[95], &COPYRIGHT_INFO_DATA[96], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[97], &COPYRIGHT_INFO_DATA[98], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[99], &COPYRIGHT_INFO_DATA[100], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[101], &COPYRIGHT_INFO_DATA[102], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[103], &COPYRIGHT_INFO_DATA[104], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[105], &COPYRIGHT_INFO_DATA[106], 1, 1 },
	{ "MPL-2.0", &COPYRIGHT_INFO_DATA[107], &COPYRIGHT_INFO_DATA[108], 1, 1 },
	{ "BSL-1.0", &COPYRIGHT_INFO_DATA[109], &COPYRIGHT_INFO_DATA[110], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[111], &COPYRIGHT_INFO_DATA[112], 1, 2 },
	{ "Expat", &COPYRIGHT_INFO_DATA[114], &COPYRIGHT_INFO_DATA[115], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[116], &COPYRIGHT_INFO_DATA[117], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[118], &COPYRIGHT_INFO_DATA[119], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[120], &COPYRIGHT_INFO_DATA[121], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[122], &COPYRIGHT_INFO_DATA[123], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[124], &COPYRIGHT_INFO_DATA[125], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[126], &COPYRIGHT_INFO_DATA[127], 1, 1 },
	{ "OFL-1.1", &COPYRIGHT_INFO_DATA[128], &COPYRIGHT_INFO_DATA[129], 1, 1 },
	{ "OFL-1.1", &COPYRIGHT_INFO_DATA[130], &COPYRIGHT_INFO_DATA[131], 1, 1 },
	{ "OFL-1.1", &COPYRIGHT_INFO_DATA[132], &COPYRIGHT_INFO_DATA[133], 1, 1 },
	{ "FTL", &COPYRIGHT_INFO_DATA[134], &COPYRIGHT_INFO_DATA[135], 1, 1 },
	{ "CC0-1.0 and Apache-2.0", &COPYRIGHT_INFO_DATA[136], &COPYRIGHT_INFO_DATA[137], 1, 2 },
	{ "glslang", &COPYRIGHT_INFO_DATA[139], &COPYRIGHT_INFO_DATA[140], 1, 3 },
	{ "Expat", &COPYRIGHT_INFO_DATA[143], &COPYRIGHT_INFO_DATA[144], 1, 1 },
	{ "Expat and Apache-2.0", &COPYRIGHT_INFO_DATA[145], &COPYRIGHT_INFO_DATA[146], 1, 2 },
	{ "HarfBuzz", &COPYRIGHT_INFO_DATA[148], &COPYRIGHT_INFO_DATA[149], 1, 17 },
	{ "Unicode", &COPYRIGHT_INFO_DATA[166], &COPYRIGHT_INFO_DATA[167], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[168], &COPYRIGHT_INFO_DATA[169], 1, 1 },
	{ "BSD-3-clause and IJG", &COPYRIGHT_INFO_DATA[170], &COPYRIGHT_INFO_DATA[171], 1, 3 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[174], &COPYRIGHT_INFO_DATA[175], 1, 2 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[177], &COPYRIGHT_INFO_DATA[178], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[179], &COPYRIGHT_INFO_DATA[180], 1, 1 },
	{ "Zlib", &COPYRIGHT_INFO_DATA[181], &COPYRIGHT_INFO_DATA[182], 1, 5 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[187], &COPYRIGHT_INFO_DATA[188], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[189], &COPYRIGHT_INFO_DATA[190], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[191], &COPYRIGHT_INFO_DATA[192], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[193], &COPYRIGHT_INFO_DATA[194], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[195], &COPYRIGHT_INFO_DATA[196], 1, 1 },
	{ "BSD-2-clause", &COPYRIGHT_INFO_DATA[197], &COPYRIGHT_INFO_DATA[198], 1, 1 },
	{ "CC0-1.0", &COPYRIGHT_INFO_DATA[199], &COPYRIGHT_INFO_DATA[200], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[201], &COPYRIGHT_INFO_DATA[202], 1, 1 },
	{ "Zlib", &COPYRIGHT_INFO_DATA[203], &COPYRIGHT_INFO_DATA[204], 1, 3 },
	{ "Expat", &COPYRIGHT_INFO_DATA[207], &COPYRIGHT_INFO_DATA[208], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[209], &COPYRIGHT_INFO_DATA[210], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[211], &COPYRIGHT_INFO_DATA[213], 2, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[214], &COPYRIGHT_INFO_DATA[215], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[216], &COPYRIGHT_INFO_DATA[218], 2, 1 },
	{ "Zlib", &COPYRIGHT_INFO_DATA[219], &COPYRIGHT_INFO_DATA[221], 2, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[222], &COPYRIGHT_INFO_DATA[223], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[224], &COPYRIGHT_INFO_DATA[226], 2, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[227], &COPYRIGHT_INFO_DATA[229], 2, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[230], &COPYRIGHT_INFO_DATA[232], 2, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[233], &COPYRIGHT_INFO_DATA[234], 1, 1 },
	{ "public-domain or Unlicense", &COPYRIGHT_INFO_DATA[235], &COPYRIGHT_INFO_DATA[237], 2, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[238], &COPYRIGHT_INFO_DATA[240], 2, 1 },
	{ "public-domain or Unlicense or Expat", &COPYRIGHT_INFO_DATA[241], &COPYRIGHT_INFO_DATA[243], 2, 1 },
	{ "public-domain or Unlicense or Expat", &COPYRIGHT_INFO_DATA[244], &COPYRIGHT_INFO_DATA[245], 1, 1 },
	{ "BSD-2-clause", &COPYRIGHT_INFO_DATA[246], &COPYRIGHT_INFO_DATA[247], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[248], &COPYRIGHT_INFO_DATA[249], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[250], &COPYRIGHT_INFO_DATA[251], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[252], &COPYRIGHT_INFO_DATA[253], 1, 2 },
	{ "Zlib", &COPYRIGHT_INFO_DATA[255], &COPYRIGHT_INFO_DATA[256], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[257], &COPYRIGHT_INFO_DATA[258], 1, 1 },
	{ "Zlib", &COPYRIGHT_INFO_DATA[259], &COPYRIGHT_INFO_DATA[260], 1, 1 },
	{ "BSD-3-Clause", &COPYRIGHT_INFO_DATA[261], &COPYRIGHT_INFO_DATA[262], 1, 1 },
	{ "Apache-2.0 or Expat", &COPYRIGHT_INFO_DATA[263], &COPYRIGHT_INFO_DATA[264], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[265], &COPYRIGHT_INFO_DATA[266], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[267], &COPYRIGHT_INFO_DATA[268], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[269], &COPYRIGHT_INFO_DATA[270], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[271], &COPYRIGHT_INFO_DATA[272], 1, 2 },
	{ "Expat", &COPYRIGHT_INFO_DATA[274], &COPYRIGHT_INFO_DATA[275], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[276], &COPYRIGHT_INFO_DATA[277], 1, 2 },
	{ "Expat", &COPYRIGHT_INFO_DATA[279], &COPYRIGHT_INFO_DATA[280], 1, 1 },
	{ "Apache-2.0", &COPYRIGHT_INFO_DATA[281], &COPYRIGHT_INFO_DATA[282], 1, 3 },
	{ "Expat", &COPYRIGHT_INFO_DATA[285], &COPYRIGHT_INFO_DATA[286], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[287], &COPYRIGHT_INFO_DATA[288], 1, 4 },
	{ "Expat", &COPYRIGHT_INFO_DATA[292], &COPYRIGHT_INFO_DATA[293], 1, 8 },
	{ "Expat", &COPYRIGHT_INFO_DATA[301], &COPYRIGHT_INFO_DATA[302], 1, 1 },
	{ "Expat", &COPYRIGHT_INFO_DATA[303], &COPYRIGHT_INFO_DATA[304], 1, 3 },
	{ "Zlib", &COPYRIGHT_INFO_DATA[307], &COPYRIGHT_INFO_DATA[308], 1, 1 },
	{ "BSD-3-clause", &COPYRIGHT_INFO_DATA[309], &COPYRIGHT_INFO_DATA[310], 1, 1 },
};

inline constexpr int COPYRIGHT_INFO_COUNT = 95;
inline constexpr ComponentCopyright COPYRIGHT_INFO[] = {
	{ "Godot Engine", &COPYRIGHT_PROJECT_PARTS[0], 1 },
	{ "Godot Engine logo", &COPYRIGHT_PROJECT_PARTS[1], 1 },
	{ "Bullet Continuous Collision Detection and Physics Library", &COPYRIGHT_PROJECT_PARTS[2], 3 },
	{ "Betsy", &COPYRIGHT_PROJECT_PARTS[5], 1 },
	{ "Chipmunk2D Joint Constraints", &COPYRIGHT_PROJECT_PARTS[6], 1 },
	{ "Open Dynamics Engine", &COPYRIGHT_PROJECT_PARTS[7], 1 },
	{ "Jolt Physics", &COPYRIGHT_PROJECT_PARTS[8], 2 },
	{ "Joint Non-Local Means (JNLM) denoiser", &COPYRIGHT_PROJECT_PARTS[10], 1 },
	{ "The Android Open Source Project", &COPYRIGHT_PROJECT_PARTS[11], 1 },
	{ "ProcessPhoenix", &COPYRIGHT_PROJECT_PARTS[12], 1 },
	{ "Robert Penner's Easing Functions", &COPYRIGHT_PROJECT_PARTS[13], 1 },
	{ "NVidia's FXAA 3.11, simplified by Simon Rodriguez", &COPYRIGHT_PROJECT_PARTS[14], 1 },
	{ "Intel ASSAO and related files", &COPYRIGHT_PROJECT_PARTS[15], 1 },
	{ "Temporal Anti-Aliasing resolve implementation", &COPYRIGHT_PROJECT_PARTS[16], 1 },
	{ "Subpixel Morphological Antialiasing", &COPYRIGHT_PROJECT_PARTS[17], 1 },
	{ "AccessKit", &COPYRIGHT_PROJECT_PARTS[18], 1 },
	{ "AMD FidelityFX Super Resolution", &COPYRIGHT_PROJECT_PARTS[19], 1 },
	{ "AMD FidelityFX Super Resolution 2", &COPYRIGHT_PROJECT_PARTS[20], 1 },
	{ "ANGLE", &COPYRIGHT_PROJECT_PARTS[21], 1 },
	{ "Arm ASTC Encoder", &COPYRIGHT_PROJECT_PARTS[22], 1 },
	{ "Basis Universal", &COPYRIGHT_PROJECT_PARTS[23], 1 },
	{ "Brotli", &COPYRIGHT_PROJECT_PARTS[24], 1 },
	{ "CA certificates", &COPYRIGHT_PROJECT_PARTS[25], 1 },
	{ "Clipper2", &COPYRIGHT_PROJECT_PARTS[26], 1 },
	{ "Convection Texture Tools Stand-Alone Kernels", &COPYRIGHT_PROJECT_PARTS[27], 1 },
	{ "D3D12 Memory Allocator", &COPYRIGHT_PROJECT_PARTS[28], 1 },
	{ "DirectX Headers", &COPYRIGHT_PROJECT_PARTS[29], 1 },
	{ "doctest", &COPYRIGHT_PROJECT_PARTS[30], 1 },
	{ "Embree", &COPYRIGHT_PROJECT_PARTS[31], 1 },
	{ "ENet", &COPYRIGHT_PROJECT_PARTS[32], 1 },
	{ "etcpak", &COPYRIGHT_PROJECT_PARTS[33], 1 },
	{ "DroidSans font", &COPYRIGHT_PROJECT_PARTS[34], 1 },
	{ "JetBrains Mono font", &COPYRIGHT_PROJECT_PARTS[35], 1 },
	{ "Noto Sans font", &COPYRIGHT_PROJECT_PARTS[36], 1 },
	{ "Vazirmatn font", &COPYRIGHT_PROJECT_PARTS[37], 1 },
	{ "The FreeType Project", &COPYRIGHT_PROJECT_PARTS[38], 1 },
	{ "glad", &COPYRIGHT_PROJECT_PARTS[39], 1 },
	{ "glslang", &COPYRIGHT_PROJECT_PARTS[40], 1 },
	{ "Graphite engine", &COPYRIGHT_PROJECT_PARTS[41], 1 },
	{ "Grisu2 float serialization algorithm", &COPYRIGHT_PROJECT_PARTS[42], 1 },
	{ "HarfBuzz text shaping library", &COPYRIGHT_PROJECT_PARTS[43], 1 },
	{ "International Components for Unicode", &COPYRIGHT_PROJECT_PARTS[44], 1 },
	{ "libbacktrace", &COPYRIGHT_PROJECT_PARTS[45], 1 },
	{ "libjpeg-turbo", &COPYRIGHT_PROJECT_PARTS[46], 1 },
	{ "KTX", &COPYRIGHT_PROJECT_PARTS[47], 1 },
	{ "OggVorbis", &COPYRIGHT_PROJECT_PARTS[48], 2 },
	{ "libpng", &COPYRIGHT_PROJECT_PARTS[50], 1 },
	{ "OggTheora", &COPYRIGHT_PROJECT_PARTS[51], 1 },
	{ "WebP codec", &COPYRIGHT_PROJECT_PARTS[52], 1 },
	{ "Manifold", &COPYRIGHT_PROJECT_PARTS[53], 1 },
	{ "Mbed TLS", &COPYRIGHT_PROJECT_PARTS[54], 1 },
	{ "meshoptimizer", &COPYRIGHT_PROJECT_PARTS[55], 1 },
	{ "mingw-std-threads", &COPYRIGHT_PROJECT_PARTS[56], 1 },
	{ "MiniMP3", &COPYRIGHT_PROJECT_PARTS[57], 1 },
	{ "MiniUPnP Project", &COPYRIGHT_PROJECT_PARTS[58], 1 },
	{ "MiniZip", &COPYRIGHT_PROJECT_PARTS[59], 1 },
	{ "bcdec", &COPYRIGHT_PROJECT_PARTS[60], 1 },
	{ "Fast Filtering of Reflection Probes", &COPYRIGHT_PROJECT_PARTS[61], 1 },
	{ "FastLZ", &COPYRIGHT_PROJECT_PARTS[62], 1 },
	{ "FastNoise Lite", &COPYRIGHT_PROJECT_PARTS[63], 1 },
	{ "libjingle", &COPYRIGHT_PROJECT_PARTS[64], 1 },
	{ "Tangent Space Normal Maps implementation", &COPYRIGHT_PROJECT_PARTS[65], 1 },
	{ "NVIDIA NVAPI (minimal excerpt)", &COPYRIGHT_PROJECT_PARTS[66], 1 },
	{ "OK Lab color space", &COPYRIGHT_PROJECT_PARTS[67], 1 },
	{ "Minimal PCG32 implementation", &COPYRIGHT_PROJECT_PARTS[68], 1 },
	{ "PolyPartition / Triangulator", &COPYRIGHT_PROJECT_PARTS[69], 1 },
	{ "Quite OK Audio Format", &COPYRIGHT_PROJECT_PARTS[70], 1 },
	{ "r128 library", &COPYRIGHT_PROJECT_PARTS[71], 1 },
	{ "SMAZ", &COPYRIGHT_PROJECT_PARTS[72], 1 },
	{ "SMOL-V", &COPYRIGHT_PROJECT_PARTS[73], 1 },
	{ "stb libraries", &COPYRIGHT_PROJECT_PARTS[74], 1 },
	{ "YUV2RGB", &COPYRIGHT_PROJECT_PARTS[75], 1 },
	{ "Multi-channel signed distance field generator", &COPYRIGHT_PROJECT_PARTS[76], 1 },
	{ "OpenXR Loader", &COPYRIGHT_PROJECT_PARTS[77], 1 },
	{ "PCRE2", &COPYRIGHT_PROJECT_PARTS[78], 1 },
	{ "Recast", &COPYRIGHT_PROJECT_PARTS[79], 1 },
	{ "RVO2", &COPYRIGHT_PROJECT_PARTS[80], 1 },
	{ "SDL", &COPYRIGHT_PROJECT_PARTS[81], 1 },
	{ "hidapi", &COPYRIGHT_PROJECT_PARTS[82], 1 },
	{ "SPIRV-Cross", &COPYRIGHT_PROJECT_PARTS[83], 1 },
	{ "SPIRV-Reflect", &COPYRIGHT_PROJECT_PARTS[84], 1 },
	{ "Swappy", &COPYRIGHT_PROJECT_PARTS[85], 1 },
	{ "ThorVG", &COPYRIGHT_PROJECT_PARTS[86], 1 },
	{ "TinyEXR", &COPYRIGHT_PROJECT_PARTS[87], 1 },
	{ "ufbx", &COPYRIGHT_PROJECT_PARTS[88], 1 },
	{ "V-HACD", &COPYRIGHT_PROJECT_PARTS[89], 1 },
	{ "volk", &COPYRIGHT_PROJECT_PARTS[90], 1 },
	{ "Vulkan Headers", &COPYRIGHT_PROJECT_PARTS[91], 1 },
	{ "Vulkan Memory Allocator", &COPYRIGHT_PROJECT_PARTS[92], 1 },
	{ "Wayland core protocol", &COPYRIGHT_PROJECT_PARTS[93], 1 },
	{ "Wayland protocols", &COPYRIGHT_PROJECT_PARTS[94], 1 },
	{ "Wslay", &COPYRIGHT_PROJECT_PARTS[95], 1 },
	{ "xatlas", &COPYRIGHT_PROJECT_PARTS[96], 1 },
	{ "zlib", &COPYRIGHT_PROJECT_PARTS[97], 1 },
	{ "Zstandard", &COPYRIGHT_PROJECT_PARTS[98], 1 },
};

inline constexpr int LICENSE_COUNT = 17;
inline constexpr const char *LICENSE_NAMES[] = {
	"Apache-2.0",
	"BSD-2-clause",
	"BSD-3-clause",
	"BSL-1.0",
	"CC0-1.0",
	"CC-BY-4.0",
	"Expat",
	"glslang",
	"FTL",
	"HarfBuzz",
	"IJG",
	"MPL-2.0",
	"OFL-1.1",
	"Unicode",
	"Unlicense",
	"WOL",
	"Zlib",
};

inline constexpr const char *LICENSE_BODIES[] = {

R"<!>(Apache License
Version 2.0, January 2004
http://www.apache.org/licenses/

TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION

1. Definitions.

"License" shall mean the terms and conditions for use, reproduction,
and distribution as defined by Sections 1 through 9 of this document.

"Licensor" shall mean the copyright owner or entity authorized by
the copyright owner that is granting the License.

"Legal Entity" shall mean the union of the acting entity and all
other entities that control, are controlled by, or are under common
control with that entity. For the purposes of this definition,
"control" means (i) the power, direct or indirect, to cause the
direction or management of such entity, whether by contract or
otherwise, or (ii) ownership of fifty percent (50%) or more of the
outstanding shares, or (iii) beneficial ownership of such entity.

"You" (or "Your") shall mean an individual or Legal Entity
exercising permissions granted by this License.

"Source" form shall mean the preferred form for making modifications,
including but not limited to software source code, documentation
source, and configuration files.

"Object" form shall mean any form resulting from mechanical
transformation or translation of a Source form, including but
not limited to compiled object code, generated documentation,
and conversions to other media types.

"Work" shall mean the work of authorship, whether in Source or
Object form, made available under the License, as indicated by a
copyright notice that is included in or attached to the work
(an example is provided in the Appendix below).

"Derivative Works" shall mean any work, whether in Source or Object
form, that is based on (or derived from) the Work and for which the
editorial revisions, annotations, elaborations, or other modifications
represent, as a whole, an original work of authorship. For the purposes
of this License, Derivative Works shall not include works that remain
separable from, or merely link (or bind by name) to the interfaces of,
the Work and Derivative Works thereof.

"Contribution" shall mean any work of authorship, including
the original version of the Work and any modifications or additions
to that Work or Derivative Works thereof, that is intentionally
submitted to Licensor for inclusion in the Work by the copyright owner
or by an individual or Legal Entity authorized to submit on behalf of
the copyright owner. For the purposes of this definition, "submitted"
means any form of electronic, verbal, or written communication sent
to the Licensor or its representatives, including but not limited to
communication on electronic mailing lists, source code control systems,
and issue tracking systems that are managed by, or on behalf of, the
Licensor for the purpose of discussing and improving the Work, but
excluding communication that is conspicuously marked or otherwise
designated in writing by the copyright owner as "Not a Contribution."

"Contributor" shall mean Licensor and any individual or Legal Entity
on behalf of whom a Contribution has been received by Licensor and
subsequently incorporated within the Work.

2. Grant of Copyright License. Subject to the terms and conditions of
this License, each Contributor hereby grants to You a perpetual,
worldwide, non-exclusive, no-charge, royalty-free, irrevocable
copyright license to reproduce, prepare Derivative Works of,
publicly display, publicly perform, sublicense, and distribute the
Work and such Derivative Works in Source or Object form.

3. Grant of Patent License. Subject to the terms and conditions of
this License, each Contributor hereby grants to You a perpetual,
worldwide, non-exclusive, no-charge, royalty-free, irrevocable
(except as stated in this section) patent license to make, have made,
use, offer to sell, sell, import, and otherwise transfer the Work,
where such license applies only to those patent claims licensable
by such Contributor that are necessarily infringed by their
Contribution(s) alone or by combination of their Contribution(s)
with the Work to which such Contribution(s) was submitted. If You
institute patent litigation against any entity (including a
cross-claim or counterclaim in a lawsuit) alleging that the Work
or a Contribution incorporated within the Work constitutes direct
or contributory patent infringement, then any patent licenses
granted to You under this License for that Work shall terminate
as of the date such litigation is filed.

4. Redistribution. You may reproduce and distribute copies of the
Work or Derivative Works thereof in any medium, with or without
modifications, and in Source or Object form, provided that You
meet the following conditions:

(a) You must give any other recipients of the Work or
Derivative Works a copy of this License; and

(b) You must cause any modified files to carry prominent notices
stating that You changed the files; and

(c) You must retain, in the Source form of any Derivative Works
that You distribute, all copyright, patent, trademark, and
attribution notices from the Source form of the Work,
excluding those notices that do not pertain to any part of
the Derivative Works; and

(d) If the Work includes a "NOTICE" text file as part of its
distribution, then any Derivative Works that You distribute must
include a readable copy of the attribution notices contained
within such NOTICE file, excluding those notices that do not
pertain to any part of the Derivative Works, in at least one
of the following places: within a NOTICE text file distributed
as part of the Derivative Works; within the Source form or
documentation, if provided along with the Derivative Works; or,
within a display generated by the Derivative Works, if and
wherever such third-party notices normally appear. The contents
of the NOTICE file are for informational purposes only and
do not modify the License. You may add Your own attribution
notices within Derivative Works that You distribute, alongside
or as an addendum to the NOTICE text from the Work, provided
that such additional attribution notices cannot be construed
as modifying the License.

You may add Your own copyright statement to Your modifications and
may provide additional or different license terms and conditions
for use, reproduction, or distribution of Your modifications, or
for any such Derivative Works as a whole, provided Your use,
reproduction, and distribution of the Work otherwise complies with
the conditions stated in this License.

5. Submission of Contributions. Unless You explicitly state otherwise,
any Contribution intentionally submitted for inclusion in the Work
by You to the Licensor shall be under the terms and conditions of
this License, without any additional terms or conditions.
Notwithstanding the above, nothing herein shall supersede or modify
the terms of any separate license agreement you may have executed
with Licensor regarding such Contributions.

6. Trademarks. This License does not grant permission to use the trade
names, trademarks, service marks, or product names of the Licensor,
except as required for reasonable and customary use in describing the
origin of the Work and reproducing the content of the NOTICE file.

7. Disclaimer of Warranty. Unless required by applicable law or
agreed to in writing, Licensor provides the Work (and each
Contributor provides its Contributions) on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
implied, including, without limitation, any warranties or conditions
of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
PARTICULAR PURPOSE. You are solely responsible for determining the
appropriateness of using or redistributing the Work and assume any
risks associated with Your exercise of permissions under this License.

8. Limitation of Liability. In no event and under no legal theory,
whether in tort (including negligence), contract, or otherwise,
unless required by applicable law (such as deliberate and grossly
negligent acts) or agreed to in writing, shall any Contributor be
liable to You for damages, including any direct, indirect, special,
incidental, or consequential damages of any character arising as a
result of this License or out of the use or inability to use the
Work (including but not limited to damages for loss of goodwill,
work stoppage, computer failure or malfunction, or any and all
other commercial damages or losses), even if such Contributor
has been advised of the possibility of such damages.

9. Accepting Warranty or Additional Liability. While redistributing
the Work or Derivative Works thereof, You may choose to offer,
and charge a fee for, acceptance of support, warranty, indemnity,
or other liability obligations and/or rights consistent with this
License. However, in accepting such obligations, You may act only
on Your own behalf and on Your sole responsibility, not on behalf
of any other Contributor, and only if You agree to indemnify,
defend, and hold each Contributor harmless for any liability
incurred by, or claims asserted against, such Contributor by reason
of your accepting any such warranty or additional liability.

END OF TERMS AND CONDITIONS

APPENDIX: How to apply the Apache License to your work.

To apply the Apache License to your work, attach the following
boilerplate notice, with the fields enclosed by brackets "[]"
replaced with your own identifying information. (Don't include
the brackets!)  The text should be enclosed in the appropriate
comment syntax for the file format. We also recommend that a
file or class name and description of purpose be included on the
same "printed page" as the copyright notice for easier
identification within third-party archives.

Copyright [yyyy] [name of copyright owner]

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
)<!>",

R"<!>(Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
)<!>",

R"<!>(Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its
contributors may be used to endorse or promote products derived from
this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
)<!>",

R"<!>(Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
)<!>",

R"<!>(CC0 1.0 Universal

Statement of Purpose

The laws of most jurisdictions throughout the world automatically confer
exclusive Copyright and Related Rights (defined below) upon the creator and
subsequent owner(s) (each and all, an "owner") of an original work of
authorship and/or a database (each, a "Work").

Certain owners wish to permanently relinquish those rights to a Work for the
purpose of contributing to a commons of creative, cultural and scientific
works ("Commons") that the public can reliably and without fear of later
claims of infringement build upon, modify, incorporate in other works, reuse
and redistribute as freely as possible in any form whatsoever and for any
purposes, including without limitation commercial purposes. These owners may
contribute to the Commons to promote the ideal of a free culture and the
further production of creative, cultural and scientific works, or to gain
reputation or greater distribution for their Work in part through the use and
efforts of others.

For these and/or other purposes and motivations, and without any expectation
of additional consideration or compensation, the person associating CC0 with a
Work (the "Affirmer"), to the extent that he or she is an owner of Copyright
and Related Rights in the Work, voluntarily elects to apply CC0 to the Work
and publicly distribute the Work under its terms, with knowledge of his or her
Copyright and Related Rights in the Work and the meaning and intended legal
effect of CC0 on those rights.

1. Copyright and Related Rights. A Work made available under CC0 may be
protected by copyright and related or neighboring rights ("Copyright and
Related Rights"). Copyright and Related Rights include, but are not limited
to, the following:

i. the right to reproduce, adapt, distribute, perform, display, communicate,
and translate a Work;

ii. moral rights retained by the original author(s) and/or performer(s);

iii. publicity and privacy rights pertaining to a person's image or likeness
depicted in a Work;

iv. rights protecting against unfair competition in regards to a Work,
subject to the limitations in paragraph 4(a), below;

v. rights protecting the extraction, dissemination, use and reuse of data in
a Work;

vi. database rights (such as those arising under Directive 96/9/EC of the
European Parliament and of the Council of 11 March 1996 on the legal
protection of databases, and under any national implementation thereof,
including any amended or successor version of such directive); and

vii. other similar, equivalent or corresponding rights throughout the world
based on applicable law or treaty, and any national implementations thereof.

2. Waiver. To the greatest extent permitted by, but not in contravention of,
applicable law, Affirmer hereby overtly, fully, permanently, irrevocably and
unconditionally waives, abandons, and surrenders all of Affirmer's Copyright
and Related Rights and associated claims and causes of action, whether now
known or unknown (including existing as well as future claims and causes of
action), in the Work (i) in all territories worldwide, (ii) for the maximum
duration provided by applicable law or treaty (including future time
extensions), (iii) in any current or future medium and for any number of
copies, and (iv) for any purpose whatsoever, including without limitation
commercial, advertising or promotional purposes (the "Waiver"). Affirmer makes
the Waiver for the benefit of each member of the public at large and to the
detriment of Affirmer's heirs and successors, fully intending that such Waiver
shall not be subject to revocation, rescission, cancellation, termination, or
any other legal or equitable action to disrupt the quiet enjoyment of the Work
by the public as contemplated by Affirmer's express Statement of Purpose.

3. Public License Fallback. Should any part of the Waiver for any reason be
judged legally invalid or ineffective under applicable law, then the Waiver
shall be preserved to the maximum extent permitted taking into account
Affirmer's express Statement of Purpose. In addition, to the extent the Waiver
is so judged Affirmer hereby grants to each affected person a royalty-free,
non transferable, non sublicensable, non exclusive, irrevocable and
unconditional license to exercise Affirmer's Copyright and Related Rights in
the Work (i) in all territories worldwide, (ii) for the maximum duration
provided by applicable law or treaty (including future time extensions), (iii)
in any current or future medium and for any number of copies, and (iv) for any
purpose whatsoever, including without limitation commercial, advertising or
promotional purposes (the "License"). The License shall be deemed effective as
of the date CC0 was applied by Affirmer to the Work. Should any part of the
License for any reason be judged legally invalid or ineffective under
applicable law, such partial invalidity or ineffectiveness shall not
invalidate the remainder of the License, and in such case Affirmer hereby
affirms that he or she will not (i) exercise any of his or her remaining
Copyright and Related Rights in the Work or (ii) assert any associated claims
and causes of action with respect to the Work, in either case contrary to
Affirmer's express Statement of Purpose.

4. Limitations and Disclaimers.

a. No trademark or patent rights held by Affirmer are waived, abandoned,
surrendered, licensed or otherwise affected by this document.

b. Affirmer offers the Work as-is and makes no representations or warranties
of any kind concerning the Work, express, implied, statutory or otherwise,
including without limitation warranties of title, merchantability, fitness
for a particular purpose, non infringement, or the absence of latent or
other defects, accuracy, or the present or absence of errors, whether or not
discoverable, all to the greatest extent permissible under applicable law.

c. Affirmer disclaims responsibility for clearing rights of other persons
that may apply to the Work or any use thereof, including without limitation
any person's Copyright and Related Rights in the Work. Further, Affirmer
disclaims responsibility for obtaining any necessary consents, permissions
or other rights required for any use of the Work.

d. Affirmer understands and acknowledges that Creative Commons is not a
party to this document and has no duty or obligation with respect to this
CC0 or use of the Work.
)<!>",

R"<!>(Creative Commons Attribution 4.0 International Public License

By exercising the Licensed Rights (defined below), You accept and agree
to be bound by the terms and conditions of this Creative Commons
Attribution 4.0 International Public License ("Public
License"). To the extent this Public License may be interpreted as a
contract, You are granted the Licensed Rights in consideration of Your
acceptance of these terms and conditions, and the Licensor grants You
such rights in consideration of benefits the Licensor receives from
making the Licensed Material available under these terms and
conditions.

Section 1 -- Definitions.

a. Adapted Material means material subject to Copyright and Similar
Rights that is derived from or based upon the Licensed Material
and in which the Licensed Material is translated, altered,
arranged, transformed, or otherwise modified in a manner requiring
permission under the Copyright and Similar Rights held by the
Licensor. For purposes of this Public License, where the Licensed
Material is a musical work, performance, or sound recording,
Adapted Material is always produced where the Licensed Material is
synched in timed relation with a moving image.

b. Adapter's License means the license You apply to Your Copyright
and Similar Rights in Your contributions to Adapted Material in
accordance with the terms and conditions of this Public License.

c. Copyright and Similar Rights means copyright and/or similar rights
closely related to copyright including, without limitation,
performance, broadcast, sound recording, and Sui Generis Database
Rights, without regard to how the rights are labeled or
categorized. For purposes of this Public License, the rights
specified in Section 2(b)(1)-(2) are not Copyright and Similar
Rights.

d. Effective Technological Measures means those measures that, in the
absence of proper authority, may not be circumvented under laws
fulfilling obligations under Article 11 of the WIPO Copyright
Treaty adopted on December 20, 1996, and/or similar international
agreements.

e. Exceptions and Limitations means fair use, fair dealing, and/or
any other exception or limitation to Copyright and Similar Rights
that applies to Your use of the Licensed Material.

f. Licensed Material means the artistic or literary work, database,
or other material to which the Licensor applied this Public
License.

g. Licensed Rights means the rights granted to You subject to the
terms and conditions of this Public License, which are limited to
all Copyright and Similar Rights that apply to Your use of the
Licensed Material and that the Licensor has authority to license.

h. Licensor means the individual(s) or entity(ies) granting rights
under this Public License.

i. Share means to provide material to the public by any means or
process that requires permission under the Licensed Rights, such
as reproduction, public display, public performance, distribution,
dissemination, communication, or importation, and to make material
available to the public including in ways that members of the
public may access the material from a place and at a time
individually chosen by them.

j. Sui Generis Database Rights means rights other than copyright
resulting from Directive 96/9/EC of the European Parliament and of
the Council of 11 March 1996 on the legal protection of databases,
as amended and/or succeeded, as well as other essentially
equivalent rights anywhere in the world.

k. You means the individual or entity exercising the Licensed Rights
under this Public License. Your has a corresponding meaning.

Section 2 -- Scope.

a. License grant.

1. Subject to the terms and conditions of this Public License,
the Licensor hereby grants You a worldwide, royalty-free,
non-sublicensable, non-exclusive, irrevocable license to
exercise the Licensed Rights in the Licensed Material to:

a. reproduce and Share the Licensed Material, in whole or
in part; and

b. produce, reproduce, and Share Adapted Material.

2. Exceptions and Limitations. For the avoidance of doubt, where
Exceptions and Limitations apply to Your use, this Public
License does not apply, and You do not need to comply with
its terms and conditions.

3. Term. The term of this Public License is specified in Section
6(a).

4. Media and formats; technical modifications allowed. The
Licensor authorizes You to exercise the Licensed Rights in
all media and formats whether now known or hereafter created,
and to make technical modifications necessary to do so. The
Licensor waives and/or agrees not to assert any right or
authority to forbid You from making technical modifications
necessary to exercise the Licensed Rights, including
technical modifications necessary to circumvent Effective
Technological Measures. For purposes of this Public License,
simply making modifications authorized by this Section 2(a)
(4) never produces Adapted Material.

5. Downstream recipients.

a. Offer from the Licensor -- Licensed Material. Every
recipient of the Licensed Material automatically
receives an offer from the Licensor to exercise the
Licensed Rights under the terms and conditions of this
Public License.

b. No downstream restrictions. You may not offer or impose
any additional or different terms or conditions on, or
apply any Effective Technological Measures to, the
Licensed Material if doing so restricts exercise of the
Licensed Rights by any recipient of the Licensed
Material.

6. No endorsement. Nothing in this Public License constitutes or
may be construed as permission to assert or imply that You
are, or that Your use of the Licensed Material is, connected
with, or sponsored, endorsed, or granted official status by,
the Licensor or others designated to receive attribution as
provided in Section 3(a)(1)(A)(i).

b. Other rights.

1. Moral rights, such as the right of integrity, are not
licensed under this Public License, nor are publicity,
privacy, and/or other similar personality rights; however, to
the extent possible, the Licensor waives and/or agrees not to
assert any such rights held by the Licensor to the limited
extent necessary to allow You to exercise the Licensed
Rights, but not otherwise.

2. Patent and trademark rights are not licensed under this
Public License.

3. To the extent possible, the Licensor waives any right to
collect royalties from You for the exercise of the Licensed
Rights, whether directly or through a collecting society
under any voluntary or waivable statutory or compulsory
licensing scheme. In all other cases the Licensor expressly
reserves any right to collect such royalties.

Section 3 -- License Conditions.

Your exercise of the Licensed Rights is expressly made subject to the
following conditions.

a. Attribution.

1. If You Share the Licensed Material (including in modified
form), You must:

a. retain the following if it is supplied by the Licensor
with the Licensed Material:

i. identification of the creator(s) of the Licensed
Material and any others designated to receive
attribution, in any reasonable manner requested by
the Licensor (including by pseudonym if
designated);

ii. a copyright notice;

iii. a notice that refers to this Public License;

iv. a notice that refers to the disclaimer of
warranties;

v. a URI or hyperlink to the Licensed Material to the
extent reasonably practicable;

b. indicate if You modified the Licensed Material and
retain an indication of any previous modifications; and

c. indicate the Licensed Material is licensed under this
Public License, and include the text of, or the URI or
hyperlink to, this Public License.

2. You may satisfy the conditions in Section 3(a)(1) in any
reasonable manner based on the medium, means, and context in
which You Share the Licensed Material. For example, it may be
reasonable to satisfy the conditions by providing a URI or
hyperlink to a resource that includes the required
information.

3. If requested by the Licensor, You must remove any of the
information required by Section 3(a)(1)(A) to the extent
reasonably practicable.

4. If You Share Adapted Material You produce, the Adapter's
License You apply must not prevent recipients of the Adapted
Material from complying with this Public License.

Section 4 -- Sui Generis Database Rights.

Where the Licensed Rights include Sui Generis Database Rights that
apply to Your use of the Licensed Material:

a. for the avoidance of doubt, Section 2(a)(1) grants You the right
to extract, reuse, reproduce, and Share all or a substantial
portion of the contents of the database;

b. if You include all or a substantial portion of the database
contents in a database in which You have Sui Generis Database
Rights, then the database in which You have Sui Generis Database
Rights (but not its individual contents) is Adapted Material; and

c. You must comply with the conditions in Section 3(a) if You Share
all or a substantial portion of the contents of the database.

For the avoidance of doubt, this Section 4 supplements and does not
replace Your obligations under this Public License where the Licensed
Rights include other Copyright and Similar Rights.

Section 5 -- Disclaimer of Warranties and Limitation of Liability.

a. UNLESS OTHERWISE SEPARATELY UNDERTAKEN BY THE LICENSOR, TO THE
EXTENT POSSIBLE, THE LICENSOR OFFERS THE LICENSED MATERIAL AS-IS
AND AS-AVAILABLE, AND MAKES NO REPRESENTATIONS OR WARRANTIES OF
ANY KIND CONCERNING THE LICENSED MATERIAL, WHETHER EXPRESS,
IMPLIED, STATUTORY, OR OTHER. THIS INCLUDES, WITHOUT LIMITATION,
WARRANTIES OF TITLE, MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, NON-INFRINGEMENT, ABSENCE OF LATENT OR OTHER DEFECTS,
ACCURACY, OR THE PRESENCE OR ABSENCE OF ERRORS, WHETHER OR NOT
KNOWN OR DISCOVERABLE. WHERE DISCLAIMERS OF WARRANTIES ARE NOT
ALLOWED IN FULL OR IN PART, THIS DISCLAIMER MAY NOT APPLY TO YOU.

b. TO THE EXTENT POSSIBLE, IN NO EVENT WILL THE LICENSOR BE LIABLE
TO YOU ON ANY LEGAL THEORY (INCLUDING, WITHOUT LIMITATION,
NEGLIGENCE) OR OTHERWISE FOR ANY DIRECT, SPECIAL, INDIRECT,
INCIDENTAL, CONSEQUENTIAL, PUNITIVE, EXEMPLARY, OR OTHER LOSSES,
COSTS, EXPENSES, OR DAMAGES ARISING OUT OF THIS PUBLIC LICENSE OR
USE OF THE LICENSED MATERIAL, EVEN IF THE LICENSOR HAS BEEN
ADVISED OF THE POSSIBILITY OF SUCH LOSSES, COSTS, EXPENSES, OR
DAMAGES. WHERE A LIMITATION OF LIABILITY IS NOT ALLOWED IN FULL OR
IN PART, THIS LIMITATION MAY NOT APPLY TO YOU.

c. The disclaimer of warranties and limitation of liability provided
above shall be interpreted in a manner that, to the extent
possible, most closely approximates an absolute disclaimer and
waiver of all liability.

Section 6 -- Term and Termination.

a. This Public License applies for the term of the Copyright and
Similar Rights licensed here. However, if You fail to comply with
this Public License, then Your rights under this Public License
terminate automatically.

b. Where Your right to use the Licensed Material has terminated under
Section 6(a), it reinstates:

1. automatically as of the date the violation is cured, provided
it is cured within 30 days of Your discovery of the
violation; or

2. upon express reinstatement by the Licensor.

For the avoidance of doubt, this Section 6(b) does not affect any
right the Licensor may have to seek remedies for Your violations
of this Public License.

c. For the avoidance of doubt, the Licensor may also offer the
Licensed Material under separate terms or conditions or stop
distributing the Licensed Material at any time; however, doing so
will not terminate this Public License.

d. Sections 1, 5, 6, 7, and 8 survive termination of this Public
License.

Section 7 -- Other Terms and Conditions.

a. The Licensor shall not be bound by any additional or different
terms or conditions communicated by You unless expressly agreed.

b. Any arrangements, understandings, or agreements regarding the
Licensed Material not stated herein are separate from and
independent of the terms and conditions of this Public License.

Section 8 -- Interpretation.

a. For the avoidance of doubt, this Public License does not, and
shall not be interpreted to, reduce, limit, restrict, or impose
conditions on any use of the Licensed Material that could lawfully
be made without permission under this Public License.

b. To the extent possible, if any provision of this Public License is
deemed unenforceable, it shall be automatically reformed to the
minimum extent necessary to make it enforceable. If the provision
cannot be reformed, it shall be severed from this Public License
without affecting the enforceability of the remaining terms and
conditions.

c. No term or condition of this Public License will be waived and no
failure to comply consented to unless expressly agreed to by the
Licensor.

d. Nothing in this Public License constitutes or may be interpreted
as a limitation upon, or waiver of, any privileges and immunities
that apply to the Licensor or You, including from the legal
processes of any jurisdiction or authority.
)<!>",

R"<!>(Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
)<!>",

R"<!>(Here, glslang proper means core GLSL parsing, HLSL parsing, and SPIR-V code
generation. Glslang proper requires use of a number of licenses, one that covers
preprocessing and others that covers non-preprocessing.

Bison was removed long ago. You can build glslang from the source grammar,
using tools of your choice, without using bison or any bison files.

Other parts, outside of glslang proper, include:

- gl_types.h, only needed for OpenGL-like reflection, and can be left out of
a parse and codegen project.  See it for its license.

- update_glslang_sources.py, which is not part of the project proper and does
not need to be used.

- the SPIR-V "remapper", which is optional, but has the same license as
glslang proper

- Google tests and SPIR-V tools, and anything in the external subdirectory
are external and optional; see them for their respective licenses.

--------------------------------------------------------------------------------

The core of glslang-proper, minus the preprocessor is licenced as follows:

--------------------------------------------------------------------------------
3-Clause BSD License
--------------------------------------------------------------------------------

Copyright (C) 2015-2018 Google, Inc.
Copyright (C) <various other dates and companies>

All rights reserved.

See: <License: BSD-3-clause>.

--------------------------------------------------------------------------------
2-Clause BSD License
--------------------------------------------------------------------------------

Copyright 2020 The Khronos Group Inc

See: <License: BSD-2-clause>.

--------------------------------------------------------------------------------
The MIT License
--------------------------------------------------------------------------------

Copyright 2020 The Khronos Group Inc

See: <License: Expat>.

--------------------------------------------------------------------------------
APACHE LICENSE, VERSION 2.0
--------------------------------------------------------------------------------

See: <License: Apache-2.0>.

--------------------------------------------------------------------------------
GPL 3 with special bison exception
--------------------------------------------------------------------------------

Bison implementation for Yacc-like parsers in C

Copyright (C) 1984, 1989-1990, 2000-2015 Free Software Foundation, Inc.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.

As a special exception, you may create a larger work that contains
part or all of the Bison parser skeleton and distribute that work
under terms of your choice, so long as that work isn't itself a
parser generator using the skeleton or a modified version thereof
as a parser skeleton.  Alternatively, if you modify or redistribute
the parser skeleton itself, you may (at your option) remove this
special exception, which will cause the skeleton and the resulting
Bison output files to be licensed under the GNU General Public
License without this special exception.

This special exception was added by the Free Software Foundation in
version 2.2 of Bison.

--------------------------------------------------------------------------------
================================================================================
--------------------------------------------------------------------------------

The preprocessor has the core licenses stated above, plus an additional licence:

Copyright (c) 2002, NVIDIA Corporation.

NVIDIA Corporation("NVIDIA") supplies this software to you in
consideration of your agreement to the following terms, and your use,
installation, modification or redistribution of this NVIDIA software
constitutes acceptance of these terms.  If you do not agree with these
terms, please do not use, install, modify or redistribute this NVIDIA
software.

In consideration of your agreement to abide by the following terms, and
subject to these terms, NVIDIA grants you a personal, non-exclusive
license, under NVIDIA's copyrights in this original NVIDIA software (the
"NVIDIA Software"), to use, reproduce, modify and redistribute the
NVIDIA Software, with or without modifications, in source and/or binary
forms; provided that if you redistribute the NVIDIA Software, you must
retain the copyright notice of NVIDIA, this notice and the following
text and disclaimers in all such redistributions of the NVIDIA Software.
Neither the name, trademarks, service marks nor logos of NVIDIA
Corporation may be used to endorse or promote products derived from the
NVIDIA Software without specific prior written permission from NVIDIA.
Except as expressly stated in this notice, no other rights or licenses
express or implied, are granted by NVIDIA herein, including but not
limited to any patent rights that may be infringed by your derivative
works or by other works in which the NVIDIA Software may be
incorporated. No hardware is licensed hereunder.

THE NVIDIA SOFTWARE IS BEING PROVIDED ON AN "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION, WARRANTIES OR CONDITIONS OF TITLE,
NON-INFRINGEMENT, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
ITS USE AND OPERATION EITHER ALONE OR IN COMBINATION WITH OTHER
PRODUCTS.

IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY SPECIAL, INDIRECT,
INCIDENTAL, EXEMPLARY, CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, LOST PROFITS; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) OR ARISING IN ANY WAY
OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION OF THE
NVIDIA SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT,
TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
NVIDIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
)<!>",

R"<!>(The FreeType Project LICENSE
----------------------------

2000-Feb-08

Copyright 1996-2000 by
David Turner, Robert Wilhelm, and Werner Lemberg



Introduction
============

The FreeType  Project is distributed in  several archive packages;
some of them may contain, in addition to the FreeType font engine,
various tools and  contributions which rely on, or  relate to, the
FreeType Project.

This  license applies  to all  files found  in such  packages, and
which do not  fall under their own explicit  license.  The license
affects  thus  the  FreeType   font  engine,  the  test  programs,
documentation and makefiles, at the very least.

This  license   was  inspired  by  the  BSD,   Artistic,  and  IJG
(Independent JPEG  Group) licenses, which  all encourage inclusion
and  use of  free  software in  commercial  and freeware  products
alike.  As a consequence, its main points are that:

o We don't promise that this software works. However, we will be
interested in any kind of bug reports. (`as is' distribution)

o You can  use this software for whatever you  want, in parts or
full form, without having to pay us. (`royalty-free' usage)

o You may not pretend that  you wrote this software.  If you use
it, or  only parts of it,  in a program,  you must acknowledge
somewhere  in  your  documentation  that  you  have  used  the
FreeType code. (`credits')

We  specifically  permit  and  encourage  the  inclusion  of  this
software, with  or without modifications,  in commercial products.
We  disclaim  all warranties  covering  The  FreeType Project  and
assume no liability related to The FreeType Project.


Legal Terms
===========

0. Definitions
--------------

Throughout this license,  the terms `package', `FreeType Project',
and  `FreeType  archive' refer  to  the  set  of files  originally
distributed  by the  authors  (David Turner,  Robert Wilhelm,  and
Werner Lemberg) as the `FreeType Project', be they named as alpha,
beta or final release.

`You' refers to  the licensee, or person using  the project, where
`using' is a generic term including compiling the project's source
code as  well as linking it  to form a  `program' or `executable'.
This  program is  referred to  as  `a program  using the  FreeType
engine'.

This  license applies  to all  files distributed  in  the original
FreeType  Project,   including  all  source   code,  binaries  and
documentation,  unless  otherwise  stated   in  the  file  in  its
original, unmodified form as  distributed in the original archive.
If you are  unsure whether or not a particular  file is covered by
this license, you must contact us to verify this.

The FreeType  Project is copyright (C) 1996-2000  by David Turner,
Robert Wilhelm, and Werner Lemberg.  All rights reserved except as
specified below.

1. No Warranty
--------------

THE FREETYPE PROJECT  IS PROVIDED `AS IS' WITHOUT  WARRANTY OF ANY
KIND, EITHER  EXPRESS OR IMPLIED,  INCLUDING, BUT NOT  LIMITED TO,
WARRANTIES  OF  MERCHANTABILITY   AND  FITNESS  FOR  A  PARTICULAR
PURPOSE.  IN NO EVENT WILL ANY OF THE AUTHORS OR COPYRIGHT HOLDERS
BE LIABLE  FOR ANY DAMAGES CAUSED  BY THE USE OR  THE INABILITY TO
USE, OF THE FREETYPE PROJECT.

2. Redistribution
-----------------

This  license  grants  a  worldwide, royalty-free,  perpetual  and
irrevocable right  and license to use,  execute, perform, compile,
display,  copy,   create  derivative  works   of,  distribute  and
sublicense the  FreeType Project (in  both source and  object code
forms)  and  derivative works  thereof  for  any  purpose; and  to
authorize others  to exercise  some or all  of the  rights granted
herein, subject to the following conditions:

o Redistribution  of source code  must retain this  license file
(`LICENSE.TXT') unaltered; any additions, deletions or changes
to   the  original   files  must   be  clearly   indicated  in
accompanying  documentation.   The  copyright notices  of  the
unaltered, original  files must be preserved in  all copies of
source files.

o Redistribution in binary form must provide a  disclaimer  that
states  that  the software is based in part of the work of the
FreeType Team,  in  the  distribution  documentation.  We also
encourage you to put an URL to the FreeType web page  in  your
documentation, though this isn't mandatory.

These conditions  apply to any  software derived from or  based on
the FreeType Project,  not just the unmodified files.   If you use
our work, you  must acknowledge us.  However, no  fee need be paid
to us.

3. Advertising
--------------

Neither the  FreeType authors and  contributors nor you  shall use
the name of the  other for commercial, advertising, or promotional
purposes without specific prior written permission.

We suggest,  but do not require, that  you use one or  more of the
following phrases to refer  to this software in your documentation
or advertising  materials: `FreeType Project',  `FreeType Engine',
`FreeType library', or `FreeType Distribution'.

As  you have  not signed  this license,  you are  not  required to
accept  it.   However,  as  the FreeType  Project  is  copyrighted
material, only  this license, or  another one contracted  with the
authors, grants you  the right to use, distribute,  and modify it.
Therefore,  by  using,  distributing,  or modifying  the  FreeType
Project, you indicate that you understand and accept all the terms
of this license.

4. Contacts
-----------

There are two mailing lists related to FreeType:

o freetype@freetype.org

Discusses general use and applications of FreeType, as well as
future and  wanted additions to the  library and distribution.
If  you are looking  for support,  start in  this list  if you
haven't found anything to help you in the documentation.

o devel@freetype.org

Discusses bugs,  as well  as engine internals,  design issues,
specific licenses, porting, etc.

o http://www.freetype.org

Holds the current  FreeType web page, which will  allow you to
download  our  latest  development  version  and  read  online
documentation.

You can also contact us individually at:

David Turner      <david.turner@freetype.org>
Robert Wilhelm    <robert.wilhelm@freetype.org>
Werner Lemberg    <werner.lemberg@freetype.org>
)<!>",

R"<!>(HarfBuzz is licensed under the so-called "Old MIT" license.  Details follow.
For parts of HarfBuzz that are licensed under different licenses see individual
files names COPYING in subdirectories where applicable.

Copyright (C) 2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020  Google, Inc.
Copyright (C) 2018,2019,2020  Ebrahim Byagowi
Copyright (C) 2019,2020  Facebook, Inc.
Copyright (C) 2012  Mozilla Foundation
Copyright (C) 2011  Codethink Limited
Copyright (C) 2008,2010  Nokia Corporation and/or its subsidiary(-ies)
Copyright (C) 2009  Keith Stribley
Copyright (C) 2009  Martin Hosken and SIL International
Copyright (C) 2007  Chris Wilson
Copyright (C) 2005,2006,2020,2021  Behdad Esfahbod
Copyright (C) 2005  David Turner
Copyright (C) 2004,2007,2008,2009,2010  Red Hat, Inc.
Copyright (C) 1998-2004  David Turner and Werner Lemberg

For full copyright notices consult the individual files in the package.


Permission is hereby granted, without written agreement and without
license or royalty fees, to use, copy, modify, and distribute this
software and its documentation for any purpose, provided that the
above copyright notice and the following two paragraphs appear in
all copies of this software.

IN NO EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE TO ANY PARTY FOR
DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.

THE COPYRIGHT HOLDER SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
ON AN "AS IS" BASIS, AND THE COPYRIGHT HOLDER HAS NO OBLIGATION TO
PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
)<!>",

R"<!>(The authors make NO WARRANTY or representation, either express or implied,
with respect to this software, its quality, accuracy, merchantability, or
fitness for a particular purpose.  This software is provided "AS IS", and you,
its user, assume the entire risk as to its quality and accuracy.

This software is copyright (C) 1991-2020, Thomas G. Lane, Guido Vollbeding.
All Rights Reserved except as specified below.

Permission is hereby granted to use, copy, modify, and distribute this
software (or portions thereof) for any purpose, without fee, subject to these
conditions:
(1) If any part of the source code for this software is distributed, then this
README file must be included, with this copyright and no-warranty notice
unaltered; and any additions, deletions, or changes to the original files
must be clearly indicated in accompanying documentation.
(2) If only executable code is distributed, then the accompanying
documentation must state that "this software is based in part on the work of
the Independent JPEG Group".
(3) Permission for use of this software is granted only if the user accepts
full responsibility for any undesirable consequences; the authors accept
NO LIABILITY for damages of any kind.

These conditions apply to any software derived from or based on the IJG code,
not just to the unmodified library.  If you use our work, you ought to
acknowledge us.

Permission is NOT granted for the use of any IJG author's name or company name
in advertising or publicity relating to this software or products derived from
it.  This software may be referred to only as "the Independent JPEG Group's
software".

We specifically permit and encourage the use of this software as the basis of
commercial products, provided that all warranty or liability claims are
assumed by the product vendor.
)<!>",

(R"<!>(Mozilla Public License Version 2.0
==================================

1. Definitions
--------------

1.1. "Contributor"
means each individual or legal entity that creates, contributes to
the creation of, or owns Covered Software.

1.2. "Contributor Version"
means the combination of the Contributions of others (if any) used
by a Contributor and that particular Contributor's Contribution.

1.3. "Contribution"
means Covered Software of a particular Contributor.

1.4. "Covered Software"
means Source Code Form to which the initial Contributor has attached
the notice in Exhibit A, the Executable Form of such Source Code
Form, and Modifications of such Source Code Form, in each case
including portions thereof.

1.5. "Incompatible With Secondary Licenses"
means

(a) that the initial Contributor has attached the notice described
in Exhibit B to the Covered Software; or

(b) that the Covered Software was made available under the terms of
version 1.1 or earlier of the License, but not also under the
terms of a Secondary License.

1.6. "Executable Form"
means any form of the work other than Source Code Form.

1.7. "Larger Work"
means a work that combines Covered Software with other material, in
a separate file or files, that is not Covered Software.

1.8. "License"
means this document.

1.9. "Licensable"
means having the right to grant, to the maximum extent possible,
whether at the time of the initial grant or subsequently, any and
all of the rights conveyed by this License.

1.10. "Modifications"
means any of the following:

(a) any file in Source Code Form that results from an addition to,
deletion from, or modification of the contents of Covered
Software; or

(b) any new file in Source Code Form that contains any Covered
Software.

1.11. "Patent Claims" of a Contributor
means any patent claim(s), including without limitation, method,
process, and apparatus claims, in any patent Licensable by such
Contributor that would be infringed, but for the grant of the
License, by the making, using, selling, offering for sale, having
made, import, or transfer of either its Contributions or its
Contributor Version.

1.12. "Secondary License"
means either the GNU General Public License, Version 2.0, the GNU
Lesser General Public License, Version 2.1, the GNU Affero General
Public License, Version 3.0, or any later versions of those
licenses.

1.13. "Source Code Form"
means the form of the work preferred for making modifications.

1.14. "You" (or "Your")
means an individual or a legal entity exercising rights under this
License. For legal entities, "You" includes any entity that
controls, is controlled by, or is under common control with You. For
purposes of this definition, "control" means (a) the power, direct
or indirect, to cause the direction or management of such entity,
whether by contract or otherwise, or (b) ownership of more than
fifty percent (50%) of the outstanding shares or beneficial
ownership of such entity.

2. License Grants and Conditions
--------------------------------

2.1. Grants

Each Contributor hereby grants You a world-wide, royalty-free,
non-exclusive license:

(a) under intellectual property rights (other than patent or trademark)
Licensable by such Contributor to use, reproduce, make available,
modify, display, perform, distribute, and otherwise exploit its
Contributions, either on an unmodified basis, with Modifications, or
as part of a Larger Work; and

(b) under Patent Claims of such Contributor to make, use, sell, offer
for sale, have made, import, and otherwise transfer either its
Contributions or its Contributor Version.

2.2. Effective Date

The licenses granted in Section 2.1 with respect to any Contribution
become effective for each Contribution on the date the Contributor first
distributes such Contribution.

2.3. Limitations on Grant Scope

The licenses granted in this Section 2 are the only rights granted under
this License. No additional rights or licenses will be implied from the
distribution or licensing of Covered Software under this License.
Notwithstanding Section 2.1(b) above, no patent license is granted by a
Contributor:

(a) for any code that a Contributor has removed from Covered Software;
or

(b) for infringements caused by: (i) Your and any other third party's
modifications of Covered Software, or (ii) the combination of its
Contributions with other software (except as part of its Contributor
Version); or

(c) under Patent Claims infringed by Covered Software in the absence of
its Contributions.

This License does not grant any rights in the trademarks, service marks,
or logos of any Contributor (except as may be necessary to comply with
the notice requirements in Section 3.4).

2.4. Subsequent Licenses

No Contributor makes additional grants as a result of Your choice to
distribute the Covered Software under a subsequent version of this
License (see Section 10.2) or under the terms of a Secondary License (if
permitted under the terms of Section 3.3).

2.5. Representation

Each Contributor represents that the Contributor believes its
Contributions are its original creation(s) or it has sufficient rights
to grant the rights to its Contributions conveyed by this License.

2.6. Fair Use

This License is not intended to limit any rights You have under
applicable copyright doctrines of fair use, fair dealing, or other
equivalents.

2.7. Conditions

Sections 3.1, 3.2, 3.3, and 3.4 are conditions of the licenses granted
in Section 2.1.

3. Responsibilities
-------------------

3.1. Distribution of Source Form

All distribution of Covered Software in Source Code Form, including any
Modifications that You create or to which You contribute, must be under
the terms of this License. You must inform recipients that the Source
Code Form of the Covered Software is governed by the terms of this
License, and how they can obtain a copy of this License. You may not
attempt to alter or restrict the recipients' rights in the Source Code
Form.

3.2. Distribution of Executable Form

If You distribute Covered Software in Executable Form then:

(a) such Covered Software must also be made available in Source Code
Form, as described in Section 3.1, and You must inform recipients of
the Executable Form how they can obtain a copy of such Source Code
Form by reasonable means in a timely manner, at a charge no more
than the cost of distribution to the recipient; and

(b) You may distribute such Executable Form under the terms of this
License, or sublicense it under different terms, provided that the
license for the Executable Form does not attempt to limit or alter
the recipients' rights in the Source Code Form under this License.

3.3. Distribution of a Larger Work

You may create and distribute a Larger Work under terms of Your choice,
provided that You also comply with the requirements of this License for
the Covered Software. If the Larger Work is a combination of Covered
Software with a work governed by one or more Secondary Licenses, and the
Covered Software is not Incompatible With Secondary Licenses, this
License permits You to additionally distribute such Covered Software
under the terms of such Secondary License(s), so that the recipient of
the Larger Work may, at their option, further distribute the Covered
Software under the terms of either this License or such Secondary
License(s).

3.4. Notices

You may not remove or alter the substance of any license notices
(including copyright notices, patent notices, disclaimers of warranty,
or limitations of liability) contained within the Source Code Form of
the Covered Software, except that You may alter any license notices to
the extent required to remedy known factual inaccuracies.

3.5. Application of Additional Terms

You may choose to offer, and to charge a fee for, warranty, support,
indemnity or liability obligations to one or more recipients of Covered
Software. However, You may do so only on Your own behalf, and not on
behalf of any Contributor. You must make it absolutely clear that any
such warranty, support, indemnity, or liability obligation is offered by
You alone, and You hereby agree to indemnify every Contributor for any
liability incurred by such Contributor as a result of warranty, support,
indemnity or liability terms You offer. You may include additional
disclaimers of warranty and limitations of liability specific to any
jurisdiction.

4. Inability to Comply Due to Statute or Regulation
---------------------------------------------------

If it is impossible for You to comply with any of the terms of this
License with respect to some or all of the Covered Software due to
statute, judicial order, or regulation then You must: (a) comply with
the terms of this License to the maximum extent possible; and (b)
describe the limitations and the code they affect. Such description must
be placed in a text file included with all distributions of the Covered
Software under this License. Except to the extent prohibited by statute
or regulation, such description must be sufficiently detailed for a
recipient of ordinary skill to be able to understand it.

5. Termination
--------------

5.1. The rights granted under this License will terminate automatically
if You fail to comply with any of its terms. However, if You become
compliant, then the rights granted under this License from a particular
Contributor are reinstated (a) provisionally, unless and until such
Contributor explicitly and finally terminates Your grants, and (b) on an
ongoing basis, if such Contributor fails to notify You of the
non-compliance by some reasonable means prior to 60 days after You have
come back into compliance. Moreover, Your grants from a particular
Contributor are reinstated on an ongoing basis if such Contributor
notifies You of the non-compliance by some reasonable means, this is the
first time You have received notice of non-compliance with this License
from such Contributor, and You become compliant prior to 30 days after
Your receipt of the notice.

5.2. If You initiate litigation against any entity by asserting a patent
infringement claim (excluding declaratory judgment actions,
counter-claims, and cross-claims) alleging that a Contributor Version
directly or indirectly infringes any patent, then the rights granted to
You by any and all Contributors for the Covered Software under Section
2.1 of this License shall terminate.

5.3. In the event of termination under Sections 5.1 or 5.2 above, all
end user license agreements (excluding distributors and resellers) which
have been validly granted by You or Your distributors under this License
prior to termination shall survive termination.

************************************************************************
*                                                                      *
*  6. Disclaimer of Warranty                                           *
*  -------------------------                                           *
*                                                                      *
*  Covered Software is provided under this License on an "as is"       *
*  basis, without warranty of any kind, either expressed, implied, or  *
*  statutory, including, without limitation, warranties that the       *
*  Covered Software is free of defects, merchantable, fit for a        *
*  particular purpose or non-infringing. The entire risk as to the     *
*  quality and performance of the Covered Software is with You.        *
*  Should any Covered Software prove defective in any respect, You     *
*  (not any Contributor) assume the cost of any necessary servicing,   *
*  repair, or correction. This disclaimer of warranty constitutes an   *
*  essential part of this License. No use of any Covered Software is   *
*  authorized under this License except under this disclaimer.         *
*                                                                      *
************************************************************************

************************************************************************
*                                                                      *
*  7. Limitation of Liability                                          *
*  --------------------------                                          *
*                                                                      *
*  Under no circumstances and under no legal theory, whether tort      *
*  (including negligence), contract, or otherwise, shall any           *
*  Contributor, or anyone who distributes Covered Software as          *
*  permitted above, be liable to You for any direct, indirect,         *
*  special, incidental, or consequential damages of any character      *
*  including, without limitation, damages for lost profits, loss of    *
*  goodwill, work stoppage, computer failure or malfunction, or any    *
*  and all other commercial damages or losses, even if such party      *
*  shall have been informed of the possibility of such damages. This   *
*  limitation of liability shall not apply to liability for death or   *
*  personal injury resulting from such party's negligence to the       *
*  extent applicable law prohibits such limitation. Some               *
*  jurisdictions do not allow the exclusion or limitation of           *
*  incidental or consequential damages, so this exclusion and          *
*  limitation may not apply to You.                                    *
*                                                                      *
************************************************************************

8. Litigation
-------------

Any litigation relating to this License may be brought only in the
courts of a jurisdiction where the defendant maintains its principal
place of business and such litigation shall be governed by laws of that
jurisdiction, without reference to its conflict-of-law provisions.
Nothing in this Section shall prevent a party's ability to bring
cross-claims or counter-claims.

9. Miscellaneous
----------------

This License represents the complete agreement concerning the subject
matter hereof. If any provision of this License is held to be
unenforceable, such provision shall be reformed only to the extent
necessary to make it enforceable. Any law or regulation which provides
that the language of a contract shall be construed against the drafter
shall not be used to construe this License against a Contributor.

10. Versions of the License
---------------------------

10.1. New Versions

Mozilla Foundation is the license steward. Except as provided in Section
10.3, no one other than the license steward has the right to modify or
publish new versions of this License. Each version will be given a
distinguishing version number.

10.2. Effect of New Versions

You may distribute the Covered Software under the terms of the version
of the License under which You originally received the Covered Software,
or under the terms of any subsequent version published by the license
steward.

10.3. Modified Versions

If you create software not governed by this License, and you want to
create a new license for such software, you may create and use a
modified version of this License if you rename the license and remove
any references to the name of the license steward (except to note that
such modified license differs from this License).

10.4. Distributing Source Code Form that is Incompatible With Secondary
Licenses

If You choose to distribute Source Code Form that is Incompatible With
Secondary Licenses under the terms of this version of the License, the
notice described in Exhibit B of this License must be attached.

Exhibit A - Source Code Form License Notice
-------------------------------------------

This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this
file, You can obtain one at https://mozilla.org/MPL/2.0/.

If it is not possible or desirable to put the notice in a particular
file, then You may include the notice in a location (such as a LICENSE
file in a relevant directory) where a recipient would be likely to look
for such a notice.

You may add additional accurate notices of copyright ownership.

Exhibit B - "Incompatible With Secondary Licenses" Notice
---------------------------------------------------------
)<!>" R"<!>(
This Source Code Form is "Incompatible With Secondary Licenses", as
defined by the Mozilla Public License, v. 2.0.
)<!>"),

R"<!>(PREAMBLE
The goals of the Open Font License (OFL) are to stimulate worldwide
development of collaborative font projects, to support the font creation
efforts of academic and linguistic communities, and to provide a free and
open framework in which fonts may be shared and improved in partnership
with others.

The OFL allows the licensed fonts to be used, studied, modified and
redistributed freely as long as they are not sold by themselves. The
fonts, including any derivative works, can be bundled, embedded,
redistributed and/or sold with any software provided that any reserved
names are not used by derivative works. The fonts and derivatives,
however, cannot be released under any other type of license. The
requirement for fonts to remain under this license does not apply
to any document created using the fonts or their derivatives.

DEFINITIONS
"Font Software" refers to the set of files released by the Copyright
Holder(s) under this license and clearly marked as such. This may
include source files, build scripts and documentation.

"Reserved Font Name" refers to any names specified as such after the
copyright statement(s).

"Original Version" refers to the collection of Font Software components as
distributed by the Copyright Holder(s).

"Modified Version" refers to any derivative made by adding to, deleting,
or substituting -- in part or in whole -- any of the components of the
Original Version, by changing formats or by porting the Font Software to a
new environment.

"Author" refers to any designer, engineer, programmer, technical
writer or other person who contributed to the Font Software.

PERMISSION & CONDITIONS
Permission is hereby granted, free of charge, to any person obtaining
a copy of the Font Software, to use, study, copy, merge, embed, modify,
redistribute, and sell modified and unmodified copies of the Font
Software, subject to the following conditions:

1) Neither the Font Software nor any of its individual components,
in Original or Modified Versions, may be sold by itself.

2) Original or Modified Versions of the Font Software may be bundled,
redistributed and/or sold with any software, provided that each copy
contains the above copyright notice and this license. These can be
included either as stand-alone text files, human-readable headers or
in the appropriate machine-readable metadata fields within text or
binary files as long as those fields can be easily viewed by the user.

3) No Modified Version of the Font Software may use the Reserved Font
Name(s) unless explicit written permission is granted by the corresponding
Copyright Holder. This restriction only applies to the primary font name as
presented to the users.

4) The name(s) of the Copyright Holder(s) or the Author(s) of the Font
Software shall not be used to promote, endorse or advertise any
Modified Version, except to acknowledge the contribution(s) of the
Copyright Holder(s) and the Author(s) or with their explicit written
permission.

5) The Font Software, modified or unmodified, in part or in whole,
must be distributed entirely under this license, and must not be
distributed under any other license. The requirement for fonts to
remain under this license does not apply to any document created
using the Font Software.

TERMINATION
This license becomes null and void if any of the above conditions are
not met.

DISCLAIMER
THE FONT SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
OF COPYRIGHT, PATENT, TRADEMARK, OR OTHER RIGHT. IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
INCLUDING ANY GENERAL, SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL
DAMAGES, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF THE USE OR INABILITY TO USE THE FONT SOFTWARE.
)<!>",

R"<!>(COPYRIGHT AND PERMISSION NOTICE (ICU 58 and later)

Copyright (C) 1991-2020 Unicode, Inc. All rights reserved.
Distributed under the Terms of Use in https://www.unicode.org/copyright.html.

Permission is hereby granted, free of charge, to any person obtaining
a copy of the Unicode data files and any associated documentation
(the "Data Files") or Unicode software and any associated documentation
(the "Software") to deal in the Data Files or Software
without restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, and/or sell copies of
the Data Files or Software, and to permit persons to whom the Data Files
or Software are furnished to do so, provided that either
(a) this copyright and permission notice appear with all copies
of the Data Files or Software, or
(b) this copyright and permission notice appear in associated
Documentation.

THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT OF THIRD PARTY RIGHTS.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THE DATA FILES OR SOFTWARE.

Except as contained in this notice, the name of a copyright holder
shall not be used in advertising or otherwise to promote the sale,
use or other dealings in these Data Files or Software without prior
written authorization of the copyright holder.
)<!>",

R"<!>(This is free and unencumbered software released into the public domain.

Anyone is free to copy, modify, publish, use, compile, sell, or
distribute this software, either in source code form or as a compiled
binary, for any purpose, commercial or non-commercial, and by any
means.

In jurisdictions that recognize copyright laws, the author or authors
of this software dedicate any and all copyright interest in the
software to the public domain. We make this dedication for the benefit
of the public at large and to the detriment of our heirs and
successors. We intend this dedication to be an overt act of
relinquishment in perpetuity of all present and future rights to this
software under copyright law.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

For more information, please refer to <https://unlicense.org/>
)<!>",

R"<!>(The Wide Open License (WOL)

Permission to use, copy, modify, distribute and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice and this license appear in all source copies.
THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF
ANY KIND. See https://dspguru.com/wide-open-license/ for more information.
)<!>",

R"<!>(This software is provided 'as-is', without any express or implied
warranty.  In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software
in a product, an acknowledgment in the product documentation would be
appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
)<!>",

};
