/* mail-merge-processor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from mail-merge-processor.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "util.h"
#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define MAIL_MERGE_PROCESSOR_FIELD_START "{{"
#define MAIL_MERGE_PROCESSOR_FIELD_END "}}"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAIL_MERGE_PROCESSOR_0_PROPERTY,
	MAIL_MERGE_PROCESSOR_TEMPLATE_PROPERTY,
	MAIL_MERGE_PROCESSOR_EMAIL_PROPERTY,
	MAIL_MERGE_PROCESSOR_MISSING_FIELDS_PROPERTY,
	MAIL_MERGE_PROCESSOR_NUM_PROPERTIES
};
static GParamSpec* mail_merge_processor_properties[MAIL_MERGE_PROCESSOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAIL_MERGE_PROCESSOR_TYPE_PARSER (mail_merge_processor_parser_get_type ())
typedef struct _MailMergeProcessorParser MailMergeProcessorParser;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _MailMergeProcessorPrivate {
	GearyEmail* _template;
	GearyComposedEmail* _email;
	GeeList* _missing_fields;
};

struct _MailMergeProcessorParser {
	const gchar* text;
	gint index;
	gboolean spent;
	gboolean at_field_start;
	gboolean at_field_end;
};

static gint MailMergeProcessor_private_offset;
static gpointer mail_merge_processor_parent_class = NULL;

static GType mail_merge_processor_parser_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static MailMergeProcessorParser* mail_merge_processor_parser_dup (const MailMergeProcessorParser* self);
static void mail_merge_processor_parser_free (MailMergeProcessorParser* self);
static void mail_merge_processor_parser_init (MailMergeProcessorParser *self,
                                       const gchar* text);
static gchar* mail_merge_processor_parser_read_field (MailMergeProcessorParser *self);
static gchar* mail_merge_processor_parser_read_text (MailMergeProcessorParser *self);
static void mail_merge_processor_set_template (MailMergeProcessor* self,
                                        GearyEmail* value);
static void mail_merge_processor_set_email (MailMergeProcessor* self,
                                     GearyComposedEmail* value);
static void mail_merge_processor_set_missing_fields (MailMergeProcessor* self,
                                              GeeList* value);
static inline GearyRFC822MailboxAddresses* mail_merge_processor_format_mailbox_addresses (MailMergeProcessor* self,
                                                                            GearyRFC822MailboxAddresses* addresses,
                                                                            GeeMap* values);
static inline GearyRFC822MailboxAddress* mail_merge_processor_format_mailbox_address (MailMergeProcessor* self,
                                                                        GearyRFC822MailboxAddress* address,
                                                                        GeeMap* values);
static inline gchar* mail_merge_processor_format_string (MailMergeProcessor* self,
                                           const gchar* text,
                                           GeeMap* values);
static void mail_merge_processor_finalize (GObject * obj);
static GType mail_merge_processor_get_type_once (void);
static void _vala_mail_merge_processor_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_mail_merge_processor_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
mail_merge_processor_get_instance_private (MailMergeProcessor* self)
{
	return G_STRUCT_MEMBER_P (self, MailMergeProcessor_private_offset);
}

gchar*
mail_merge_processor_to_field (const gchar* name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_strconcat (MAIL_MERGE_PROCESSOR_FIELD_START, name, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, MAIL_MERGE_PROCESSOR_FIELD_END, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gboolean
mail_merge_processor_is_mail_merge_template (GearyEmail* email,
                                             GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GearyRFC822Subject* _tmp6_;
	GearyRFC822Subject* _tmp7_;
	gboolean found = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, GEARY_TYPE_EMAIL), FALSE);
	_tmp6_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GearyRFC822Subject* _tmp8_;
		GearyRFC822Subject* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp9_ = _tmp8_;
		_tmp10_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
		_tmp11_ = _tmp10_;
		_tmp5_ = mail_merge_processor_contains_field (_tmp11_);
		_g_free0 (_tmp11_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp12_ = FALSE;
		GearyRFC822MailboxAddresses* _tmp13_;
		GearyRFC822MailboxAddresses* _tmp14_;
		_tmp13_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp14_ = _tmp13_;
		if (_tmp14_ != NULL) {
			GearyRFC822MailboxAddresses* _tmp15_;
			GearyRFC822MailboxAddresses* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp15_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp16_ = _tmp15_;
			_tmp17_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_tmp18_ = _tmp17_;
			_tmp12_ = mail_merge_processor_contains_field (_tmp18_);
			_g_free0 (_tmp18_);
		} else {
			_tmp12_ = FALSE;
		}
		_tmp4_ = _tmp12_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp19_ = FALSE;
		GearyRFC822MailboxAddresses* _tmp20_;
		GearyRFC822MailboxAddresses* _tmp21_;
		_tmp20_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp21_ = _tmp20_;
		if (_tmp21_ != NULL) {
			GearyRFC822MailboxAddresses* _tmp22_;
			GearyRFC822MailboxAddresses* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp22_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp23_ = _tmp22_;
			_tmp24_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_tmp25_ = _tmp24_;
			_tmp19_ = mail_merge_processor_contains_field (_tmp25_);
			_g_free0 (_tmp25_);
		} else {
			_tmp19_ = FALSE;
		}
		_tmp3_ = _tmp19_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp26_ = FALSE;
		GearyRFC822MailboxAddresses* _tmp27_;
		GearyRFC822MailboxAddresses* _tmp28_;
		_tmp27_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			GearyRFC822MailboxAddresses* _tmp29_;
			GearyRFC822MailboxAddresses* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp29_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp30_ = _tmp29_;
			_tmp31_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_tmp32_ = _tmp31_;
			_tmp26_ = mail_merge_processor_contains_field (_tmp32_);
			_g_free0 (_tmp32_);
		} else {
			_tmp26_ = FALSE;
		}
		_tmp2_ = _tmp26_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp33_ = FALSE;
		GearyRFC822MailboxAddresses* _tmp34_;
		GearyRFC822MailboxAddresses* _tmp35_;
		_tmp34_ = geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp35_ = _tmp34_;
		if (_tmp35_ != NULL) {
			GearyRFC822MailboxAddresses* _tmp36_;
			GearyRFC822MailboxAddresses* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp36_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp37_ = _tmp36_;
			_tmp38_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_tmp39_ = _tmp38_;
			_tmp33_ = mail_merge_processor_contains_field (_tmp39_);
			_g_free0 (_tmp39_);
		} else {
			_tmp33_ = FALSE;
		}
		_tmp1_ = _tmp33_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp40_ = FALSE;
		GearyRFC822MailboxAddress* _tmp41_;
		GearyRFC822MailboxAddress* _tmp42_;
		_tmp41_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp42_ = _tmp41_;
		if (_tmp42_ != NULL) {
			GearyRFC822MailboxAddress* _tmp43_;
			GearyRFC822MailboxAddress* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			_tmp43_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp44_ = _tmp43_;
			_tmp45_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_tmp46_ = _tmp45_;
			_tmp40_ = mail_merge_processor_contains_field (_tmp46_);
			_g_free0 (_tmp46_);
		} else {
			_tmp40_ = FALSE;
		}
		_tmp0_ = _tmp40_;
	}
	found = _tmp0_;
	if (!found) {
		GearyRFC822Message* message = NULL;
		GearyRFC822Message* _tmp47_;
		gchar* _tmp49_ = NULL;
		GearyRFC822Message* _tmp50_;
		gchar* body = NULL;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		_tmp47_ = geary_email_get_message (email, &_inner_error0_);
		message = _tmp47_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp48_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp48_;
		}
		_tmp50_ = message;
		if (geary_rf_c822_message_has_plain_body (_tmp50_)) {
			GearyRFC822Message* _tmp51_;
			gchar* _tmp52_;
			_tmp51_ = message;
			_tmp52_ = geary_rf_c822_message_get_plain_body (_tmp51_, FALSE, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp49_);
			_tmp49_ = _tmp52_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp53_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp49_);
				_g_object_unref0 (message);
				return _tmp53_;
			}
		} else {
			GearyRFC822Message* _tmp54_;
			gchar* _tmp55_;
			_tmp54_ = message;
			_tmp55_ = geary_rf_c822_message_get_html_body (_tmp54_, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp49_);
			_tmp49_ = _tmp55_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp56_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_free0 (_tmp49_);
				_g_object_unref0 (message);
				return _tmp56_;
			}
		}
		_tmp57_ = g_strdup (_tmp49_);
		body = _tmp57_;
		_tmp58_ = body;
		found = mail_merge_processor_contains_field (_tmp58_);
		_g_free0 (body);
		_g_free0 (_tmp49_);
		_g_object_unref0 (message);
	}
	result = found;
	return result;
}

gboolean
mail_merge_processor_contains_field (const gchar* text)
{
	MailMergeProcessorParser parser = {0};
	gboolean found = FALSE;
	gboolean result;
	g_return_val_if_fail (text != NULL, FALSE);
	mail_merge_processor_parser_init (&parser, text);
	found = FALSE;
	while (TRUE) {
		MailMergeProcessorParser _tmp0_;
		MailMergeProcessorParser _tmp1_;
		_tmp0_ = parser;
		if (!(!_tmp0_.spent)) {
			break;
		}
		_tmp1_ = parser;
		if (_tmp1_.at_field_start) {
			gchar* _tmp2_;
			gchar* _tmp3_;
			MailMergeProcessorParser _tmp4_;
			_tmp2_ = mail_merge_processor_parser_read_field (&parser);
			_tmp3_ = _tmp2_;
			_g_free0 (_tmp3_);
			_tmp4_ = parser;
			if (_tmp4_.at_field_end) {
				found = TRUE;
				break;
			}
		} else {
			gchar* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = mail_merge_processor_parser_read_text (&parser);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp6_);
		}
	}
	result = found;
	return result;
}

GearyEmail*
mail_merge_processor_get_template (MailMergeProcessor* self)
{
	GearyEmail* result;
	GearyEmail* _tmp0_;
	g_return_val_if_fail (MAIL_MERGE_IS_PROCESSOR (self), NULL);
	_tmp0_ = self->priv->_template;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mail_merge_processor_set_template (MailMergeProcessor* self,
                                   GearyEmail* value)
{
	GearyEmail* old_value;
	g_return_if_fail (MAIL_MERGE_IS_PROCESSOR (self));
	old_value = mail_merge_processor_get_template (self);
	if (old_value != value) {
		GearyEmail* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_template);
		self->priv->_template = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_merge_processor_properties[MAIL_MERGE_PROCESSOR_TEMPLATE_PROPERTY]);
	}
}

GearyComposedEmail*
mail_merge_processor_get_email (MailMergeProcessor* self)
{
	GearyComposedEmail* result;
	GearyComposedEmail* _tmp0_;
	g_return_val_if_fail (MAIL_MERGE_IS_PROCESSOR (self), NULL);
	_tmp0_ = self->priv->_email;
	result = _tmp0_;
	return result;
}

static void
mail_merge_processor_set_email (MailMergeProcessor* self,
                                GearyComposedEmail* value)
{
	GearyComposedEmail* old_value;
	g_return_if_fail (MAIL_MERGE_IS_PROCESSOR (self));
	old_value = mail_merge_processor_get_email (self);
	if (old_value != value) {
		GearyComposedEmail* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_email);
		self->priv->_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_merge_processor_properties[MAIL_MERGE_PROCESSOR_EMAIL_PROPERTY]);
	}
}

GeeList*
mail_merge_processor_get_missing_fields (MailMergeProcessor* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (MAIL_MERGE_IS_PROCESSOR (self), NULL);
	_tmp0_ = self->priv->_missing_fields;
	result = _tmp0_;
	return result;
}

static void
mail_merge_processor_set_missing_fields (MailMergeProcessor* self,
                                         GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (MAIL_MERGE_IS_PROCESSOR (self));
	old_value = mail_merge_processor_get_missing_fields (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_missing_fields);
		self->priv->_missing_fields = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_merge_processor_properties[MAIL_MERGE_PROCESSOR_MISSING_FIELDS_PROPERTY]);
	}
}

/** Constructs a new merge processor with the given template. */
MailMergeProcessor*
mail_merge_processor_construct (GType object_type,
                                GearyEmail* template)
{
	MailMergeProcessor * self = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (template, GEARY_TYPE_EMAIL), NULL);
	self = (MailMergeProcessor*) g_object_new (object_type, NULL);
	mail_merge_processor_set_template (self, template);
	return self;
}

MailMergeProcessor*
mail_merge_processor_new (GearyEmail* template)
{
	return mail_merge_processor_construct (MAIL_MERGE_TYPE_PROCESSOR, template);
}

/**
     * Merges the template with the given data to produce a complete message.
     *
     * Creates a new composed email based on the template and given
     * data, set it as the {@email} property and returns it.
     */
GearyComposedEmail*
mail_merge_processor_merge (MailMergeProcessor* self,
                            GeeMap* values,
                            GError** error)
{
	GearyRFC822MailboxAddresses* from = NULL;
	GearyEmail* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyRFC822MailboxAddresses* _tmp3_;
	GearyComposedEmail* email = NULL;
	GTimeZone* _tmp4_;
	GTimeZone* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GearyRFC822MailboxAddresses* _tmp8_;
	GearyComposedEmail* _tmp9_;
	GearyComposedEmail* _tmp10_;
	GearyComposedEmail* _tmp11_;
	GearyComposedEmail* _tmp12_;
	GearyComposedEmail* _tmp13_;
	GearyEmail* _tmp14_;
	GearyRFC822MailboxAddresses* _tmp15_;
	GearyRFC822MailboxAddresses* _tmp16_;
	GearyRFC822MailboxAddresses* _tmp17_;
	GearyRFC822MailboxAddresses* _tmp18_;
	GearyComposedEmail* _tmp19_;
	GearyComposedEmail* _tmp20_;
	GearyComposedEmail* _tmp21_;
	GearyEmail* _tmp22_;
	GearyRFC822MailboxAddresses* _tmp23_;
	GearyRFC822MailboxAddresses* _tmp24_;
	GearyRFC822MailboxAddresses* _tmp25_;
	GearyRFC822MailboxAddresses* _tmp26_;
	GearyComposedEmail* _tmp27_;
	GearyComposedEmail* _tmp28_;
	GearyComposedEmail* _tmp29_;
	GearyEmail* _tmp30_;
	GearyRFC822MailboxAddresses* _tmp31_;
	GearyRFC822MailboxAddresses* _tmp32_;
	GearyRFC822MailboxAddresses* _tmp33_;
	GearyRFC822MailboxAddresses* _tmp34_;
	GearyComposedEmail* _tmp35_;
	GearyComposedEmail* _tmp36_;
	GearyComposedEmail* _tmp37_;
	GearyEmail* _tmp38_;
	GearyRFC822MailboxAddresses* _tmp39_;
	GearyRFC822MailboxAddresses* _tmp40_;
	GearyRFC822MailboxAddresses* _tmp41_;
	GearyRFC822MailboxAddresses* _tmp42_;
	GearyComposedEmail* _tmp43_;
	GearyComposedEmail* _tmp44_;
	GearyComposedEmail* _tmp45_;
	GearyEmail* _tmp46_;
	GearyRFC822MailboxAddress* _tmp47_;
	GearyRFC822MailboxAddress* _tmp48_;
	GearyRFC822MailboxAddress* _tmp49_;
	GearyRFC822MailboxAddress* _tmp50_;
	GearyComposedEmail* _tmp51_;
	GearyComposedEmail* _tmp52_;
	GearyEmail* _tmp53_;
	GearyRFC822Subject* _tmp54_;
	GearyRFC822Subject* _tmp55_;
	GearyComposedEmail* _tmp66_;
	GearyEmail* _tmp67_;
	GearyRFC822MessageIDList* _tmp68_;
	GearyRFC822MessageIDList* _tmp69_;
	GearyComposedEmail* _tmp70_;
	GearyComposedEmail* _tmp71_;
	GearyComposedEmail* _tmp72_;
	GearyEmail* _tmp73_;
	GearyRFC822MessageIDList* _tmp74_;
	GearyRFC822MessageIDList* _tmp75_;
	GearyComposedEmail* _tmp76_;
	GearyComposedEmail* _tmp77_;
	GearyRFC822Message* message = NULL;
	GearyEmail* _tmp78_;
	GearyRFC822Message* _tmp79_;
	GearyRFC822Message* _tmp80_;
	GearyRFC822Message* _tmp87_;
	GError* _inner_error0_ = NULL;
	GearyComposedEmail* result;
	g_return_val_if_fail (MAIL_MERGE_IS_PROCESSOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (values, GEE_TYPE_MAP), NULL);
	_tmp0_ = self->priv->_template;
	_tmp1_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp2_ = _tmp1_;
	_tmp3_ = mail_merge_processor_format_mailbox_addresses (self, _tmp2_, values);
	from = _tmp3_;
	_tmp4_ = g_time_zone_new_local ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_date_time_new_now (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = from;
	_tmp9_ = geary_composed_email_new (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	mail_merge_processor_set_email (self, _tmp10_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	_g_date_time_unref0 (_tmp7_);
	_g_time_zone_unref0 (_tmp5_);
	email = _tmp12_;
	_tmp13_ = email;
	_tmp14_ = self->priv->_template;
	_tmp15_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp16_ = _tmp15_;
	_tmp17_ = mail_merge_processor_format_mailbox_addresses (self, _tmp16_, values);
	_tmp18_ = _tmp17_;
	_tmp19_ = geary_composed_email_set_to (_tmp13_, _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (_tmp18_);
	_tmp21_ = email;
	_tmp22_ = self->priv->_template;
	_tmp23_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp24_ = _tmp23_;
	_tmp25_ = mail_merge_processor_format_mailbox_addresses (self, _tmp24_, values);
	_tmp26_ = _tmp25_;
	_tmp27_ = geary_composed_email_set_cc (_tmp21_, _tmp26_);
	_tmp28_ = _tmp27_;
	_g_object_unref0 (_tmp28_);
	_g_object_unref0 (_tmp26_);
	_tmp29_ = email;
	_tmp30_ = self->priv->_template;
	_tmp31_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp32_ = _tmp31_;
	_tmp33_ = mail_merge_processor_format_mailbox_addresses (self, _tmp32_, values);
	_tmp34_ = _tmp33_;
	_tmp35_ = geary_composed_email_set_bcc (_tmp29_, _tmp34_);
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp36_);
	_g_object_unref0 (_tmp34_);
	_tmp37_ = email;
	_tmp38_ = self->priv->_template;
	_tmp39_ = geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp40_ = _tmp39_;
	_tmp41_ = mail_merge_processor_format_mailbox_addresses (self, _tmp40_, values);
	_tmp42_ = _tmp41_;
	_tmp43_ = geary_composed_email_set_reply_to (_tmp37_, _tmp42_);
	_tmp44_ = _tmp43_;
	_g_object_unref0 (_tmp44_);
	_g_object_unref0 (_tmp42_);
	_tmp45_ = email;
	_tmp46_ = self->priv->_template;
	_tmp47_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp48_ = _tmp47_;
	_tmp49_ = mail_merge_processor_format_mailbox_address (self, _tmp48_, values);
	_tmp50_ = _tmp49_;
	_tmp51_ = geary_composed_email_set_sender (_tmp45_, _tmp50_);
	_tmp52_ = _tmp51_;
	_g_object_unref0 (_tmp52_);
	_g_object_unref0 (_tmp50_);
	_tmp53_ = self->priv->_template;
	_tmp54_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		GearyComposedEmail* _tmp56_;
		GearyEmail* _tmp57_;
		GearyRFC822Subject* _tmp58_;
		GearyRFC822Subject* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		GearyComposedEmail* _tmp64_;
		GearyComposedEmail* _tmp65_;
		_tmp56_ = email;
		_tmp57_ = self->priv->_template;
		_tmp58_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp59_ = _tmp58_;
		_tmp60_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_tmp61_ = _tmp60_;
		_tmp62_ = mail_merge_processor_format_string (self, _tmp61_, values);
		_tmp63_ = _tmp62_;
		_tmp64_ = geary_composed_email_set_subject (_tmp56_, _tmp63_);
		_tmp65_ = _tmp64_;
		_g_object_unref0 (_tmp65_);
		_g_free0 (_tmp63_);
	}
	_tmp66_ = email;
	_tmp67_ = self->priv->_template;
	_tmp68_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp69_ = _tmp68_;
	_tmp70_ = geary_composed_email_set_in_reply_to (_tmp66_, _tmp69_);
	_tmp71_ = _tmp70_;
	_g_object_unref0 (_tmp71_);
	_tmp72_ = email;
	_tmp73_ = self->priv->_template;
	_tmp74_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp75_ = _tmp74_;
	_tmp76_ = geary_composed_email_set_references (_tmp72_, _tmp75_);
	_tmp77_ = _tmp76_;
	_g_object_unref0 (_tmp77_);
	_tmp78_ = self->priv->_template;
	_tmp79_ = geary_email_get_message (_tmp78_, &_inner_error0_);
	message = _tmp79_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (email);
		_g_object_unref0 (from);
		return NULL;
	}
	_tmp80_ = message;
	if (geary_rf_c822_message_has_plain_body (_tmp80_)) {
		gchar* _tmp81_ = NULL;
		GearyRFC822Message* _tmp82_;
		gchar* _tmp83_;
		GearyComposedEmail* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		_tmp82_ = message;
		_tmp83_ = geary_rf_c822_message_get_plain_body (_tmp82_, FALSE, NULL, NULL, &_inner_error0_);
		_tmp81_ = _tmp83_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (message);
			_g_object_unref0 (email);
			_g_object_unref0 (from);
			return NULL;
		}
		_tmp84_ = email;
		_tmp85_ = mail_merge_processor_format_string (self, _tmp81_, values);
		_tmp86_ = _tmp85_;
		geary_composed_email_set_body_text (_tmp84_, _tmp86_);
		_g_free0 (_tmp86_);
		_g_free0 (_tmp81_);
	}
	_tmp87_ = message;
	if (geary_rf_c822_message_has_html_body (_tmp87_)) {
		gchar* _tmp88_ = NULL;
		GearyRFC822Message* _tmp89_;
		gchar* _tmp90_;
		GearyComposedEmail* _tmp91_;
		gchar* _tmp92_;
		gchar* _tmp93_;
		_tmp89_ = message;
		_tmp90_ = geary_rf_c822_message_get_html_body (_tmp89_, NULL, NULL, &_inner_error0_);
		_tmp88_ = _tmp90_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (message);
			_g_object_unref0 (email);
			_g_object_unref0 (from);
			return NULL;
		}
		_tmp91_ = email;
		_tmp92_ = mail_merge_processor_format_string (self, _tmp88_, values);
		_tmp93_ = _tmp92_;
		geary_composed_email_set_body_html (_tmp91_, _tmp93_);
		_g_free0 (_tmp93_);
		_g_free0 (_tmp88_);
	}
	result = email;
	_g_object_unref0 (message);
	_g_object_unref0 (from);
	return result;
}

static inline GearyRFC822MailboxAddresses*
mail_merge_processor_format_mailbox_addresses (MailMergeProcessor* self,
                                               GearyRFC822MailboxAddresses* addresses,
                                               GeeMap* values)
{
	GearyRFC822MailboxAddresses* formatted = NULL;
	gboolean _tmp0_ = FALSE;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (MAIL_MERGE_IS_PROCESSOR (self), NULL);
	g_return_val_if_fail ((addresses == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (addresses, GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (values, GEE_TYPE_MAP), NULL);
	formatted = NULL;
	if (addresses != NULL) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = geary_rf_c822_mailbox_addresses_get_is_empty (addresses);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyRFC822MailboxAddresses* _tmp3_;
		_tmp3_ = geary_rf_c822_mailbox_addresses_new (NULL);
		_g_object_unref0 (formatted);
		formatted = _tmp3_;
		{
			GearyRFC822MailboxAddresses* _addr_list = NULL;
			gint _addr_size = 0;
			GearyRFC822MailboxAddresses* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _addr_index = 0;
			_addr_list = addresses;
			_tmp4_ = _addr_list;
			_tmp5_ = geary_rf_c822_mailbox_addresses_get_size (_tmp4_);
			_tmp6_ = _tmp5_;
			_addr_size = _tmp6_;
			_addr_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				GearyRFC822MailboxAddress* addr = NULL;
				GearyRFC822MailboxAddresses* _tmp9_;
				GearyRFC822MailboxAddress* _tmp10_;
				GearyRFC822MailboxAddresses* _tmp11_;
				GearyRFC822MailboxAddress* _tmp12_;
				GearyRFC822MailboxAddress* _tmp13_;
				GearyRFC822MailboxAddress* _tmp14_;
				GearyRFC822MailboxAddresses* _tmp15_;
				_addr_index = _addr_index + 1;
				_tmp7_ = _addr_index;
				_tmp8_ = _addr_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _addr_list;
				_tmp10_ = geary_rf_c822_mailbox_addresses_get (_tmp9_, _addr_index);
				addr = _tmp10_;
				_tmp11_ = formatted;
				_tmp12_ = addr;
				_tmp13_ = mail_merge_processor_format_mailbox_address (self, _tmp12_, values);
				_tmp14_ = _tmp13_;
				_tmp15_ = geary_rf_c822_mailbox_addresses_merge_mailbox (_tmp11_, _tmp14_);
				_g_object_unref0 (formatted);
				formatted = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (addr);
			}
		}
	}
	result = formatted;
	return result;
}

static inline GearyRFC822MailboxAddress*
mail_merge_processor_format_mailbox_address (MailMergeProcessor* self,
                                             GearyRFC822MailboxAddress* address,
                                             GeeMap* values)
{
	GearyRFC822MailboxAddress* formatted = NULL;
	GearyRFC822MailboxAddress* result;
	g_return_val_if_fail (MAIL_MERGE_IS_PROCESSOR (self), NULL);
	g_return_val_if_fail ((address == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (address, GEARY_RF_C822_TYPE_MAILBOX_ADDRESS), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (values, GEE_TYPE_MAP), NULL);
	formatted = NULL;
	if (address != NULL) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GearyRFC822MailboxAddress* _tmp8_;
		_tmp0_ = geary_rf_c822_mailbox_address_get_name (address);
		_tmp1_ = _tmp0_;
		_tmp2_ = mail_merge_processor_format_string (self, _tmp1_, values);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_rf_c822_mailbox_address_get_address (address);
		_tmp5_ = _tmp4_;
		_tmp6_ = mail_merge_processor_format_string (self, _tmp5_, values);
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_rf_c822_mailbox_address_new (_tmp3_, _tmp7_);
		_g_object_unref0 (formatted);
		formatted = _tmp8_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp3_);
	}
	result = formatted;
	return result;
}

static inline gchar*
mail_merge_processor_format_string (MailMergeProcessor* self,
                                    const gchar* text,
                                    GeeMap* values)
{
	gchar* formatted = NULL;
	gchar* result;
	g_return_val_if_fail (MAIL_MERGE_IS_PROCESSOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (values, GEE_TYPE_MAP), NULL);
	formatted = NULL;
	if (text != NULL) {
		GString* buf = NULL;
		gint _tmp0_;
		gint _tmp1_;
		GString* _tmp2_;
		MailMergeProcessorParser parser = {0};
		GString* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp0_ = strlen (text);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_string_sized_new ((gsize) _tmp1_);
		buf = _tmp2_;
		mail_merge_processor_parser_init (&parser, text);
		while (TRUE) {
			MailMergeProcessorParser _tmp3_;
			gchar* value = NULL;
			MailMergeProcessorParser _tmp4_;
			GString* _tmp17_;
			const gchar* _tmp18_;
			_tmp3_ = parser;
			if (!(!_tmp3_.spent)) {
				break;
			}
			value = NULL;
			_tmp4_ = parser;
			if (_tmp4_.at_field_start) {
				gchar* field = NULL;
				gchar* _tmp5_;
				MailMergeProcessorParser _tmp6_;
				_tmp5_ = mail_merge_processor_parser_read_field (&parser);
				field = _tmp5_;
				_tmp6_ = parser;
				if (_tmp6_.at_field_end) {
					const gchar* _tmp7_;
					gpointer _tmp8_;
					const gchar* _tmp9_;
					_tmp7_ = field;
					_tmp8_ = gee_map_get (values, _tmp7_);
					_g_free0 (value);
					value = (gchar*) _tmp8_;
					_tmp9_ = value;
					if (_tmp9_ == NULL) {
						GeeList* _tmp10_;
						const gchar* _tmp11_;
						const gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp10_ = self->priv->_missing_fields;
						_tmp11_ = field;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), _tmp11_);
						_tmp12_ = field;
						_tmp13_ = mail_merge_processor_to_field (_tmp12_);
						_g_free0 (value);
						value = _tmp13_;
					}
				} else {
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = field;
					_tmp15_ = g_strdup (_tmp14_);
					_g_free0 (value);
					value = _tmp15_;
				}
				_g_free0 (field);
			} else {
				gchar* _tmp16_;
				_tmp16_ = mail_merge_processor_parser_read_text (&parser);
				_g_free0 (value);
				value = _tmp16_;
			}
			_tmp17_ = buf;
			_tmp18_ = value;
			g_string_append (_tmp17_, _tmp18_);
			_g_free0 (value);
		}
		_tmp19_ = buf;
		_tmp20_ = _tmp19_->str;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (formatted);
		formatted = _tmp21_;
		_g_string_free0 (buf);
	}
	result = formatted;
	return result;
}

static void
mail_merge_processor_parser_init (MailMergeProcessorParser *self,
                                  const gchar* text)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (text != NULL);
	memset (self, 0, sizeof (MailMergeProcessorParser));
	(*self).text = text;
	(*self).index = 0;
	_tmp0_ = strlen (text);
	_tmp1_ = _tmp0_;
	(*self).spent = _tmp1_ == 0;
	(*self).at_field_start = g_str_has_prefix (text, MAIL_MERGE_PROCESSOR_FIELD_START);
	(*self).at_field_end = FALSE;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
mail_merge_processor_parser_read_text (MailMergeProcessorParser *self)
{
	gint start = 0;
	gchar c = '\0';
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	(*self).at_field_end = FALSE;
	start = (*self).index;
	_tmp0_ = (*self).text;
	c = string_get (_tmp0_, (glong) (*self).index);
	while (TRUE) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp5_;
		if (!(((gint) c) != 0)) {
			break;
		}
		_tmp1_ = (*self).index;
		(*self).index = _tmp1_ + 1;
		if (c == string_get (MAIL_MERGE_PROCESSOR_FIELD_START, (glong) 0)) {
			const gchar* _tmp3_;
			_tmp3_ = (*self).text;
			_tmp2_ = string_get (_tmp3_, (glong) (*self).index) == string_get (MAIL_MERGE_PROCESSOR_FIELD_START, (glong) 1);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp4_;
			_tmp4_ = (*self).index;
			(*self).index = _tmp4_ - 1;
			(*self).at_field_start = TRUE;
			break;
		}
		_tmp5_ = (*self).text;
		c = string_get (_tmp5_, (glong) (*self).index);
	}
	if (((gint) c) == 0) {
		(*self).spent = TRUE;
	}
	_tmp6_ = (*self).text;
	_tmp7_ = string_slice (_tmp6_, (glong) start, (glong) (*self).index);
	result = _tmp7_;
	return result;
}

static gchar*
mail_merge_processor_parser_read_field (MailMergeProcessorParser *self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint start = 0;
	gchar c = '\0';
	const gchar* _tmp2_;
	gint end = 0;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* result;
	(*self).at_field_start = FALSE;
	_tmp0_ = strlen (MAIL_MERGE_PROCESSOR_FIELD_START);
	_tmp1_ = _tmp0_;
	(*self).index = (*self).index + _tmp1_;
	start = (*self).index;
	_tmp2_ = (*self).text;
	c = string_get (_tmp2_, (glong) (*self).index);
	while (TRUE) {
		gint _tmp3_;
		const gchar* _tmp6_;
		if (!(((gint) c) != 0)) {
			break;
		}
		_tmp3_ = (*self).index;
		(*self).index = _tmp3_ + 1;
		if (c == string_get (MAIL_MERGE_PROCESSOR_FIELD_END, (glong) 0)) {
			const gchar* _tmp4_;
			_tmp4_ = (*self).text;
			if (string_get (_tmp4_, (glong) (*self).index) == string_get (MAIL_MERGE_PROCESSOR_FIELD_END, (glong) 1)) {
				gint _tmp5_;
				_tmp5_ = (*self).index;
				(*self).index = _tmp5_ + 1;
				(*self).at_field_end = TRUE;
				break;
			}
		}
		_tmp6_ = (*self).text;
		c = string_get (_tmp6_, (glong) (*self).index);
	}
	end = (*self).index;
	if ((*self).at_field_end) {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (MAIL_MERGE_PROCESSOR_FIELD_END);
		_tmp8_ = _tmp7_;
		end -= _tmp8_;
	} else {
		gint _tmp9_;
		gint _tmp10_;
		_tmp9_ = strlen (MAIL_MERGE_PROCESSOR_FIELD_START);
		_tmp10_ = _tmp9_;
		start -= _tmp10_;
	}
	if (((gint) c) == 0) {
		_tmp11_ = TRUE;
	} else {
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp12_ = (*self).text;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp11_ = (*self).index == _tmp14_;
	}
	if (_tmp11_) {
		(*self).spent = TRUE;
	}
	_tmp15_ = (*self).text;
	_tmp16_ = string_slice (_tmp15_, (glong) start, (glong) end);
	result = _tmp16_;
	return result;
}

static MailMergeProcessorParser*
mail_merge_processor_parser_dup (const MailMergeProcessorParser* self)
{
	MailMergeProcessorParser* dup;
	dup = g_new0 (MailMergeProcessorParser, 1);
	memcpy (dup, self, sizeof (MailMergeProcessorParser));
	return dup;
}

static void
mail_merge_processor_parser_free (MailMergeProcessorParser* self)
{
	g_free (self);
}

static GType
mail_merge_processor_parser_get_type_once (void)
{
	GType mail_merge_processor_parser_type_id;
	mail_merge_processor_parser_type_id = g_boxed_type_register_static ("MailMergeProcessorParser", (GBoxedCopyFunc) mail_merge_processor_parser_dup, (GBoxedFreeFunc) mail_merge_processor_parser_free);
	return mail_merge_processor_parser_type_id;
}

static GType
mail_merge_processor_parser_get_type (void)
{
	static volatile gsize mail_merge_processor_parser_type_id__once = 0;
	if (g_once_init_enter (&mail_merge_processor_parser_type_id__once)) {
		GType mail_merge_processor_parser_type_id;
		mail_merge_processor_parser_type_id = mail_merge_processor_parser_get_type_once ();
		g_once_init_leave (&mail_merge_processor_parser_type_id__once, mail_merge_processor_parser_type_id);
	}
	return mail_merge_processor_parser_type_id__once;
}

static void
mail_merge_processor_class_init (MailMergeProcessorClass * klass,
                                 gpointer klass_data)
{
	mail_merge_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailMergeProcessor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_merge_processor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_merge_processor_set_property;
	G_OBJECT_CLASS (klass)->finalize = mail_merge_processor_finalize;
	/** The email template being processed. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MERGE_PROCESSOR_TEMPLATE_PROPERTY, mail_merge_processor_properties[MAIL_MERGE_PROCESSOR_TEMPLATE_PROPERTY] = g_param_spec_object ("template", "template", "template", GEARY_TYPE_EMAIL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The email constructed by the processor. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MERGE_PROCESSOR_EMAIL_PROPERTY, mail_merge_processor_properties[MAIL_MERGE_PROCESSOR_EMAIL_PROPERTY] = g_param_spec_object ("email", "email", "email", GEARY_TYPE_COMPOSED_EMAIL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** A list of data fields missing when processing the template. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_MERGE_PROCESSOR_MISSING_FIELDS_PROPERTY, mail_merge_processor_properties[MAIL_MERGE_PROCESSOR_MISSING_FIELDS_PROPERTY] = g_param_spec_object ("missing-fields", "missing-fields", "missing-fields", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
mail_merge_processor_instance_init (MailMergeProcessor * self,
                                    gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = mail_merge_processor_get_instance_private (self);
	self->priv->_email = NULL;
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	self->priv->_missing_fields = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
}

static void
mail_merge_processor_finalize (GObject * obj)
{
	MailMergeProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_MERGE_TYPE_PROCESSOR, MailMergeProcessor);
	_g_object_unref0 (self->priv->_template);
	_g_object_unref0 (self->priv->_email);
	_g_object_unref0 (self->priv->_missing_fields);
	G_OBJECT_CLASS (mail_merge_processor_parent_class)->finalize (obj);
}

/**
 * Substitutes merge fields in an email with actual data.
 */
static GType
mail_merge_processor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailMergeProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_merge_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailMergeProcessor), 0, (GInstanceInitFunc) mail_merge_processor_instance_init, NULL };
	GType mail_merge_processor_type_id;
	mail_merge_processor_type_id = g_type_register_static (G_TYPE_OBJECT, "MailMergeProcessor", &g_define_type_info, 0);
	MailMergeProcessor_private_offset = g_type_add_instance_private (mail_merge_processor_type_id, sizeof (MailMergeProcessorPrivate));
	return mail_merge_processor_type_id;
}

GType
mail_merge_processor_get_type (void)
{
	static volatile gsize mail_merge_processor_type_id__once = 0;
	if (g_once_init_enter (&mail_merge_processor_type_id__once)) {
		GType mail_merge_processor_type_id;
		mail_merge_processor_type_id = mail_merge_processor_get_type_once ();
		g_once_init_leave (&mail_merge_processor_type_id__once, mail_merge_processor_type_id);
	}
	return mail_merge_processor_type_id__once;
}

static void
_vala_mail_merge_processor_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	MailMergeProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_MERGE_TYPE_PROCESSOR, MailMergeProcessor);
	switch (property_id) {
		case MAIL_MERGE_PROCESSOR_TEMPLATE_PROPERTY:
		g_value_set_object (value, mail_merge_processor_get_template (self));
		break;
		case MAIL_MERGE_PROCESSOR_EMAIL_PROPERTY:
		g_value_set_object (value, mail_merge_processor_get_email (self));
		break;
		case MAIL_MERGE_PROCESSOR_MISSING_FIELDS_PROPERTY:
		g_value_set_object (value, mail_merge_processor_get_missing_fields (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_merge_processor_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	MailMergeProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_MERGE_TYPE_PROCESSOR, MailMergeProcessor);
	switch (property_id) {
		case MAIL_MERGE_PROCESSOR_TEMPLATE_PROPERTY:
		mail_merge_processor_set_template (self, g_value_get_object (value));
		break;
		case MAIL_MERGE_PROCESSOR_EMAIL_PROPERTY:
		mail_merge_processor_set_email (self, g_value_get_object (value));
		break;
		case MAIL_MERGE_PROCESSOR_MISSING_FIELDS_PROPERTY:
		mail_merge_processor_set_missing_fields (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

