/* auto-generated, do not modify */
#pragma once
#include <fu-input-stream.h>
typedef enum {
    FU_USB_DIRECTION_DEVICE_TO_HOST,
    FU_USB_DIRECTION_HOST_TO_DEVICE,
}  FuUsbDirection;
#define FU_USB_DIRECTION_LAST 2
typedef enum {
    FU_USB_REQUEST_TYPE_STANDARD,
    FU_USB_REQUEST_TYPE_CLASS,
    FU_USB_REQUEST_TYPE_VENDOR,
    FU_USB_REQUEST_TYPE_RESERVED,
}  FuUsbRequestType;
#define FU_USB_REQUEST_TYPE_LAST 4
typedef enum {
    FU_USB_RECIPIENT_DEVICE,
    FU_USB_RECIPIENT_INTERFACE,
    FU_USB_RECIPIENT_ENDPOINT,
    FU_USB_RECIPIENT_OTHER,
}  FuUsbRecipient;
#define FU_USB_RECIPIENT_LAST 4
typedef enum {
    FU_USB_CLASS_INTERFACE_DESC = 0x00,
    FU_USB_CLASS_AUDIO = 0x01,
    FU_USB_CLASS_COMMUNICATIONS = 0x02,
    FU_USB_CLASS_HID = 0x03,
    FU_USB_CLASS_PHYSICAL = 0x05,
    FU_USB_CLASS_IMAGE = 0x06,
    FU_USB_CLASS_PRINTER = 0x07,
    FU_USB_CLASS_MASS_STORAGE = 0x08,
    FU_USB_CLASS_HUB = 0x09,
    FU_USB_CLASS_CDC_DATA = 0x0A,
    FU_USB_CLASS_SMART_CARD = 0x0B,
    FU_USB_CLASS_CONTENT_SECURITY = 0x0D,
    FU_USB_CLASS_VIDEO = 0x0E,
    FU_USB_CLASS_PERSONAL_HEALTHCARE = 0x0F,
    FU_USB_CLASS_AUDIO_VIDEO = 0x10,
    FU_USB_CLASS_BILLBOARD = 0x11,
    FU_USB_CLASS_DIAGNOSTIC = 0xDC,
    FU_USB_CLASS_WIRELESS_CONTROLLER = 0xE0,
    FU_USB_CLASS_MISCELLANEOUS = 0xEF,
    FU_USB_CLASS_APPLICATION_SPECIFIC = 0xFE,
    FU_USB_CLASS_VENDOR_SPECIFIC = 0xFF,
}  FuUsbClass;
const gchar *fu_usb_class_to_string(FuUsbClass val) G_GNUC_CONST;
typedef enum {
    FU_USB_LANGID_INVALID = 0x0000,
    FU_USB_LANGID_ENGLISH_UNITED_STATES = 0x0409,
}  FuUsbLangid;
typedef enum {
    FU_USB_DESCRIPTOR_KIND_INVALID = 0x00,
    FU_USB_DESCRIPTOR_KIND_DEVICE = 0x01,
    FU_USB_DESCRIPTOR_KIND_CONFIG = 0x02,
    FU_USB_DESCRIPTOR_KIND_STRING = 0x03,
    FU_USB_DESCRIPTOR_KIND_INTERFACE = 0x04,
    FU_USB_DESCRIPTOR_KIND_ENDPOINT = 0x05,
    FU_USB_DESCRIPTOR_KIND_INTERFACE_ASSOCIATION = 0x0B,
    FU_USB_DESCRIPTOR_KIND_BOS = 0x0F,
    FU_USB_DESCRIPTOR_KIND_DEVICE_CAPABILITY = 0x10,
    FU_USB_DESCRIPTOR_KIND_HID = 0x21,
    FU_USB_DESCRIPTOR_KIND_REPORT = 0x22,
    FU_USB_DESCRIPTOR_KIND_PHYSICAL = 0x23,
    FU_USB_DESCRIPTOR_KIND_HUB = 0x29,
    FU_USB_DESCRIPTOR_KIND_SUPERSPEED_HUB = 0x2A,
    FU_USB_DESCRIPTOR_KIND_SS_ENDPOINT_COMPANION = 0x30,
}  FuUsbDescriptorKind;
const gchar *fu_usb_descriptor_kind_to_string(FuUsbDescriptorKind val) G_GNUC_CONST;
FuUsbDescriptorKind fu_usb_descriptor_kind_from_string(const gchar *val) G_GNUC_CONST G_GNUC_NON_NULL(1);
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbBaseHdr;

FuUsbBaseHdr *fu_usb_base_hdr_ref(FuUsbBaseHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_base_hdr_unref(FuUsbBaseHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbBaseHdr, fu_usb_base_hdr_unref)
FuUsbBaseHdr *fu_usb_base_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuUsbBaseHdr *fu_usb_base_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuUsbBaseHdr *fu_usb_base_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_base_hdr_get_length(const FuUsbBaseHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuUsbDescriptorKind fu_usb_base_hdr_get_descriptor_type(const FuUsbBaseHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_USB_BASE_HDR_OFFSET_LENGTH 0x0
#define FU_USB_BASE_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#endif

#ifndef __GI_SCANNER__
#define FU_USB_BASE_HDR_SIZE 0x2
#endif

#ifndef __GI_SCANNER__
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbDeviceHdr;

FuUsbDeviceHdr *fu_usb_device_hdr_ref(FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_device_hdr_unref(FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbDeviceHdr, fu_usb_device_hdr_unref)
FuUsbDeviceHdr *fu_usb_device_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_length(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_device_hdr_get_usb(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuUsbClass fu_usb_device_hdr_get_device_class(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_device_sub_class(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_device_protocol(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_max_packet_size0(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_device_hdr_get_vendor(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_device_hdr_get_product(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_device_hdr_get_device(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_manufacturer_idx(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_product_idx(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_serial_number_idx(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_device_hdr_get_num_configurations(const FuUsbDeviceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_USB_DEVICE_HDR_OFFSET_LENGTH 0x0
#define FU_USB_DEVICE_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#define FU_USB_DEVICE_HDR_OFFSET_USB 0x2
#define FU_USB_DEVICE_HDR_OFFSET_DEVICE_CLASS 0x4
#define FU_USB_DEVICE_HDR_OFFSET_DEVICE_SUB_CLASS 0x5
#define FU_USB_DEVICE_HDR_OFFSET_DEVICE_PROTOCOL 0x6
#define FU_USB_DEVICE_HDR_OFFSET_MAX_PACKET_SIZE0 0x7
#define FU_USB_DEVICE_HDR_OFFSET_VENDOR 0x8
#define FU_USB_DEVICE_HDR_OFFSET_PRODUCT 0xA
#define FU_USB_DEVICE_HDR_OFFSET_DEVICE 0xC
#define FU_USB_DEVICE_HDR_OFFSET_MANUFACTURER_IDX 0xE
#define FU_USB_DEVICE_HDR_OFFSET_PRODUCT_IDX 0xF
#define FU_USB_DEVICE_HDR_OFFSET_SERIAL_NUMBER_IDX 0x10
#define FU_USB_DEVICE_HDR_OFFSET_NUM_CONFIGURATIONS 0x11
#endif

#ifndef __GI_SCANNER__
#define FU_USB_DEVICE_HDR_SIZE 0x12
#endif

#ifndef __GI_SCANNER__
#define FU_USB_DEVICE_HDR_DEFAULT_DESCRIPTOR_TYPE FU_USB_DESCRIPTOR_KIND_DEVICE
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbDescriptorHdr;

FuUsbDescriptorHdr *fu_usb_descriptor_hdr_ref(FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_descriptor_hdr_unref(FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbDescriptorHdr, fu_usb_descriptor_hdr_unref)
FuUsbDescriptorHdr *fu_usb_descriptor_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_descriptor_hdr_get_length(const FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_descriptor_hdr_get_total_length(const FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_descriptor_hdr_get_num_interfaces(const FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_descriptor_hdr_get_configuration_value(const FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_descriptor_hdr_get_configuration(const FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_descriptor_hdr_get_attributes(const FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_descriptor_hdr_get_max_power(const FuUsbDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_USB_DESCRIPTOR_HDR_OFFSET_LENGTH 0x0
#define FU_USB_DESCRIPTOR_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#define FU_USB_DESCRIPTOR_HDR_OFFSET_TOTAL_LENGTH 0x2
#define FU_USB_DESCRIPTOR_HDR_OFFSET_NUM_INTERFACES 0x4
#define FU_USB_DESCRIPTOR_HDR_OFFSET_CONFIGURATION_VALUE 0x5
#define FU_USB_DESCRIPTOR_HDR_OFFSET_CONFIGURATION 0x6
#define FU_USB_DESCRIPTOR_HDR_OFFSET_ATTRIBUTES 0x7
#define FU_USB_DESCRIPTOR_HDR_OFFSET_MAX_POWER 0x8
#endif

#ifndef __GI_SCANNER__
#define FU_USB_DESCRIPTOR_HDR_SIZE 0x9
#endif

#ifndef __GI_SCANNER__
#define FU_USB_DESCRIPTOR_HDR_DEFAULT_DESCRIPTOR_TYPE FU_USB_DESCRIPTOR_KIND_CONFIG
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbHidDescriptorHdr;

FuUsbHidDescriptorHdr *fu_usb_hid_descriptor_hdr_ref(FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_hid_descriptor_hdr_unref(FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbHidDescriptorHdr, fu_usb_hid_descriptor_hdr_unref)
FuUsbHidDescriptorHdr *fu_usb_hid_descriptor_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_hid_descriptor_hdr_get_length(const FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_hid_descriptor_hdr_get_hid(const FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_hid_descriptor_hdr_get_country_code(const FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_hid_descriptor_hdr_get_num_descriptors(const FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_hid_descriptor_hdr_get_class_descriptor_type(const FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_hid_descriptor_hdr_get_class_descriptor_length(const FuUsbHidDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_USB_HID_DESCRIPTOR_HDR_OFFSET_LENGTH 0x0
#define FU_USB_HID_DESCRIPTOR_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#define FU_USB_HID_DESCRIPTOR_HDR_OFFSET_HID 0x2
#define FU_USB_HID_DESCRIPTOR_HDR_OFFSET_COUNTRY_CODE 0x4
#define FU_USB_HID_DESCRIPTOR_HDR_OFFSET_NUM_DESCRIPTORS 0x5
#define FU_USB_HID_DESCRIPTOR_HDR_OFFSET_CLASS_DESCRIPTOR_TYPE 0x6
#define FU_USB_HID_DESCRIPTOR_HDR_OFFSET_CLASS_DESCRIPTOR_LENGTH 0x7
#endif

#ifndef __GI_SCANNER__
#define FU_USB_HID_DESCRIPTOR_HDR_SIZE 0x9
#endif

#ifndef __GI_SCANNER__
#define FU_USB_HID_DESCRIPTOR_HDR_DEFAULT_DESCRIPTOR_TYPE FU_USB_DESCRIPTOR_KIND_HID
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbDfuDescriptorHdr;

FuUsbDfuDescriptorHdr *fu_usb_dfu_descriptor_hdr_ref(FuUsbDfuDescriptorHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_dfu_descriptor_hdr_unref(FuUsbDfuDescriptorHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbDfuDescriptorHdr, fu_usb_dfu_descriptor_hdr_unref)
FuUsbDfuDescriptorHdr *fu_usb_dfu_descriptor_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_dfu_descriptor_hdr_get_length(const FuUsbDfuDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_dfu_descriptor_hdr_get_attributes(const FuUsbDfuDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_dfu_descriptor_hdr_get_detach_timeout(const FuUsbDfuDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_dfu_descriptor_hdr_get_transfer_size(const FuUsbDfuDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_dfu_descriptor_hdr_get_dfu_version(const FuUsbDfuDescriptorHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_USB_DFU_DESCRIPTOR_HDR_OFFSET_LENGTH 0x0
#define FU_USB_DFU_DESCRIPTOR_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#define FU_USB_DFU_DESCRIPTOR_HDR_OFFSET_ATTRIBUTES 0x2
#define FU_USB_DFU_DESCRIPTOR_HDR_OFFSET_DETACH_TIMEOUT 0x3
#define FU_USB_DFU_DESCRIPTOR_HDR_OFFSET_TRANSFER_SIZE 0x5
#define FU_USB_DFU_DESCRIPTOR_HDR_OFFSET_DFU_VERSION 0x7
#endif

#ifndef __GI_SCANNER__
#define FU_USB_DFU_DESCRIPTOR_HDR_SIZE 0x9
#endif

#ifndef __GI_SCANNER__
#define FU_USB_DFU_DESCRIPTOR_HDR_DEFAULT_DESCRIPTOR_TYPE FU_USB_DESCRIPTOR_KIND_HID
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbInterfaceHdr;

FuUsbInterfaceHdr *fu_usb_interface_hdr_ref(FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_interface_hdr_unref(FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbInterfaceHdr, fu_usb_interface_hdr_unref)
FuUsbInterfaceHdr *fu_usb_interface_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_interface_hdr_get_length(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_interface_hdr_get_interface_number(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_interface_hdr_get_alternate_setting(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_interface_hdr_get_num_endpoints(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuUsbClass fu_usb_interface_hdr_get_interface_class(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_interface_hdr_get_interface_sub_class(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_interface_hdr_get_interface_protocol(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_interface_hdr_get_interface(const FuUsbInterfaceHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_USB_INTERFACE_HDR_OFFSET_LENGTH 0x0
#define FU_USB_INTERFACE_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#define FU_USB_INTERFACE_HDR_OFFSET_INTERFACE_NUMBER 0x2
#define FU_USB_INTERFACE_HDR_OFFSET_ALTERNATE_SETTING 0x3
#define FU_USB_INTERFACE_HDR_OFFSET_NUM_ENDPOINTS 0x4
#define FU_USB_INTERFACE_HDR_OFFSET_INTERFACE_CLASS 0x5
#define FU_USB_INTERFACE_HDR_OFFSET_INTERFACE_SUB_CLASS 0x6
#define FU_USB_INTERFACE_HDR_OFFSET_INTERFACE_PROTOCOL 0x7
#define FU_USB_INTERFACE_HDR_OFFSET_INTERFACE 0x8
#endif

#ifndef __GI_SCANNER__
#define FU_USB_INTERFACE_HDR_SIZE 0x9
#endif

#ifndef __GI_SCANNER__
#define FU_USB_INTERFACE_HDR_DEFAULT_DESCRIPTOR_TYPE FU_USB_DESCRIPTOR_KIND_INTERFACE
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbEndpointHdr;

FuUsbEndpointHdr *fu_usb_endpoint_hdr_ref(FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_endpoint_hdr_unref(FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbEndpointHdr, fu_usb_endpoint_hdr_unref)
FuUsbEndpointHdr *fu_usb_endpoint_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_endpoint_hdr_get_length(const FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuUsbDescriptorKind fu_usb_endpoint_hdr_get_descriptor_type(const FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_endpoint_hdr_get_endpoint_address(const FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_endpoint_hdr_get_attributes(const FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint16 fu_usb_endpoint_hdr_get_max_packet_size(const FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_endpoint_hdr_get_interval(const FuUsbEndpointHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;

#ifndef __GI_SCANNER__
#define FU_USB_ENDPOINT_HDR_OFFSET_LENGTH 0x0
#define FU_USB_ENDPOINT_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#define FU_USB_ENDPOINT_HDR_OFFSET_ENDPOINT_ADDRESS 0x2
#define FU_USB_ENDPOINT_HDR_OFFSET_ATTRIBUTES 0x3
#define FU_USB_ENDPOINT_HDR_OFFSET_MAX_PACKET_SIZE 0x4
#define FU_USB_ENDPOINT_HDR_OFFSET_INTERVAL 0x6
#endif

#ifndef __GI_SCANNER__
#define FU_USB_ENDPOINT_HDR_SIZE 0x7
#endif

#ifndef __GI_SCANNER__
#endif
typedef struct {
  GByteArray *buf;
  guint refcount;
} FuUsbBosHdr;

FuUsbBosHdr *fu_usb_bos_hdr_ref(FuUsbBosHdr *st) G_GNUC_NON_NULL(1);
void fu_usb_bos_hdr_unref(FuUsbBosHdr *st) G_GNUC_NON_NULL(1);
G_DEFINE_AUTOPTR_CLEANUP_FUNC(FuUsbBosHdr, fu_usb_bos_hdr_unref)
FuUsbBosHdr *fu_usb_bos_hdr_new(void) G_GNUC_WARN_UNUSED_RESULT;
FuUsbBosHdr *fu_usb_bos_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_bos_hdr_get_length(const FuUsbBosHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
FuUsbDescriptorKind fu_usb_bos_hdr_get_descriptor_type(const FuUsbBosHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
guint8 fu_usb_bos_hdr_get_dev_capability_type(const FuUsbBosHdr *st) G_GNUC_NON_NULL(1) G_GNUC_WARN_UNUSED_RESULT;
void fu_usb_bos_hdr_set_length(FuUsbBosHdr *st, guint8 value) G_GNUC_NON_NULL(1);
void fu_usb_bos_hdr_set_descriptor_type(FuUsbBosHdr *st, FuUsbDescriptorKind value) G_GNUC_NON_NULL(1);
void fu_usb_bos_hdr_set_dev_capability_type(FuUsbBosHdr *st, guint8 value) G_GNUC_NON_NULL(1);

#ifndef __GI_SCANNER__
#define FU_USB_BOS_HDR_OFFSET_LENGTH 0x0
#define FU_USB_BOS_HDR_OFFSET_DESCRIPTOR_TYPE 0x1
#define FU_USB_BOS_HDR_OFFSET_DEV_CAPABILITY_TYPE 0x2
#endif

#ifndef __GI_SCANNER__
#define FU_USB_BOS_HDR_SIZE 0x3
#endif

#ifndef __GI_SCANNER__
#define FU_USB_BOS_HDR_DEFAULT_LENGTH 3
#define FU_USB_BOS_HDR_DEFAULT_DESCRIPTOR_TYPE FU_USB_DESCRIPTOR_KIND_BOS
#endif
