/* auto-generated, do not modify */
#include "config.h"

#include "fu-tpm-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_tpm_eventlog_item_kind_to_string(FuTpmEventlogItemKind val)
{
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_PREBOOT_CERT)
        return "ev-preboot-cert";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_POST_CODE)
        return "ev-post-code";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_NO_ACTION)
        return "ev-no-action";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_SEPARATOR)
        return "ev-separator";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_ACTION)
        return "ev-action";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EVENT_TAG)
        return "ev-event-tag";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_S_CRTM_CONTENTS)
        return "ev-s-crtm-contents";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_S_CRTM_VERSION)
        return "ev-s-crtm-version";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_CPU_MICROCODE)
        return "ev-cpu-microcode";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_PLATFORM_CONFIG_FLAGS)
        return "ev-platform-config-flags";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_TABLE_OF_DEVICES)
        return "ev-table-of-devices";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_COMPACT_HASH)
        return "ev-compact-hash";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_NONHOST_CODE)
        return "ev-nonhost-code";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_NONHOST_CONFIG)
        return "ev-nonhost-config";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_NONHOST_INFO)
        return "ev-nonhost-info";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_OMIT_BOOT_DEVICE_EVENTS)
        return "ev-omit-boot-device-events";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_EVENT_BASE)
        return "ev-efi-event-base";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_VARIABLE_DRIVER_CONFIG)
        return "ev-efi-variable-driver-config";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_VARIABLE_BOOT)
        return "ev-efi-variable-boot";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_BOOT_SERVICES_APPLICATION)
        return "ev-efi-boot-services-application";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_BOOT_SERVICES_DRIVER)
        return "ev-efi-boot-services-driver";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_RUNTIME_SERVICES_DRIVER)
        return "ev-efi-runtime-services-driver";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_GPT_EVENT)
        return "ev-efi-gpt-event";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_ACTION)
        return "ev-efi-action";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_PLATFORM_FIRMWARE_BLOB)
        return "ev-efi-platform-firmware-blob";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_HANDOFF_TABLES)
        return "ev-efi-handoff-tables";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_HCRTM_EVENT)
        return "ev-efi-hcrtm-event";
    if (val == FU_TPM_EVENTLOG_ITEM_KIND_EV_EFI_VARIABLE_AUTHORITY)
        return "ev-efi-variable-authority";
    return NULL;
}
/* getters */
/**
 * fu_struct_tpm_event_log2_get_pcr: (skip):
 **/
guint32
fu_struct_tpm_event_log2_get_pcr(const FuStructTpmEventLog2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_tpm_event_log2_get_type: (skip):
 **/
FuTpmEventlogItemKind
fu_struct_tpm_event_log2_get_type(const FuStructTpmEventLog2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_tpm_event_log2_get_digest_count: (skip):
 **/
guint32
fu_struct_tpm_event_log2_get_digest_count(const FuStructTpmEventLog2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_tpm_event_log2_to_string: (skip):
 **/
static gchar *
fu_struct_tpm_event_log2_to_string(const FuStructTpmEventLog2 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructTpmEventLog2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  pcr: 0x%x\n",
                           (guint) fu_struct_tpm_event_log2_get_pcr(st));
    {
        const gchar *tmp = fu_tpm_eventlog_item_kind_to_string(fu_struct_tpm_event_log2_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_tpm_event_log2_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_tpm_event_log2_get_type(st));
        }
    }
    g_string_append_printf(str, "  digest_count: 0x%x\n",
                           (guint) fu_struct_tpm_event_log2_get_digest_count(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_tpm_event_log2_validate_internal(FuStructTpmEventLog2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_tpm_event_log2_parse_internal(FuStructTpmEventLog2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_tpm_event_log2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_tpm_event_log2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_tpm_event_log2_parse: (skip):
 **/
FuStructTpmEventLog2 *
fu_struct_tpm_event_log2_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructTpmEventLog2: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 12);
    if (!fu_struct_tpm_event_log2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_tpm_efi_startup_locality_event_get_signature: (skip):
 **/
static gchar *
fu_struct_tpm_efi_startup_locality_event_get_signature(const FuStructTpmEfiStartupLocalityEvent *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 16, NULL);
}
/**
 * fu_struct_tpm_efi_startup_locality_event_get_locality: (skip):
 **/
guint8
fu_struct_tpm_efi_startup_locality_event_get_locality(const FuStructTpmEfiStartupLocalityEvent *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[16];
}

/* setters */
/**
 * fu_struct_tpm_efi_startup_locality_event_to_string: (skip):
 **/
static gchar *
fu_struct_tpm_efi_startup_locality_event_to_string(const FuStructTpmEfiStartupLocalityEvent *st)
{
    g_autoptr(GString) str = g_string_new("FuStructTpmEfiStartupLocalityEvent:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  locality: 0x%x\n",
                           (guint) fu_struct_tpm_efi_startup_locality_event_get_locality(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_tpm_efi_startup_locality_event_validate_internal(FuStructTpmEfiStartupLocalityEvent *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->data + 0), "StartupLocality", 16) != 0) {
        g_autofree gchar *str = fu_struct_tpm_efi_startup_locality_event_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructTpmEfiStartupLocalityEvent.signature was not valid, "
                    "expected 'StartupLocality' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_tpm_efi_startup_locality_event_parse_internal(FuStructTpmEfiStartupLocalityEvent *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_tpm_efi_startup_locality_event_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_tpm_efi_startup_locality_event_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_tpm_efi_startup_locality_event_parse: (skip):
 **/
static FuStructTpmEfiStartupLocalityEvent *
fu_struct_tpm_efi_startup_locality_event_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 17, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructTpmEfiStartupLocalityEvent: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 17);
    if (!fu_struct_tpm_efi_startup_locality_event_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_tpm_efi_startup_locality_event_parse_bytes: (skip):
 **/
FuStructTpmEfiStartupLocalityEvent *
fu_struct_tpm_efi_startup_locality_event_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_tpm_efi_startup_locality_event_parse(buf, bufsz, offset, error);
}
