/* auto-generated, do not modify */
#include "config.h"

#include "fu-igsc-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"





static const gchar *
fu_igsc_fwu_heci_status_to_string(FuIgscFwuHeciStatus val)
{
    if (val == FU_IGSC_FWU_HECI_STATUS_SUCCESS)
        return "success";
    if (val == FU_IGSC_FWU_HECI_STATUS_SIZE_ERROR)
        return "size-error";
    if (val == FU_IGSC_FWU_HECI_STATUS_INVALID_PARAMS)
        return "invalid-params";
    if (val == FU_IGSC_FWU_HECI_STATUS_INVALID_COMMAND)
        return "invalid-command";
    if (val == FU_IGSC_FWU_HECI_STATUS_FAILURE)
        return "failure";
    if (val == FU_IGSC_FWU_HECI_STATUS_UPDATE_OPROM_INVALID_STRUCTURE)
        return "update-oprom-invalid-structure";
    if (val == FU_IGSC_FWU_HECI_STATUS_UPDATE_OPROM_SECTION_NOT_EXIST)
        return "update-oprom-section-not-exist";
    return NULL;
}

static const gchar *
fu_igsc_fwu_heci_get_config_flags_to_string(FuIgscFwuHeciGetConfigFlags val)
{
    if (val == FU_IGSC_FWU_HECI_GET_CONFIG_FLAG_NONE)
        return "none";
    if (val == FU_IGSC_FWU_HECI_GET_CONFIG_FLAG_OPROM_CODE_DEVID_ENFORCEMENT)
        return "oprom-code-devid-enforcement";
    return NULL;
}


const gchar *
fu_igsc_fwu_ext_type_to_string(FuIgscFwuExtType val)
{
    if (val == FU_IGSC_FWU_EXT_TYPE_DEVICE_TYPE)
        return "device-type";
    if (val == FU_IGSC_FWU_EXT_TYPE_MODULE_ATTR)
        return "module-attr";
    if (val == FU_IGSC_FWU_EXT_TYPE_SIGNED_PACKAGE_INFO)
        return "signed-package-info";
    if (val == FU_IGSC_FWU_EXT_TYPE_FWDATA_UPDATE)
        return "fwdata-update";
    if (val == FU_IGSC_FWU_EXT_TYPE_IFWI_PART_MAN)
        return "ifwi-part-man";
    if (val == FU_IGSC_FWU_EXT_TYPE_DEVICE_ID_ARRAY)
        return "device-id-array";
    return NULL;
}
/* getters */
/**
 * fu_struct_igsc_oprom_version_get_major: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_major(const FuStructIgscOpromVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_version_get_minor: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_minor(const FuStructIgscOpromVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_version_get_hotfix: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_hotfix(const FuStructIgscOpromVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_oprom_version_get_build: (skip):
 **/
guint16
fu_struct_igsc_oprom_version_get_build(const FuStructIgscOpromVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_oprom_version_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_oprom_version_to_string(const FuStructIgscOpromVersion *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIgscOpromVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_minor(st));
    g_string_append_printf(str, "  hotfix: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_hotfix(st));
    g_string_append_printf(str, "  build: 0x%x\n",
                           (guint) fu_struct_igsc_oprom_version_get_build(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_igsc_oprom_version_validate_internal(FuStructIgscOpromVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_igsc_oprom_version_parse_internal(FuStructIgscOpromVersion *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_igsc_oprom_version_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_igsc_oprom_version_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_igsc_oprom_version_parse: (skip):
 **/
FuStructIgscOpromVersion *
fu_struct_igsc_oprom_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIgscOpromVersion: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    if (!fu_struct_igsc_oprom_version_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_igsc_fw_version_get_project: (skip):
 **/
gchar *
fu_struct_igsc_fw_version_get_project(const FuStructIgscFwVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 4, NULL);
}
/**
 * fu_struct_igsc_fw_version_get_hotfix: (skip):
 **/
guint16
fu_struct_igsc_fw_version_get_hotfix(const FuStructIgscFwVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fw_version_get_build: (skip):
 **/
guint16
fu_struct_igsc_fw_version_get_build(const FuStructIgscFwVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_fw_version_set_project: (skip):
 **/
gboolean
fu_struct_igsc_fw_version_set_project(FuStructIgscFwVersion *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructIgscFwVersion.project (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_igsc_fw_version_set_hotfix: (skip):
 **/
void
fu_struct_igsc_fw_version_set_hotfix(FuStructIgscFwVersion *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fw_version_set_build: (skip):
 **/
void
fu_struct_igsc_fw_version_set_build(FuStructIgscFwVersion *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fw_version_new: (skip):
 **/
FuStructIgscFwVersion *
fu_struct_igsc_fw_version_new(void)
{
    FuStructIgscFwVersion *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/* getters */
/**
 * fu_igsc_fwdata_device_info2_get_subsys_vendor_id: (skip):
 **/
guint16
fu_igsc_fwdata_device_info2_get_subsys_vendor_id(const FuIgscFwdataDeviceInfo2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info2_get_subsys_device_id: (skip):
 **/
guint16
fu_igsc_fwdata_device_info2_get_subsys_device_id(const FuIgscFwdataDeviceInfo2 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwdata_device_info2_to_string: (skip):
 **/
static gchar *
fu_igsc_fwdata_device_info2_to_string(const FuIgscFwdataDeviceInfo2 *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwdataDeviceInfo2:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  subsys_vendor_id: 0x%x\n",
                           (guint) fu_igsc_fwdata_device_info2_get_subsys_vendor_id(st));
    g_string_append_printf(str, "  subsys_device_id: 0x%x\n",
                           (guint) fu_igsc_fwdata_device_info2_get_subsys_device_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwdata_device_info2_validate_internal(FuIgscFwdataDeviceInfo2 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_igsc_fwdata_device_info2_parse_internal(FuIgscFwdataDeviceInfo2 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwdata_device_info2_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwdata_device_info2_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_igsc_fwdata_device_info2_parse_stream: (skip):
 **/
FuIgscFwdataDeviceInfo2 *
fu_igsc_fwdata_device_info2_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuIgscFwdataDeviceInfo2 failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuIgscFwdataDeviceInfo2 requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_igsc_fwdata_device_info2_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_igsc_fwdata_device_info4_get_vendor_id: (skip):
 **/
guint16
fu_igsc_fwdata_device_info4_get_vendor_id(const FuIgscFwdataDeviceInfo4 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info4_get_device_id: (skip):
 **/
guint16
fu_igsc_fwdata_device_info4_get_device_id(const FuIgscFwdataDeviceInfo4 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info4_get_subsys_vendor_id: (skip):
 **/
guint16
fu_igsc_fwdata_device_info4_get_subsys_vendor_id(const FuIgscFwdataDeviceInfo4 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info4_get_subsys_device_id: (skip):
 **/
guint16
fu_igsc_fwdata_device_info4_get_subsys_device_id(const FuIgscFwdataDeviceInfo4 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwdata_device_info4_set_vendor_id: (skip):
 **/
void
fu_igsc_fwdata_device_info4_set_vendor_id(FuIgscFwdataDeviceInfo4 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info4_set_device_id: (skip):
 **/
void
fu_igsc_fwdata_device_info4_set_device_id(FuIgscFwdataDeviceInfo4 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info4_set_subsys_vendor_id: (skip):
 **/
void
fu_igsc_fwdata_device_info4_set_subsys_vendor_id(FuIgscFwdataDeviceInfo4 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info4_set_subsys_device_id: (skip):
 **/
void
fu_igsc_fwdata_device_info4_set_subsys_device_id(FuIgscFwdataDeviceInfo4 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwdata_device_info4_new: (skip):
 **/
FuIgscFwdataDeviceInfo4 *
fu_igsc_fwdata_device_info4_new(void)
{
    FuIgscFwdataDeviceInfo4 *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_igsc_fwdata_device_info4_to_string: (skip):
 **/
static gchar *
fu_igsc_fwdata_device_info4_to_string(const FuIgscFwdataDeviceInfo4 *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwdataDeviceInfo4:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vendor_id: 0x%x\n",
                           (guint) fu_igsc_fwdata_device_info4_get_vendor_id(st));
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_igsc_fwdata_device_info4_get_device_id(st));
    g_string_append_printf(str, "  subsys_vendor_id: 0x%x\n",
                           (guint) fu_igsc_fwdata_device_info4_get_subsys_vendor_id(st));
    g_string_append_printf(str, "  subsys_device_id: 0x%x\n",
                           (guint) fu_igsc_fwdata_device_info4_get_subsys_device_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwdata_device_info4_validate_internal(FuIgscFwdataDeviceInfo4 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_igsc_fwdata_device_info4_parse_internal(FuIgscFwdataDeviceInfo4 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwdata_device_info4_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwdata_device_info4_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_igsc_fwdata_device_info4_parse_stream: (skip):
 **/
FuIgscFwdataDeviceInfo4 *
fu_igsc_fwdata_device_info4_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuIgscFwdataDeviceInfo4 failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuIgscFwdataDeviceInfo4 requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_igsc_fwdata_device_info4_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_igsc_fwu_gws_image_info_get_format_version: (skip):
 **/
static guint32
fu_struct_igsc_fwu_gws_image_info_get_format_version(const FuStructIgscFwuGwsImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_gws_image_info_get_instance_id: (skip):
 **/
guint32
fu_struct_igsc_fwu_gws_image_info_get_instance_id(const FuStructIgscFwuGwsImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_fwu_gws_image_info_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_fwu_gws_image_info_to_string(const FuStructIgscFwuGwsImageInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIgscFwuGwsImageInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  instance_id: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_gws_image_info_get_instance_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_igsc_fwu_gws_image_info_validate_internal(FuStructIgscFwuGwsImageInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_igsc_fwu_gws_image_info_get_format_version(st) != 0x1) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructIgscFwuGwsImageInfo.format_version was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x1,
                    (guint) fu_struct_igsc_fwu_gws_image_info_get_format_version(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_igsc_fwu_gws_image_info_parse_internal(FuStructIgscFwuGwsImageInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_igsc_fwu_gws_image_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_igsc_fwu_gws_image_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_igsc_fwu_gws_image_info_parse_stream: (skip):
 **/
FuStructIgscFwuGwsImageInfo *
fu_struct_igsc_fwu_gws_image_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 64, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIgscFwuGwsImageInfo failed read of 0x%x: ", (guint) 64);
        return NULL;
    }
    if (st->len != 64) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIgscFwuGwsImageInfo requested 0x%x and got 0x%x",
                    (guint) 64,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_igsc_fwu_gws_image_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_major: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_major(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_minor: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_minor(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_hotfix: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_hotfix(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_version_build: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_version_build(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_flags: (skip):
 **/
guint16
fu_struct_igsc_fwu_fw_image_data_get_flags(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_fw_type: (skip):
 **/
guint8
fu_struct_igsc_fwu_fw_image_data_get_fw_type(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_fw_sub_type: (skip):
 **/
guint8
fu_struct_igsc_fwu_fw_image_data_get_fw_sub_type(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_arb_svn: (skip):
 **/
guint32
fu_struct_igsc_fwu_fw_image_data_get_arb_svn(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_tcb_svn: (skip):
 **/
guint32
fu_struct_igsc_fwu_fw_image_data_get_tcb_svn(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_fw_image_data_get_vcn: (skip):
 **/
guint32
fu_struct_igsc_fwu_fw_image_data_get_vcn(const FuStructIgscFwuFwImageData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_fwu_fw_image_data_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_fwu_fw_image_data_to_string(const FuStructIgscFwuFwImageData *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIgscFwuFwImageData:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version_major: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_version_major(st));
    g_string_append_printf(str, "  version_minor: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_version_minor(st));
    g_string_append_printf(str, "  version_hotfix: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_version_hotfix(st));
    g_string_append_printf(str, "  version_build: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_version_build(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_flags(st));
    g_string_append_printf(str, "  fw_type: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_fw_type(st));
    g_string_append_printf(str, "  fw_sub_type: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_fw_sub_type(st));
    g_string_append_printf(str, "  arb_svn: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_arb_svn(st));
    g_string_append_printf(str, "  tcb_svn: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_tcb_svn(st));
    g_string_append_printf(str, "  vcn: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_fw_image_data_get_vcn(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_igsc_fwu_fw_image_data_validate_internal(FuStructIgscFwuFwImageData *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/* getters */
/**
 * fu_struct_igsc_fwu_iup_data_get_iup_name: (skip):
 **/
guint32
fu_struct_igsc_fwu_iup_data_get_iup_name(const FuStructIgscFwuIupData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_iup_data_get_flags: (skip):
 **/
guint16
fu_struct_igsc_fwu_iup_data_get_flags(const FuStructIgscFwuIupData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_iup_data_get_svn: (skip):
 **/
guint32
fu_struct_igsc_fwu_iup_data_get_svn(const FuStructIgscFwuIupData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_iup_data_get_vcn: (skip):
 **/
guint32
fu_struct_igsc_fwu_iup_data_get_vcn(const FuStructIgscFwuIupData *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/* getters */
/**
 * fu_struct_igsc_fwu_heci_image_metadata_get_version_format: (skip):
 **/
guint32
fu_struct_igsc_fwu_heci_image_metadata_get_version_format(const FuStructIgscFwuHeciImageMetadata *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/* getters */
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_version_format: (skip):
 **/
guint32
fu_struct_igsc_fwu_image_metadata_v1_get_version_format(const FuStructIgscFwuImageMetadataV1 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_project: (skip):
 **/
gchar *
fu_struct_igsc_fwu_image_metadata_v1_get_project(const FuStructIgscFwuImageMetadataV1 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 4, 4, NULL);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_version_hotfix: (skip):
 **/
guint16
fu_struct_igsc_fwu_image_metadata_v1_get_version_hotfix(const FuStructIgscFwuImageMetadataV1 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_version_build: (skip):
 **/
guint16
fu_struct_igsc_fwu_image_metadata_v1_get_version_build(const FuStructIgscFwuImageMetadataV1 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_get_image_data: (skip):
 **/
FuStructIgscFwuFwImageData *
fu_struct_igsc_fwu_image_metadata_v1_get_image_data(const FuStructIgscFwuImageMetadataV1 *st)
{
    g_autoptr(GByteArray) buf = g_byte_array_new();
    g_return_val_if_fail(st != NULL, NULL);
    g_byte_array_append(buf, st->data + FU_STRUCT_IGSC_FWU_IMAGE_METADATA_V1_OFFSET_IMAGE_DATA, 24);
    return g_steal_pointer(&buf);
}

/* setters */
/**
 * fu_struct_igsc_fwu_image_metadata_v1_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_fwu_image_metadata_v1_to_string(const FuStructIgscFwuImageMetadataV1 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIgscFwuImageMetadataV1:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version_format: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_image_metadata_v1_get_version_format(st));
    {
        g_autofree gchar *tmp = fu_struct_igsc_fwu_image_metadata_v1_get_project(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  project: %s\n", tmp);
    }
    g_string_append_printf(str, "  version_hotfix: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_image_metadata_v1_get_version_hotfix(st));
    g_string_append_printf(str, "  version_build: 0x%x\n",
                           (guint) fu_struct_igsc_fwu_image_metadata_v1_get_version_build(st));
    {
        g_autoptr(GByteArray) st_tmp = fu_struct_igsc_fwu_image_metadata_v1_get_image_data(st);
        g_autofree gchar *tmp = fu_struct_igsc_fwu_fw_image_data_to_string(st_tmp);
        g_string_append_printf(str, "  image_data: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_igsc_fwu_image_metadata_v1_validate_internal(FuStructIgscFwuImageMetadataV1 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    {
        GByteArray st_tmp = {
            .data = (guint8*) st->data + 0xC,
            .len = 24,
        };
        if (!fu_struct_igsc_fwu_fw_image_data_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_igsc_fwu_image_metadata_v1_parse_internal(FuStructIgscFwuImageMetadataV1 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_igsc_fwu_image_metadata_v1_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_igsc_fwu_image_metadata_v1_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_igsc_fwu_image_metadata_v1_parse_stream: (skip):
 **/
FuStructIgscFwuImageMetadataV1 *
fu_struct_igsc_fwu_image_metadata_v1_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 36, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIgscFwuImageMetadataV1 failed read of 0x%x: ", (guint) 36);
        return NULL;
    }
    if (st->len != 36) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIgscFwuImageMetadataV1 requested 0x%x and got 0x%x",
                    (guint) 36,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_igsc_fwu_image_metadata_v1_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fwu_heci_version_req_set_command_id: (skip):
 **/
static void
fu_igsc_fwu_heci_version_req_set_command_id(FuIgscFwuHeciVersionReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fwu_heci_version_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fwu_heci_version_req_set_hdr_flags(FuIgscFwuHeciVersionReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fwu_heci_version_req_set_partition: (skip):
 **/
void
fu_igsc_fwu_heci_version_req_set_partition(FuIgscFwuHeciVersionReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_version_req_new: (skip):
 **/
FuIgscFwuHeciVersionReq *
fu_igsc_fwu_heci_version_req_new(void)
{
    FuIgscFwuHeciVersionReq *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    fu_igsc_fwu_heci_version_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_GET_IP_VERSION);
    fu_igsc_fwu_heci_version_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_igsc_fwu_heci_version_res_get_command_id: (skip):
 **/
static FuIgscFwuHeciCommandId
fu_igsc_fwu_heci_version_res_get_command_id(const FuIgscFwuHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_igsc_fwu_heci_version_res_get_hdr_flags: (skip):
 **/
static FuIgscFwuHeciHdrFlags
fu_igsc_fwu_heci_version_res_get_hdr_flags(const FuIgscFwuHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_igsc_fwu_heci_version_res_get_status: (skip):
 **/
FuIgscFwuHeciStatus
fu_igsc_fwu_heci_version_res_get_status(const FuIgscFwuHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_version_res_get_partition: (skip):
 **/
guint32
fu_igsc_fwu_heci_version_res_get_partition(const FuIgscFwuHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_version_res_get_version_length: (skip):
 **/
guint32
fu_igsc_fwu_heci_version_res_get_version_length(const FuIgscFwuHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwu_heci_version_res_to_string: (skip):
 **/
static gchar *
fu_igsc_fwu_heci_version_res_to_string(const FuIgscFwuHeciVersionRes *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwuHeciVersionRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_igsc_fwu_heci_status_to_string(fu_igsc_fwu_heci_version_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_igsc_fwu_heci_version_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_igsc_fwu_heci_version_res_get_status(st));
        }
    }
    g_string_append_printf(str, "  partition: 0x%x\n",
                           (guint) fu_igsc_fwu_heci_version_res_get_partition(st));
    g_string_append_printf(str, "  version_length: 0x%x\n",
                           (guint) fu_igsc_fwu_heci_version_res_get_version_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwu_heci_version_res_validate_internal(FuIgscFwuHeciVersionRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_igsc_fwu_heci_version_res_get_command_id(st) != FU_IGSC_FWU_HECI_COMMAND_ID_GET_IP_VERSION) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciVersionRes.command_id was not valid");
        return FALSE;
    }
    if (fu_igsc_fwu_heci_version_res_get_hdr_flags(st) != FU_IGSC_FWU_HECI_HDR_FLAG_IS_RESPONSE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciVersionRes.hdr_flags was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_igsc_fwu_heci_version_res_parse_internal(FuIgscFwuHeciVersionRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwu_heci_version_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwu_heci_version_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_igsc_fwu_heci_version_res_parse: (skip):
 **/
FuIgscFwuHeciVersionRes *
fu_igsc_fwu_heci_version_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error_literal(error, "invalid struct FuIgscFwuHeciVersionRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 20);
    if (!fu_igsc_fwu_heci_version_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fw_data_heci_version_req_set_command_id: (skip):
 **/
static void
fu_igsc_fw_data_heci_version_req_set_command_id(FuIgscFwDataHeciVersionReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fw_data_heci_version_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fw_data_heci_version_req_set_hdr_flags(FuIgscFwDataHeciVersionReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fw_data_heci_version_req_new: (skip):
 **/
FuIgscFwDataHeciVersionReq *
fu_igsc_fw_data_heci_version_req_new(void)
{
    FuIgscFwDataHeciVersionReq *st = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st, 12, 0x0);
    fu_igsc_fw_data_heci_version_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_GET_GFX_DATA_UPDATE_INFO);
    fu_igsc_fw_data_heci_version_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_igsc_fw_data_heci_version_res_get_command_id: (skip):
 **/
static FuIgscFwuHeciCommandId
fu_igsc_fw_data_heci_version_res_get_command_id(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_igsc_fw_data_heci_version_res_get_hdr_flags: (skip):
 **/
static FuIgscFwuHeciHdrFlags
fu_igsc_fw_data_heci_version_res_get_hdr_flags(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_igsc_fw_data_heci_version_res_get_status: (skip):
 **/
FuIgscFwuHeciStatus
fu_igsc_fw_data_heci_version_res_get_status(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fw_data_heci_version_res_get_oem_version_nvm: (skip):
 **/
guint32
fu_igsc_fw_data_heci_version_res_get_oem_version_nvm(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fw_data_heci_version_res_get_oem_version_fitb: (skip):
 **/
guint32
fu_igsc_fw_data_heci_version_res_get_oem_version_fitb(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fw_data_heci_version_res_get_major_version: (skip):
 **/
guint16
fu_igsc_fw_data_heci_version_res_get_major_version(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fw_data_heci_version_res_get_major_vcn: (skip):
 **/
guint16
fu_igsc_fw_data_heci_version_res_get_major_vcn(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fw_data_heci_version_res_get_oem_version_fitb_valid: (skip):
 **/
guint32
fu_igsc_fw_data_heci_version_res_get_oem_version_fitb_valid(const FuIgscFwDataHeciVersionRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fw_data_heci_version_res_to_string: (skip):
 **/
static gchar *
fu_igsc_fw_data_heci_version_res_to_string(const FuIgscFwDataHeciVersionRes *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwDataHeciVersionRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_igsc_fwu_heci_status_to_string(fu_igsc_fw_data_heci_version_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_igsc_fw_data_heci_version_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_igsc_fw_data_heci_version_res_get_status(st));
        }
    }
    g_string_append_printf(str, "  oem_version_nvm: 0x%x\n",
                           (guint) fu_igsc_fw_data_heci_version_res_get_oem_version_nvm(st));
    g_string_append_printf(str, "  oem_version_fitb: 0x%x\n",
                           (guint) fu_igsc_fw_data_heci_version_res_get_oem_version_fitb(st));
    g_string_append_printf(str, "  major_version: 0x%x\n",
                           (guint) fu_igsc_fw_data_heci_version_res_get_major_version(st));
    g_string_append_printf(str, "  major_vcn: 0x%x\n",
                           (guint) fu_igsc_fw_data_heci_version_res_get_major_vcn(st));
    g_string_append_printf(str, "  oem_version_fitb_valid: 0x%x\n",
                           (guint) fu_igsc_fw_data_heci_version_res_get_oem_version_fitb_valid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fw_data_heci_version_res_validate_internal(FuIgscFwDataHeciVersionRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_igsc_fw_data_heci_version_res_get_command_id(st) != FU_IGSC_FWU_HECI_COMMAND_ID_GET_GFX_DATA_UPDATE_INFO) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwDataHeciVersionRes.command_id was not valid");
        return FALSE;
    }
    if (fu_igsc_fw_data_heci_version_res_get_hdr_flags(st) != FU_IGSC_FWU_HECI_HDR_FLAG_IS_RESPONSE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwDataHeciVersionRes.hdr_flags was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_igsc_fw_data_heci_version_res_parse_internal(FuIgscFwDataHeciVersionRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fw_data_heci_version_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fw_data_heci_version_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_igsc_fw_data_heci_version_res_parse: (skip):
 **/
FuIgscFwDataHeciVersionRes *
fu_igsc_fw_data_heci_version_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error_literal(error, "invalid struct FuIgscFwDataHeciVersionRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 64);
    if (!fu_igsc_fw_data_heci_version_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_req_set_command_id: (skip):
 **/
static void
fu_igsc_fwu_heci_get_subsystem_ids_req_set_command_id(FuIgscFwuHeciGetSubsystemIdsReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fwu_heci_get_subsystem_ids_req_set_hdr_flags(FuIgscFwuHeciGetSubsystemIdsReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_req_new: (skip):
 **/
FuIgscFwuHeciGetSubsystemIdsReq *
fu_igsc_fwu_heci_get_subsystem_ids_req_new(void)
{
    FuIgscFwuHeciGetSubsystemIdsReq *st = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st, 12, 0x0);
    fu_igsc_fwu_heci_get_subsystem_ids_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_GET_SUBSYSTEM_IDS);
    fu_igsc_fwu_heci_get_subsystem_ids_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_res_get_command_id: (skip):
 **/
static FuIgscFwuHeciCommandId
fu_igsc_fwu_heci_get_subsystem_ids_res_get_command_id(const FuIgscFwuHeciGetSubsystemIdsRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_res_get_hdr_flags: (skip):
 **/
static FuIgscFwuHeciHdrFlags
fu_igsc_fwu_heci_get_subsystem_ids_res_get_hdr_flags(const FuIgscFwuHeciGetSubsystemIdsRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_res_get_status: (skip):
 **/
FuIgscFwuHeciStatus
fu_igsc_fwu_heci_get_subsystem_ids_res_get_status(const FuIgscFwuHeciGetSubsystemIdsRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_res_get_ssvid: (skip):
 **/
guint16
fu_igsc_fwu_heci_get_subsystem_ids_res_get_ssvid(const FuIgscFwuHeciGetSubsystemIdsRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_res_get_ssdid: (skip):
 **/
guint16
fu_igsc_fwu_heci_get_subsystem_ids_res_get_ssdid(const FuIgscFwuHeciGetSubsystemIdsRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwu_heci_get_subsystem_ids_res_to_string: (skip):
 **/
static gchar *
fu_igsc_fwu_heci_get_subsystem_ids_res_to_string(const FuIgscFwuHeciGetSubsystemIdsRes *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwuHeciGetSubsystemIdsRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_igsc_fwu_heci_status_to_string(fu_igsc_fwu_heci_get_subsystem_ids_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_igsc_fwu_heci_get_subsystem_ids_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_igsc_fwu_heci_get_subsystem_ids_res_get_status(st));
        }
    }
    g_string_append_printf(str, "  ssvid: 0x%x\n",
                           (guint) fu_igsc_fwu_heci_get_subsystem_ids_res_get_ssvid(st));
    g_string_append_printf(str, "  ssdid: 0x%x\n",
                           (guint) fu_igsc_fwu_heci_get_subsystem_ids_res_get_ssdid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwu_heci_get_subsystem_ids_res_validate_internal(FuIgscFwuHeciGetSubsystemIdsRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_igsc_fwu_heci_get_subsystem_ids_res_get_command_id(st) != FU_IGSC_FWU_HECI_COMMAND_ID_GET_SUBSYSTEM_IDS) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciGetSubsystemIdsRes.command_id was not valid");
        return FALSE;
    }
    if (fu_igsc_fwu_heci_get_subsystem_ids_res_get_hdr_flags(st) != FU_IGSC_FWU_HECI_HDR_FLAG_IS_RESPONSE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciGetSubsystemIdsRes.hdr_flags was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_igsc_fwu_heci_get_subsystem_ids_res_parse_internal(FuIgscFwuHeciGetSubsystemIdsRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwu_heci_get_subsystem_ids_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwu_heci_get_subsystem_ids_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_igsc_fwu_heci_get_subsystem_ids_res_parse: (skip):
 **/
FuIgscFwuHeciGetSubsystemIdsRes *
fu_igsc_fwu_heci_get_subsystem_ids_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error_literal(error, "invalid struct FuIgscFwuHeciGetSubsystemIdsRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 24);
    if (!fu_igsc_fwu_heci_get_subsystem_ids_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fwu_heci_get_config_req_set_command_id: (skip):
 **/
static void
fu_igsc_fwu_heci_get_config_req_set_command_id(FuIgscFwuHeciGetConfigReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fwu_heci_get_config_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fwu_heci_get_config_req_set_hdr_flags(FuIgscFwuHeciGetConfigReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fwu_heci_get_config_req_new: (skip):
 **/
FuIgscFwuHeciGetConfigReq *
fu_igsc_fwu_heci_get_config_req_new(void)
{
    FuIgscFwuHeciGetConfigReq *st = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st, 12, 0x0);
    fu_igsc_fwu_heci_get_config_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_GET_CONFIG);
    fu_igsc_fwu_heci_get_config_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_igsc_fwu_heci_get_config_res_get_command_id: (skip):
 **/
static FuIgscFwuHeciCommandId
fu_igsc_fwu_heci_get_config_res_get_command_id(const FuIgscFwuHeciGetConfigRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_igsc_fwu_heci_get_config_res_get_hdr_flags: (skip):
 **/
static FuIgscFwuHeciHdrFlags
fu_igsc_fwu_heci_get_config_res_get_hdr_flags(const FuIgscFwuHeciGetConfigRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_igsc_fwu_heci_get_config_res_get_status: (skip):
 **/
FuIgscFwuHeciStatus
fu_igsc_fwu_heci_get_config_res_get_status(const FuIgscFwuHeciGetConfigRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_get_config_res_get_hw_sku: (skip):
 **/
guint32
fu_igsc_fwu_heci_get_config_res_get_hw_sku(const FuIgscFwuHeciGetConfigRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_get_config_res_get_flags: (skip):
 **/
FuIgscFwuHeciGetConfigFlags
fu_igsc_fwu_heci_get_config_res_get_flags(const FuIgscFwuHeciGetConfigRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwu_heci_get_config_res_to_string: (skip):
 **/
static gchar *
fu_igsc_fwu_heci_get_config_res_to_string(const FuIgscFwuHeciGetConfigRes *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwuHeciGetConfigRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_igsc_fwu_heci_status_to_string(fu_igsc_fwu_heci_get_config_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_igsc_fwu_heci_get_config_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_igsc_fwu_heci_get_config_res_get_status(st));
        }
    }
    g_string_append_printf(str, "  hw_sku: 0x%x\n",
                           (guint) fu_igsc_fwu_heci_get_config_res_get_hw_sku(st));
    {
        const gchar *tmp = fu_igsc_fwu_heci_get_config_flags_to_string(fu_igsc_fwu_heci_get_config_res_get_flags(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  flags: 0x%x [%s]\n", (guint) fu_igsc_fwu_heci_get_config_res_get_flags(st), tmp);
        } else {
            g_string_append_printf(str, "  flags: 0x%x\n", (guint) fu_igsc_fwu_heci_get_config_res_get_flags(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwu_heci_get_config_res_validate_internal(FuIgscFwuHeciGetConfigRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_igsc_fwu_heci_get_config_res_get_command_id(st) != FU_IGSC_FWU_HECI_COMMAND_ID_GET_CONFIG) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciGetConfigRes.command_id was not valid");
        return FALSE;
    }
    if (fu_igsc_fwu_heci_get_config_res_get_hdr_flags(st) != FU_IGSC_FWU_HECI_HDR_FLAG_IS_RESPONSE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciGetConfigRes.hdr_flags was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_igsc_fwu_heci_get_config_res_parse_internal(FuIgscFwuHeciGetConfigRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwu_heci_get_config_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwu_heci_get_config_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_igsc_fwu_heci_get_config_res_parse: (skip):
 **/
FuIgscFwuHeciGetConfigRes *
fu_igsc_fwu_heci_get_config_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 60, error)) {
        g_prefix_error_literal(error, "invalid struct FuIgscFwuHeciGetConfigRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 60);
    if (!fu_igsc_fwu_heci_get_config_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fwu_heci_end_req_set_command_id: (skip):
 **/
static void
fu_igsc_fwu_heci_end_req_set_command_id(FuIgscFwuHeciEndReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fwu_heci_end_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fwu_heci_end_req_set_hdr_flags(FuIgscFwuHeciEndReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fwu_heci_end_req_new: (skip):
 **/
FuIgscFwuHeciEndReq *
fu_igsc_fwu_heci_end_req_new(void)
{
    FuIgscFwuHeciEndReq *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    fu_igsc_fwu_heci_end_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_END);
    fu_igsc_fwu_heci_end_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_igsc_fwu_heci_end_res_get_command_id: (skip):
 **/
static FuIgscFwuHeciCommandId
fu_igsc_fwu_heci_end_res_get_command_id(const FuIgscFwuHeciEndRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_igsc_fwu_heci_end_res_get_hdr_flags: (skip):
 **/
static FuIgscFwuHeciHdrFlags
fu_igsc_fwu_heci_end_res_get_hdr_flags(const FuIgscFwuHeciEndRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_igsc_fwu_heci_end_res_get_status: (skip):
 **/
FuIgscFwuHeciStatus
fu_igsc_fwu_heci_end_res_get_status(const FuIgscFwuHeciEndRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwu_heci_end_res_to_string: (skip):
 **/
static gchar *
fu_igsc_fwu_heci_end_res_to_string(const FuIgscFwuHeciEndRes *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwuHeciEndRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_igsc_fwu_heci_status_to_string(fu_igsc_fwu_heci_end_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_igsc_fwu_heci_end_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_igsc_fwu_heci_end_res_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwu_heci_end_res_validate_internal(FuIgscFwuHeciEndRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_igsc_fwu_heci_end_res_get_command_id(st) != FU_IGSC_FWU_HECI_COMMAND_ID_END) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciEndRes.command_id was not valid");
        return FALSE;
    }
    if (fu_igsc_fwu_heci_end_res_get_hdr_flags(st) != FU_IGSC_FWU_HECI_HDR_FLAG_IS_RESPONSE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciEndRes.hdr_flags was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_igsc_fwu_heci_end_res_parse_internal(FuIgscFwuHeciEndRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwu_heci_end_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwu_heci_end_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_igsc_fwu_heci_end_res_parse: (skip):
 **/
FuIgscFwuHeciEndRes *
fu_igsc_fwu_heci_end_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error_literal(error, "invalid struct FuIgscFwuHeciEndRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 12);
    if (!fu_igsc_fwu_heci_end_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fwu_heci_data_req_set_command_id: (skip):
 **/
static void
fu_igsc_fwu_heci_data_req_set_command_id(FuIgscFwuHeciDataReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fwu_heci_data_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fwu_heci_data_req_set_hdr_flags(FuIgscFwuHeciDataReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fwu_heci_data_req_set_data_length: (skip):
 **/
void
fu_igsc_fwu_heci_data_req_set_data_length(FuIgscFwuHeciDataReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_data_req_new: (skip):
 **/
FuIgscFwuHeciDataReq *
fu_igsc_fwu_heci_data_req_new(void)
{
    FuIgscFwuHeciDataReq *st = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st, 12, 0x0);
    fu_igsc_fwu_heci_data_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_DATA);
    fu_igsc_fwu_heci_data_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_igsc_fwu_heci_data_res_get_command_id: (skip):
 **/
static FuIgscFwuHeciCommandId
fu_igsc_fwu_heci_data_res_get_command_id(const FuIgscFwuHeciDataRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_igsc_fwu_heci_data_res_get_hdr_flags: (skip):
 **/
static FuIgscFwuHeciHdrFlags
fu_igsc_fwu_heci_data_res_get_hdr_flags(const FuIgscFwuHeciDataRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_igsc_fwu_heci_data_res_get_status: (skip):
 **/
FuIgscFwuHeciStatus
fu_igsc_fwu_heci_data_res_get_status(const FuIgscFwuHeciDataRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwu_heci_data_res_to_string: (skip):
 **/
static gchar *
fu_igsc_fwu_heci_data_res_to_string(const FuIgscFwuHeciDataRes *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwuHeciDataRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_igsc_fwu_heci_status_to_string(fu_igsc_fwu_heci_data_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_igsc_fwu_heci_data_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_igsc_fwu_heci_data_res_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwu_heci_data_res_validate_internal(FuIgscFwuHeciDataRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_igsc_fwu_heci_data_res_get_command_id(st) != FU_IGSC_FWU_HECI_COMMAND_ID_DATA) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciDataRes.command_id was not valid");
        return FALSE;
    }
    if (fu_igsc_fwu_heci_data_res_get_hdr_flags(st) != FU_IGSC_FWU_HECI_HDR_FLAG_IS_RESPONSE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciDataRes.hdr_flags was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_igsc_fwu_heci_data_res_parse_internal(FuIgscFwuHeciDataRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwu_heci_data_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwu_heci_data_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_igsc_fwu_heci_data_res_parse: (skip):
 **/
FuIgscFwuHeciDataRes *
fu_igsc_fwu_heci_data_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error_literal(error, "invalid struct FuIgscFwuHeciDataRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 12);
    if (!fu_igsc_fwu_heci_data_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fwu_heci_start_req_set_command_id: (skip):
 **/
static void
fu_igsc_fwu_heci_start_req_set_command_id(FuIgscFwuHeciStartReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fwu_heci_start_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fwu_heci_start_req_set_hdr_flags(FuIgscFwuHeciStartReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fwu_heci_start_req_set_update_img_length: (skip):
 **/
void
fu_igsc_fwu_heci_start_req_set_update_img_length(FuIgscFwuHeciStartReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_start_req_set_payload_type: (skip):
 **/
void
fu_igsc_fwu_heci_start_req_set_payload_type(FuIgscFwuHeciStartReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_start_req_set_flags: (skip):
 **/
void
fu_igsc_fwu_heci_start_req_set_flags(FuIgscFwuHeciStartReq *st, FuIgscFwuHeciStartFlags value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_igsc_fwu_heci_start_req_new: (skip):
 **/
FuIgscFwuHeciStartReq *
fu_igsc_fwu_heci_start_req_new(void)
{
    FuIgscFwuHeciStartReq *st = g_byte_array_sized_new(48);
    fu_byte_array_set_size(st, 48, 0x0);
    fu_igsc_fwu_heci_start_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_START);
    fu_igsc_fwu_heci_start_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_igsc_fwu_heci_start_res_get_command_id: (skip):
 **/
static FuIgscFwuHeciCommandId
fu_igsc_fwu_heci_start_res_get_command_id(const FuIgscFwuHeciStartRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_igsc_fwu_heci_start_res_get_hdr_flags: (skip):
 **/
static FuIgscFwuHeciHdrFlags
fu_igsc_fwu_heci_start_res_get_hdr_flags(const FuIgscFwuHeciStartRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_igsc_fwu_heci_start_res_get_status: (skip):
 **/
FuIgscFwuHeciStatus
fu_igsc_fwu_heci_start_res_get_status(const FuIgscFwuHeciStartRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_igsc_fwu_heci_start_res_to_string: (skip):
 **/
static gchar *
fu_igsc_fwu_heci_start_res_to_string(const FuIgscFwuHeciStartRes *st)
{
    g_autoptr(GString) str = g_string_new("FuIgscFwuHeciStartRes:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_igsc_fwu_heci_status_to_string(fu_igsc_fwu_heci_start_res_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_igsc_fwu_heci_start_res_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_igsc_fwu_heci_start_res_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_igsc_fwu_heci_start_res_validate_internal(FuIgscFwuHeciStartRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_igsc_fwu_heci_start_res_get_command_id(st) != FU_IGSC_FWU_HECI_COMMAND_ID_START) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciStartRes.command_id was not valid");
        return FALSE;
    }
    if (fu_igsc_fwu_heci_start_res_get_hdr_flags(st) != FU_IGSC_FWU_HECI_HDR_FLAG_IS_RESPONSE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuIgscFwuHeciStartRes.hdr_flags was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_igsc_fwu_heci_start_res_parse_internal(FuIgscFwuHeciStartRes *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_igsc_fwu_heci_start_res_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_igsc_fwu_heci_start_res_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_igsc_fwu_heci_start_res_parse: (skip):
 **/
FuIgscFwuHeciStartRes *
fu_igsc_fwu_heci_start_res_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error_literal(error, "invalid struct FuIgscFwuHeciStartRes: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 12);
    if (!fu_igsc_fwu_heci_start_res_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_igsc_fwu_heci_no_update_req_set_command_id: (skip):
 **/
static void
fu_igsc_fwu_heci_no_update_req_set_command_id(FuIgscFwuHeciNoUpdateReq *st, FuIgscFwuHeciCommandId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_igsc_fwu_heci_no_update_req_set_hdr_flags: (skip):
 **/
static void
fu_igsc_fwu_heci_no_update_req_set_hdr_flags(FuIgscFwuHeciNoUpdateReq *st, FuIgscFwuHeciHdrFlags value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_igsc_fwu_heci_no_update_req_new: (skip):
 **/
FuIgscFwuHeciNoUpdateReq *
fu_igsc_fwu_heci_no_update_req_new(void)
{
    FuIgscFwuHeciNoUpdateReq *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    fu_igsc_fwu_heci_no_update_req_set_command_id(st, FU_IGSC_FWU_HECI_COMMAND_ID_NO_UPDATE);
    fu_igsc_fwu_heci_no_update_req_set_hdr_flags(st, FU_IGSC_FWU_HECI_HDR_FLAG_NONE);
    return st;
}
/* getters */
/**
 * fu_struct_igsc_fwdata_version_get_oem_manuf_data_version: (skip):
 **/
guint32
fu_struct_igsc_fwdata_version_get_oem_manuf_data_version(const FuStructIgscFwdataVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwdata_version_get_major_version: (skip):
 **/
guint16
fu_struct_igsc_fwdata_version_get_major_version(const FuStructIgscFwdataVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwdata_version_get_major_vcn: (skip):
 **/
guint16
fu_struct_igsc_fwdata_version_get_major_vcn(const FuStructIgscFwdataVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_igsc_fwdata_version_get_key_index: (skip):
 **/
guint8
fu_struct_igsc_fwdata_version_get_key_index(const FuStructIgscFwdataVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_igsc_fwdata_version_get_data_arb_svn: (skip):
 **/
guint32
fu_struct_igsc_fwdata_version_get_data_arb_svn(const FuStructIgscFwdataVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_igsc_fwdata_version_to_string: (skip):
 **/
static gchar *
fu_struct_igsc_fwdata_version_to_string(const FuStructIgscFwdataVersion *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIgscFwdataVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  oem_manuf_data_version: 0x%x\n",
                           (guint) fu_struct_igsc_fwdata_version_get_oem_manuf_data_version(st));
    g_string_append_printf(str, "  major_version: 0x%x\n",
                           (guint) fu_struct_igsc_fwdata_version_get_major_version(st));
    g_string_append_printf(str, "  major_vcn: 0x%x\n",
                           (guint) fu_struct_igsc_fwdata_version_get_major_vcn(st));
    g_string_append_printf(str, "  key_index: 0x%x\n",
                           (guint) fu_struct_igsc_fwdata_version_get_key_index(st));
    g_string_append_printf(str, "  data_arb_svn: 0x%x\n",
                           (guint) fu_struct_igsc_fwdata_version_get_data_arb_svn(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_igsc_fwdata_version_validate_internal(FuStructIgscFwdataVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_igsc_fwdata_version_parse_internal(FuStructIgscFwdataVersion *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_igsc_fwdata_version_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_igsc_fwdata_version_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_igsc_fwdata_version_parse_stream: (skip):
 **/
FuStructIgscFwdataVersion *
fu_struct_igsc_fwdata_version_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIgscFwdataVersion failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIgscFwdataVersion requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_igsc_fwdata_version_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
