/* auto-generated, do not modify */
#include "config.h"

#include "fu-acpi-table-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_acpi_table_get_signature: (skip):
 **/
gchar *
fu_struct_acpi_table_get_signature(const FuStructAcpiTable *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 4, NULL);
}
/**
 * fu_struct_acpi_table_get_length: (skip):
 **/
guint32
fu_struct_acpi_table_get_length(const FuStructAcpiTable *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_table_get_revision: (skip):
 **/
guint8
fu_struct_acpi_table_get_revision(const FuStructAcpiTable *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_acpi_table_get_checksum: (skip):
 **/
guint8
fu_struct_acpi_table_get_checksum(const FuStructAcpiTable *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_acpi_table_get_oem_id: (skip):
 **/
gchar *
fu_struct_acpi_table_get_oem_id(const FuStructAcpiTable *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 10, 6, NULL);
}
/**
 * fu_struct_acpi_table_get_oem_table_id: (skip):
 **/
gchar *
fu_struct_acpi_table_get_oem_table_id(const FuStructAcpiTable *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 16, 8, NULL);
}
/**
 * fu_struct_acpi_table_get_oem_revision: (skip):
 **/
guint32
fu_struct_acpi_table_get_oem_revision(const FuStructAcpiTable *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_acpi_table_set_signature: (skip):
 **/
gboolean
fu_struct_acpi_table_set_signature(FuStructAcpiTable *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAcpiTable.signature (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_acpi_table_set_length: (skip):
 **/
void
fu_struct_acpi_table_set_length(FuStructAcpiTable *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_table_set_revision: (skip):
 **/
void
fu_struct_acpi_table_set_revision(FuStructAcpiTable *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[8] = value;
}
/**
 * fu_struct_acpi_table_set_checksum: (skip):
 **/
void
fu_struct_acpi_table_set_checksum(FuStructAcpiTable *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[9] = value;
}
/**
 * fu_struct_acpi_table_set_oem_id: (skip):
 **/
gboolean
fu_struct_acpi_table_set_oem_id(FuStructAcpiTable *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 10, 0x0, 6);
        return TRUE;
    }
    len = strlen(value);
    if (len > 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAcpiTable.oem_id (0x%x bytes)",
                    value, (guint) len, (guint) 6);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 10, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_acpi_table_set_oem_table_id: (skip):
 **/
gboolean
fu_struct_acpi_table_set_oem_table_id(FuStructAcpiTable *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 16, 0x0, 8);
        return TRUE;
    }
    len = strlen(value);
    if (len > 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAcpiTable.oem_table_id (0x%x bytes)",
                    value, (guint) len, (guint) 8);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 16, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_acpi_table_set_oem_revision: (skip):
 **/
void
fu_struct_acpi_table_set_oem_revision(FuStructAcpiTable *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 24, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_acpi_table_new: (skip):
 **/
FuStructAcpiTable *
fu_struct_acpi_table_new(void)
{
    FuStructAcpiTable *st = g_byte_array_sized_new(36);
    fu_byte_array_set_size(st, 36, 0x0);
    return st;
}
/**
 * fu_struct_acpi_table_to_string: (skip):
 **/
static gchar *
fu_struct_acpi_table_to_string(const FuStructAcpiTable *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAcpiTable:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_acpi_table_get_signature(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  signature: %s\n", tmp);
    }
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_acpi_table_get_length(st));
    g_string_append_printf(str, "  revision: 0x%x\n",
                           (guint) fu_struct_acpi_table_get_revision(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_acpi_table_get_checksum(st));
    {
        g_autofree gchar *tmp = fu_struct_acpi_table_get_oem_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  oem_id: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fu_struct_acpi_table_get_oem_table_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  oem_table_id: %s\n", tmp);
    }
    g_string_append_printf(str, "  oem_revision: 0x%x\n",
                           (guint) fu_struct_acpi_table_get_oem_revision(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_acpi_table_validate_internal(FuStructAcpiTable *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_acpi_table_parse_internal(FuStructAcpiTable *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_acpi_table_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_acpi_table_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_acpi_table_parse_stream: (skip):
 **/
FuStructAcpiTable *
fu_struct_acpi_table_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 36, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructAcpiTable failed read of 0x%x: ", (guint) 36);
        return NULL;
    }
    if (st->len != 36) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAcpiTable requested 0x%x and got 0x%x",
                    (guint) 36,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_acpi_table_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
