/* THIS FILE IS AUTOGENERATED FROM HTMLFormElement.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "ElementBinding.h"
#include "HTMLElementBinding.h"
#include "HTMLFormElementBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CustomElementRegistry.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/DocGroup.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/HTMLFormControlsCollection.h"
#include "mozilla/dom/HTMLFormElement.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsDOMTokenList.h"
#include "nsGenericHTMLElement.h"
#include "nsISupports.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace HTMLFormElement_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<HTMLElement_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_acceptCharset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "acceptCharset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAcceptCharset(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAcceptCharset(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_acceptCharset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "acceptCharset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetAcceptCharset(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetAcceptCharset(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.acceptCharset setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo acceptCharset_getterinfo = {
  { get_acceptCharset },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo acceptCharset_setterinfo = {
  { (JSJitGetterOp)set_acceptCharset },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_action(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "action", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAction(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAction(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_action(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "action", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetAction(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetAction(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.action setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo action_getterinfo = {
  { get_action },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo action_setterinfo = {
  { (JSJitGetterOp)set_action },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_autocomplete(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "autocomplete", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAutocomplete(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAutocomplete(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_autocomplete(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "autocomplete", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetAutocomplete(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetAutocomplete(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.autocomplete setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo autocomplete_getterinfo = {
  { get_autocomplete },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo autocomplete_setterinfo = {
  { (JSJitGetterOp)set_autocomplete },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_enctype(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "enctype", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetEnctype(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetEnctype(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_enctype(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "enctype", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetEnctype(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetEnctype(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.enctype setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo enctype_getterinfo = {
  { get_enctype },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo enctype_setterinfo = {
  { (JSJitGetterOp)set_enctype },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_encoding(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "encoding", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetEncoding(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetEncoding(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_encoding(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "encoding", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetEncoding(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetEncoding(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.encoding setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo encoding_getterinfo = {
  { get_encoding },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo encoding_setterinfo = {
  { (JSJitGetterOp)set_encoding },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_method(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "method", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetMethod(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetMethod(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_method(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "method", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetMethod(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetMethod(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.method setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo method_getterinfo = {
  { get_method },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo method_setterinfo = {
  { (JSJitGetterOp)set_method },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_name(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "name", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetName(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetName(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_name(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "name", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetName(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetName(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.name setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo name_getterinfo = {
  { get_name },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo name_setterinfo = {
  { (JSJitGetterOp)set_name },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_noValidate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "noValidate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  bool result(MOZ_KnownLive(self)->NoValidate());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_noValidate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "noValidate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetNoValidate(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetNoValidate(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.noValidate setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo noValidate_getterinfo = {
  { get_noValidate },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo noValidate_setterinfo = {
  { (JSJitGetterOp)set_noValidate },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_target(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "target", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetTarget(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetTarget(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_target(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "target", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTarget(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetTarget(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.target setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo target_getterinfo = {
  { get_target },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo target_setterinfo = {
  { (JSJitGetterOp)set_target },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_rel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "rel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetRel(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetRel(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_rel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "rel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetRel(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetRel(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.rel setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo rel_getterinfo = {
  { get_rel },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo rel_setterinfo = {
  { (JSJitGetterOp)set_rel },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_relList(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "relList", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  auto result(StrongOrRawPtr<nsDOMTokenList>(MOZ_KnownLive(self)->RelList()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_relList(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "HTMLFormElement.relList setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "relList", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::Rooted<JS::Value> v(cx);
  if (!JS_GetProperty(cx, obj, "relList", &v)) {
    return false;
  }

  if (!v.isObject()) {
    return cx.ThrowErrorMessage<MSG_NOT_OBJECT>("HTMLFormElement.relList");
  }

  JS::Rooted<JSObject*> targetObj(cx, &v.toObject());
  return JS_SetProperty(cx, targetObj, "value", args[0]);
}

static const JSJitInfo relList_getterinfo = {
  { get_relList },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo relList_setterinfo = {
  { (JSJitGetterOp)set_relList },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_elements(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "elements", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::HTMLFormControlsCollection>(MOZ_KnownLive(self)->Elements()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo elements_getterinfo = {
  { get_elements },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasNone, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_length(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "length", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  int32_t result(MOZ_KnownLive(self)->Length());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setInt32(int32_t(result));
  return true;
}

static const JSJitInfo length_getterinfo = {
  { get_length },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_INT32,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
submit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "submit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Submit(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Submit(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.submit"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo submit_methodinfo = {
  { (JSJitGetterOp)submit },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
requestSubmit(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "HTMLFormElement.requestSubmit");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "requestSubmit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  nsGenericHTMLElement* arg0;
  if (args.hasDefined(0)) {
    if (args[0].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::HTMLElement, nsGenericHTMLElement>(args[0], arg0, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "HTMLElement");
          return false;
        }
      }
    } else if (args[0].isNullOrUndefined()) {
      arg0 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
      return false;
    }
  } else {
    arg0 = nullptr;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RequestSubmit(MOZ_KnownLive(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->RequestSubmit(MOZ_KnownLive(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "HTMLFormElement.requestSubmit"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo requestSubmit_methodinfo = {
  { (JSJitGetterOp)requestSubmit },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
reset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "reset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Reset())>, "Should be returning void here");
  MOZ_KnownLive(self)->Reset();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo reset_methodinfo = {
  { (JSJitGetterOp)reset },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
checkValidity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "checkValidity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  bool result(MOZ_KnownLive(self)->CheckValidity());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo checkValidity_methodinfo = {
  { (JSJitGetterOp)checkValidity },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
reportValidity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "reportValidity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::HTMLFormElement*>(void_self);
  bool result(MOZ_KnownLive(self)->ReportValidity());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo reportValidity_methodinfo = {
  { (JSJitGetterOp)reportValidity },
  { prototypes::id::HTMLFormElement },
  { PrototypeTraits<prototypes::id::HTMLFormElement>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("submit", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&submit_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("requestSubmit", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&requestSubmit_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("reset", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&reset_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("checkValidity", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&checkValidity_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("reportValidity", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&reportValidity_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_SYM_FNSPEC(iterator, nullptr, nullptr, 0, 0, "$ArrayValues"),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(6 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("acceptCharset", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &acceptCharset_getterinfo, GenericSetter<NormalThisPolicy>, &acceptCharset_setterinfo),
  JSPropertySpec::nativeAccessors("action", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &action_getterinfo, GenericSetter<NormalThisPolicy>, &action_setterinfo),
  JSPropertySpec::nativeAccessors("autocomplete", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &autocomplete_getterinfo, GenericSetter<NormalThisPolicy>, &autocomplete_setterinfo),
  JSPropertySpec::nativeAccessors("enctype", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &enctype_getterinfo, GenericSetter<NormalThisPolicy>, &enctype_setterinfo),
  JSPropertySpec::nativeAccessors("encoding", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &encoding_getterinfo, GenericSetter<NormalThisPolicy>, &encoding_setterinfo),
  JSPropertySpec::nativeAccessors("method", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &method_getterinfo, GenericSetter<NormalThisPolicy>, &method_setterinfo),
  JSPropertySpec::nativeAccessors("name", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &name_getterinfo, GenericSetter<NormalThisPolicy>, &name_setterinfo),
  JSPropertySpec::nativeAccessors("noValidate", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &noValidate_getterinfo, GenericSetter<NormalThisPolicy>, &noValidate_setterinfo),
  JSPropertySpec::nativeAccessors("target", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &target_getterinfo, GenericSetter<NormalThisPolicy>, &target_setterinfo),
  JSPropertySpec::nativeAccessors("rel", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &rel_getterinfo, GenericSetter<NormalThisPolicy>, &rel_setterinfo),
  JSPropertySpec::nativeAccessors("relList", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &relList_getterinfo, GenericSetter<NormalThisPolicy>, &relList_setterinfo),
  JSPropertySpec::nativeAccessors("elements", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &elements_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("length", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &length_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(13 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[19];
static PropertyInfo sNativeProperties_propertyInfos[19];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  19,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[6] }
  }
};
static_assert(19 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static_assert(std::is_base_of_v<nsISupports, mozilla::dom::HTMLFormElement>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public ShadowingDOMProxyHandler
{
public:
  using Base = ShadowingDOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  void
  trace(JSTracer* trc, JSObject* proxy) const override;

  bool
  getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::dom::HTMLFormElement*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::dom::HTMLFormElement*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &Element_Binding::ReflectedHTMLAttributeSlots::sXrayExpandoObjectClassOps);

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::HTMLFormElement,
  constructors::id::HTMLFormElement,
  &sXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "HTMLFormElement", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  return HTMLConstructor(cx, argc, vp,
                         constructors::id::HTMLFormElement,
                         prototypes::id::HTMLFormElement,
                         CreateInterfaceObjects);
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  HTMLElement_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::HTMLFormElement>::Depth,
  prototypes::id::HTMLFormElement,
  true,
  0,
  "HTMLFormElement",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "HTMLFormElementPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::HTMLFormElement,
  PrototypeTraits<prototypes::id::HTMLFormElement>::Depth,
  &sNativePropertyHooks,
  HTMLElement_Binding::GetProtoObject
};

bool
InterfaceHasProperty(const nsAString& name)
{
  switch (name.Length()) {
    case 2: {
      if (name == u"id"_ns) {
        return true;
      }
      break;
    }
    case 3: {
      switch (name[0]) {
        case 'd': {
          if (name == u"dir"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"rel"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 4: {
      switch (name[0]) {
        case 'b': {
          if (name == u"blur"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"lang"_ns) {
            return true;
          }
          break;
        }
        case 'n': {
          if (name == u"name"_ns) {
            return true;
          }
          break;
        }
        case 'p': {
          if (name == u"part"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"role"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"slot"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 5: {
      switch (name[0]) {
        case 'a': {
          if (name == u"after"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"click"_ns) {
            return true;
          }
          break;
        }
        case 'f': {
          if (name == u"focus"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"inert"_ns) {
            return true;
          }
          break;
        }
        case 'n': {
          if (name == u"nonce"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          if (name == u"oncut"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"reset"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"style"_ns) {
            return true;
          }
          break;
        }
        case 't': {
          if (name == u"title"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 6: {
      switch (name[0]) {
        case 'a': {
          switch (name[1]) {
            case 'c': {
              if (name == u"action"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"append"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'b': {
          if (name == u"before"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hidden"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"length"_ns) {
            return true;
          }
          break;
        }
        case 'm': {
          if (name == u"method"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'b': {
              if (name == u"onblur"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              if (name == u"oncopy"_ns) {
                return true;
              }
              break;
            }
            case 'd': {
              switch (name[4]) {
                case 'a': {
                  if (name == u"ondrag"_ns) {
                    return true;
                  }
                  break;
                }
                case 'o': {
                  if (name == u"ondrop"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'l': {
              if (name == u"onload"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"onplay"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"prefix"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"remove"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          switch (name[1]) {
            case 'c': {
              if (name == u"scroll"_ns) {
                return true;
              }
              break;
            }
            case 'u': {
              if (name == u"submit"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 't': {
          if (name == u"target"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 7: {
      switch (name[0]) {
        case 'a': {
          if (name == u"animate"_ns) {
            return true;
          }
          break;
        }
        case 'b': {
          if (name == u"baseURI"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"closest"_ns) {
            return true;
          }
          break;
        }
        case 'd': {
          if (name == u"dataset"_ns) {
            return true;
          }
          break;
        }
        case 'e': {
          if (name == u"enctype"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getHTML"_ns) {
            return true;
          }
          break;
        }
        case 'm': {
          if (name == u"matches"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onabort"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              switch (name[4]) {
                case 'i': {
                  if (name == u"onclick"_ns) {
                    return true;
                  }
                  break;
                }
                case 'o': {
                  if (name == u"onclose"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'e': {
              switch (name[3]) {
                case 'n': {
                  if (name == u"onended"_ns) {
                    return true;
                  }
                  break;
                }
                case 'r': {
                  if (name == u"onerror"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'f': {
              if (name == u"onfocus"_ns) {
                return true;
              }
              break;
            }
            case 'i': {
              if (name == u"oninput"_ns) {
                return true;
              }
              break;
            }
            case 'k': {
              if (name == u"onkeyup"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              switch (name[4]) {
                case 's': {
                  if (name == u"onpaste"_ns) {
                    return true;
                  }
                  break;
                }
                case 'u': {
                  if (name == u"onpause"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'r': {
              if (name == u"onreset"_ns) {
                return true;
              }
              break;
            }
            case 'w': {
              if (name == u"onwheel"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          switch (name[1]) {
            case 'o': {
              if (name == u"popover"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"prepend"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"relList"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"setHTML"_ns) {
            return true;
          }
          break;
        }
        case 't': {
          if (name == u"tagName"_ns) {
            return true;
          }
          break;
        }
        case 'v': {
          if (name == u"valueOf"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 8: {
      switch (name[0]) {
        case 'a': {
          switch (name[4]) {
            case 'B': {
              if (name == u"ariaBusy"_ns) {
                return true;
              }
              break;
            }
            case 'L': {
              if (name == u"ariaLive"_ns) {
                return true;
              }
              break;
            }
            case 'S': {
              if (name == u"ariaSort"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'h': {
              if (name == u"children"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"contains"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'e': {
          switch (name[1]) {
            case 'l': {
              if (name == u"elements"_ns) {
                return true;
              }
              break;
            }
            case 'n': {
              if (name == u"encoding"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'n': {
          switch (name[4]) {
            case 'N': {
              if (name == u"nodeName"_ns) {
                return true;
              }
              break;
            }
            case 'T': {
              if (name == u"nodeType"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'c': {
              switch (name[3]) {
                case 'a': {
                  if (name == u"oncancel"_ns) {
                    return true;
                  }
                  break;
                }
                case 'h': {
                  if (name == u"onchange"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'r': {
              if (name == u"onresize"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              switch (name[3]) {
                case 'c': {
                  if (name == u"onscroll"_ns) {
                    return true;
                  }
                  break;
                }
                case 'e': {
                  switch (name[4]) {
                    case 'e': {
                      if (name == u"onseeked"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'l': {
                      if (name == u"onselect"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'u': {
                  if (name == u"onsubmit"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 't': {
              if (name == u"ontoggle"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 's': {
          switch (name[6]) {
            case 'B': {
              if (name == u"scrollBy"_ns) {
                return true;
              }
              break;
            }
            case 'T': {
              if (name == u"scrollTo"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 't': {
          switch (name[1]) {
            case 'a': {
              if (name == u"tabIndex"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"toString"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
      }
      break;
    }
    case 9: {
      switch (name[0]) {
        case 'T': {
          if (name == u"TEXT_NODE"_ns) {
            return true;
          }
          break;
        }
        case '_': {
          if (name == u"__proto__"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          switch (name[1]) {
            case 'c': {
              if (name == u"accessKey"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              switch (name[4]) {
                case 'L': {
                  switch (name[5]) {
                    case 'a': {
                      if (name == u"ariaLabel"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'e': {
                      if (name == u"ariaLevel"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'M': {
                  if (name == u"ariaModal"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'u': {
              if (name == u"autofocus"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[2]) {
            case 'a': {
              switch (name[5]) {
                case 'L': {
                  if (name == u"classList"_ns) {
                    return true;
                  }
                  break;
                }
                case 'N': {
                  if (name == u"className"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'i': {
              if (name == u"clientTop"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"cloneNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'd': {
          if (name == u"draggable"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          switch (name[2]) {
            case 'n': {
              switch (name[5]) {
                case 'H': {
                  if (name == u"innerHTML"_ns) {
                    return true;
                  }
                  break;
                }
                case 'T': {
                  if (name == u"innerText"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'p': {
              if (name == u"inputMode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'l': {
          switch (name[1]) {
            case 'a': {
              if (name == u"lastChild"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"localName"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'n': {
          switch (name[2]) {
            case 'd': {
              if (name == u"nodeValue"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              if (name == u"normalize"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[1]) {
            case 'f': {
              if (name == u"offsetTop"_ns) {
                return true;
              }
              break;
            }
            case 'n': {
              switch (name[2]) {
                case 'c': {
                  switch (name[3]) {
                    case 'a': {
                      if (name == u"oncanplay"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'o': {
                      if (name == u"oncommand"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'd': {
                  if (name == u"ondragend"_ns) {
                    return true;
                  }
                  break;
                }
                case 'e': {
                  if (name == u"onemptied"_ns) {
                    return true;
                  }
                  break;
                }
                case 'i': {
                  if (name == u"oninvalid"_ns) {
                    return true;
                  }
                  break;
                }
                case 'k': {
                  if (name == u"onkeydown"_ns) {
                    return true;
                  }
                  break;
                }
                case 'm': {
                  if (name == u"onmouseup"_ns) {
                    return true;
                  }
                  break;
                }
                case 'p': {
                  if (name == u"onplaying"_ns) {
                    return true;
                  }
                  break;
                }
                case 's': {
                  switch (name[3]) {
                    case 'e': {
                      if (name == u"onseeking"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 't': {
                      if (name == u"onstalled"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'u': {
                      if (name == u"onsuspend"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'w': {
                  if (name == u"onwaiting"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'u': {
              switch (name[5]) {
                case 'H': {
                  if (name == u"outerHTML"_ns) {
                    return true;
                  }
                  break;
                }
                case 'T': {
                  if (name == u"outerText"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 's': {
          if (name == u"scrollTop"_ns) {
            return true;
          }
          break;
        }
        case 't': {
          if (name == u"translate"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 10: {
      switch (name[0]) {
        case 'a': {
          switch (name[1]) {
            case 'r': {
              switch (name[4]) {
                case 'A': {
                  if (name == u"ariaAtomic"_ns) {
                    return true;
                  }
                  break;
                }
                case 'H': {
                  if (name == u"ariaHidden"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 't': {
              if (name == u"attributes"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'h': {
              if (name == u"childNodes"_ns) {
                return true;
              }
              break;
            }
            case 'l': {
              if (name == u"clientLeft"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'f': {
          if (name == u"firstChild"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"isSameNode"_ns) {
            return true;
          }
          break;
        }
        case 'm': {
          if (name == u"moveBefore"_ns) {
            return true;
          }
          break;
        }
        case 'n': {
          if (name == u"noValidate"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[1]) {
            case 'f': {
              if (name == u"offsetLeft"_ns) {
                return true;
              }
              break;
            }
            case 'n': {
              switch (name[2]) {
                case 'a': {
                  if (name == u"onauxclick"_ns) {
                    return true;
                  }
                  break;
                }
                case 'd': {
                  switch (name[3]) {
                    case 'b': {
                      if (name == u"ondblclick"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'r': {
                      switch (name[6]) {
                        case 'e': {
                          if (name == u"ondragexit"_ns) {
                            return true;
                          }
                          break;
                        }
                        case 'o': {
                          if (name == u"ondragover"_ns) {
                            return true;
                          }
                          break;
                        }
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'f': {
                  if (name == u"onformdata"_ns) {
                    return true;
                  }
                  break;
                }
                case 'k': {
                  if (name == u"onkeypress"_ns) {
                    return true;
                  }
                  break;
                }
                case 'm': {
                  if (name == u"onmouseout"_ns) {
                    return true;
                  }
                  break;
                }
                case 'p': {
                  if (name == u"onprogress"_ns) {
                    return true;
                  }
                  break;
                }
                case 't': {
                  if (name == u"ontouchend"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"parentNode"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          switch (name[1]) {
            case 'c': {
              if (name == u"scrollLeft"_ns) {
                return true;
              }
              break;
            }
            case 'e': {
              if (name == u"setCapture"_ns) {
                return true;
              }
              break;
            }
            case 'h': {
              if (name == u"shadowRoot"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"spellcheck"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
      }
      break;
    }
    case 11: {
      switch (name[0]) {
        case 'E': {
          if (name == u"ENTITY_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          switch (name[1]) {
            case 'p': {
              if (name == u"appendChild"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              switch (name[4]) {
                case 'C': {
                  switch (name[5]) {
                    case 'h': {
                      if (name == u"ariaChecked"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'o': {
                      if (name == u"ariaColSpan"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'u': {
                      if (name == u"ariaCurrent"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'I': {
                  if (name == u"ariaInvalid"_ns) {
                    return true;
                  }
                  break;
                }
                case 'P': {
                  if (name == u"ariaPressed"_ns) {
                    return true;
                  }
                  break;
                }
                case 'R': {
                  if (name == u"ariaRowSpan"_ns) {
                    return true;
                  }
                  break;
                }
                case 'S': {
                  if (name == u"ariaSetSize"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'u': {
              if (name == u"autocorrect"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'l': {
              if (name == u"clientWidth"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"constructor"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'g': {
          switch (name[3]) {
            case 'B': {
              if (name == u"getBoxQuads"_ns) {
                return true;
              }
              break;
            }
            case 'R': {
              if (name == u"getRootNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'h': {
          if (name == u"hidePopover"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          switch (name[2]) {
            case 'C': {
              if (name == u"isConnected"_ns) {
                return true;
              }
              break;
            }
            case 'E': {
              if (name == u"isEqualNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'n': {
          if (name == u"nextSibling"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[1]) {
            case 'f': {
              if (name == u"offsetWidth"_ns) {
                return true;
              }
              break;
            }
            case 'n': {
              switch (name[2]) {
                case 'c': {
                  if (name == u"oncuechange"_ns) {
                    return true;
                  }
                  break;
                }
                case 'd': {
                  switch (name[6]) {
                    case 'e': {
                      if (name == u"ondragenter"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'l': {
                      if (name == u"ondragleave"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 's': {
                      if (name == u"ondragstart"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'l': {
                  if (name == u"onloadstart"_ns) {
                    return true;
                  }
                  break;
                }
                case 'm': {
                  switch (name[7]) {
                    case 'd': {
                      if (name == u"onmousedown"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'm': {
                      if (name == u"onmousemove"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'o': {
                      if (name == u"onmouseover"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'p': {
                  if (name == u"onpointerup"_ns) {
                    return true;
                  }
                  break;
                }
                case 's': {
                  if (name == u"onscrollend"_ns) {
                    return true;
                  }
                  break;
                }
                case 't': {
                  if (name == u"ontouchmove"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          switch (name[2]) {
            case 'm': {
              if (name == u"removeChild"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"replaceWith"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 's': {
          switch (name[1]) {
            case 'c': {
              if (name == u"scrollWidth"_ns) {
                return true;
              }
              break;
            }
            case 'h': {
              if (name == u"showPopover"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 't': {
          if (name == u"textContent"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 12: {
      switch (name[0]) {
        case 'C': {
          if (name == u"COMMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'E': {
          if (name == u"ELEMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          switch (name[1]) {
            case 'r': {
              switch (name[4]) {
                case 'C': {
                  switch (name[7]) {
                    case 'C': {
                      if (name == u"ariaColCount"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'I': {
                      if (name == u"ariaColIndex"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'D': {
                  if (name == u"ariaDisabled"_ns) {
                    return true;
                  }
                  break;
                }
                case 'E': {
                  if (name == u"ariaExpanded"_ns) {
                    return true;
                  }
                  break;
                }
                case 'H': {
                  if (name == u"ariaHasPopup"_ns) {
                    return true;
                  }
                  break;
                }
                case 'P': {
                  if (name == u"ariaPosInSet"_ns) {
                    return true;
                  }
                  break;
                }
                case 'R': {
                  switch (name[5]) {
                    case 'e': {
                      switch (name[6]) {
                        case 'a': {
                          if (name == u"ariaReadOnly"_ns) {
                            return true;
                          }
                          break;
                        }
                        case 'l': {
                          if (name == u"ariaRelevant"_ns) {
                            return true;
                          }
                          break;
                        }
                        case 'q': {
                          if (name == u"ariaRequired"_ns) {
                            return true;
                          }
                          break;
                        }
                      }
                      break;
                    }
                    case 'o': {
                      switch (name[7]) {
                        case 'C': {
                          if (name == u"ariaRowCount"_ns) {
                            return true;
                          }
                          break;
                        }
                        case 'I': {
                          if (name == u"ariaRowIndex"_ns) {
                            return true;
                          }
                          break;
                        }
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'S': {
                  if (name == u"ariaSelected"_ns) {
                    return true;
                  }
                  break;
                }
                case 'V': {
                  switch (name[9]) {
                    case 'M': {
                      switch (name[10]) {
                        case 'a': {
                          if (name == u"ariaValueMax"_ns) {
                            return true;
                          }
                          break;
                        }
                        case 'i': {
                          if (name == u"ariaValueMin"_ns) {
                            return true;
                          }
                          break;
                        }
                      }
                      break;
                    }
                    case 'N': {
                      if (name == u"ariaValueNow"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
              }
              break;
            }
            case 's': {
              if (name == u"assignedSlot"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              if (name == u"attachShadow"_ns) {
                return true;
              }
              break;
            }
            case 'u': {
              if (name == u"autocomplete"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          if (name == u"clientHeight"_ns) {
            return true;
          }
          break;
        }
        case 'e': {
          if (name == u"enterKeyHint"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getAttribute"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hasAttribute"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"insertBefore"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"lookupPrefix"_ns) {
            return true;
          }
          break;
        }
        case 'n': {
          if (name == u"namespaceURI"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[1]) {
            case 'f': {
              switch (name[6]) {
                case 'H': {
                  if (name == u"offsetHeight"_ns) {
                    return true;
                  }
                  break;
                }
                case 'P': {
                  if (name == u"offsetParent"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'n': {
              switch (name[2]) {
                case 'l': {
                  if (name == u"onloadeddata"_ns) {
                    return true;
                  }
                  break;
                }
                case 'm': {
                  switch (name[7]) {
                    case 'e': {
                      if (name == u"onmouseenter"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'l': {
                      if (name == u"onmouseleave"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'p': {
                  if (name == u"onpointerout"_ns) {
                    return true;
                  }
                  break;
                }
                case 'r': {
                  if (name == u"onratechange"_ns) {
                    return true;
                  }
                  break;
                }
                case 's': {
                  if (name == u"onslotchange"_ns) {
                    return true;
                  }
                  break;
                }
                case 't': {
                  switch (name[3]) {
                    case 'i': {
                      if (name == u"ontimeupdate"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'o': {
                      if (name == u"ontouchstart"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"replaceChild"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          switch (name[1]) {
            case 'c': {
              switch (name[6]) {
                case 'H': {
                  if (name == u"scrollHeight"_ns) {
                    return true;
                  }
                  break;
                }
                case 'T': {
                  if (name == u"scrollTopMax"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'e': {
              if (name == u"setAttribute"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
      }
      break;
    }
    case 13: {
      switch (name[0]) {
        case 'D': {
          if (name == u"DOCUMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'N': {
          if (name == u"NOTATION_NODE"_ns) {
            return true;
          }
          break;
        }
        case '_': {
          if (name == u"__namedgetter"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          switch (name[1]) {
            case 'c': {
              if (name == u"acceptCharset"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              switch (name[4]) {
                case 'M': {
                  if (name == u"ariaMultiLine"_ns) {
                    return true;
                  }
                  break;
                }
                case 'V': {
                  if (name == u"ariaValueText"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          if (name == u"checkValidity"_ns) {
            return true;
          }
          break;
        }
        case 'd': {
          if (name == u"dispatchEvent"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getAnimations"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          switch (name[3]) {
            case 'A': {
              if (name == u"hasAttributes"_ns) {
                return true;
              }
              break;
            }
            case 'C': {
              if (name == u"hasChildNodes"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'i': {
          if (name == u"isPrototypeOf"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[1]) {
            case 'n': {
              switch (name[2]) {
                case 'b': {
                  switch (name[8]) {
                    case 'i': {
                      if (name == u"onbeforeinput"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'm': {
                      if (name == u"onbeforematch"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'c': {
                  switch (name[9]) {
                    case 'l': {
                      if (name == u"oncontextlost"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'm': {
                      if (name == u"oncontextmenu"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 'p': {
                  switch (name[9]) {
                    case 'd': {
                      if (name == u"onpointerdown"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'm': {
                      if (name == u"onpointermove"_ns) {
                        return true;
                      }
                      break;
                    }
                    case 'o': {
                      if (name == u"onpointerover"_ns) {
                        return true;
                      }
                      break;
                    }
                  }
                  break;
                }
                case 's': {
                  if (name == u"onselectstart"_ns) {
                    return true;
                  }
                  break;
                }
                case 't': {
                  if (name == u"ontouchcancel"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'w': {
              if (name == u"ownerDocument"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"parentElement"_ns) {
            return true;
          }
          break;
        }
        case 'q': {
          if (name == u"querySelector"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          if (name == u"requestSubmit"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          switch (name[1]) {
            case 'c': {
              if (name == u"scrollLeftMax"_ns) {
                return true;
              }
              break;
            }
            case 'e': {
              if (name == u"setHTMLUnsafe"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 't': {
          if (name == u"togglePopover"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 14: {
      switch (name[0]) {
        case 'A': {
          if (name == u"ATTRIBUTE_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          switch (name[1]) {
            case 'c': {
              switch (name[6]) {
                case 'K': {
                  if (name == u"accessKeyLabel"_ns) {
                    return true;
                  }
                  break;
                }
                case 'i': {
                  if (name == u"accessibleNode"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'u': {
              if (name == u"autocapitalize"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          if (name == u"currentCSSZoom"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          switch (name[3]) {
            case 'A': {
              if (name == u"getAttributeNS"_ns) {
                return true;
              }
              break;
            }
            case 'C': {
              if (name == u"getClientRects"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'h': {
          switch (name[3]) {
            case 'A': {
              if (name == u"hasAttributeNS"_ns) {
                return true;
              }
              break;
            }
            case 'O': {
              if (name == u"hasOwnProperty"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationend"_ns) {
                return true;
              }
              break;
            }
            case 'b': {
              if (name == u"onbeforetoggle"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              switch (name[9]) {
                case 'e': {
                  if (name == u"onpointerenter"_ns) {
                    return true;
                  }
                  break;
                }
                case 'l': {
                  if (name == u"onpointerleave"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'v': {
              if (name == u"onvolumechange"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          switch (name[2]) {
            case 'l': {
              if (name == u"releaseCapture"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"reportValidity"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 's': {
          switch (name[1]) {
            case 'c': {
              if (name == u"scrollIntoView"_ns) {
                return true;
              }
              break;
            }
            case 'e': {
              if (name == u"setAttributeNS"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 't': {
          if (name == u"toLocaleString"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 15: {
      switch (name[0]) {
        case '_': {
          if (name == u"__indexedgetter"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          switch (name[1]) {
            case 'r': {
              switch (name[4]) {
                case 'D': {
                  if (name == u"ariaDescription"_ns) {
                    return true;
                  }
                  break;
                }
                case 'O': {
                  if (name == u"ariaOrientation"_ns) {
                    return true;
                  }
                  break;
                }
                case 'P': {
                  if (name == u"ariaPlaceholder"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 't': {
              if (name == u"attachInternals"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[1]) {
            case 'h': {
              if (name == u"checkVisibility"_ns) {
                return true;
              }
              break;
            }
            case 'o': {
              if (name == u"contentEditable"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'p': {
              if (name == u"onpointercancel"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              switch (name[12]) {
                case 'e': {
                  if (name == u"ontransitionend"_ns) {
                    return true;
                  }
                  break;
                }
                case 'r': {
                  if (name == u"ontransitionrun"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"previousSibling"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          switch (name[2]) {
            case 'm': {
              if (name == u"removeAttribute"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"replaceChildren"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 't': {
          if (name == u"toggleAttribute"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 16: {
      switch (name[0]) {
        case '_': {
          switch (name[2]) {
            case 'd': {
              switch (name[8]) {
                case 'G': {
                  if (name == u"__defineGetter__"_ns) {
                    return true;
                  }
                  break;
                }
                case 'S': {
                  if (name == u"__defineSetter__"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'l': {
              switch (name[8]) {
                case 'G': {
                  if (name == u"__lookupGetter__"_ns) {
                    return true;
                  }
                  break;
                }
                case 'S': {
                  if (name == u"__lookupSetter__"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'a': {
          switch (name[1]) {
            case 'd': {
              if (name == u"addEventListener"_ns) {
                return true;
              }
              break;
            }
            case 'r': {
              switch (name[4]) {
                case 'A': {
                  if (name == u"ariaAutoComplete"_ns) {
                    return true;
                  }
                  break;
                }
                case 'B': {
                  if (name == u"ariaBrailleLabel"_ns) {
                    return true;
                  }
                  break;
                }
                case 'C': {
                  if (name == u"ariaColIndexText"_ns) {
                    return true;
                  }
                  break;
                }
                case 'K': {
                  if (name == u"ariaKeyShortcuts"_ns) {
                    return true;
                  }
                  break;
                }
                case 'O': {
                  if (name == u"ariaOwnsElements"_ns) {
                    return true;
                  }
                  break;
                }
                case 'R': {
                  if (name == u"ariaRowIndexText"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          if (name == u"computedStyleMap"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getAttributeNode"_ns) {
            return true;
          }
          break;
        }
        case 'l': {
          if (name == u"lastElementChild"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationstart"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              if (name == u"oncanplaythrough"_ns) {
                return true;
              }
              break;
            }
            case 'd': {
              if (name == u"ondurationchange"_ns) {
                return true;
              }
              break;
            }
            case 'l': {
              if (name == u"onloadedmetadata"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'q': {
          if (name == u"querySelectorAll"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"setAttributeNode"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 17: {
      switch (name[0]) {
        case 'a': {
          if (name == u"attributeStyleMap"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"childElementCount"_ns) {
            return true;
          }
          break;
        }
        case 'f': {
          if (name == u"firstElementChild"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getAttributeNames"_ns) {
            return true;
          }
          break;
        }
        case 'h': {
          if (name == u"hasPointerCapture"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"isContentEditable"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationcancel"_ns) {
                return true;
              }
              break;
            }
            case 'c': {
              if (name == u"oncontextrestored"_ns) {
                return true;
              }
              break;
            }
            case 'f': {
              if (name == u"onfullscreenerror"_ns) {
                return true;
              }
              break;
            }
            case 's': {
              if (name == u"onselectionchange"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              if (name == u"ontransitionstart"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          switch (name[2]) {
            case 'm': {
              if (name == u"removeAttributeNS"_ns) {
                return true;
              }
              break;
            }
            case 'q': {
              if (name == u"requestFullscreen"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 's': {
          if (name == u"setPointerCapture"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 18: {
      switch (name[0]) {
        case 'C': {
          if (name == u"CDATA_SECTION_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'D': {
          if (name == u"DOCUMENT_TYPE_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"ariaFlowToElements"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getAttributeNodeNS"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          switch (name[1]) {
            case 'n': {
              switch (name[14]) {
                case 'H': {
                  if (name == u"insertAdjacentHTML"_ns) {
                    return true;
                  }
                  break;
                }
                case 'T': {
                  if (name == u"insertAdjacentText"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 's': {
              if (name == u"isDefaultNamespace"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'l': {
          if (name == u"lookupNamespaceURI"_ns) {
            return true;
          }
          break;
        }
        case 'm': {
          if (name == u"mozMatchesSelector"_ns) {
            return true;
          }
          break;
        }
        case 'n': {
          if (name == u"nextElementSibling"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'f': {
              if (name == u"onfullscreenchange"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"onpointerrawupdate"_ns) {
                return true;
              }
              break;
            }
            case 't': {
              if (name == u"ontransitioncancel"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"requestPointerLock"_ns) {
            return true;
          }
          break;
        }
        case 's': {
          if (name == u"setAttributeNodeNS"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 19: {
      switch (name[0]) {
        case 'a': {
          switch (name[4]) {
            case 'D': {
              if (name == u"ariaDetailsElements"_ns) {
                return true;
              }
              break;
            }
            case 'M': {
              if (name == u"ariaMultiSelectable"_ns) {
                return true;
              }
              break;
            }
            case 'R': {
              if (name == u"ariaRoleDescription"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'c': {
          switch (name[7]) {
            case 'Q': {
              if (name == u"convertQuadFromNode"_ns) {
                return true;
              }
              break;
            }
            case 'R': {
              if (name == u"convertRectFromNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          if (name == u"ongotpointercapture"_ns) {
            return true;
          }
          break;
        }
        case 'r': {
          switch (name[6]) {
            case 'A': {
              if (name == u"removeAttributeNode"_ns) {
                return true;
              }
              break;
            }
            case 'E': {
              if (name == u"removeEventListener"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
      }
      break;
    }
    case 20: {
      switch (name[0]) {
        case 'a': {
          if (name == u"ariaControlsElements"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          switch (name[3]) {
            case 't': {
              if (name == u"containingShadowRoot"_ns) {
                return true;
              }
              break;
            }
            case 'v': {
              if (name == u"convertPointFromNode"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'g': {
          switch (name[3]) {
            case 'E': {
              if (name == u"getElementsByTagName"_ns) {
                return true;
              }
              break;
            }
            case 'T': {
              if (name == u"getTransformToParent"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'm': {
          if (name == u"mozRequestFullScreen"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'a': {
              if (name == u"onanimationiteration"_ns) {
                return true;
              }
              break;
            }
            case 'l': {
              if (name == u"onlostpointercapture"_ns) {
                return true;
              }
              break;
            }
            case 'm': {
              if (name == u"onmozfullscreenerror"_ns) {
                return true;
              }
              break;
            }
            case 'w': {
              if (name == u"onwebkitanimationend"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"propertyIsEnumerable"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 21: {
      switch (name[0]) {
        case 'E': {
          if (name == u"ENTITY_REFERENCE_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          if (name == u"getBoundingClientRect"_ns) {
            return true;
          }
          break;
        }
        case 'i': {
          if (name == u"insertAdjacentElement"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          switch (name[2]) {
            case 'm': {
              if (name == u"onmozfullscreenchange"_ns) {
                return true;
              }
              break;
            }
            case 'w': {
              if (name == u"onwebkittransitionend"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'r': {
          if (name == u"releasePointerCapture"_ns) {
            return true;
          }
          break;
        }
        case 'w': {
          if (name == u"webkitMatchesSelector"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 22: {
      switch (name[0]) {
        case 'D': {
          if (name == u"DOCUMENT_FRAGMENT_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"ariaLabelledByElements"_ns) {
            return true;
          }
          break;
        }
        case 'g': {
          switch (name[3]) {
            case 'E': {
              switch (name[13]) {
                case 'C': {
                  if (name == u"getElementsByClassName"_ns) {
                    return true;
                  }
                  break;
                }
                case 'T': {
                  if (name == u"getElementsByTagNameNS"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
            case 'T': {
              switch (name[14]) {
                case 'A': {
                  if (name == u"getTransformToAncestor"_ns) {
                    return true;
                  }
                  break;
                }
                case 'V': {
                  if (name == u"getTransformToViewport"_ns) {
                    return true;
                  }
                  break;
                }
              }
              break;
            }
          }
          break;
        }
        case 'o': {
          switch (name[1]) {
            case 'n': {
              if (name == u"onwebkitanimationstart"_ns) {
                return true;
              }
              break;
            }
            case 'p': {
              if (name == u"openOrClosedShadowRoot"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'p': {
          if (name == u"previousElementSibling"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 23: {
      switch (name[0]) {
        case 'a': {
          if (name == u"ariaDescribedByElements"_ns) {
            return true;
          }
          break;
        }
        case 'c': {
          if (name == u"compareDocumentPosition"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 24: {
      if (name == u"ariaErrorMessageElements"_ns) {
        return true;
      }
      break;
    }
    case 25: {
      if (name == u"onsecuritypolicyviolation"_ns) {
        return true;
      }
      break;
    }
    case 26: {
      switch (name[0]) {
        case 'D': {
          if (name == u"DOCUMENT_POSITION_CONTAINS"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"ariaBrailleRoleDescription"_ns) {
            return true;
          }
          break;
        }
        case 'o': {
          if (name == u"onwebkitanimationiteration"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 27: {
      switch (name[0]) {
        case 'D': {
          switch (name[18]) {
            case 'F': {
              if (name == u"DOCUMENT_POSITION_FOLLOWING"_ns) {
                return true;
              }
              break;
            }
            case 'P': {
              if (name == u"DOCUMENT_POSITION_PRECEDING"_ns) {
                return true;
              }
              break;
            }
          }
          break;
        }
        case 'P': {
          if (name == u"PROCESSING_INSTRUCTION_NODE"_ns) {
            return true;
          }
          break;
        }
        case 'a': {
          if (name == u"ariaActiveDescendantElement"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 30: {
      switch (name[18]) {
        case 'C': {
          if (name == u"DOCUMENT_POSITION_CONTAINED_BY"_ns) {
            return true;
          }
          break;
        }
        case 'D': {
          if (name == u"DOCUMENT_POSITION_DISCONNECTED"_ns) {
            return true;
          }
          break;
        }
      }
      break;
    }
    case 34: {
      if (name == u"oncontentvisibilityautostatechange"_ns) {
        return true;
      }
      break;
    }
    case 41: {
      if (name == u"DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC"_ns) {
        return true;
      }
      break;
    }
  }

  return false;
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    JS::Rooted<JS::Value> value(cx);
    mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, &value)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
      return true;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!IsArrayIndex(index) && !ignoreNamedProps) {
    if (!isXray) {
      callNamedGetter = true;
    } else {
      bool hasOnProto;
      if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
        return false;
      }
      callNamedGetter = !hasOnProto;
    }
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
      bool found = false;
      auto result(StrongOrRawPtr<nsISupports>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!WrapObject(cx, result, &value)) {
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  if (IsArrayIndex(GetArrayIndexFromId(id))) {
    *done = true;
    return opresult.failNoIndexedSetter();
  }
  JSContext* cx = cx_;
  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<nsISupports>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  if (found) {
    *done = true;
    return opresult.failNoNamedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  uint32_t length = UnwrapProxy(proxy)->Length();
  MOZ_ASSERT(int32_t(length) >= 0);
  for (int32_t i = 0; i < int32_t(length); ++i) {
    if (!props.append(JS::PropertyKey::Int(i))) {
      return false;
    }
  }

  if (flags & JSITER_HIDDEN) {
    nsTArray<nsString> names;
    UnwrapProxy(proxy)->GetSupportedNames(names);
    if (!AppendNamedPropertyIds(cx, proxy, names, !isXray, props)) {
      return false;
    }
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");
  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool found = false;
    mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;

    *bp = found;
    return true;
  }


  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<nsISupports>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  *bp = found;

  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    // Even if we don't have this index, we don't forward the
    // get on to our expando object.
  } else {
    bool expandoHasProp = false;
    { // Scope for expando
      JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
      if (expando) {
        if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
          return false;
        }

        if (expandoHasProp) {
          // Forward the get to the expando object, but our receiver is whatever our
          // receiver is.
          if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
            return false;
          }
        }
      }
    }

    if (expandoHasProp) {
      return true;
    }
  }

  if (!IsArrayIndex(index)) {
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
      bool found = false;
      auto result(StrongOrRawPtr<nsISupports>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!WrapObject(cx, result, vp)) {
          return false;
        }
        return true;
      }
    }
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "HTMLFormElement";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::dom::HTMLFormElement* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::HTMLFormElement>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    // Either our proxy created an expando object or not.  If it did,
    // then we would have preserved ourselves, and hence if we're going
    // away so is our C++ object and we should reset its expando value.
    // It's possible that in this situation the C++ object's reflector
    // pointer has been nulled out, but if not it's pointing to us.  If
    // our proxy did _not_ create an expando object then it's possible
    // that we're no longer the reflector for our C++ object (and
    // incremental finalization is finally getting to us), and that in
    // the meantime the new reflector has created an expando object.
    // In that case we do NOT want to clear the expando pointer in the
    // C++ object.
    //
    // It's important to do this before we ClearWrapper, of course.
    JSObject* reflector = self->GetWrapperMaybeDead();
    if (!reflector || reflector == proxy) {
      self->mExpandoAndGeneration.expando = JS::UndefinedValue();
    }
    Element_Binding::ReflectedHTMLAttributeSlots::Finalize(proxy);
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::HTMLFormElement>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  uint32_t index = GetArrayIndexFromId(id);
  if (IsArrayIndex(index)) {
    bool deleteSucceeded;
    bool found = false;
    mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
    deleteSucceeded = !found;
    return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
  }
  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<nsISupports>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }
    deleteSucceeded = !found;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

void
DOMProxyHandler::trace(JSTracer* trc, JSObject* proxy) const
{
  Element_Binding::ReflectedHTMLAttributeSlots::Trace(trc, proxy);
  return Base::trace(trc, proxy);
}

bool
DOMProxyHandler::getElements(JSContext* cx, JS::Handle<JSObject*> proxy, uint32_t begin, uint32_t end, js::ElementAdder* adder) const
{
  JS::Rooted<JS::Value> temp(cx);
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");

  mozilla::dom::HTMLFormElement* self = UnwrapProxy(proxy);
  uint32_t length = self->Length();
  // Compute the end of the indices we'll get ourselves
  uint32_t ourEnd = std::clamp(length, begin, end);

  for (uint32_t index = begin; index < ourEnd; ++index) {
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->IndexedGetter(index, found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    MOZ_ASSERT(found);
    if (!GetOrCreateDOMReflector(cx, result, &temp)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!adder->append(cx, temp)) return false;
    continue;
  }

  if (end > ourEnd) {
    JS::Rooted<JSObject*> proto(cx);
    if (!js::GetObjectProto(cx, proxy, &proto)) {
      return false;
    }
    return js::GetElementsWithAdder(cx, proto, proxy, ourEnd, end, adder);
  }

  return true;
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::dom::HTMLFormElement>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("HTMLFormElement",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(2)),
  { prototypes::id::EventTarget, prototypes::id::Node, prototypes::id::Element, prototypes::id::HTMLElement, prototypes::id::HTMLFormElement, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::HTMLFormElement>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::HTMLFormElement>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::HTMLFormElement>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::dom::HTMLFormElement* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::HTMLFormElement>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::HTMLFormElement*>);
  MOZ_ASSERT(static_cast<nsGenericHTMLElement*>(aObject) ==
             reinterpret_cast<nsGenericHTMLElement*>(aObject),
             "Multiple inheritance for nsGenericHTMLElement is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::Element*>(aObject) ==
             reinterpret_cast<mozilla::dom::Element*>(aObject),
             "Multiple inheritance for mozilla::dom::Element is broken.");
  MOZ_ASSERT(static_cast<nsINode*>(aObject) ==
             reinterpret_cast<nsINode*>(aObject),
             "Multiple inheritance for nsINode is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::HTMLFormElement> creator(aCx);
  aObject->mExpandoAndGeneration.expando.setUndefined();
  JS::Rooted<JS::Value> expandoValue(aCx, JS::PrivateValue(&aObject->mExpandoAndGeneration));
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false, aObject,
                            expandoValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::HTMLFormElement);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::HTMLFormElement);

  JS::Handle<JSObject*> parentProto(HTMLElement_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(HTMLElement_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "HTMLFormElement",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLFormElement,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLFormElement,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace HTMLFormElement_Binding



} // namespace mozilla::dom
