/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM TCPServerSocketEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "TCPServerSocketEvent.h"
#include "TCPServerSocketEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/TCPServerSocketEvent.h"
#include "mozilla/dom/TCPSocket.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(TCPServerSocketEvent)

NS_IMPL_ADDREF_INHERITED(TCPServerSocketEvent, Event)
NS_IMPL_RELEASE_INHERITED(TCPServerSocketEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(TCPServerSocketEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mSocket)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(TCPServerSocketEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(TCPServerSocketEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mSocket)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(TCPServerSocketEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

TCPServerSocketEvent::TCPServerSocketEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

TCPServerSocketEvent::~TCPServerSocketEvent()
{
}

TCPServerSocketEvent*
TCPServerSocketEvent::AsTCPServerSocketEvent()
{
  return this;
}

JSObject*
TCPServerSocketEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return TCPServerSocketEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<TCPServerSocketEvent>
TCPServerSocketEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const TCPServerSocketEventInit& aEventInitDict)
{
  RefPtr<TCPServerSocketEvent> e = new TCPServerSocketEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mSocket = aEventInitDict.mSocket;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<TCPServerSocketEvent>
TCPServerSocketEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const TCPServerSocketEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

TCPSocket*
TCPServerSocketEvent::Socket() const
{
  return mSocket;
}


} // namespace mozilla::dom
