/* THIS FILE IS AUTOGENERATED FROM IntersectionObserver.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_INTERSECTIONOBSERVERBINDING_H_
#define DOM_INTERSECTIONOBSERVERBINDING_H_

#include "DOMRectBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"

namespace mozilla {
namespace dom {

class DOMIntersectionObserver;
class DOMIntersectionObserverEntry;
struct DOMRectInit;
class Document;
class DoubleOrDoubleSequence;
class Element;
class ElementOrDocument;
class IntersectionCallback;
struct IntersectionObserverEntryInitAtoms;
struct IntersectionObserverInitAtoms;
struct NativePropertyHooks;
class OwningDoubleOrDoubleSequence;
class OwningElementOrDocument;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningElementOrDocument& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningElementOrDocument& aUnion);


class DoubleOrDoubleSequence : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eDoubleSequence
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eDoubleSequence = TypeOrUninit::eDoubleSequence
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<binding_detail::AutoSequence<double> > mDoubleSequence;

  };

  TypeOrUninit mType;
  Value mValue;

  DoubleOrDoubleSequence(const DoubleOrDoubleSequence&) = delete;
  DoubleOrDoubleSequence& operator=(const DoubleOrDoubleSequence&) = delete;
public:
  explicit inline DoubleOrDoubleSequence()
    : mType(eUninitialized)
  {
  }

  inline ~DoubleOrDoubleSequence()
  {
    Uninit();
  }

  [[nodiscard]] inline double&
  RawSetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  [[nodiscard]] inline double&
  SetAsDouble()
  {
    if (mType == eDouble) {
      return mValue.mDouble.Value();
    }
    Uninit();
    mType = eDouble;
    return mValue.mDouble.SetValue();
  }

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<double>&
  RawSetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  [[nodiscard]] inline binding_detail::AutoSequence<double>&
  SetAsDoubleSequence()
  {
    if (mType == eDoubleSequence) {
      return mValue.mDoubleSequence.Value();
    }
    Uninit();
    mType = eDoubleSequence;
    return mValue.mDoubleSequence.SetValue();
  }

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline binding_detail::AutoSequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline const Sequence<double>&
  GetAsDoubleSequence() const
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDouble: {
        DestroyDouble();
        break;
      }
      case eDoubleSequence: {
        DestroyDoubleSequence();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    mValue.mDouble.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDoubleSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    mValue.mDoubleSequence.Destroy();
    mType = eUninitialized;
  }
};


class OwningDoubleOrDoubleSequence : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDouble,
    eDoubleSequence
  };
public:
  enum class Type
  {
    eDouble = TypeOrUninit::eDouble,
    eDoubleSequence = TypeOrUninit::eDoubleSequence
  };

private:
  union Value
  {
    UnionMember<double > mDouble;
    UnionMember<Sequence<double> > mDoubleSequence;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningDoubleOrDoubleSequence()
    : mType(eUninitialized)
  {
  }

  OwningDoubleOrDoubleSequence(OwningDoubleOrDoubleSequence&& aOther);

  explicit inline OwningDoubleOrDoubleSequence(const OwningDoubleOrDoubleSequence& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningDoubleOrDoubleSequence()
  {
    Uninit();
  }

  [[nodiscard]] double&
  RawSetAsDouble();

  [[nodiscard]] double&
  SetAsDouble();

  inline bool
  IsDouble() const
  {
    return mType == eDouble;
  }

  inline double&
  GetAsDouble()
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  inline double const &
  GetAsDouble() const
  {
    MOZ_RELEASE_ASSERT(IsDouble(), "Wrong type!");
    return mValue.mDouble.Value();
  }

  [[nodiscard]] Sequence<double>&
  RawSetAsDoubleSequence();

  [[nodiscard]] Sequence<double>&
  SetAsDoubleSequence();

  inline bool
  IsDoubleSequence() const
  {
    return mType == eDoubleSequence;
  }

  inline Sequence<double>&
  GetAsDoubleSequence()
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  inline Sequence<double> const &
  GetAsDoubleSequence() const
  {
    MOZ_RELEASE_ASSERT(IsDoubleSequence(), "Wrong type!");
    return mValue.mDoubleSequence.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningDoubleOrDoubleSequence&
  operator=(OwningDoubleOrDoubleSequence&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningDoubleOrDoubleSequence&
  operator=(const OwningDoubleOrDoubleSequence& aOther);

private:
  bool
  TrySetToDouble(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDouble(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDouble();

  bool
  TrySetToDoubleSequence(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDoubleSequence(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDoubleSequence();
};


class ElementOrDocument : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eElement,
    eDocument
  };
public:
  enum class Type
  {
    eElement = TypeOrUninit::eElement,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Element> > mElement;
    UnionMember<NonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

  ElementOrDocument(const ElementOrDocument&) = delete;
  ElementOrDocument& operator=(const ElementOrDocument&) = delete;
public:
  explicit inline ElementOrDocument()
    : mType(eUninitialized)
  {
  }

  inline ~ElementOrDocument()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Document>&
  RawSetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Document>&
  SetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    Uninit();
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline NonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline mozilla::dom::Document&
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
      case eDocument: {
        DestroyDocument();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    mValue.mDocument.Destroy();
    mType = eUninitialized;
  }
};


class OwningElementOrDocument : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningElementOrDocument& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eElement,
    eDocument
  };
public:
  enum class Type
  {
    eElement = TypeOrUninit::eElement,
    eDocument = TypeOrUninit::eDocument
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;
    UnionMember<OwningNonNull<mozilla::dom::Document> > mDocument;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningElementOrDocument()
    : mType(eUninitialized)
  {
  }

  OwningElementOrDocument(OwningElementOrDocument&& aOther);

  explicit inline OwningElementOrDocument(const OwningElementOrDocument& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningElementOrDocument()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Document>&
  RawSetAsDocument();

  [[nodiscard]] OwningNonNull<mozilla::dom::Document>&
  SetAsDocument();

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline OwningNonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline OwningNonNull<mozilla::dom::Document> const &
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningElementOrDocument&
  operator=(OwningElementOrDocument&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningElementOrDocument&
  operator=(const OwningElementOrDocument& aOther);

private:
  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyElement();

  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDocument();
};


class IntersectionCallback : public CallbackFunction
{
public:
  explicit inline IntersectionCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IntersectionCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IntersectionCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline IntersectionCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "IntersectionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, entries, observer, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "IntersectionCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, entries, observer, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, entries, observer, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, const char* aExecutionReason = nullptr)
  {
    return Call(entries, observer, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const IntersectionCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const Sequence<OwningNonNull<DOMIntersectionObserverEntry>>& entries, DOMIntersectionObserver& observer, ErrorResult& aRv);
};


namespace binding_detail {
class FastIntersectionCallback : public IntersectionCallback
{
public:
  explicit inline FastIntersectionCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : IntersectionCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    IntersectionCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    IntersectionCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct IntersectionObserverEntryInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR DOMRectInit mBoundingClientRect;
  MOZ_INIT_OUTSIDE_CTOR DOMRectInit mIntersectionRect;
  MOZ_INIT_OUTSIDE_CTOR DOMRectInit mRootBounds;
  MOZ_INIT_OUTSIDE_CTOR OwningNonNull<mozilla::dom::Element> mTarget;
  MOZ_INIT_OUTSIDE_CTOR double mTime;

  IntersectionObserverEntryInit();

  explicit inline IntersectionObserverEntryInit(const FastDictionaryInitializer& )
    : mBoundingClientRect(FastDictionaryInitializer()),
      mIntersectionRect(FastDictionaryInitializer()),
      mRootBounds(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  IntersectionObserverEntryInit(IntersectionObserverEntryInit&& aOther) = default;

  explicit inline IntersectionObserverEntryInit(const IntersectionObserverEntryInit& aOther)
    : mBoundingClientRect(FastDictionaryInitializer()),
      mIntersectionRect(FastDictionaryInitializer()),
      mRootBounds(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mTarget, "mTarget", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mTarget);
  }

  IntersectionObserverEntryInit&
  operator=(const IntersectionObserverEntryInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, IntersectionObserverEntryInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastIntersectionObserverEntryInit : public IntersectionObserverEntryInit
{
  inline FastIntersectionObserverEntryInit()
    : IntersectionObserverEntryInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct IntersectionObserverInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Nullable<OwningElementOrDocument > mRoot;
  MOZ_INIT_OUTSIDE_CTOR nsCString mRootMargin;
  MOZ_INIT_OUTSIDE_CTOR nsCString mScrollMargin;
  MOZ_INIT_OUTSIDE_CTOR OwningDoubleOrDoubleSequence mThreshold;

  IntersectionObserverInit();

  explicit inline IntersectionObserverInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  IntersectionObserverInit(IntersectionObserverInit&& aOther) = default;

  explicit inline IntersectionObserverInit(const IntersectionObserverInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mRoot, "mRoot", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mRoot);
  }

  IntersectionObserverInit&
  operator=(const IntersectionObserverInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, IntersectionObserverInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastIntersectionObserverInit : public IntersectionObserverInit
{
  inline FastIntersectionObserverInit()
    : IntersectionObserverInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace IntersectionObserver_Binding {

  typedef mozilla::dom::DOMIntersectionObserver NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMIntersectionObserver* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::IntersectionObserver,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace IntersectionObserver_Binding



namespace IntersectionObserverEntry_Binding {

  typedef mozilla::dom::DOMIntersectionObserverEntry NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::DOMIntersectionObserverEntry* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::IntersectionObserverEntry,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace IntersectionObserverEntry_Binding



} // namespace mozilla::dom

#endif // DOM_INTERSECTIONOBSERVERBINDING_H_
