/* THIS FILE IS AUTOGENERATED FROM FontFace.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_FONTFACEBINDING_H_
#define DOM_FONTFACEBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "js/Value.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class FontFace;
struct FontFaceDescriptorsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class FontFaceLoadStatus : uint8_t {
  Unloaded,
  Loading,
  Loaded,
  Error,
};

namespace binding_detail {
template <> struct EnumStrings<FontFaceLoadStatus> {
  static constexpr nsLiteralCString Values[4] {
    "unloaded"_ns,
    "loading"_ns,
    "loaded"_ns,
    "error"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, FontFaceLoadStatus aArgument, JS::MutableHandle<JS::Value> aValue);


struct FontFaceDescriptors : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsCString mAscentOverride;
  MOZ_INIT_OUTSIDE_CTOR nsCString mDescentOverride;
  MOZ_INIT_OUTSIDE_CTOR nsCString mDisplay;
  MOZ_INIT_OUTSIDE_CTOR nsCString mFeatureSettings;
  MOZ_INIT_OUTSIDE_CTOR nsCString mLineGapOverride;
  MOZ_INIT_OUTSIDE_CTOR nsCString mSizeAdjust;
  MOZ_INIT_OUTSIDE_CTOR nsCString mStretch;
  MOZ_INIT_OUTSIDE_CTOR nsCString mStyle;
  MOZ_INIT_OUTSIDE_CTOR nsCString mUnicodeRange;
  MOZ_INIT_OUTSIDE_CTOR nsCString mVariant;
  MOZ_INIT_OUTSIDE_CTOR nsCString mVariationSettings;
  MOZ_INIT_OUTSIDE_CTOR nsCString mWeight;

  FontFaceDescriptors();

  explicit inline FontFaceDescriptors(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FontFaceDescriptors(FontFaceDescriptors&& aOther) = default;

  explicit inline FontFaceDescriptors(const FontFaceDescriptors& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  FontFaceDescriptors&
  operator=(const FontFaceDescriptors& aOther);

private:
  static bool
  InitIds(JSContext* cx, FontFaceDescriptorsAtoms* atomsCache);
};

namespace binding_detail {
struct FastFontFaceDescriptors : public FontFaceDescriptors
{
  inline FastFontFaceDescriptors()
    : FontFaceDescriptors(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrArrayBufferOrArrayBufferView : public AllUnionBase,
                                                 public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<UTF8StringOrArrayBufferOrArrayBufferView, true, ArrayBuffer, ArrayBufferView>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eArrayBuffer,
    eArrayBufferView
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eArrayBufferView = TypeOrUninit::eArrayBufferView
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrArrayBufferOrArrayBufferView(const UTF8StringOrArrayBufferOrArrayBufferView&) = delete;
  UTF8StringOrArrayBufferOrArrayBufferView& operator=(const UTF8StringOrArrayBufferOrArrayBufferView&) = delete;
public:
  explicit inline UTF8StringOrArrayBufferOrArrayBufferView()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrArrayBufferOrArrayBufferView()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrArrayBufferOrArrayBufferView : public AllOwningUnionBase,
                                                       public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningUTF8StringOrArrayBufferOrArrayBufferView, true, ArrayBuffer, ArrayBufferView>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eArrayBuffer,
    eArrayBufferView
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eArrayBufferView = TypeOrUninit::eArrayBufferView
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<ArrayBufferView > mArrayBufferView;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningUTF8StringOrArrayBufferOrArrayBufferView(const OwningUTF8StringOrArrayBufferOrArrayBufferView&) = delete;
  OwningUTF8StringOrArrayBufferOrArrayBufferView& operator=(const OwningUTF8StringOrArrayBufferOrArrayBufferView&) = delete;
public:
  explicit inline OwningUTF8StringOrArrayBufferOrArrayBufferView()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrArrayBufferOrArrayBufferView(OwningUTF8StringOrArrayBufferOrArrayBufferView&& aOther);

  inline ~OwningUTF8StringOrArrayBufferOrArrayBufferView()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] ArrayBuffer&
  RawSetAsArrayBuffer();

  [[nodiscard]] ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  [[nodiscard]] ArrayBufferView&
  RawSetAsArrayBufferView();

  [[nodiscard]] ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningUTF8StringOrArrayBufferOrArrayBufferView&
  operator=(OwningUTF8StringOrArrayBufferOrArrayBufferView&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();
};


namespace FontFace_Binding {

  typedef mozilla::dom::FontFace NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::FontFace* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::FontFace,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace FontFace_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::FontFaceLoadStatus>
{
  static constexpr dom::FontFaceLoadStatus value = dom::FontFaceLoadStatus::Error;

  static_assert(static_cast<uint8_t>(dom::FontFaceLoadStatus::Unloaded) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::FontFaceLoadStatus>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_FONTFACEBINDING_H_
