void applyCustomReader(vtkAlgorithm* algo, const std::string& vtkNotUsed(fileName)) const override
{
  std::string optName = "IGES.linear_deflection";
  std::string str = this->ReaderOptions.at(optName);
  double linearDeflect = F3DUtils::ParseToDouble(str, 0.1, optName);

  optName = "IGES.angular_deflection";
  str = this->ReaderOptions.at(optName);
  double angularDeflect = F3DUtils::ParseToDouble(str, 0.5, optName);

  optName = "IGES.relative_deflection";
  str = this->ReaderOptions.at(optName);
  bool relativeDeflect = (F3DUtils::ParseToDouble(str, 0, optName) != 0);

  optName = "IGES.read_wire";
  str = this->ReaderOptions.at(optName);
  bool readWire = (F3DUtils::ParseToDouble(str, 1, optName) != 0);

  vtkF3DOCCTReader* occtReader = vtkF3DOCCTReader::SafeDownCast(algo);
  occtReader->RelativeDeflectionOn();
  occtReader->SetLinearDeflection(linearDeflect);
  occtReader->SetAngularDeflection(angularDeflect);
  occtReader->SetRelativeDeflection(relativeDeflect);
  occtReader->SetReadWire(readWire);

  // clang-format off
  occtReader->SetFileFormat(vtkF3DOCCTReader::FILE_FORMAT::IGES);
  // clang-format on
}
