// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#include "pal_random.h"
#include <minipal/random.h>

/*

Generate random bytes. The generated bytes are not cryptographically strong.

*/

void SystemNative_GetNonCryptographicallySecureRandomBytes(uint8_t* buffer, int32_t bufferLength)
{
    minipal_get_non_cryptographically_secure_random_bytes(buffer, bufferLength);
}

/*

Generate cryptographically strong random bytes.

Return 0 on success, -1 on failure.
*/
int32_t SystemNative_GetCryptographicallySecureRandomBytes(uint8_t* buffer, int32_t bufferLength)
{
    return minipal_get_cryptographically_secure_random_bytes(buffer, bufferLength);
}
