/* ActionDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ActionDialog.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/* This implements the "Action Dialog" pattern from the HIG.*/
/* Used for getting extra info after clicking an action button*/
/* (like Print - or Restore in our case).*/

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ACTION_DIALOG (action_dialog_get_type ())
#define ACTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACTION_DIALOG, ActionDialog))
#define ACTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACTION_DIALOG, ActionDialogClass))
#define IS_ACTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACTION_DIALOG))
#define IS_ACTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACTION_DIALOG))
#define ACTION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACTION_DIALOG, ActionDialogClass))

typedef struct _ActionDialog ActionDialog;
typedef struct _ActionDialogClass ActionDialogClass;
typedef struct _ActionDialogPrivate ActionDialogPrivate;
enum  {
	ACTION_DIALOG_0_PROPERTY,
	ACTION_DIALOG_ACCEPT_ENABLED_PROPERTY,
	ACTION_DIALOG_ACCEPT_LABEL_PROPERTY,
	ACTION_DIALOG_CONTENT_PROPERTY,
	ACTION_DIALOG_NUM_PROPERTIES
};
static GParamSpec* action_dialog_properties[ACTION_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	ACTION_DIALOG_ACCEPTED_SIGNAL,
	ACTION_DIALOG_NUM_SIGNALS
};
static guint action_dialog_signals[ACTION_DIALOG_NUM_SIGNALS] = {0};

struct _ActionDialog {
	AdwDialog parent_instance;
	ActionDialogPrivate * priv;
};

struct _ActionDialogClass {
	AdwDialogClass parent_class;
	void (*accept) (ActionDialog* self);
};

struct _ActionDialogPrivate {
	gboolean _accept_enabled;
	gchar* _accept_label;
	GtkWidget* _content;
};

static gint ActionDialog_private_offset;
static gpointer action_dialog_parent_class = NULL;

VALA_EXTERN GType action_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ActionDialog, g_object_unref)
VALA_EXTERN void action_dialog_accept (ActionDialog* self);
static void action_dialog_real_accept (ActionDialog* self);
static void action_dialog_handle_cancel (ActionDialog* self);
static void _action_dialog_handle_cancel_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
static void action_dialog_handle_accept (ActionDialog* self);
static void _action_dialog_handle_accept_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
VALA_EXTERN ActionDialog* action_dialog_new (void);
VALA_EXTERN ActionDialog* action_dialog_construct (GType object_type);
VALA_EXTERN gboolean action_dialog_get_accept_enabled (ActionDialog* self);
VALA_EXTERN void action_dialog_set_accept_enabled (ActionDialog* self,
                                       gboolean value);
VALA_EXTERN const gchar* action_dialog_get_accept_label (ActionDialog* self);
VALA_EXTERN void action_dialog_set_accept_label (ActionDialog* self,
                                     const gchar* value);
VALA_EXTERN GtkWidget* action_dialog_get_content (ActionDialog* self);
VALA_EXTERN void action_dialog_set_content (ActionDialog* self,
                                GtkWidget* value);
static void action_dialog_finalize (GObject * obj);
static GType action_dialog_get_type_once (void);
static void _vala_action_dialog_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_action_dialog_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
action_dialog_get_instance_private (ActionDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ActionDialog_private_offset);
}

static void
action_dialog_real_accept (ActionDialog* self)
{
}

void
action_dialog_accept (ActionDialog* self)
{
	ActionDialogClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = ACTION_DIALOG_GET_CLASS (self);
	if (_klass_->accept) {
		_klass_->accept (self);
	}
}

static void
action_dialog_handle_cancel (ActionDialog* self)
{
	g_return_if_fail (self != NULL);
	adw_dialog_close ((AdwDialog*) self);
}

static void
_action_dialog_handle_cancel_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	action_dialog_handle_cancel ((ActionDialog*) self);
}

static void
action_dialog_handle_accept (ActionDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, action_dialog_signals[ACTION_DIALOG_ACCEPTED_SIGNAL], 0);
	action_dialog_accept (self);
	adw_dialog_close ((AdwDialog*) self);
}

static void
_action_dialog_handle_accept_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	action_dialog_handle_accept ((ActionDialog*) self);
}

ActionDialog*
action_dialog_construct (GType object_type)
{
	ActionDialog * self = NULL;
	self = (ActionDialog*) g_object_new (object_type, NULL);
	return self;
}

ActionDialog*
action_dialog_new (void)
{
	return action_dialog_construct (TYPE_ACTION_DIALOG);
}

gboolean
action_dialog_get_accept_enabled (ActionDialog* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_accept_enabled;
	return result;
}

void
action_dialog_set_accept_enabled (ActionDialog* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = action_dialog_get_accept_enabled (self);
	if (old_value != value) {
		self->priv->_accept_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, action_dialog_properties[ACTION_DIALOG_ACCEPT_ENABLED_PROPERTY]);
	}
}

const gchar*
action_dialog_get_accept_label (ActionDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accept_label;
	result = _tmp0_;
	return result;
}

void
action_dialog_set_accept_label (ActionDialog* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = action_dialog_get_accept_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_accept_label);
		self->priv->_accept_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, action_dialog_properties[ACTION_DIALOG_ACCEPT_LABEL_PROPERTY]);
	}
}

GtkWidget*
action_dialog_get_content (ActionDialog* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
action_dialog_set_content (ActionDialog* self,
                           GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = action_dialog_get_content (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_content);
		self->priv->_content = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, action_dialog_properties[ACTION_DIALOG_CONTENT_PROPERTY]);
	}
}

static void
action_dialog_class_init (ActionDialogClass * klass,
                          gpointer klass_data)
{
	action_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ActionDialog_private_offset);
	((ActionDialogClass *) klass)->accept = (void (*) (ActionDialog*)) action_dialog_real_accept;
	G_OBJECT_CLASS (klass)->get_property = _vala_action_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_action_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = action_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTION_DIALOG_ACCEPT_ENABLED_PROPERTY, action_dialog_properties[ACTION_DIALOG_ACCEPT_ENABLED_PROPERTY] = g_param_spec_boolean ("accept-enabled", "accept-enabled", "accept-enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTION_DIALOG_ACCEPT_LABEL_PROPERTY, action_dialog_properties[ACTION_DIALOG_ACCEPT_LABEL_PROPERTY] = g_param_spec_string ("accept-label", "accept-label", "accept-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACTION_DIALOG_CONTENT_PROPERTY, action_dialog_properties[ACTION_DIALOG_CONTENT_PROPERTY] = g_param_spec_object ("content", "content", "content", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/DejaDup/ActionDialog.ui");
	action_dialog_signals[ACTION_DIALOG_ACCEPTED_SIGNAL] = g_signal_new ("accepted", TYPE_ACTION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "handle_cancel", G_CALLBACK(_action_dialog_handle_cancel_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "handle_accept", G_CALLBACK(_action_dialog_handle_accept_gtk_button_clicked));
}

static void
action_dialog_instance_init (ActionDialog * self,
                             gpointer klass)
{
	self->priv = action_dialog_get_instance_private (self);
	self->priv->_accept_enabled = TRUE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
action_dialog_finalize (GObject * obj)
{
	ActionDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACTION_DIALOG, ActionDialog);
	g_debug ("ActionDialog.vala:26: Finalizing ActionDialog\n");
	_g_free0 (self->priv->_accept_label);
	_g_object_unref0 (self->priv->_content);
	G_OBJECT_CLASS (action_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
action_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ActionDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) action_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ActionDialog), 0, (GInstanceInitFunc) action_dialog_instance_init, NULL };
	GType action_dialog_type_id;
	action_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "ActionDialog", &g_define_type_info, 0);
	ActionDialog_private_offset = g_type_add_instance_private (action_dialog_type_id, sizeof (ActionDialogPrivate));
	return action_dialog_type_id;
}

GType
action_dialog_get_type (void)
{
	static gsize action_dialog_type_id__once = 0;
	if (g_once_init_enter (&action_dialog_type_id__once)) {
		GType action_dialog_type_id;
		action_dialog_type_id = action_dialog_get_type_once ();
		g_once_init_leave (&action_dialog_type_id__once, action_dialog_type_id);
	}
	return action_dialog_type_id__once;
}

static void
_vala_action_dialog_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	ActionDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACTION_DIALOG, ActionDialog);
	switch (property_id) {
		case ACTION_DIALOG_ACCEPT_ENABLED_PROPERTY:
		g_value_set_boolean (value, action_dialog_get_accept_enabled (self));
		break;
		case ACTION_DIALOG_ACCEPT_LABEL_PROPERTY:
		g_value_set_string (value, action_dialog_get_accept_label (self));
		break;
		case ACTION_DIALOG_CONTENT_PROPERTY:
		g_value_set_object (value, action_dialog_get_content (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_action_dialog_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	ActionDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACTION_DIALOG, ActionDialog);
	switch (property_id) {
		case ACTION_DIALOG_ACCEPT_ENABLED_PROPERTY:
		action_dialog_set_accept_enabled (self, g_value_get_boolean (value));
		break;
		case ACTION_DIALOG_ACCEPT_LABEL_PROPERTY:
		action_dialog_set_accept_label (self, g_value_get_string (value));
		break;
		case ACTION_DIALOG_CONTENT_PROPERTY:
		action_dialog_set_content (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

