// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/dde-restrict.xml

#ifndef QT_WAYLAND_SERVER_DDE_RESTRICT
#define QT_WAYLAND_SERVER_DDE_RESTRICT

#include "wayland-server-core.h"
#include "wayland-dde-restrict-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  dde_restrict
    {
    public:
        dde_restrict(struct ::wl_client *client, int id, int version);
        dde_restrict(struct ::wl_display *display, int version);
        dde_restrict(struct ::wl_resource *resource);
        dde_restrict();

        virtual ~dde_restrict();

        class Resource
        {
        public:
            Resource() : dde_restrict_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_restrict *dde_restrict_object;
            dde_restrict *object() { return dde_restrict_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum switch_flag {
            switch_flag_on = 1, // feature toggle on
            switch_flag_off = 2, // feature toggle off
        };

        void send_loged(const QString &log);
        void send_loged(struct ::wl_resource *resource, const QString &log);

    protected:
        virtual Resource *dde_restrict_allocate();

        virtual void dde_restrict_destroy_global();

        virtual void dde_restrict_bind_resource(Resource *resource);
        virtual void dde_restrict_destroy_resource(Resource *resource);

        virtual void dde_restrict_switch_screencast(Resource *resource, uint32_t switch_flag);
        virtual void dde_restrict_client_whitelist(Resource *resource, const QString &whitelists);
        virtual void dde_restrict_set_protected_window(Resource *resource, int32_t window);
        virtual void dde_restrict_remove_protected_window(Resource *resource, int32_t window);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_restrict_interface m_dde_restrict_interface;

        static void handle_switch_screencast(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t switch_flag);
        static void handle_client_whitelist(
            ::wl_client *client,
            struct wl_resource *resource,
            const char *whitelists);
        static void handle_set_protected_window(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t window);
        static void handle_remove_protected_window(
            ::wl_client *client,
            struct wl_resource *resource,
            int32_t window);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_restrict *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
