// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum keyword.yaml. DO NOT EDIT.

package keyword

import (
	"fmt"
	"iter"
)

// Keywords are special "grammar particles" recognized by the compiler.
//
// These include both reserved words, including all identifiers with special
// treatment [in Protobuf], as well as all valid punctuation.
//
// [in Protobuf]: https://protobuf.com/docs/language-spec#identifiers-and-keywords
type Keyword byte

const (
	Unknown      Keyword = iota // Zero value, not a real keyword.
	Syntax                      // syntax
	Edition                     // edition
	Import                      // import
	Weak                        // weak
	Public                      // public
	Package                     // package
	Message                     // message
	Enum                        // enum
	Service                     // service
	Extend                      // extend
	Option                      // option
	Group                       // group
	Oneof                       // oneof
	Extensions                  // extensions
	Reserved                    // reserved
	RPC                         // rpc
	Returns                     // returns
	To                          // to
	Optional                    // optional
	Repeated                    // repeated
	Required                    // required
	Stream                      // stream
	Export                      // export
	Local                       // local
	Int32                       // int32
	Int64                       // int64
	Uint32                      // uint32
	Uint64                      // uint64
	Sint32                      // sint32
	Sint64                      // sint64
	Fixed32                     // fixed32
	Fixed64                     // fixed64
	Sfixed32                    // sfixed32
	Sfixed64                    // sfixed64
	Float                       // float
	Double                      // double
	Bool                        // bool
	String                      // string
	Bytes                       // bytes
	Inf                         // inf
	NaN                         // nan
	True                        // true
	False                       // false
	Null                        // null
	Map                         // map
	Max                         // max
	Return                      // return
	Break                       // break
	Continue                    // continue
	Yield                       // yield
	Defer                       // defer
	Try                         // try
	Catch                       // catch
	If                          // if
	Unless                      // unless
	Else                        // else
	Loop                        // loop
	While                       // while
	Do                          // do
	For                         // for
	In                          // in
	Switch                      // switch
	Match                       // match
	Case                        // case
	As                          // as
	Func                        // func
	Const                       // const
	Let                         // let
	Var                         // var
	Type                        // type
	Extern                      // extern
	And                         // and
	Or                          // or
	Not                         // not
	Default                     // default
	JsonName                    // json_name
	Semi                        // ;
	Comma                       // ,
	Dot                         // .
	Colon                       // :
	Newline                     // \n
	At                          // @
	Hash                        // #
	Dollar                      // $
	Twiddle                     // ~
	Add                         // +
	Sub                         // -
	Mul                         // *
	Div                         // /
	Rem                         // %
	Amp                         // &
	Pipe                        // |
	Xor                         // ^
	Shl                         // <<
	Shr                         // >>
	Bang                        // !
	Bangs                       // !!
	Ask                         // ?
	Asks                        // ??
	Amps                        // &&
	Pipes                       // ||
	Assign                      // =
	AssignNew                   // :=
	AssignAdd                   // +=
	AssignSub                   // -=
	AssignMul                   // *=
	AssignDiv                   // /=
	AssignRem                   // %=
	AssignAmp                   // &=
	AssignPipe                  // |=
	AssignXor                   // ^=
	AssignShl                   // <<=
	AssignShr                   // >>=
	Range                       // ..
	RangeEq                     // ..=
	LParen                      // (
	RParen                      // )
	LBracket                    // [
	RBracket                    // ]
	LBrace                      // {
	RBrace                      // }
	Lt                          // <
	Gt                          // >
	Le                          // <=
	Ge                          // >=
	Eq                          // ==
	Ne                          // !=
	Comment                     // //
	LComment                    // /*
	RComment                    // */
	Parens                      // (...) (fused)
	Brackets                    // [...] (fused)
	Braces                      // {...} (fused)
	Angles                      // <...> (fused)
	BlockComment                // /* ... */ (fused)
)

// String implements [fmt.Stringer].
func (v Keyword) String() string {
	if int(v) < 0 || int(v) > len(_table_Keyword_String) {
		return fmt.Sprintf("Keyword(%v)", int(v))
	}
	return _table_Keyword_String[v]
}

// GoString implements [fmt.GoStringer].
func (v Keyword) GoString() string {
	if int(v) < 0 || int(v) > len(_table_Keyword_GoString) {
		return fmt.Sprintf("keyword.Keyword(%v)", int(v))
	}
	return _table_Keyword_GoString[v]
}

// Lookup looks up a keyword by name.
//
// If name does not name a keyword, returns [Unknown].
func Lookup(s string) Keyword {
	return _table_Keyword_Lookup[s]
}

// All returns an iterator over all distinct [Keyword] values.
func All() iter.Seq[Keyword] {
	return func(yield func(Keyword) bool) {
		for i := 1; i < 136; i++ {
			if !yield(Keyword(i)) {
				return
			}
		}
	}
}

var _table_Keyword_String = [...]string{
	Unknown:      "unknown",
	Syntax:       "syntax",
	Edition:      "edition",
	Import:       "import",
	Weak:         "weak",
	Public:       "public",
	Package:      "package",
	Message:      "message",
	Enum:         "enum",
	Service:      "service",
	Extend:       "extend",
	Option:       "option",
	Group:        "group",
	Oneof:        "oneof",
	Extensions:   "extensions",
	Reserved:     "reserved",
	RPC:          "rpc",
	Returns:      "returns",
	To:           "to",
	Optional:     "optional",
	Repeated:     "repeated",
	Required:     "required",
	Stream:       "stream",
	Export:       "export",
	Local:        "local",
	Int32:        "int32",
	Int64:        "int64",
	Uint32:       "uint32",
	Uint64:       "uint64",
	Sint32:       "sint32",
	Sint64:       "sint64",
	Fixed32:      "fixed32",
	Fixed64:      "fixed64",
	Sfixed32:     "sfixed32",
	Sfixed64:     "sfixed64",
	Float:        "float",
	Double:       "double",
	Bool:         "bool",
	String:       "string",
	Bytes:        "bytes",
	Inf:          "inf",
	NaN:          "nan",
	True:         "true",
	False:        "false",
	Null:         "null",
	Map:          "map",
	Max:          "max",
	Return:       "return",
	Break:        "break",
	Continue:     "continue",
	Yield:        "yield",
	Defer:        "defer",
	Try:          "try",
	Catch:        "catch",
	If:           "if",
	Unless:       "unless",
	Else:         "else",
	Loop:         "loop",
	While:        "while",
	Do:           "do",
	For:          "for",
	In:           "in",
	Switch:       "switch",
	Match:        "match",
	Case:         "case",
	As:           "as",
	Func:         "func",
	Const:        "const",
	Let:          "let",
	Var:          "var",
	Type:         "type",
	Extern:       "extern",
	And:          "and",
	Or:           "or",
	Not:          "not",
	Default:      "default",
	JsonName:     "json_name",
	Semi:         ";",
	Comma:        ",",
	Dot:          ".",
	Colon:        ":",
	Newline:      "\n",
	At:           "@",
	Hash:         "#",
	Dollar:       "$",
	Twiddle:      "~",
	Add:          "+",
	Sub:          "-",
	Mul:          "*",
	Div:          "/",
	Rem:          "%",
	Amp:          "&",
	Pipe:         "|",
	Xor:          "^",
	Shl:          "<<",
	Shr:          ">>",
	Bang:         "!",
	Bangs:        "!!",
	Ask:          "?",
	Asks:         "??",
	Amps:         "&&",
	Pipes:        "||",
	Assign:       "=",
	AssignNew:    ":=",
	AssignAdd:    "+=",
	AssignSub:    "-=",
	AssignMul:    "*=",
	AssignDiv:    "/=",
	AssignRem:    "%=",
	AssignAmp:    "&=",
	AssignPipe:   "|=",
	AssignXor:    "^=",
	AssignShl:    "<<=",
	AssignShr:    ">>=",
	Range:        "..",
	RangeEq:      "..=",
	LParen:       "(",
	RParen:       ")",
	LBracket:     "[",
	RBracket:     "]",
	LBrace:       "{",
	RBrace:       "}",
	Lt:           "<",
	Gt:           ">",
	Le:           "<=",
	Ge:           ">=",
	Eq:           "==",
	Ne:           "!=",
	Comment:      "//",
	LComment:     "/*",
	RComment:     "*/",
	Parens:       "(...)",
	Brackets:     "[...]",
	Braces:       "{...}",
	Angles:       "<...>",
	BlockComment: "/* ... */",
}

var _table_Keyword_GoString = [...]string{
	Unknown:      "keyword.Unknown",
	Syntax:       "keyword.Syntax",
	Edition:      "keyword.Edition",
	Import:       "keyword.Import",
	Weak:         "keyword.Weak",
	Public:       "keyword.Public",
	Package:      "keyword.Package",
	Message:      "keyword.Message",
	Enum:         "keyword.Enum",
	Service:      "keyword.Service",
	Extend:       "keyword.Extend",
	Option:       "keyword.Option",
	Group:        "keyword.Group",
	Oneof:        "keyword.Oneof",
	Extensions:   "keyword.Extensions",
	Reserved:     "keyword.Reserved",
	RPC:          "keyword.RPC",
	Returns:      "keyword.Returns",
	To:           "keyword.To",
	Optional:     "keyword.Optional",
	Repeated:     "keyword.Repeated",
	Required:     "keyword.Required",
	Stream:       "keyword.Stream",
	Export:       "keyword.Export",
	Local:        "keyword.Local",
	Int32:        "keyword.Int32",
	Int64:        "keyword.Int64",
	Uint32:       "keyword.Uint32",
	Uint64:       "keyword.Uint64",
	Sint32:       "keyword.Sint32",
	Sint64:       "keyword.Sint64",
	Fixed32:      "keyword.Fixed32",
	Fixed64:      "keyword.Fixed64",
	Sfixed32:     "keyword.Sfixed32",
	Sfixed64:     "keyword.Sfixed64",
	Float:        "keyword.Float",
	Double:       "keyword.Double",
	Bool:         "keyword.Bool",
	String:       "keyword.String",
	Bytes:        "keyword.Bytes",
	Inf:          "keyword.Inf",
	NaN:          "keyword.NaN",
	True:         "keyword.True",
	False:        "keyword.False",
	Null:         "keyword.Null",
	Map:          "keyword.Map",
	Max:          "keyword.Max",
	Return:       "keyword.Return",
	Break:        "keyword.Break",
	Continue:     "keyword.Continue",
	Yield:        "keyword.Yield",
	Defer:        "keyword.Defer",
	Try:          "keyword.Try",
	Catch:        "keyword.Catch",
	If:           "keyword.If",
	Unless:       "keyword.Unless",
	Else:         "keyword.Else",
	Loop:         "keyword.Loop",
	While:        "keyword.While",
	Do:           "keyword.Do",
	For:          "keyword.For",
	In:           "keyword.In",
	Switch:       "keyword.Switch",
	Match:        "keyword.Match",
	Case:         "keyword.Case",
	As:           "keyword.As",
	Func:         "keyword.Func",
	Const:        "keyword.Const",
	Let:          "keyword.Let",
	Var:          "keyword.Var",
	Type:         "keyword.Type",
	Extern:       "keyword.Extern",
	And:          "keyword.And",
	Or:           "keyword.Or",
	Not:          "keyword.Not",
	Default:      "keyword.Default",
	JsonName:     "keyword.JsonName",
	Semi:         "keyword.Semi",
	Comma:        "keyword.Comma",
	Dot:          "keyword.Dot",
	Colon:        "keyword.Colon",
	Newline:      "keyword.Newline",
	At:           "keyword.At",
	Hash:         "keyword.Hash",
	Dollar:       "keyword.Dollar",
	Twiddle:      "keyword.Twiddle",
	Add:          "keyword.Add",
	Sub:          "keyword.Sub",
	Mul:          "keyword.Mul",
	Div:          "keyword.Div",
	Rem:          "keyword.Rem",
	Amp:          "keyword.Amp",
	Pipe:         "keyword.Pipe",
	Xor:          "keyword.Xor",
	Shl:          "keyword.Shl",
	Shr:          "keyword.Shr",
	Bang:         "keyword.Bang",
	Bangs:        "keyword.Bangs",
	Ask:          "keyword.Ask",
	Asks:         "keyword.Asks",
	Amps:         "keyword.Amps",
	Pipes:        "keyword.Pipes",
	Assign:       "keyword.Assign",
	AssignNew:    "keyword.AssignNew",
	AssignAdd:    "keyword.AssignAdd",
	AssignSub:    "keyword.AssignSub",
	AssignMul:    "keyword.AssignMul",
	AssignDiv:    "keyword.AssignDiv",
	AssignRem:    "keyword.AssignRem",
	AssignAmp:    "keyword.AssignAmp",
	AssignPipe:   "keyword.AssignPipe",
	AssignXor:    "keyword.AssignXor",
	AssignShl:    "keyword.AssignShl",
	AssignShr:    "keyword.AssignShr",
	Range:        "keyword.Range",
	RangeEq:      "keyword.RangeEq",
	LParen:       "keyword.LParen",
	RParen:       "keyword.RParen",
	LBracket:     "keyword.LBracket",
	RBracket:     "keyword.RBracket",
	LBrace:       "keyword.LBrace",
	RBrace:       "keyword.RBrace",
	Lt:           "keyword.Lt",
	Gt:           "keyword.Gt",
	Le:           "keyword.Le",
	Ge:           "keyword.Ge",
	Eq:           "keyword.Eq",
	Ne:           "keyword.Ne",
	Comment:      "keyword.Comment",
	LComment:     "keyword.LComment",
	RComment:     "keyword.RComment",
	Parens:       "keyword.Parens",
	Brackets:     "keyword.Brackets",
	Braces:       "keyword.Braces",
	Angles:       "keyword.Angles",
	BlockComment: "keyword.BlockComment",
}

var _table_Keyword_Lookup = map[string]Keyword{
	"unknown":    Unknown,
	"syntax":     Syntax,
	"edition":    Edition,
	"import":     Import,
	"weak":       Weak,
	"public":     Public,
	"package":    Package,
	"message":    Message,
	"enum":       Enum,
	"service":    Service,
	"extend":     Extend,
	"option":     Option,
	"group":      Group,
	"oneof":      Oneof,
	"extensions": Extensions,
	"reserved":   Reserved,
	"rpc":        RPC,
	"returns":    Returns,
	"to":         To,
	"optional":   Optional,
	"repeated":   Repeated,
	"required":   Required,
	"stream":     Stream,
	"export":     Export,
	"local":      Local,
	"int32":      Int32,
	"int64":      Int64,
	"uint32":     Uint32,
	"uint64":     Uint64,
	"sint32":     Sint32,
	"sint64":     Sint64,
	"fixed32":    Fixed32,
	"fixed64":    Fixed64,
	"sfixed32":   Sfixed32,
	"sfixed64":   Sfixed64,
	"float":      Float,
	"double":     Double,
	"bool":       Bool,
	"string":     String,
	"bytes":      Bytes,
	"inf":        Inf,
	"nan":        NaN,
	"true":       True,
	"false":      False,
	"null":       Null,
	"map":        Map,
	"max":        Max,
	"return":     Return,
	"break":      Break,
	"continue":   Continue,
	"yield":      Yield,
	"defer":      Defer,
	"try":        Try,
	"catch":      Catch,
	"if":         If,
	"unless":     Unless,
	"else":       Else,
	"loop":       Loop,
	"while":      While,
	"do":         Do,
	"for":        For,
	"in":         In,
	"switch":     Switch,
	"match":      Match,
	"case":       Case,
	"as":         As,
	"func":       Func,
	"const":      Const,
	"let":        Let,
	"var":        Var,
	"type":       Type,
	"extern":     Extern,
	"and":        And,
	"or":         Or,
	"not":        Not,
	"default":    Default,
	"json_name":  JsonName,
	";":          Semi,
	",":          Comma,
	".":          Dot,
	":":          Colon,
	"\n":         Newline,
	"@":          At,
	"#":          Hash,
	"$":          Dollar,
	"~":          Twiddle,
	"+":          Add,
	"-":          Sub,
	"*":          Mul,
	"/":          Div,
	"%":          Rem,
	"&":          Amp,
	"|":          Pipe,
	"^":          Xor,
	"<<":         Shl,
	">>":         Shr,
	"!":          Bang,
	"!!":         Bangs,
	"?":          Ask,
	"??":         Asks,
	"&&":         Amps,
	"||":         Pipes,
	"=":          Assign,
	":=":         AssignNew,
	"+=":         AssignAdd,
	"-=":         AssignSub,
	"*=":         AssignMul,
	"/=":         AssignDiv,
	"%=":         AssignRem,
	"&=":         AssignAmp,
	"|=":         AssignPipe,
	"^=":         AssignXor,
	"<<=":        AssignShl,
	">>=":        AssignShr,
	"..":         Range,
	"..=":        RangeEq,
	"(":          LParen,
	")":          RParen,
	"[":          LBracket,
	"]":          RBracket,
	"{":          LBrace,
	"}":          RBrace,
	"<":          Lt,
	">":          Gt,
	"<=":         Le,
	">=":         Ge,
	"==":         Eq,
	"!=":         Ne,
	"//":         Comment,
	"/*":         LComment,
	"*/":         RComment,
}
var _ iter.Seq[int] // Mark iter as used.
