/* src/bazaar.p/bz-pride-flag-spec.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>
#include "bz-pride-flag-stripe-spec.h"

G_BEGIN_DECLS



#define BZ_TYPE_PRIDE_FLAG_SPEC (bz_pride_flag_spec_get_type ())
G_DECLARE_FINAL_TYPE (BzPrideFlagSpec, bz_pride_flag_spec, BZ, PRIDE_FLAG_SPEC, GObject)

BzPrideFlagSpec *
bz_pride_flag_spec_new (void);

const char *
bz_pride_flag_spec_get_id (BzPrideFlagSpec *self);

const char *
bz_pride_flag_spec_get_name (BzPrideFlagSpec *self);

gboolean
bz_pride_flag_spec_get_homogeneous (BzPrideFlagSpec *self);

const char *
bz_pride_flag_spec_get_direction (BzPrideFlagSpec *self);

GListModel *
bz_pride_flag_spec_get_stripes (BzPrideFlagSpec *self);

void
bz_pride_flag_spec_set_id (BzPrideFlagSpec *self,
    const char *id);

void
bz_pride_flag_spec_set_name (BzPrideFlagSpec *self,
    const char *name);

void
bz_pride_flag_spec_set_homogeneous (BzPrideFlagSpec *self,
    gboolean homogeneous);

void
bz_pride_flag_spec_set_direction (BzPrideFlagSpec *self,
    const char *direction);

void
bz_pride_flag_spec_set_stripes (BzPrideFlagSpec *self,
    GListModel *stripes);

G_END_DECLS

/* End of src/bazaar.p/bz-pride-flag-spec.h */
