/** THIS FILE IS AUTOGENERATED by signals.py: CHANGES WILL BE LOST */

/** A signal with 0 parameters */
template <typename R, typename C = OptionalLastValue<R> >
class Signal0 : public SignalBase
{
public:

	typedef boost::function<R()> slot_function_type;
	typedef boost::optional<R> result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal0 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void()> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir) {
		event_loop->call_slot (ir, boost::bind (f));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	typename C::result_type operator() ()
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		std::list<R> r;
		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				r.push_back ((i->second)());
			}
		}

		/* Call our combiner to do whatever is required to the result values */
		C c;
		return c (r.begin(), r.end());
	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 0 parameters (specialisation for a void return) */
template <>
class Signal0<void> : public SignalBase
{
public:

	typedef boost::function<void()> slot_function_type;
	typedef void result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal0 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (boost::function<void()> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir) {
		event_loop->call_slot (ir, boost::bind (f));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	void operator() ()
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		for (Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				(i->second)();
			}
		}

	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 1 parameters */
template <typename R, typename A1, typename C = OptionalLastValue<R> >
class Signal1 : public SignalBase
{
public:

	typedef boost::function<R(A1)> slot_function_type;
	typedef boost::optional<R> result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal1 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1) {
		event_loop->call_slot (ir, boost::bind (f, a1));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	typename C::result_type operator() (A1 a1)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		std::list<R> r;
		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				r.push_back ((i->second)(a1));
			}
		}

		/* Call our combiner to do whatever is required to the result values */
		C c;
		return c (r.begin(), r.end());
	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 1 parameters (specialisation for a void return) */
template <typename A1>
class Signal1<void, A1> : public SignalBase
{
public:

	typedef boost::function<void(A1)> slot_function_type;
	typedef void result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal1 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1) {
		event_loop->call_slot (ir, boost::bind (f, a1));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	void operator() (A1 a1)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				(i->second)(a1);
			}
		}

	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 2 parameters */
template <typename R, typename A1, typename A2, typename C = OptionalLastValue<R> >
class Signal2 : public SignalBase
{
public:

	typedef boost::function<R(A1, A2)> slot_function_type;
	typedef boost::optional<R> result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal2 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	typename C::result_type operator() (A1 a1, A2 a2)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		std::list<R> r;
		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				r.push_back ((i->second)(a1, a2));
			}
		}

		/* Call our combiner to do whatever is required to the result values */
		C c;
		return c (r.begin(), r.end());
	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 2 parameters (specialisation for a void return) */
template <typename A1, typename A2>
class Signal2<void, A1, A2> : public SignalBase
{
public:

	typedef boost::function<void(A1, A2)> slot_function_type;
	typedef void result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal2 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	void operator() (A1 a1, A2 a2)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				(i->second)(a1, a2);
			}
		}

	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 3 parameters */
template <typename R, typename A1, typename A2, typename A3, typename C = OptionalLastValue<R> >
class Signal3 : public SignalBase
{
public:

	typedef boost::function<R(A1, A2, A3)> slot_function_type;
	typedef boost::optional<R> result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal3 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2, A3)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2, A3 a3) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2, a3));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	typename C::result_type operator() (A1 a1, A2 a2, A3 a3)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		std::list<R> r;
		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				r.push_back ((i->second)(a1, a2, a3));
			}
		}

		/* Call our combiner to do whatever is required to the result values */
		C c;
		return c (r.begin(), r.end());
	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 3 parameters (specialisation for a void return) */
template <typename A1, typename A2, typename A3>
class Signal3<void, A1, A2, A3> : public SignalBase
{
public:

	typedef boost::function<void(A1, A2, A3)> slot_function_type;
	typedef void result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal3 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2, A3)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2, A3 a3) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2, a3));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	void operator() (A1 a1, A2 a2, A3 a3)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				(i->second)(a1, a2, a3);
			}
		}

	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 4 parameters */
template <typename R, typename A1, typename A2, typename A3, typename A4, typename C = OptionalLastValue<R> >
class Signal4 : public SignalBase
{
public:

	typedef boost::function<R(A1, A2, A3, A4)> slot_function_type;
	typedef boost::optional<R> result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal4 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2, A3, A4)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2, A3 a3, A4 a4) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2, a3, a4));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	typename C::result_type operator() (A1 a1, A2 a2, A3 a3, A4 a4)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		std::list<R> r;
		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				r.push_back ((i->second)(a1, a2, a3, a4));
			}
		}

		/* Call our combiner to do whatever is required to the result values */
		C c;
		return c (r.begin(), r.end());
	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 4 parameters (specialisation for a void return) */
template <typename A1, typename A2, typename A3, typename A4>
class Signal4<void, A1, A2, A3, A4> : public SignalBase
{
public:

	typedef boost::function<void(A1, A2, A3, A4)> slot_function_type;
	typedef void result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal4 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2, A3, A4)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2, A3 a3, A4 a4) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2, a3, a4));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	void operator() (A1 a1, A2 a2, A3 a3, A4 a4)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				(i->second)(a1, a2, a3, a4);
			}
		}

	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 5 parameters */
template <typename R, typename A1, typename A2, typename A3, typename A4, typename A5, typename C = OptionalLastValue<R> >
class Signal5 : public SignalBase
{
public:

	typedef boost::function<R(A1, A2, A3, A4, A5)> slot_function_type;
	typedef boost::optional<R> result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal5 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2, A3, A4, A5)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2, a3, a4, a5));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4, _5)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4, _5));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	typename C::result_type operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		std::list<R> r;
		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				r.push_back ((i->second)(a1, a2, a3, a4, a5));
			}
		}

		/* Call our combiner to do whatever is required to the result values */
		C c;
		return c (r.begin(), r.end());
	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

/** A signal with 5 parameters (specialisation for a void return) */
template <typename A1, typename A2, typename A3, typename A4, typename A5>
class Signal5<void, A1, A2, A3, A4, A5> : public SignalBase
{
public:

	typedef boost::function<void(A1, A2, A3, A4, A5)> slot_function_type;
	typedef void result_type;

private:

	/** The slots that this signal will call on emission */
	typedef std::map<std::shared_ptr<Connection>, slot_function_type> Slots;
	Slots _slots;

public:

	~Signal5 () {
		_in_dtor.store (true, std::memory_order_release);
		Glib::Threads::Mutex::Lock lm (_mutex);
		/* Tell our connection objects that we are going away, so they don't try to call us */
		for (typename Slots::const_iterator i = _slots.begin(); i != _slots.end(); ++i) {
			i->first->signal_going_away ();
		}
	}

	static void compositor (typename boost::function<void(A1, A2, A3, A4, A5)> f, EventLoop* event_loop, EventLoop::InvalidationRecord* ir, A1 a1, A2 a2, A3 a3, A4 a4, A5 a5) {
		event_loop->call_slot (ir, boost::bind (f, a1, a2, a3, a4, a5));
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Store the connection that represents this arrangement in @a c.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnection& c, const slot_function_type& slot) {
		c = _connect (0, slot);
	}

	/** Arrange for @a slot to be executed whenever this signal is emitted.
	  * Add the connection that represents this arrangement to @a clist.
	  *
	  * NOTE: @a slot will be executed in the same thread that the signal is
	  * emitted in.
	  */

	void connect_same_thread (ScopedConnectionList& clist, const slot_function_type& slot) {
		clist.add_connection (_connect (0, slot));
	}

	/** Arrange for @a slot to be executed in the context of @a event_loop
	  * whenever this signal is emitted. Add the connection that represents
	  * this arrangement to @a clist.
	  *
	  * If the event loop/thread in which @a slot will be executed will
	  * outlive the lifetime of any object referenced in @a slot,
	  * then an InvalidationRecord should be passed, allowing
	  * any request sent to the @a event_loop and not executed
	  * before the object is destroyed to be marked invalid.
	  *
	  * "outliving the lifetime" doesn't have a specific, detailed meaning,
	  * but is best illustrated by two contrasting examples:
	  *
	  * 1) the main GUI event loop/thread - this will outlive more or
	  * less all objects in the application, and thus when arranging for
	  * @a slot to be called in that context, an invalidation record is
	  * highly advisable.
	  *
	  * 2) a secondary event loop/thread which will be destroyed along
	  * with the objects that are typically referenced by @a slot.
	  * Assuming that the event loop is stopped before the objects are
	  * destroyed, there is no reason to pass in an invalidation record,
	  * and MISSING_INVALIDATOR may be used.
	  */

	void connect (ScopedConnectionList& clist,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		clist.add_connection (_connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4, _5)));

	}

	/** See notes for the ScopedConnectionList variant of this function. This
	 *  differs in that it stores the connection to the signal in a single
	 *  ScopedConnection rather than a ScopedConnectionList.
	 */

	void connect (ScopedConnection& c,
	              PBD::EventLoop::InvalidationRecord* ir,
	              const slot_function_type& slot,
	              PBD::EventLoop* event_loop) {

		if (ir) {
			ir->event_loop = event_loop;
		}

		c = _connect (ir, boost::bind (&compositor, slot, event_loop, ir, _1, _2, _3, _4, _5));
	}

	/** Emit this signal. This will cause all slots connected to it be executed
	  * in the order that they were connected (cross-thread issues may alter
	  * the precise execution time of cross-thread slots).
	  */

	void operator() (A1 a1, A2 a2, A3 a3, A4 a4, A5 a5)
	{
		/* First, take a copy of our list of slots as it is now */

		Slots s;
		{
			Glib::Threads::Mutex::Lock lm (_mutex);
			s = _slots;
		}

		for (typename Slots::const_iterator i = s.begin(); i != s.end(); ++i) {

			/* We may have just called a slot, and this may have resulted in
			 * disconnection of other slots from us.  The list copy means that
			 * this won't cause any problems with invalidated iterators, but we
			 * must check to see if the slot we are about to call is still on the list.
			 */
			bool still_there = false;
			{
				Glib::Threads::Mutex::Lock lm (_mutex);
				still_there = _slots.find (i->first) != _slots.end ();
			}

			if (still_there) {
				(i->second)(a1, a2, a3, a4, a5);
			}
		}

	}

	bool empty () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.empty ();
	}


	size_t size () const {
		Glib::Threads::Mutex::Lock lm (_mutex);
		return _slots.size ();
	}

private:

	friend class Connection;

	std::shared_ptr<Connection> _connect (PBD::EventLoop::InvalidationRecord* ir, slot_function_type f)
	{
		std::shared_ptr<Connection> c (new Connection (this, ir));
		Glib::Threads::Mutex::Lock lm (_mutex);
		_slots[c] = f;
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "+++++++ CONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
		return c;
	}

	void disconnect (std::shared_ptr<Connection> c)
	{
		/* ~ScopedConnection can call this concurrently with our d'tor */
		Glib::Threads::Mutex::Lock lm (_mutex, Glib::Threads::TRY_LOCK);
		while (!lm.locked()) {
			if (_in_dtor.load (std::memory_order_acquire)) {
			/* d'tor signal_going_away() took care of everything already */
				return;
			}
			/* Spin */
			lm.try_acquire ();
		}
		_slots.erase (c);
		lm.release ();

		c->disconnected ();
#ifdef DEBUG_PBD_SIGNAL_CONNECTIONS
		if (_debug_connection) {
			std::cerr << "------- DISCCONNECT " << this << " size now " << _slots.size() << std::endl;
			PBD::stacktrace (std::cerr, 10);
		}
#endif
	}

};

