/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtStubBasedElementTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclarationStub;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinParameterStub;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;

public class KtParameter
extends KtNamedDeclarationStub<KotlinParameterStub>
implements KtCallableDeclaration,
KtValVarKeywordOwner {
    public static final TokenSet VAL_VAR_TOKEN_SET = TokenSet.create(KtTokens.VAL_KEYWORD, KtTokens.VAR_KEYWORD);

    public KtParameter(@NotNull ASTNode node) {
        if (node == null) {
            KtParameter.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public KtParameter(@NotNull KotlinParameterStub stub) {
        if (stub == null) {
            KtParameter.$$$reportNull$$$0(1);
        }
        super(stub, KtStubBasedElementTypes.VALUE_PARAMETER);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            KtParameter.$$$reportNull$$$0(2);
        }
        return visitor2.visitParameter(this, data);
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        return this.getStubOrPsiChild(KtStubBasedElementTypes.TYPE_REFERENCE);
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    public boolean hasDefaultValue() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasDefaultValue();
        }
        return this.getDefaultValue() != null;
    }

    @Nullable
    public KtExpression getDefaultValue() {
        PsiElement equalsToken;
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null) {
            if (!stub.hasDefaultValue()) {
                return null;
            }
            if (this.getContainingKtFile().isCompiled()) {
                return null;
            }
        }
        return (equalsToken = this.getEqualsToken()) != null ? PsiTreeUtil.getNextSiblingOfType(equalsToken, KtExpression.class) : null;
    }

    public boolean isMutable() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.isMutable();
        }
        return this.findChildByType(KtTokens.VAR_KEYWORD) != null;
    }

    public boolean isVarArg() {
        KtModifierList modifierList2 = this.getModifierList();
        return modifierList2 != null && modifierList2.hasModifier(KtTokens.VARARG_KEYWORD);
    }

    public boolean hasValOrVar() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasValOrVar();
        }
        return this.getValOrVarKeyword() != null;
    }

    @Override
    @Nullable
    public PsiElement getValOrVarKeyword() {
        KotlinParameterStub stub = (KotlinParameterStub)this.getStub();
        if (stub != null && !stub.hasValOrVar()) {
            return null;
        }
        return this.findChildByType(VAL_VAR_TOKEN_SET);
    }

    @Nullable
    public KtDestructuringDeclaration getDestructuringDeclaration() {
        if (this.getStub() != null) {
            return null;
        }
        return (KtDestructuringDeclaration)this.findChildByType(KtNodeTypes.DESTRUCTURING_DECLARATION);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    public boolean isLoopParameter() {
        return this.getParent() instanceof KtForExpression;
    }

    private <T extends PsiElement> boolean checkParentOfParentType(Class<T> klass) {
        PsiElement parent2 = this.getParent();
        if (parent2 == null) {
            return false;
        }
        return klass.isInstance(parent2.getParent());
    }

    public boolean isCatchParameter() {
        return this.checkParentOfParentType(KtCatchClause.class);
    }

    public boolean isContextParameter() {
        return this.getParent() instanceof KtContextReceiverList;
    }

    public boolean isLambdaParameter() {
        return this.checkParentOfParentType(KtFunctionLiteral.class);
    }

    public boolean isFunctionTypeParameter() {
        return this.checkParentOfParentType(KtFunctionType.class);
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        List<KtParameter> list = Collections.emptyList();
        if (list == null) {
            KtParameter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        return null;
    }

    @Override
    @Nullable
    public KtTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    @Nullable
    public KtTypeConstraintList getTypeConstraintList() {
        return null;
    }

    @Override
    @NotNull
    public List<KtTypeConstraint> getTypeConstraints() {
        List<KtTypeConstraint> list = Collections.emptyList();
        if (list == null) {
            KtParameter.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public List<KtTypeParameter> getTypeParameters() {
        List<KtTypeParameter> list = Collections.emptyList();
        if (list == null) {
            KtParameter.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public KtDeclarationWithBody getOwnerFunction() {
        PsiElement parent2 = this.getParentByStub();
        if (!(parent2 instanceof KtParameterList)) {
            return null;
        }
        return ((KtParameterList)parent2).getOwnerFunction();
    }

    @Nullable
    public KtDeclaration getOwnerDeclaration() {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof KtParameterList) {
            return ((KtParameterList)parent2).getOwnerFunction();
        }
        if (parent2 instanceof KtContextReceiverList) {
            return ((KtContextReceiverList)parent2).getOwnerDeclaration();
        }
        return null;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        KtExpression owner = this.getOwnerFunction();
        if (owner instanceof KtPrimaryConstructor) {
            if (this.hasValOrVar()) {
                SearchScope searchScope = super.getUseScope();
                if (searchScope == null) {
                    KtParameter.$$$reportNull$$$0(6);
                }
                return searchScope;
            }
            owner = ((KtPrimaryConstructor)owner).getContainingClassOrObject();
        }
        if (owner == null) {
            owner = PsiTreeUtil.getParentOfType((PsiElement)this, KtExpression.class);
        }
        return new LocalSearchScope(owner != null ? owner : this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtParameter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtParameter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeConstraints";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

