/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Segments structures in images based on a user supplied edge potential
map.


IMPORTANT
The SegmentationLevelSetImageFilter class and the GeodesicActiveContourLevelSetFunction class contain additional information necessary to gain full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. An initial
contour is propagated outwards (or inwards) until it ''sticks'' to the
shape boundaries. This is done by using a level set speed function
based on a user supplied edge potential map.
INPUTS
This filter requires two inputs. The first input is a initial level
set. The initial level set is a real image which contains the initial
contour/surface as the zero level set. For example, a signed distance
function from the initial contour/surface is typically used. Unlike
the simpler ShapeDetectionLevelSetImageFilter the initial contour does not have to lie wholly within the shape to
be segmented. The initial contour is allow to overlap the shape
boundary. The extra advection term in the update equation behaves like
a doublet and attracts the contour to the boundary. This approach for
segmentation follows that of Caselles et al (1997).

The second input is the feature image. For this filter, this is the
edge potential map. General characteristics of an edge potential map
is that it has values close to zero in regions near the edges and
values close to one inside the shape itself. Typically, the edge
potential map is compute from the image gradient, for example:
\\[ g(I) = 1 / ( 1 + | (\\nabla * G)(I)| ) \\] \\[ g(I) = \\exp^{-|(\\nabla * G)(I)|} \\]

where $ I $ is image intensity and $ (\\nabla * G) $ is the derivative of Gaussian operator.


See SegmentationLevelSetImageFilter and SparseFieldLevelSetImageFilter for more information on Inputs.
PARAMETERS
The PropagationScaling parameter can be used to switch from
propagation outwards (POSITIVE scaling parameter) versus propagating
inwards (NEGATIVE scaling parameter).
 This implementation allows the user to set the weights between the
propagation, advection and curvature term using methods SetPropagationScaling() , SetAdvectionScaling() , SetCurvatureScaling() . In general, the larger the CurvatureScaling, the smoother the
resulting contour. To follow the implementation in Caselles et al
paper, set the PropagationScaling to $ c $ (the inflation or balloon force) and AdvectionScaling and
CurvatureScaling both to 1.0.

OUTPUTS
The filter outputs a single, scalar, real-valued image. Negative
values in the output image represent the inside of the segmented
region and positive values in the image represent the outside of the
segmented region. The zero crossings of the image correspond to the
position of the propagating front.

See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
REFERENCES

"Geodesic Active Contours", V. Caselles, R. Kimmel and G. Sapiro.
International Journal on Computer Vision, Vol 22, No. 1, pp 61-97,
1997

See:
 SegmentationLevelSetImageFilter

 GeodesicActiveContourLevelSetFunction

 SparseFieldLevelSetImageFilter

 itk::simple::GeodesicActiveContourLevelSet for the procedural interface

 itk::GeodesicActiveContourLevelSetImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGeodesicActiveContourLevelSetImageFilter.h
*/
public class GeodesicActiveContourLevelSetImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GeodesicActiveContourLevelSetImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GeodesicActiveContourLevelSetImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GeodesicActiveContourLevelSetImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GeodesicActiveContourLevelSetImageFilter::~GeodesicActiveContourLevelSetImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GeodesicActiveContourLevelSetImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GeodesicActiveContourLevelSetImageFilter::GeodesicActiveContourLevelSetImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GeodesicActiveContourLevelSetImageFilter() {
    this(SimpleITKJNI.new_GeodesicActiveContourLevelSetImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::SetMaximumRMSError(double MaximumRMSError)
*/
public  void setMaximumRMSError(double MaximumRMSError) {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_setMaximumRMSError(swigCPtr, this, MaximumRMSError);
  }

  /**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetMaximumRMSError() const
*/
public  double getMaximumRMSError() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getMaximumRMSError(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::SetPropagationScaling(double PropagationScaling)
*/
public  void setPropagationScaling(double PropagationScaling) {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_setPropagationScaling(swigCPtr, this, PropagationScaling);
  }

  /**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetPropagationScaling() const
*/
public  double getPropagationScaling() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getPropagationScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::SetCurvatureScaling(double CurvatureScaling)
*/
public  void setCurvatureScaling(double CurvatureScaling) {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_setCurvatureScaling(swigCPtr, this, CurvatureScaling);
  }

  /**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetCurvatureScaling() const
*/
public  double getCurvatureScaling() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getCurvatureScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::SetAdvectionScaling(double AdvectionScaling)
*/
public  void setAdvectionScaling(double AdvectionScaling) {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_setAdvectionScaling(swigCPtr, this, AdvectionScaling);
  }

  /**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetAdvectionScaling() const
*/
public  double getAdvectionScaling() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getAdvectionScaling(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::SetNumberOfIterations(uint32_t NumberOfIterations)
*/
public  void setNumberOfIterations(long NumberOfIterations) {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_setNumberOfIterations(swigCPtr, this, NumberOfIterations);
  }

  /**
uint32_t itk::simple::GeodesicActiveContourLevelSetImageFilter::GetNumberOfIterations() const
*/
public  long getNumberOfIterations() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::SetReverseExpansionDirection(bool ReverseExpansionDirection)
*/
public  void setReverseExpansionDirection(boolean ReverseExpansionDirection) {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_setReverseExpansionDirection(swigCPtr, this, ReverseExpansionDirection);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::ReverseExpansionDirectionOn()

Set the value of ReverseExpansionDirection to true or false
respectfully.

*/
public  void reverseExpansionDirectionOn() {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_reverseExpansionDirectionOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GeodesicActiveContourLevelSetImageFilter::ReverseExpansionDirectionOff()
*/
public  void reverseExpansionDirectionOff() {
    SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_reverseExpansionDirectionOff(swigCPtr, this);
  }

  /**
bool itk::simple::GeodesicActiveContourLevelSetImageFilter::GetReverseExpansionDirection() const
*/
public  boolean getReverseExpansionDirection() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getReverseExpansionDirection(swigCPtr, this);
  }

  /**
uint32_t itk::simple::GeodesicActiveContourLevelSetImageFilter::GetElapsedIterations() const

Number of iterations run.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::GeodesicActiveContourLevelSetImageFilter::GetRMSChange() const

The Root Mean Square of the levelset upon termination.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getRMSChange() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getRMSChange(swigCPtr, this);
  }

  /**
std::string itk::simple::GeodesicActiveContourLevelSetImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GeodesicActiveContourLevelSetImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GeodesicActiveContourLevelSetImageFilter::Execute(Image &amp;&amp;initialImage, const Image &amp;featureImage)

Execute the filter on the input image

*/
public  Image execute(Image initialImage, Image featureImage) {
    return new Image(SimpleITKJNI.GeodesicActiveContourLevelSetImageFilter_execute(swigCPtr, this, Image.getCPtr(initialImage), initialImage, Image.getCPtr(featureImage), featureImage), true);
  }

}
