//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdSkelImaging/inbetweenShapeSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdSkelImagingInbetweenShapeSchemaTokens,
    USD_SKEL_IMAGING_INBETWEEN_SHAPE_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdFloatDataSourceHandle
UsdSkelImagingInbetweenShapeSchema::GetWeight() const
{
    return _GetTypedDataSource<HdFloatDataSource>(
        UsdSkelImagingInbetweenShapeSchemaTokens->weight);
}

HdVec3fArrayDataSourceHandle
UsdSkelImagingInbetweenShapeSchema::GetOffsets() const
{
    return _GetTypedDataSource<HdVec3fArrayDataSource>(
        UsdSkelImagingInbetweenShapeSchemaTokens->offsets);
}

HdVec3fArrayDataSourceHandle
UsdSkelImagingInbetweenShapeSchema::GetNormalOffsets() const
{
    return _GetTypedDataSource<HdVec3fArrayDataSource>(
        UsdSkelImagingInbetweenShapeSchemaTokens->normalOffsets);
}

/*static*/
HdContainerDataSourceHandle
UsdSkelImagingInbetweenShapeSchema::BuildRetained(
        const HdFloatDataSourceHandle &weight,
        const HdVec3fArrayDataSourceHandle &offsets,
        const HdVec3fArrayDataSourceHandle &normalOffsets
)
{
    TfToken _names[3];
    HdDataSourceBaseHandle _values[3];

    size_t _count = 0;

    if (weight) {
        _names[_count] = UsdSkelImagingInbetweenShapeSchemaTokens->weight;
        _values[_count++] = weight;
    }

    if (offsets) {
        _names[_count] = UsdSkelImagingInbetweenShapeSchemaTokens->offsets;
        _values[_count++] = offsets;
    }

    if (normalOffsets) {
        _names[_count] = UsdSkelImagingInbetweenShapeSchemaTokens->normalOffsets;
        _values[_count++] = normalOffsets;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdSkelImagingInbetweenShapeSchema::Builder &
UsdSkelImagingInbetweenShapeSchema::Builder::SetWeight(
    const HdFloatDataSourceHandle &weight)
{
    _weight = weight;
    return *this;
}

UsdSkelImagingInbetweenShapeSchema::Builder &
UsdSkelImagingInbetweenShapeSchema::Builder::SetOffsets(
    const HdVec3fArrayDataSourceHandle &offsets)
{
    _offsets = offsets;
    return *this;
}

UsdSkelImagingInbetweenShapeSchema::Builder &
UsdSkelImagingInbetweenShapeSchema::Builder::SetNormalOffsets(
    const HdVec3fArrayDataSourceHandle &normalOffsets)
{
    _normalOffsets = normalOffsets;
    return *this;
}

HdContainerDataSourceHandle
UsdSkelImagingInbetweenShapeSchema::Builder::Build()
{
    return UsdSkelImagingInbetweenShapeSchema::BuildRetained(
        _weight,
        _offsets,
        _normalOffsets
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE
