//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/tetMeshSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdTetMeshSchemaTokens,
    HD_TET_MESH_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTetMeshTopologySchema
HdTetMeshSchema::GetTopology() const
{
    return HdTetMeshTopologySchema(_GetTypedDataSource<HdContainerDataSource>(
        HdTetMeshSchemaTokens->topology));
}

HdBoolDataSourceHandle
HdTetMeshSchema::GetDoubleSided() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdTetMeshSchemaTokens->doubleSided);
}

/*static*/
HdContainerDataSourceHandle
HdTetMeshSchema::BuildRetained(
        const HdContainerDataSourceHandle &topology,
        const HdBoolDataSourceHandle &doubleSided
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (topology) {
        _names[_count] = HdTetMeshSchemaTokens->topology;
        _values[_count++] = topology;
    }

    if (doubleSided) {
        _names[_count] = HdTetMeshSchemaTokens->doubleSided;
        _values[_count++] = doubleSided;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdTetMeshSchema::Builder &
HdTetMeshSchema::Builder::SetTopology(
    const HdContainerDataSourceHandle &topology)
{
    _topology = topology;
    return *this;
}

HdTetMeshSchema::Builder &
HdTetMeshSchema::Builder::SetDoubleSided(
    const HdBoolDataSourceHandle &doubleSided)
{
    _doubleSided = doubleSided;
    return *this;
}

HdContainerDataSourceHandle
HdTetMeshSchema::Builder::Build()
{
    return HdTetMeshSchema::BuildRetained(
        _topology,
        _doubleSided
    );
}

/*static*/
HdTetMeshSchema
HdTetMeshSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdTetMeshSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdTetMeshSchemaTokens->tetMesh))
        : nullptr);
}

/*static*/
const TfToken &
HdTetMeshSchema::GetSchemaToken()
{
    return HdTetMeshSchemaTokens->tetMesh;
}

/*static*/
const HdDataSourceLocator &
HdTetMeshSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdTetMeshSchema::GetTopologyLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdTetMeshSchemaTokens->topology);
    return locator;
}

/* static */
const HdDataSourceLocator &
HdTetMeshSchema::GetDoubleSidedLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdTetMeshSchemaTokens->doubleSided);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE