//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/systemSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/imaging/hd/overlayContainerDataSource.h"
#include "pxr/imaging/hd/sceneIndex.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdSystemSchemaTokens,
    HD_SYSTEM_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

// static
HdDataSourceBaseHandle
HdSystemSchema::GetFromPath(
    HdSceneIndexBaseRefPtr const& inputScene,
    SdfPath const& fromPath,
    TfToken const& key,
    SdfPath* foundAtPath)
{
    if (!inputScene) {
        return nullptr;
    }

    const HdDataSourceLocator locator(HdSystemSchemaTokens->system, key);

    for (SdfPath currPath = fromPath;
            !currPath.IsEmpty();
            currPath = currPath.GetParentPath()) {
        const HdSceneIndexPrim currPrim = inputScene->GetPrim(currPath);
        if (HdDataSourceBaseHandle dataSource
            = HdContainerDataSource::Get(currPrim.dataSource, locator)) {
            if (foundAtPath) {
                *foundAtPath = currPath;
            }
            return dataSource;
        }
    }

    return nullptr;
}

// static
HdContainerDataSourceHandle
HdSystemSchema::Compose(
    HdSceneIndexBaseRefPtr const& inputScene,
    SdfPath const& fromPath,
    SdfPath* foundAtPath)
{
    if (!inputScene) {
        return nullptr;
    }

    TfSmallVector<HdContainerDataSourceHandle, 4> systemContainers;

    SdfPath lastFound;
    for (SdfPath currPath = fromPath;
            !currPath.IsEmpty();
            currPath = currPath.GetParentPath()) {
        const HdSceneIndexPrim currPrim = inputScene->GetPrim(currPath);
        if (HdContainerDataSourceHandle systemContainer
            = HdSystemSchema::GetFromParent(currPrim.dataSource)
                  .GetContainer()) {
            systemContainers.push_back(systemContainer);
            lastFound = currPath;
        }
    }

    if (systemContainers.empty()) {
        return nullptr;
    }

    if (foundAtPath) {
        *foundAtPath = lastFound;
    }

    return HdOverlayContainerDataSource::New(
        systemContainers.size(), systemContainers.data());
}

// static
HdContainerDataSourceHandle
HdSystemSchema::ComposeAsPrimDataSource(
    HdSceneIndexBaseRefPtr const& inputScene,
    SdfPath const& fromPath,
    SdfPath* foundAtPath)
{
    if (HdContainerDataSourceHandle systemDs
        = Compose(inputScene, fromPath, foundAtPath)) {
        return HdRetainedContainerDataSource::New(
            HdSystemSchemaTokens->system, systemDs);
    }
    return nullptr;
}

// --(END CUSTOM CODE: Schema Methods)--

/*static*/
HdSystemSchema
HdSystemSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdSystemSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdSystemSchemaTokens->system))
        : nullptr);
}

/*static*/
const TfToken &
HdSystemSchema::GetSchemaToken()
{
    return HdSystemSchemaTokens->system;
}

/*static*/
const HdDataSourceLocator &
HdSystemSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE