// python wrapper for vtkPVSessionCore
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVSessionCore.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVSessionCore(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVSessionCore_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSessionCore_MessageTypes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkPVSessionCore.MessageTypes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVSessionCore_MessageTypes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVSessionCore_MessageTypes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPVSessionCore_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVSessionCore::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVSessionCore::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVSessionCore *tempr = vtkPVSessionCore::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVSessionCore *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVSessionCore::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVSessionCore::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVSessionCore::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetInterpreter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInterpreter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkClientServerInterpreter *tempr = (ap.IsBound() ?
      op->GetInterpreter() :
      op->vtkPVSessionCore::GetInterpreter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetProxyDefinitionManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProxyDefinitionManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSIProxyDefinitionManager *tempr = (ap.IsBound() ?
      op->GetProxyDefinitionManager() :
      op->vtkPVSessionCore::GetProxyDefinitionManager());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_ExecuteStream(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExecuteStream");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  unsigned int temp0;
  vtkClientServerStream *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetValue(temp0) &&
      ap.GetSpecialObject(temp1, pobj1, "vtkClientServerStream") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->ExecuteStream(temp0, *temp1, temp2);
    }
    else
    {
      op->vtkPVSessionCore::ExecuteStream(temp0, *temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  Py_XDECREF(pobj1);

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetLastResult(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLastResult");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const vtkClientServerStream *tempr = (ap.IsBound() ?
      &op->GetLastResult() :
      &op->vtkPVSessionCore::GetLastResult());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(tempr, "vtkClientServerStream");
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetSIObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSIObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSIObject *tempr = (ap.IsBound() ?
      op->GetSIObject(temp0) :
      op->vtkPVSessionCore::GetSIObject(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetRemoteObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRemoteObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkObject *tempr = (ap.IsBound() ?
      op->GetRemoteObject(temp0) :
      op->vtkPVSessionCore::GetRemoteObject(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_RegisterRemoteObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterRemoteObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  unsigned int temp0;
  vtkObject *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->RegisterRemoteObject(temp0, temp1);
    }
    else
    {
      op->vtkPVSessionCore::RegisterRemoteObject(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_UnRegisterRemoteObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnRegisterRemoteObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UnRegisterRemoteObject(temp0);
    }
    else
    {
      op->vtkPVSessionCore::UnRegisterRemoteObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GatherInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GatherInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  unsigned int temp0;
  vtkPVInformation *temp1 = nullptr;
  unsigned int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkPVInformation") &&
      ap.GetValue(temp2))
  {
    bool tempr = (ap.IsBound() ?
      op->GatherInformation(temp0, temp1, temp2) :
      op->vtkPVSessionCore::GatherInformation(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetNumberOfProcesses(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfProcesses");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfProcesses() :
      op->vtkPVSessionCore::GetNumberOfProcesses());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_SetMPIMToNSocketConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMPIMToNSocketConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  vtkMPIMToNSocketConnection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMPIMToNSocketConnection"))
  {
    if (ap.IsBound())
    {
      op->SetMPIMToNSocketConnection(temp0);
    }
    else
    {
      op->vtkPVSessionCore::SetMPIMToNSocketConnection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetMPIMToNSocketConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMPIMToNSocketConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMPIMToNSocketConnection *tempr = (ap.IsBound() ?
      op->GetMPIMToNSocketConnection() :
      op->vtkPVSessionCore::GetMPIMToNSocketConnection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetNextGlobalUniqueIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNextGlobalUniqueIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNextGlobalUniqueIdentifier() :
      op->vtkPVSessionCore::GetNextGlobalUniqueIdentifier());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetNextChunkGlobalUniqueIdentifier(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNextChunkGlobalUniqueIdentifier");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetNextChunkGlobalUniqueIdentifier(temp0) :
      op->vtkPVSessionCore::GetNextChunkGlobalUniqueIdentifier(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_PushStateSatelliteCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PushStateSatelliteCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PushStateSatelliteCallback();
    }
    else
    {
      op->vtkPVSessionCore::PushStateSatelliteCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_ExecuteStreamSatelliteCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExecuteStreamSatelliteCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExecuteStreamSatelliteCallback();
    }
    else
    {
      op->vtkPVSessionCore::ExecuteStreamSatelliteCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GatherInformationStatelliteCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GatherInformationStatelliteCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GatherInformationStatelliteCallback();
    }
    else
    {
      op->vtkPVSessionCore::GatherInformationStatelliteCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_RegisterSIObjectSatelliteCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RegisterSIObjectSatelliteCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RegisterSIObjectSatelliteCallback();
    }
    else
    {
      op->vtkPVSessionCore::RegisterSIObjectSatelliteCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_UnRegisterSIObjectSatelliteCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UnRegisterSIObjectSatelliteCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UnRegisterSIObjectSatelliteCallback();
    }
    else
    {
      op->vtkPVSessionCore::UnRegisterSIObjectSatelliteCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GetAllRemoteObjects(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAllRemoteObjects");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  vtkCollection *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCollection"))
  {
    if (ap.IsBound())
    {
      op->GetAllRemoteObjects(temp0);
    }
    else
    {
      op->vtkPVSessionCore::GetAllRemoteObjects(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVSessionCore_GarbageCollectSIObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GarbageCollectSIObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVSessionCore *op = static_cast<vtkPVSessionCore *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<int> store0(2*size0);
  int *temp0 = store0.Data();
  int *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GarbageCollectSIObject(temp0, temp1);
    }
    else
    {
      op->vtkPVSessionCore::GarbageCollectSIObject(temp0, temp1);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVSessionCore_Methods[] = {
  {"IsTypeOf", PyvtkPVSessionCore_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVSessionCore_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVSessionCore_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVSessionCore\nC++: static vtkPVSessionCore *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVSessionCore_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVSessionCore\nC++: vtkPVSessionCore *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVSessionCore_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVSessionCore_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetInterpreter", PyvtkPVSessionCore_GetInterpreter, METH_VARARGS,
   "GetInterpreter(self) -> vtkClientServerInterpreter\nC++: virtual vtkClientServerInterpreter *GetInterpreter()\n\nProvides access to the interpreter.\n"},
  {"GetProxyDefinitionManager", PyvtkPVSessionCore_GetProxyDefinitionManager, METH_VARARGS,
   "GetProxyDefinitionManager(self) -> vtkSIProxyDefinitionManager\nC++: virtual vtkSIProxyDefinitionManager *GetProxyDefinitionManager(\n    )\n\nProvides access to the proxy definition manager.\n"},
  {"ExecuteStream", PyvtkPVSessionCore_ExecuteStream, METH_VARARGS,
   "ExecuteStream(self, location:int, stream:vtkClientServerStream,\n    ignore_errors:bool=False) -> None\nC++: virtual void ExecuteStream(vtkTypeUInt32 location,\n    const vtkClientServerStream &stream, bool ignore_errors=false)\n\nExecute a command on the given processes. Use GetLastResult() to\nobtain the last result after the command stream is evaluated.\nOnce can setignore_errors to true, to ignore any interpreting\nerrors.\n"},
  {"GetLastResult", PyvtkPVSessionCore_GetLastResult, METH_VARARGS,
   "GetLastResult(self) -> vtkClientServerStream\nC++: virtual const vtkClientServerStream &GetLastResult()\n\nReturns the response of the ExecuteStream() call from the\nlocation. Note if location refers to multiple processes, then the\nreply is only fetched from the \"closest\" process.\n"},
  {"GetSIObject", PyvtkPVSessionCore_GetSIObject, METH_VARARGS,
   "GetSIObject(self, globalid:int) -> vtkSIObject\nC++: vtkSIObject *GetSIObject(vtkTypeUInt32 globalid)\n\nReturns a vtkSIObject or subclass given its global id, if any\notherwise return nullptr;\n"},
  {"GetRemoteObject", PyvtkPVSessionCore_GetRemoteObject, METH_VARARGS,
   "GetRemoteObject(self, globalid:int) -> vtkObject\nC++: vtkObject *GetRemoteObject(vtkTypeUInt32 globalid)\n\nReturn a vtkObject given its global id if any otherwise return\nnullptr;\n"},
  {"RegisterRemoteObject", PyvtkPVSessionCore_RegisterRemoteObject, METH_VARARGS,
   "RegisterRemoteObject(self, globalid:int, obj:vtkObject) -> None\nC++: void RegisterRemoteObject(vtkTypeUInt32 globalid,\n    vtkObject *obj)\n\nRegister a remote object\n"},
  {"UnRegisterRemoteObject", PyvtkPVSessionCore_UnRegisterRemoteObject, METH_VARARGS,
   "UnRegisterRemoteObject(self, globalid:int) -> None\nC++: void UnRegisterRemoteObject(vtkTypeUInt32 globalid)\n\nUnregister a remote object\n"},
  {"GatherInformation", PyvtkPVSessionCore_GatherInformation, METH_VARARGS,
   "GatherInformation(self, location:int,\n    information:vtkPVInformation, globalid:int) -> bool\nC++: virtual bool GatherInformation(vtkTypeUInt32 location,\n    vtkPVInformation *information, vtkTypeUInt32 globalid)\n\nGather information about an object referred by the\nglobalid.location identifies the processes to gather the\ninformation from.\n"},
  {"GetNumberOfProcesses", PyvtkPVSessionCore_GetNumberOfProcesses, METH_VARARGS,
   "GetNumberOfProcesses(self) -> int\nC++: int GetNumberOfProcesses()\n\nReturns the number of processes. This simply calls the\nGetNumberOfProcesses() on this->ParallelController\n"},
  {"SetMPIMToNSocketConnection", PyvtkPVSessionCore_SetMPIMToNSocketConnection, METH_VARARGS,
   "SetMPIMToNSocketConnection(self, __a:vtkMPIMToNSocketConnection)\n    -> None\nC++: void SetMPIMToNSocketConnection(vtkMPIMToNSocketConnection *)\n\nGet/Set the socket connection used to communicate between\ndata=server and render-server processes. This is valid only on\ndata-server and render-server processes.\n"},
  {"GetMPIMToNSocketConnection", PyvtkPVSessionCore_GetMPIMToNSocketConnection, METH_VARARGS,
   "GetMPIMToNSocketConnection(self) -> vtkMPIMToNSocketConnection\nC++: virtual vtkMPIMToNSocketConnection *GetMPIMToNSocketConnection(\n    )\n\n"},
  {"GetNextGlobalUniqueIdentifier", PyvtkPVSessionCore_GetNextGlobalUniqueIdentifier, METH_VARARGS,
   "GetNextGlobalUniqueIdentifier(self) -> int\nC++: virtual vtkTypeUInt32 GetNextGlobalUniqueIdentifier()\n\nProvides the next available identifier. This implementation works\nlocally. without any code distribution. To support the\ndistributed architecture the vtkSMSessionClient override those\nmethod to call them on the DATA_SERVER vtkPVSessionBase instance.\n"},
  {"GetNextChunkGlobalUniqueIdentifier", PyvtkPVSessionCore_GetNextChunkGlobalUniqueIdentifier, METH_VARARGS,
   "GetNextChunkGlobalUniqueIdentifier(self, chunkSize:int) -> int\nC++: virtual vtkTypeUInt32 GetNextChunkGlobalUniqueIdentifier(\n    vtkTypeUInt32 chunkSize)\n\nReturn the first Id of the requested chunk. 1 =\nReverveNextIdChunk(10); | Reserved ids [1,2,3,4,5,6,7,8,9,10] 11\n= ReverveNextIdChunk(10);| Reserved ids\n[11,12,13,14,15,16,17,18,19,20] b = a + 10;\n"},
  {"PushStateSatelliteCallback", PyvtkPVSessionCore_PushStateSatelliteCallback, METH_VARARGS,
   "PushStateSatelliteCallback(self) -> None\nC++: void PushStateSatelliteCallback()\n\n"},
  {"ExecuteStreamSatelliteCallback", PyvtkPVSessionCore_ExecuteStreamSatelliteCallback, METH_VARARGS,
   "ExecuteStreamSatelliteCallback(self) -> None\nC++: void ExecuteStreamSatelliteCallback()\n\n"},
  {"GatherInformationStatelliteCallback", PyvtkPVSessionCore_GatherInformationStatelliteCallback, METH_VARARGS,
   "GatherInformationStatelliteCallback(self) -> None\nC++: void GatherInformationStatelliteCallback()\n\n"},
  {"RegisterSIObjectSatelliteCallback", PyvtkPVSessionCore_RegisterSIObjectSatelliteCallback, METH_VARARGS,
   "RegisterSIObjectSatelliteCallback(self) -> None\nC++: void RegisterSIObjectSatelliteCallback()\n\n"},
  {"UnRegisterSIObjectSatelliteCallback", PyvtkPVSessionCore_UnRegisterSIObjectSatelliteCallback, METH_VARARGS,
   "UnRegisterSIObjectSatelliteCallback(self) -> None\nC++: void UnRegisterSIObjectSatelliteCallback()\n\n"},
  {"GetAllRemoteObjects", PyvtkPVSessionCore_GetAllRemoteObjects, METH_VARARGS,
   "GetAllRemoteObjects(self, collection:vtkCollection) -> None\nC++: virtual void GetAllRemoteObjects(vtkCollection *collection)\n\nAllow the user to fill a vtkCollection with all RemoteObjects\nThis is useful when you want to hold a reference to them to\nprevent any deletion across several method call.\n"},
  {"GarbageCollectSIObject", PyvtkPVSessionCore_GarbageCollectSIObject, METH_VARARGS,
   "GarbageCollectSIObject(self, clientIds:[int, ...], nbClients:int)\n    -> None\nC++: void GarbageCollectSIObject(int *clientIds, int nbClients)\n\nDelete SIObject that are held by clients that disappeared from\nthe given list.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVSessionCore_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("mpim_to_n_socket_connection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionCore_GetMPIMToNSocketConnection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVSessionCore_SetMPIMToNSocketConnection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVSessionCore_SetMPIMToNSocketConnection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMPIMToNSocketConnection/SetMPIMToNSocketConnection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interpreter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionCore_GetInterpreter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetInterpreter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("proxy_definition_manager"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionCore_GetProxyDefinitionManager(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProxyDefinitionManager\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_result"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionCore_GetLastResult(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLastResult\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("next_global_unique_identifier"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionCore_GetNextGlobalUniqueIdentifier(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNextGlobalUniqueIdentifier\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_processes"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVSessionCore_GetNumberOfProcesses(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfProcesses\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVSessionCore_Doc =
  "vtkPVSessionCore - vtkPVSessionCore is used by vtkSMSession.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkPVSessionCore handle the communication to MPI satellites and\n"
  "ServerImplementation code instantiation and execution. On the other\n"
  "hand, the vtkSMSession dispatch the request to the right process and\n"
  "therefore to the right vtkPVSessionCore instance.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVSessionCore_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkPVSessionCore", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVSessionCore_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVSessionCore_StaticNew()
{
  return vtkPVSessionCore::New();
}

PyObject *PyvtkPVSessionCore_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVSessionCore_Type, PyvtkPVSessionCore_Methods,
    "vtkPVSessionCore",
 &PyvtkPVSessionCore_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPVSessionCore_MessageTypes_Type);
  PyVTKEnum_Add(&PyvtkPVSessionCore_MessageTypes_Type, "vtkPVSessionCore.MessageTypes");

  o = (PyObject *)&PyvtkPVSessionCore_MessageTypes_Type;
  if (PyDict_SetItemString(d, "MessageTypes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 6; c++)
  {
    typedef vtkPVSessionCore::MessageTypes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[6] = {
        { "PUSH_STATE", vtkPVSessionCore::PUSH_STATE },
        { "PULL_STATE", vtkPVSessionCore::PULL_STATE },
        { "EXECUTE_STREAM", vtkPVSessionCore::EXECUTE_STREAM },
        { "GATHER_INFORMATION", vtkPVSessionCore::GATHER_INFORMATION },
        { "REGISTER_SI", vtkPVSessionCore::REGISTER_SI },
        { "UNREGISTER_SI", vtkPVSessionCore::UNREGISTER_SI },
      };

    o = PyvtkPVSessionCore_MessageTypes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVSessionCore_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVSessionCore(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVSessionCore_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVSessionCore", o) != 0)
  {
    Py_DECREF(o);
  }

}

