/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_tagged_encoder = R"doc(Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

Constructor Specific Documentation:

Build the FEC encoder block from an FECAPI encoder object.

Args:
    my_encoder : An FECAPI encoder object child of the generic_encoder class.
    input_item_size : size of a block of data for the encoder.
    output_item_size : size of a block of data the encoder will produce.
    lengthtagname : Key name of the tagged stream frame size.
    mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_tagged_encoder_tagged_encoder_0 = R"doc()doc";


static const char* __doc_gr_fec_tagged_encoder_tagged_encoder_1 = R"doc()doc";


static const char* __doc_gr_fec_tagged_encoder_make = R"doc(Creates the encoder block for use in GNU Radio flowgraphs from a given FECAPI object derived from the generic_encoder class.

Generally, we would use the fec.extended_encoder Python implementation to instantiate this. The extended_encoder wraps up a few more details, like taking care of puncturing as well as the encoder itself.

Constructor Specific Documentation:

Build the FEC encoder block from an FECAPI encoder object.

Args:
    my_encoder : An FECAPI encoder object child of the generic_encoder class.
    input_item_size : size of a block of data for the encoder.
    output_item_size : size of a block of data the encoder will produce.
    lengthtagname : Key name of the tagged stream frame size.
    mtu : The Maximum Transmission Unit (MTU) of the input frame that the block will be able to process. Specified in bytes and defaults to 1500.)doc";


static const char* __doc_gr_fec_tagged_encoder_work = R"doc(Just like gr::block::general_work, but makes sure the input is valid.

The user must override work to define the signal processing code. Check the documentation for general_work() to see what happens here.


Like gr::sync_block, this calls consume() for you (it consumes ninput_items[i] items from the i-th port).


A note on tag propagation: The PDU length tags are handled by other functions, but all other tags are handled just as in any other . So, most likely, you either set the tag propagation policy to TPP_DONT and handle the tag propagation manually, or you propagate tags through the scheduler and don't do anything here.)doc";


static const char* __doc_gr_fec_tagged_encoder_calculate_output_stream_length =
    R"doc()doc";
