/* storage-actionbar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from storage-actionbar.vala, do not modify */

/* storage-actionbar.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_STORAGE_ACTION_BAR (usage_storage_action_bar_get_type ())
#define USAGE_STORAGE_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_ACTION_BAR, UsageStorageActionBar))
#define USAGE_STORAGE_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_ACTION_BAR, UsageStorageActionBarClass))
#define USAGE_IS_STORAGE_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_ACTION_BAR))
#define USAGE_IS_STORAGE_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_ACTION_BAR))
#define USAGE_STORAGE_ACTION_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_ACTION_BAR, UsageStorageActionBarClass))

typedef struct _UsageStorageActionBar UsageStorageActionBar;
typedef struct _UsageStorageActionBarClass UsageStorageActionBarClass;
typedef struct _UsageStorageActionBarPrivate UsageStorageActionBarPrivate;

#define USAGE_TYPE_STORAGE_VIEW_ITEM (usage_storage_view_item_get_type ())
#define USAGE_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem))
#define USAGE_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))
#define USAGE_IS_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_IS_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_STORAGE_VIEW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))

typedef struct _UsageStorageViewItem UsageStorageViewItem;
typedef struct _UsageStorageViewItemClass UsageStorageViewItemClass;
enum  {
	USAGE_STORAGE_ACTION_BAR_0_PROPERTY,
	USAGE_STORAGE_ACTION_BAR_NUM_PROPERTIES
};
static GParamSpec* usage_storage_action_bar_properties[USAGE_STORAGE_ACTION_BAR_NUM_PROPERTIES];
typedef struct _UsageStorageViewItemPrivate UsageStorageViewItemPrivate;
typedef enum  {
	USAGE_STORAGE_VIEW_TYPE_NONE,
	USAGE_STORAGE_VIEW_TYPE_OS,
	USAGE_STORAGE_VIEW_TYPE_UP_FOLDER,
	USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH,
	USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM
} UsageStorageViewType;

#define USAGE_TYPE_STORAGE_VIEW_TYPE (usage_storage_view_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	USAGE_STORAGE_ACTION_BAR_REFRESH_LISTBOX_SIGNAL,
	USAGE_STORAGE_ACTION_BAR_NUM_SIGNALS
};
static guint usage_storage_action_bar_signals[USAGE_STORAGE_ACTION_BAR_NUM_SIGNALS] = {0};

struct _UsageStorageActionBar {
	AdwBin parent_instance;
	UsageStorageActionBarPrivate * priv;
};

struct _UsageStorageActionBarClass {
	AdwBinClass parent_class;
};

struct _UsageStorageActionBarPrivate {
	GList* selected_items;
	GtkLabel* size_label;
};

struct _UsageStorageViewItem {
	GObject parent_instance;
	UsageStorageViewItemPrivate * priv;
	gchar* uri;
	gchar* name;
	guint64 size;
	GFileType type;
	GUserDirectory* dir;
	gchar* ontology;
	UsageStorageViewType custom_type;
};

struct _UsageStorageViewItemClass {
	GObjectClass parent_class;
};

static gint UsageStorageActionBar_private_offset;
static gpointer usage_storage_action_bar_parent_class = NULL;

VALA_EXTERN GType usage_storage_action_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageActionBar, g_object_unref)
VALA_EXTERN GType usage_storage_view_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewItem, g_object_unref)
VALA_EXTERN void usage_storage_action_bar_update_selected_items (UsageStorageActionBar* self,
                                                     GList* selected_items);
VALA_EXTERN GType usage_storage_view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
static void usage_storage_action_bar_delete_clicked (UsageStorageActionBar* self);
static void __lambda37_ (UsageStorageActionBar* self,
                  AdwAlertDialog* dialog,
                  const gchar* response_type);
static void usage_storage_action_bar_delete_file (UsageStorageActionBar* self,
                                           const gchar* uri,
                                           gboolean delete_basefile);
static void ___lambda37__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void _usage_storage_action_bar_delete_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
VALA_EXTERN UsageStorageActionBar* usage_storage_action_bar_new (void);
VALA_EXTERN UsageStorageActionBar* usage_storage_action_bar_construct (GType object_type);
static void usage_storage_action_bar_finalize (GObject * obj);
static GType usage_storage_action_bar_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_storage_action_bar_get_instance_private (UsageStorageActionBar* self)
{
	return G_STRUCT_MEMBER_P (self, UsageStorageActionBar_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
usage_storage_action_bar_update_selected_items (UsageStorageActionBar* self,
                                                GList* selected_items)
{
	guint64 size = 0ULL;
	gulong most_significant = 0UL;
	gchar* size_formatted = NULL;
	gulong* _tmp2_ = NULL;
	gchar* _tmp3_;
	gulong* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	self->priv->selected_items = selected_items;
	size = (guint64) 0;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = selected_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			UsageStorageViewItem* _tmp0_;
			UsageStorageViewItem* item = NULL;
			_tmp0_ = _g_object_ref0 ((UsageStorageViewItem*) item_it->data);
			item = _tmp0_;
			{
				UsageStorageViewItem* _tmp1_;
				_tmp1_ = item;
				size += _tmp1_->size;
				_g_object_unref0 (item);
			}
		}
	}
	_tmp3_ = usage_utils_format_size_values (size, &_tmp2_);
	_tmp4_ = _tmp2_;
	most_significant = *_tmp4_;
	_tmp5_ = _tmp3_;
	_g_free0 (_tmp4_);
	size_formatted = _tmp5_;
	_tmp6_ = self->priv->size_label;
	_tmp7_ = g_strdup_printf (ngettext ("%s selected", "%s selected", most_significant), size_formatted);
	_tmp8_ = _tmp7_;
	gtk_label_set_label (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (size_formatted);
}

static void
__lambda37_ (UsageStorageActionBar* self,
             AdwAlertDialog* dialog,
             const gchar* response_type)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	g_return_if_fail (dialog != NULL);
	g_return_if_fail (response_type != NULL);
	_tmp0_ = response_type;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("replace")))) {
		switch (0) {
			default:
			{
				GList* _tmp3_;
				_tmp3_ = self->priv->selected_items;
				{
					GList* item_collection = NULL;
					GList* item_it = NULL;
					item_collection = _tmp3_;
					for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
						UsageStorageViewItem* _tmp4_;
						UsageStorageViewItem* item = NULL;
						_tmp4_ = _g_object_ref0 ((UsageStorageViewItem*) item_it->data);
						item = _tmp4_;
						{
							gboolean _tmp5_ = FALSE;
							UsageStorageViewItem* _tmp6_;
							_tmp6_ = item;
							if (_tmp6_->type == G_FILE_TYPE_DIRECTORY) {
								UsageStorageViewItem* _tmp7_;
								_tmp7_ = item;
								_tmp5_ = _tmp7_->custom_type == USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM;
							} else {
								_tmp5_ = FALSE;
							}
							if (_tmp5_) {
								UsageStorageViewItem* _tmp8_;
								const gchar* _tmp9_;
								_tmp8_ = item;
								_tmp9_ = _tmp8_->uri;
								usage_storage_action_bar_delete_file (self, _tmp9_, FALSE);
							} else {
								UsageStorageViewItem* _tmp10_;
								const gchar* _tmp11_;
								_tmp10_ = item;
								_tmp11_ = _tmp10_->uri;
								usage_storage_action_bar_delete_file (self, _tmp11_, TRUE);
							}
							_g_object_unref0 (item);
						}
					}
				}
				g_signal_emit (self, usage_storage_action_bar_signals[USAGE_STORAGE_ACTION_BAR_REFRESH_LISTBOX_SIGNAL], 0);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	g_signal_emit_by_name ((GtkWidget*) dialog, "destroy");
}

static void
___lambda37__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda37_ ((UsageStorageActionBar*) self, _sender, response);
}

static void
usage_storage_action_bar_delete_clicked (UsageStorageActionBar* self)
{
	gchar* display_message = NULL;
	gchar* _tmp0_;
	gchar* display_explanation = NULL;
	gchar* _tmp1_;
	AdwAlertDialog* dialog = NULL;
	AdwAlertDialog* _tmp2_;
	GtkRoot* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Are you sure you want to permanently delete selected items?"));
	display_message = _tmp0_;
	_tmp1_ = g_strdup (_ ("If you delete these items, they will be permanently lost."));
	display_explanation = _tmp1_;
	_tmp2_ = (AdwAlertDialog*) adw_alert_dialog_new (display_message, display_explanation);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	adw_alert_dialog_add_response (dialog, "cancel", _ ("Cancel"));
	adw_alert_dialog_add_response (dialog, "delete", _ ("Delete"));
	adw_alert_dialog_set_response_appearance (dialog, "delete", ADW_RESPONSE_DESTRUCTIVE);
	adw_alert_dialog_set_default_response (dialog, "cancel");
	adw_alert_dialog_set_close_response (dialog, "cancel");
	g_signal_connect_object (dialog, "response", (GCallback) ___lambda37__adw_alert_dialog_response, self, 0);
	_tmp3_ = gtk_widget_get_root ((GtkWidget*) self);
	adw_dialog_present ((AdwDialog*) dialog, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_g_object_unref0 (dialog);
	_g_free0 (display_explanation);
	_g_free0 (display_message);
}

static void
_usage_storage_action_bar_delete_clicked_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	usage_storage_action_bar_delete_clicked ((UsageStorageActionBar*) self);
}

static void
usage_storage_action_bar_delete_file (UsageStorageActionBar* self,
                                      const gchar* uri,
                                      gboolean delete_basefile)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileType type = 0;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = file;
	type = g_file_query_file_type (_tmp1_, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	{
		if (type == G_FILE_TYPE_DIRECTORY) {
			GFileInfo* info = NULL;
			GFileEnumerator* enumerator = NULL;
			GFile* _tmp2_;
			GFileEnumerator* _tmp3_;
			_tmp2_ = file;
			_tmp3_ = g_file_enumerate_children (_tmp2_, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
			enumerator = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp4_ = NULL;
				GFileEnumerator* _tmp5_;
				GFileInfo* _tmp6_;
				GFileInfo* _tmp7_;
				GFileInfo* _tmp8_;
				GFile* child = NULL;
				GFile* _tmp9_;
				GFileInfo* _tmp10_;
				const gchar* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp5_ = enumerator;
				_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (enumerator);
					_g_object_unref0 (info);
					goto __catch0_g_error;
				}
				_tmp7_ = _tmp4_;
				_tmp4_ = NULL;
				_g_object_unref0 (info);
				info = _tmp7_;
				_tmp8_ = info;
				if (!(_tmp8_ != NULL)) {
					_g_object_unref0 (_tmp4_);
					break;
				}
				_tmp9_ = file;
				_tmp10_ = info;
				_tmp11_ = g_file_info_get_name (_tmp10_);
				_tmp12_ = g_file_get_child (_tmp9_, _tmp11_);
				child = _tmp12_;
				_tmp13_ = child;
				_tmp14_ = g_file_get_uri (_tmp13_);
				_tmp15_ = _tmp14_;
				usage_storage_action_bar_delete_file (self, _tmp15_, TRUE);
				_g_free0 (_tmp15_);
				_g_object_unref0 (child);
				_g_object_unref0 (_tmp4_);
			}
			_g_object_unref0 (enumerator);
			_g_object_unref0 (info);
		}
		if (delete_basefile) {
			GFile* _tmp16_;
			_tmp16_ = file;
			g_file_delete (_tmp16_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = stderr;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "Error: %s\n", _tmp19_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

UsageStorageActionBar*
usage_storage_action_bar_construct (GType object_type)
{
	UsageStorageActionBar * self = NULL;
	self = (UsageStorageActionBar*) g_object_new (object_type, NULL);
	return self;
}

UsageStorageActionBar*
usage_storage_action_bar_new (void)
{
	return usage_storage_action_bar_construct (USAGE_TYPE_STORAGE_ACTION_BAR);
}

static void
usage_storage_action_bar_class_init (UsageStorageActionBarClass * klass,
                                     gpointer klass_data)
{
	usage_storage_action_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageStorageActionBar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = usage_storage_action_bar_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/storage-actionbar.ui");
	usage_storage_action_bar_signals[USAGE_STORAGE_ACTION_BAR_REFRESH_LISTBOX_SIGNAL] = g_signal_new ("refresh-listbox", USAGE_TYPE_STORAGE_ACTION_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "size_label", FALSE, UsageStorageActionBar_private_offset + G_STRUCT_OFFSET (UsageStorageActionBarPrivate, size_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_clicked", G_CALLBACK(_usage_storage_action_bar_delete_clicked_gtk_button_clicked));
}

static void
usage_storage_action_bar_instance_init (UsageStorageActionBar * self,
                                        gpointer klass)
{
	self->priv = usage_storage_action_bar_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_storage_action_bar_finalize (GObject * obj)
{
	UsageStorageActionBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_STORAGE_ACTION_BAR, UsageStorageActionBar);
	G_OBJECT_CLASS (usage_storage_action_bar_parent_class)->finalize (obj);
}

static GType
usage_storage_action_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageStorageActionBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_storage_action_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageStorageActionBar), 0, (GInstanceInitFunc) usage_storage_action_bar_instance_init, NULL };
	GType usage_storage_action_bar_type_id;
	usage_storage_action_bar_type_id = g_type_register_static (adw_bin_get_type (), "UsageStorageActionBar", &g_define_type_info, 0);
	UsageStorageActionBar_private_offset = g_type_add_instance_private (usage_storage_action_bar_type_id, sizeof (UsageStorageActionBarPrivate));
	return usage_storage_action_bar_type_id;
}

GType
usage_storage_action_bar_get_type (void)
{
	static volatile gsize usage_storage_action_bar_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_action_bar_type_id__once)) {
		GType usage_storage_action_bar_type_id;
		usage_storage_action_bar_type_id = usage_storage_action_bar_get_type_once ();
		g_once_init_leave (&usage_storage_action_bar_type_id__once, usage_storage_action_bar_type_id);
	}
	return usage_storage_action_bar_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

